/*
 * Decompiled with CFR 0.152.
 */
package org.lamport.tla.toolbox.tool.prover.ui.dialog;

import java.util.ArrayList;
import org.eclipse.core.runtime.Assert;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.text.ITextSelection;
import org.eclipse.jface.window.IShellProvider;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.part.FileEditorInput;
import org.lamport.tla.toolbox.editor.basic.TLAEditor;
import org.lamport.tla.toolbox.editor.basic.util.EditorUtil;
import org.lamport.tla.toolbox.tool.prover.job.ProverJob;
import org.lamport.tla.toolbox.tool.prover.ui.ProverUIActivator;
import org.lamport.tla.toolbox.tool.prover.ui.util.ProverHelper;

public class LaunchProverDialog
extends Dialog {
    private Text extraOptionsText;
    private Button isatool;
    private Button isacheck;
    private Button noisa;
    private Button noProving;
    private Button toolboxMode;
    private Button paranoid;
    private Button fpNormal;
    private Button fpForgetAll;
    private Button fpForgetCurrent;
    public static final String EXTRA_OPTIONS_KEY = "extra_options";
    public static final String TOOLBOX_MODE_KEY = "toolbox_mode";
    public static final String ISATOOL_KEY = "isatool";
    public static final String STATUS_CHECK_KEY = "status_check";
    public static final String ISACHECK_KEY = "isacheck";
    public static final String NOISA_KEY = "noisa";
    public static final String PARANOID_KEY = "paranoid";
    public static final String FP_NORMAL_KEY = "fpnormal";
    public static final String FP_FORGET_ALL_KEY = "fpforgetall";
    public static final String FP_FORGET_CURRENT_KEY = "fpforgetcurrent";

    public LaunchProverDialog(IShellProvider parentShell) {
        super(parentShell);
        this.setBlockOnOpen(true);
    }

    protected Control createDialogArea(Composite parent) {
        IPreferenceStore store = ProverUIActivator.getDefault().getPreferenceStore();
        Composite topComposite = new Composite(parent, 0);
        GridData gd = new GridData();
        topComposite.setLayoutData((Object)gd);
        topComposite.setLayout((Layout)new GridLayout(2, true));
        Label label = new Label(topComposite, 0);
        label.setText("Enter the prover options.");
        gd = new GridData();
        gd.horizontalSpan = 2;
        label.setLayoutData((Object)gd);
        Group nonCommandLineGroup = new Group(topComposite, 0);
        gd = new GridData();
        gd.horizontalSpan = 2;
        nonCommandLineGroup.setLayoutData((Object)gd);
        nonCommandLineGroup.setLayout((Layout)new GridLayout(2, true));
        Composite left = new Composite((Composite)nonCommandLineGroup, 0);
        gd = new GridData();
        left.setLayoutData((Object)gd);
        left.setLayout((Layout)new GridLayout(1, true));
        this.toolboxMode = new Button(left, 32);
        this.toolboxMode.setText(" Launch in toolbox mode");
        this.toolboxMode.setSelection(store.getBoolean(TOOLBOX_MODE_KEY));
        Group proverGroup = new Group(left, 0);
        proverGroup.setLayout((Layout)new GridLayout(1, false));
        proverGroup.setText("Choose prover(s) to use:");
        this.isatool = new Button((Composite)proverGroup, 16);
        this.isatool.setText(" Use Isabelle only if necessary.");
        this.isatool.setSelection(store.getBoolean(ISATOOL_KEY));
        this.noProving = new Button((Composite)proverGroup, 16);
        this.noProving.setText(" No proving.");
        this.noProving.setSelection(store.getBoolean(STATUS_CHECK_KEY));
        this.isacheck = new Button((Composite)proverGroup, 16);
        this.isacheck.setText(" Check Zenon proofs with Isabelle.");
        this.isacheck.setSelection(store.getBoolean(ISACHECK_KEY));
        this.noisa = new Button((Composite)proverGroup, 16);
        this.noisa.setText(" Do not use Isabelle.");
        this.noisa.setSelection(store.getBoolean(NOISA_KEY));
        Group fpGroup = new Group(left, 0);
        fpGroup.setLayout((Layout)new GridLayout(1, false));
        fpGroup.setText("Using previous results:");
        this.fpNormal = new Button((Composite)fpGroup, 16);
        this.fpNormal.setText(" Use previous results.");
        this.fpNormal.setSelection(store.getBoolean(FP_NORMAL_KEY));
        this.fpForgetAll = new Button((Composite)fpGroup, 16);
        this.fpForgetAll.setText(" Forget all previous results.");
        this.fpForgetAll.setSelection(store.getBoolean(FP_FORGET_ALL_KEY));
        this.fpForgetCurrent = new Button((Composite)fpGroup, 16);
        this.fpForgetCurrent.setText(" Forget currently selected previous results.");
        this.fpForgetCurrent.setSelection(store.getBoolean(FP_FORGET_CURRENT_KEY));
        this.noProving.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
                if (LaunchProverDialog.this.paranoid != null) {
                    LaunchProverDialog.this.paranoid.setEnabled(!LaunchProverDialog.this.noProving.getSelection());
                }
            }

            public void widgetDefaultSelected(SelectionEvent e) {
                if (LaunchProverDialog.this.paranoid != null) {
                    LaunchProverDialog.this.paranoid.setEnabled(!LaunchProverDialog.this.noProving.getSelection());
                }
            }
        });
        Composite right = new Composite((Composite)nonCommandLineGroup, 0);
        gd = new GridData();
        right.setLayoutData((Object)gd);
        right.setLayout((Layout)new GridLayout(1, true));
        this.paranoid = new Button(right, 32);
        this.paranoid.setText("Paranoid checking");
        this.paranoid.setSelection(store.getBoolean(PARANOID_KEY));
        this.paranoid.setEnabled(!this.noProving.getSelection());
        Composite threadsComposite = new Composite(right, 0);
        gd = new GridData();
        threadsComposite.setLayoutData((Object)gd);
        threadsComposite.setLayout((Layout)new GridLayout(2, false));
        label = new Label(topComposite, 0);
        label.setText("Enter additional tlapm command-line arguments.");
        gd = new GridData();
        gd.horizontalSpan = 2;
        label.setLayoutData((Object)gd);
        this.extraOptionsText = new Text(topComposite, 4);
        gd = new GridData(4, 4, true, true);
        gd.horizontalSpan = 2;
        this.extraOptionsText.setLayoutData((Object)gd);
        this.extraOptionsText.setText(store.getString(EXTRA_OPTIONS_KEY));
        return topComposite;
    }

    protected void okPressed() {
        IPreferenceStore store = ProverUIActivator.getDefault().getPreferenceStore();
        store.setValue(EXTRA_OPTIONS_KEY, this.extraOptionsText.getText());
        store.setValue(TOOLBOX_MODE_KEY, this.toolboxMode.getSelection());
        store.setValue(ISATOOL_KEY, this.isatool.getSelection());
        store.setValue(STATUS_CHECK_KEY, this.noProving.getSelection());
        store.setValue(ISACHECK_KEY, this.isacheck.getSelection());
        store.setValue(NOISA_KEY, this.noisa.getSelection());
        store.setValue(PARANOID_KEY, this.paranoid.getSelection());
        store.setValue(FP_NORMAL_KEY, this.fpNormal.getSelection());
        store.setValue(FP_FORGET_ALL_KEY, this.fpForgetAll.getSelection());
        store.setValue(FP_FORGET_CURRENT_KEY, this.fpForgetCurrent.getSelection());
        ArrayList<String> command = new ArrayList<String>();
        if (!this.isatool.getSelection() && this.isacheck.getSelection()) {
            command.add("-C");
        }
        if (this.fpForgetAll.getSelection()) {
            command.add("--cleanfp");
        } else if (this.fpForgetCurrent.getSelection()) {
            command.add("--nofp");
        }
        if (this.paranoid.isEnabled() && this.paranoid.getSelection()) {
            command.add("--paranoid");
        }
        ProverHelper.setThreadsOption(command);
        ProverHelper.setSolverOption(command);
        ProverHelper.setSafeFPOption(command);
        String extraOptions = this.extraOptionsText.getText();
        StringBuilder argument = new StringBuilder();
        int state = 0;
        int j = 0;
        while (j < extraOptions.length()) {
            char c = extraOptions.charAt(j);
            switch (state) {
                case 0: {
                    if (c == ' ') break;
                    if (c == '\'') {
                        state = 2;
                        break;
                    }
                    argument.append(c);
                    state = 1;
                    break;
                }
                case 1: {
                    if (c == ' ') {
                        command.add(argument.toString());
                        argument.setLength(0);
                        state = 0;
                        break;
                    }
                    if (c == '\'') {
                        state = 2;
                        break;
                    }
                    argument.append(c);
                    break;
                }
                case 2: {
                    if (c == '\'') {
                        state = 1;
                        break;
                    }
                    argument.append(c);
                }
            }
            ++j;
        }
        if (state == 1 || state == 2) {
            command.add(argument.toString());
        }
        TLAEditor editor = EditorUtil.getActiveTLAEditor();
        Assert.isNotNull((Object)editor, (String)"User attempted to run general prover dialog without a tla editor active. This is a bug.");
        ProverJob proverJob = new ProverJob(((FileEditorInput)editor.getEditorInput()).getFile(), ((ITextSelection)editor.getSelectionProvider().getSelection()).getOffset(), this.noProving.getSelection(), command.toArray(new String[command.size()]), this.toolboxMode.getSelection());
        proverJob.setUser(true);
        proverJob.schedule();
        super.okPressed();
    }
}

