/*
 * Decompiled with CFR 0.152.
 */
package org.lamport.tla.toolbox.tool.prover.ui.preference;

import org.eclipse.jface.preference.BooleanFieldEditor;
import org.eclipse.jface.preference.ColorFieldEditor;
import org.eclipse.jface.preference.ComboFieldEditor;
import org.eclipse.jface.preference.FieldEditor;
import org.eclipse.jface.preference.FieldEditorPreferencePage;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.util.IPropertyChangeListener;
import org.eclipse.jface.util.PropertyChangeEvent;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchPreferencePage;
import org.eclipse.ui.editors.text.EditorsUI;
import org.lamport.tla.toolbox.tool.prover.ui.ProverUIActivator;
import org.lamport.tla.toolbox.tool.prover.ui.output.data.ColorPredicate;
import org.lamport.tla.toolbox.tool.prover.ui.preference.TLCChainedPreferenceStore;

public class ColorPredicatePreferencePage
extends FieldEditorPreferencePage
implements IWorkbenchPreferencePage {
    public static final String PREDICATE = "predicate";
    public static final String APPLIES_TO_LEAF_ONLY = "appliesToLeafOnly";
    public static final String STEP_STATUS_COLOR = "stepStatusColor";
    public static final String STEP_STATUS_OVERVIEW = "stepStatusOverview";
    public static final int NUM_STATUS_COLORS = 12;
    public static final String COLOR_PREF_KEY_PREFIX = "stepStatusColor";

    public ColorPredicatePreferencePage() {
        super(1);
        IPreferenceStore[] preferenceStores = new IPreferenceStore[]{EditorsUI.getPreferenceStore(), ProverUIActivator.getDefault().getPreferenceStore()};
        this.setPreferenceStore(new TLCChainedPreferenceStore(preferenceStores));
        this.getPreferenceStore().addPropertyChangeListener((IPropertyChangeListener)this);
        this.setDescription("Color Predicates");
    }

    protected void createFieldEditors() {
        int i = 1;
        while (i <= 12) {
            this.addField((FieldEditor)new ColorFieldEditor(ColorPredicatePreferencePage.getMainColorPrefName(i), "Color " + i, this.getFieldEditorParent()));
            this.addField((FieldEditor)new ComboFieldEditor(ColorPredicatePreferencePage.getColorPredPrefName(i), "Predicate", ColorPredicate.PREDEFINED_MACROS, this.getFieldEditorParent()));
            this.addField((FieldEditor)new BooleanFieldEditor(ColorPredicatePreferencePage.getLeafSideBarPrefName(i), "Show Leaf Steps in Side Bar", this.getFieldEditorParent()));
            this.addField((FieldEditor)new BooleanFieldEditor(ColorPredicatePreferencePage.getAppliesToLeafPrefName(i), "Applies to Leaf Steps Only", this.getFieldEditorParent()));
            ++i;
        }
    }

    public void init(IWorkbench workbench) {
    }

    public static final String getMainColorPrefName(int colorNum) {
        return "stepStatusColor" + colorNum + "A";
    }

    public static final String getPartnerColorPrefName(int colorNum) {
        return "stepStatusColor" + colorNum + "B";
    }

    public static final int getNumFromMainColorPref(String key) {
        return Integer.parseInt(key.substring("stepStatusColor".length(), key.length() - 1));
    }

    public static final String getColorPredPrefName(int colorNum) {
        return "stepStatusColor" + colorNum + PREDICATE;
    }

    public static final String getLeafSideBarPrefName(int colorNum) {
        return STEP_STATUS_OVERVIEW + colorNum + "B";
    }

    public static final String getAppliesToLeafPrefName(int colorNum) {
        String string = APPLIES_TO_LEAF_ONLY;
        return string + colorNum;
    }

    public void propertyChange(PropertyChangeEvent event) {
        if (event.getProperty().contains("stepStatusColor") && event.getProperty().endsWith("A")) {
            int colorNum = ColorPredicatePreferencePage.getNumFromMainColorPref(event.getProperty());
            IPreferenceStore store = this.getPreferenceStore();
            String partnerPrefName = ColorPredicatePreferencePage.getPartnerColorPrefName(colorNum);
            String newValue = this.getPreferenceStore().getString(event.getProperty());
            if (store.getDefaultString(partnerPrefName).equals(newValue)) {
                store.setToDefault(partnerPrefName);
            } else {
                this.getPreferenceStore().setValue(partnerPrefName, newValue);
            }
        }
        super.propertyChange(event);
    }

    protected void adjustGridLayout() {
        ((GridLayout)this.getFieldEditorParent().getLayout()).numColumns = 6;
    }

    public static String makeAtLeastThreeDigitsWide(int value) {
        Object result = "";
        if (value < 100) {
            result = (String)result + "0";
            if (value < 10) {
                result = (String)result + "0";
            }
        }
        return (String)result + value;
    }
}

