/*
 * Decompiled with CFR 0.152.
 */
package org.lamport.tla.toolbox.tool.prover.ui.output.data;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.eclipse.core.resources.IMarker;
import org.eclipse.core.runtime.Assert;
import org.lamport.tla.toolbox.tool.prover.job.ProverJob;
import org.lamport.tla.toolbox.tool.prover.ui.output.data.ColorPredicate;
import org.lamport.tla.toolbox.tool.prover.ui.output.data.ObligationStatus;
import org.lamport.tla.toolbox.tool.prover.ui.util.ProverHelper;
import tla2sany.st.Location;

public class StepTuple {
    private StepTuple parent;
    private IMarker sanyMarker;
    private List children;
    private boolean[] colorPredicateValues;
    private ProverJob proverJob;

    public void updateStatus() {
        int i;
        boolean isLeaf = this.sanyMarker.getAttribute("org.lamport.tla.toolbox.tool.prover.ui.isLeafStep", false);
        ColorPredicate[] colorPredicates = this.proverJob.getColorPredicates();
        boolean predicateChanged = false;
        if (isLeaf) {
            int[] obligationStateNumbers = new int[this.children.size()];
            i = 0;
            while (i < obligationStateNumbers.length) {
                obligationStateNumbers[i] = ((ObligationStatus)this.children.get(i)).getObligationState();
                ++i;
            }
            i = 0;
            while (i < this.colorPredicateValues.length) {
                boolean newPredicateValue = colorPredicates[i].satisfiedByObligations(obligationStateNumbers);
                predicateChanged = predicateChanged || this.colorPredicateValues[i] != newPredicateValue;
                this.colorPredicateValues[i] = newPredicateValue;
                ++i;
            }
        } else {
            boolean[] childPredicateValues = new boolean[this.children.size()];
            i = 0;
            while (i < this.colorPredicateValues.length) {
                int childNum = 0;
                Iterator it = this.children.iterator();
                while (it.hasNext()) {
                    childPredicateValues[childNum] = ((StepTuple)it.next()).getColorPredicateValues()[i];
                    ++childNum;
                }
                boolean newPredicateValue = colorPredicates[i].satisfiedBasedOnChildren(childPredicateValues);
                predicateChanged = predicateChanged || this.colorPredicateValues[i] != newPredicateValue;
                this.colorPredicateValues[i] = newPredicateValue;
                ++i;
            }
        }
        if (predicateChanged) {
            int newMinimum = 13;
            i = 0;
            while (i < this.colorPredicateValues.length) {
                if (this.colorPredicateValues[i]) {
                    newMinimum = i + 1;
                    break;
                }
                ++i;
            }
            ProverHelper.newStepStatusMarker(this.sanyMarker, newMinimum);
            if (this.parent != null) {
                this.parent.updateStatus();
            }
        }
    }

    public StepTuple(ProverJob proverJob) {
        this.proverJob = proverJob;
        this.children = new ArrayList();
        ColorPredicate[] colorPredicates = proverJob.getColorPredicates();
        this.colorPredicateValues = new boolean[12];
        int i = 0;
        while (i < this.colorPredicateValues.length) {
            this.colorPredicateValues[i] = !colorPredicates[i].isSome;
            ++i;
        }
    }

    public void addChild(Object child) {
        Assert.isTrue((child instanceof StepTuple || child instanceof ObligationStatus ? 1 : 0) != 0, (String)("An instance of " + String.valueOf(child.getClass()) + " was added as a child to a StepTuple. This is a bug."));
        this.children.add(child);
        this.updateStatus();
    }

    public void setSanyMarker(IMarker sanyMarker) {
        this.sanyMarker = sanyMarker;
    }

    public void setParent(StepTuple parent) {
        this.parent = parent;
    }

    public boolean[] getColorPredicateValues() {
        return this.colorPredicateValues;
    }

    public IMarker getSanyMarker() {
        return this.sanyMarker;
    }

    public Location getSANYLocation() {
        return ProverHelper.stringToLoc(this.sanyMarker.getAttribute("org.lamport.tla.toolbox.tool.prover.ui.sanyLoc", null));
    }
}

