/*
 * Decompiled with CFR 0.152.
 */
package org.lamport.tla.toolbox.tool.prover.ui.output;

import org.eclipse.core.resources.IFile;
import org.eclipse.core.runtime.IProgressMonitor;
import org.lamport.tla.toolbox.tool.prover.job.ProverJob;
import org.lamport.tla.toolbox.tool.prover.output.IProverProcessOutputSink;
import org.lamport.tla.toolbox.tool.prover.ui.output.data.ErrorMessage;
import org.lamport.tla.toolbox.tool.prover.ui.output.data.ObligationNumberMessage;
import org.lamport.tla.toolbox.tool.prover.ui.output.data.ObligationStatusMessage;
import org.lamport.tla.toolbox.tool.prover.ui.output.data.StepStatusMessage;
import org.lamport.tla.toolbox.tool.prover.ui.output.data.TLAPMMessage;
import org.lamport.tla.toolbox.tool.prover.ui.output.data.WarningMessage;
import org.lamport.tla.toolbox.tool.prover.ui.util.ProverHelper;

public class TagBasedTLAPMOutputIncrementalParser
implements IProverProcessOutputSink {
    private StringBuilder currentSearchTextBuffer;
    private IFile moduleFile;
    private ProverJob proverJob;
    private IProgressMonitor monitor;
    private boolean inMessage = false;
    public static final String DELIM = "@!!";
    public static final String START_TAG = "@!!BEGIN";
    public static final String END_TAG = "@!!END";

    @Override
    public void appendText(String text) {
        this.currentSearchTextBuffer.append(text);
        int tagIndex = -1;
        tagIndex = this.inMessage ? this.currentSearchTextBuffer.indexOf(END_TAG) : this.currentSearchTextBuffer.indexOf(START_TAG);
        while (tagIndex != -1) {
            if (this.inMessage) {
                TLAPMMessage data = TLAPMMessage.parseMessage(this.currentSearchTextBuffer.substring(0, tagIndex), this.moduleFile.getLocation().removeFileExtension().lastSegment());
                this.currentSearchTextBuffer.replace(0, tagIndex + END_TAG.length(), "");
                this.inMessage = false;
                if (data != null) {
                    if (data instanceof ObligationStatusMessage) {
                        ProverHelper.processObligationMessage((ObligationStatusMessage)data, this.proverJob);
                        if (ProverHelper.isObligationFinished((ObligationStatusMessage)data, this.proverJob)) {
                            this.monitor.worked(1);
                        }
                    } else if (data instanceof ObligationNumberMessage) {
                        ObligationNumberMessage numMessage = (ObligationNumberMessage)data;
                        this.monitor.beginTask(this.proverJob.getProverJobTaskName(), numMessage.getCount());
                        this.monitor.subTask("Processing Obligations : " + numMessage.getCount() + " total.");
                    } else if (data instanceof StepStatusMessage) {
                        ProverHelper.newStepStatusMessage((StepStatusMessage)data, this.proverJob);
                    } else if (data instanceof WarningMessage) {
                        ProverHelper.processWarningMessage((WarningMessage)data);
                    } else if (data instanceof ErrorMessage) {
                        ProverHelper.processErrorMessage((ErrorMessage)data);
                    }
                }
            } else {
                this.currentSearchTextBuffer.replace(0, tagIndex + START_TAG.length(), "");
                this.inMessage = true;
            }
            tagIndex = this.inMessage ? this.currentSearchTextBuffer.indexOf(END_TAG) : this.currentSearchTextBuffer.indexOf(START_TAG);
        }
    }

    @Override
    public void initializeSink(IFile moduleFile, ProverJob proverJob, IProgressMonitor monitor) {
        this.currentSearchTextBuffer = new StringBuilder();
        this.moduleFile = moduleFile;
        this.monitor = monitor;
        this.proverJob = proverJob;
    }

    @Override
    public void processFinished() {
        ProverHelper.compareStepStatusComputations(this.proverJob);
    }
}

