/*
 * Decompiled with CFR 0.152.
 */
package org.lamport.tla.toolbox.tool.prover.ui.dialog;

import java.net.MalformedURLException;
import java.net.URL;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.layout.GridDataFactory;
import org.eclipse.jface.resource.JFaceColors;
import org.eclipse.jface.window.IShellProvider;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.browser.IWebBrowser;
import org.eclipse.ui.browser.IWorkbenchBrowserSupport;
import org.eclipse.ui.forms.events.HyperlinkAdapter;
import org.eclipse.ui.forms.events.HyperlinkEvent;
import org.eclipse.ui.forms.events.IHyperlinkListener;
import org.eclipse.ui.forms.widgets.Hyperlink;
import org.lamport.tla.toolbox.tool.prover.ui.ProverUIActivator;
import org.lamport.tla.toolbox.util.UIHelper;

public class TLAPMErrorDialog
extends Dialog {
    private Text dialogText;
    private String message;
    private String title;
    private Image image;
    private String url;

    protected TLAPMErrorDialog(IShellProvider parentShell, String message) {
        super(parentShell);
        this.setShellStyle(65568);
        this.setBlockOnOpen(true);
        this.message = message;
    }

    protected Control createDialogArea(Composite parent) {
        Composite composite = new Composite(parent, 0);
        composite.setLayoutData((Object)new GridData(4, 4, true, true));
        composite.setLayout((Layout)new GridLayout(2, false));
        if (this.image != null) {
            Label imageLabel = new Label(composite, 0);
            this.image.setBackground(imageLabel.getBackground());
            imageLabel.setImage(this.image);
            GridDataFactory.fillDefaults().align(0x1000000, 1).applyTo((Control)imageLabel);
        }
        this.dialogText = new Text(composite, 66);
        this.dialogText.setText(this.message);
        this.dialogText.setEditable(false);
        GridDataFactory.fillDefaults().align(4, 1).grab(true, false).hint(this.convertHorizontalDLUsToPixels(300), -1).applyTo((Control)this.dialogText);
        Composite linkComposite = new Composite(composite, 0);
        GridData gd = new GridData();
        gd.horizontalSpan = 2;
        linkComposite.setLayoutData((Object)gd);
        linkComposite.setLayout((Layout)new GridLayout(2, false));
        Label label = new Label(linkComposite, 64);
        label.setText("Please submit the above message to the TLAPM developers using the following link : ");
        Hyperlink link = new Hyperlink(linkComposite, 64);
        link.setForeground(JFaceColors.getHyperlinkText((Display)UIHelper.getCurrentDisplay()));
        link.setUnderlined(true);
        link.setHref((Object)this.url);
        link.setText(this.url);
        link.addHyperlinkListener((IHyperlinkListener)new HyperlinkAdapter(){

            public void linkActivated(HyperlinkEvent e) {
                try {
                    IWorkbenchBrowserSupport browserSupport = PlatformUI.getWorkbench().getBrowserSupport();
                    IWebBrowser browser = browserSupport.getExternalBrowser();
                    browser.openURL(new URL(TLAPMErrorDialog.this.url));
                }
                catch (PartInitException e1) {
                    ProverUIActivator.getDefault().logError("Error opening browser to url : " + TLAPMErrorDialog.this.url, e1);
                }
                catch (MalformedURLException e1) {
                    ProverUIActivator.getDefault().logError("Malformed URL : " + TLAPMErrorDialog.this.url, e1);
                }
            }
        });
        return composite;
    }

    public static void open(String message, String title, String url) {
        TLAPMErrorDialog dialog = new TLAPMErrorDialog(UIHelper.getShellProvider(), message);
        dialog.setTitle(title);
        dialog.setImage(UIHelper.getSWTImage((int)1));
        dialog.setURL(url);
        dialog.open();
    }

    public void setTitle(String title) {
        this.title = title;
    }

    public void setImage(Image image) {
        this.image = image;
    }

    public void setURL(String url) {
        this.url = url;
    }

    protected void configureShell(Shell shell) {
        super.configureShell(shell);
        if (this.title != null) {
            shell.setText(this.title);
        }
    }
}

