/*
 * Decompiled with CFR 0.152.
 */
package org.lamport.tla.toolbox.util;

import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.nio.file.Files;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;

public class ZipUtil {
    public static boolean isArchive(String filePath) {
        File file = new File(filePath);
        try {
            String probeContentType = Files.probeContentType(file.toPath());
            if (probeContentType != null && probeContentType.equals("application/zip")) {
                return true;
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return false;
    }

    public static File unzip(File zipFilePath, File destDir, boolean unique) throws IOException {
        return ZipUtil.unzip(new FileInputStream(zipFilePath), destDir, unique);
    }

    public static File unzip(InputStream zip, File destDir, boolean unique) throws IOException {
        if (unique) {
            while (destDir.exists()) {
                destDir = new File(String.valueOf(destDir) + "_" + System.currentTimeMillis());
            }
            destDir.mkdirs();
        }
        ZipInputStream zipIn = new ZipInputStream(zip);
        ZipEntry entry = zipIn.getNextEntry();
        while (entry != null) {
            String filePath = String.valueOf(destDir) + File.separator + entry.getName();
            File file = new File(filePath);
            if (entry.isDirectory()) {
                file.mkdir();
            } else {
                if (file.getParentFile() != null && !file.getParentFile().exists()) {
                    file.getParentFile().mkdirs();
                }
                BufferedOutputStream bos = new BufferedOutputStream(new FileOutputStream(file));
                byte[] bytesIn = new byte[4096];
                int read = 0;
                while ((read = zipIn.read(bytesIn)) != -1) {
                    bos.write(bytesIn, 0, read);
                }
                bos.close();
            }
            zipIn.closeEntry();
            entry = zipIn.getNextEntry();
        }
        zipIn.close();
        return destDir;
    }
}

