/*
 * Decompiled with CFR 0.152.
 */
package org.lamport.tla.toolbox.editor.basic.tla;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import org.eclipse.core.resources.IMarker;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.Position;
import org.eclipse.jface.text.source.Annotation;
import org.eclipse.jface.text.source.IAnnotationHover;
import org.eclipse.jface.text.source.IAnnotationModel;
import org.eclipse.jface.text.source.ISourceViewer;
import org.eclipse.ui.texteditor.MarkerAnnotation;

public class TLAAnnotationHover
implements IAnnotationHover {
    public String getHoverInfo(ISourceViewer sourceViewer, int lineNumber) {
        String[] messages = this.getMessagesForLine(sourceViewer, lineNumber);
        if (messages.length == 0) {
            return null;
        }
        StringBuilder sb = new StringBuilder();
        String lineSeparator = System.getProperty("line.separator");
        int i = 0;
        while (i < messages.length) {
            sb.append(messages[i]);
            if (i < messages.length - 1) {
                sb.append(lineSeparator);
            }
            ++i;
        }
        return sb.toString();
    }

    private String[] getMessagesForLine(ISourceViewer viewer, int line) {
        IAnnotationModel model = viewer.getAnnotationModel();
        if (model == null) {
            return new String[0];
        }
        Iterator it = model.getAnnotationIterator();
        IDocument document = viewer.getDocument();
        ArrayList<String> messages = new ArrayList<String>();
        HashMap placeMessagesMap = new HashMap();
        while (it.hasNext()) {
            IMarker marker;
            String message;
            MarkerAnnotation ma;
            Position p;
            Annotation annotation = (Annotation)it.next();
            if (!(annotation instanceof MarkerAnnotation) || !this.compareRulerLine(p = model.getPosition((Annotation)(ma = (MarkerAnnotation)annotation)), document, line) || (message = (marker = ma.getMarker()).getAttribute("message", null)) == null || message.trim().length() <= 0) continue;
            HashSet<String> priorMessages = (HashSet<String>)placeMessagesMap.get(p);
            if (priorMessages == null) {
                priorMessages = new HashSet<String>();
                placeMessagesMap.put(p, priorMessages);
            }
            if (priorMessages.contains(message)) continue;
            messages.add(message);
            priorMessages.add(message);
        }
        return messages.toArray(new String[messages.size()]);
    }

    private boolean compareRulerLine(Position position, IDocument document, int line) {
        try {
            if (position.getOffset() > -1 && position.getLength() > -1) {
                return document.getLineOfOffset(position.getOffset()) == line;
            }
        }
        catch (BadLocationException badLocationException) {
            // empty catch block
        }
        return false;
    }
}

