/*
 * Decompiled with CFR 0.152.
 */
package org.lamport.tla.toolbox.editor.basic;

import java.lang.reflect.Field;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.resource.JFaceResources;
import org.eclipse.jface.text.DefaultInformationControl;
import org.eclipse.jface.text.IInformationControl;
import org.eclipse.jface.text.IInformationControlCreator;
import org.eclipse.jface.text.ITextHover;
import org.eclipse.jface.text.TextAttribute;
import org.eclipse.jface.text.contentassist.ContentAssistant;
import org.eclipse.jface.text.contentassist.ICompletionProposal;
import org.eclipse.jface.text.contentassist.ICompletionProposalSorter;
import org.eclipse.jface.text.contentassist.IContentAssistProcessor;
import org.eclipse.jface.text.contentassist.IContentAssistant;
import org.eclipse.jface.text.presentation.IPresentationDamager;
import org.eclipse.jface.text.presentation.IPresentationReconciler;
import org.eclipse.jface.text.presentation.IPresentationRepairer;
import org.eclipse.jface.text.presentation.PresentationReconciler;
import org.eclipse.jface.text.reconciler.IReconciler;
import org.eclipse.jface.text.reconciler.IReconcilingStrategy;
import org.eclipse.jface.text.reconciler.MonoReconciler;
import org.eclipse.jface.text.rules.BufferedRuleBasedScanner;
import org.eclipse.jface.text.rules.DefaultDamagerRepairer;
import org.eclipse.jface.text.rules.IToken;
import org.eclipse.jface.text.rules.ITokenScanner;
import org.eclipse.jface.text.rules.Token;
import org.eclipse.jface.text.source.IAnnotationHover;
import org.eclipse.jface.text.source.ISourceViewer;
import org.eclipse.jface.text.source.projection.ProjectionViewer;
import org.eclipse.swt.custom.StyledText;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.editors.text.TextSourceViewerConfiguration;
import org.lamport.tla.toolbox.editor.basic.TLAColorProvider;
import org.lamport.tla.toolbox.editor.basic.TLAEditor;
import org.lamport.tla.toolbox.editor.basic.TLAEditorActivator;
import org.lamport.tla.toolbox.editor.basic.TLAReconcilingStrategy;
import org.lamport.tla.toolbox.editor.basic.ToolboxHover;
import org.lamport.tla.toolbox.editor.basic.pcal.PCalCompletionProcessor;
import org.lamport.tla.toolbox.editor.basic.pcal.PCalHover;
import org.lamport.tla.toolbox.editor.basic.tla.TLAAnnotationHover;
import org.lamport.tla.toolbox.editor.basic.tla.TLACompletionProcessor;

public class TLASourceViewerConfiguration
extends TextSourceViewerConfiguration {
    private final TLAEditor editor;

    public TLASourceViewerConfiguration() {
        this.editor = null;
    }

    public TLASourceViewerConfiguration(IPreferenceStore preferenceStore, TLAEditor editor) {
        super(preferenceStore);
        this.editor = editor;
    }

    public IPresentationReconciler getPresentationReconciler(ISourceViewer sourceViewer) {
        TLAColorProvider provider = TLAEditorActivator.getDefault().getTLAColorProvider();
        PresentationReconciler reconciler = new PresentationReconciler();
        reconciler.setDocumentPartitioning(this.getConfiguredDocumentPartitioning(sourceViewer));
        DefaultDamagerRepairer dr = new DefaultDamagerRepairer(TLAEditorActivator.getDefault().getTLACodeScanner());
        reconciler.setDamager((IPresentationDamager)dr, "__dftl_partition_content_type");
        reconciler.setRepairer((IPresentationRepairer)dr, "__dftl_partition_content_type");
        dr = new DefaultDamagerRepairer((ITokenScanner)new SingleTokenScanner(new TextAttribute(provider.getColor("tla.comment.multiline"))));
        reconciler.setDamager((IPresentationDamager)dr, "__tla_multiline_comment");
        reconciler.setRepairer((IPresentationRepairer)dr, "__tla_multiline_comment");
        dr = new DefaultDamagerRepairer((ITokenScanner)new SingleTokenScanner(new TextAttribute(provider.getColor("tla.comment.single"))));
        reconciler.setDamager((IPresentationDamager)dr, "__tla_singleline_comment");
        reconciler.setRepairer((IPresentationRepairer)dr, "__tla_singleline_comment");
        dr = new DefaultDamagerRepairer((ITokenScanner)new SingleTokenScanner(new TextAttribute(provider.getColor("tla.value"))));
        reconciler.setDamager((IPresentationDamager)dr, "__tla_string");
        reconciler.setRepairer((IPresentationRepairer)dr, "__tla_string");
        dr = new DefaultDamagerRepairer(TLAEditorActivator.getDefault().getPCALCodeScanner());
        reconciler.setDamager((IPresentationDamager)dr, "__tla_pcal");
        reconciler.setRepairer((IPresentationRepairer)dr, "__tla_pcal");
        return reconciler;
    }

    public String getConfiguredDocumentPartitioning(ISourceViewer sourceViewer) {
        return "__tla_partitioning";
    }

    public String[] getConfiguredContentTypes(ISourceViewer sourceViewer) {
        return new String[]{"__dftl_partition_content_type", "__tla_multiline_comment", "__tla_singleline_comment", "__tla_string", "__tla_pcal"};
    }

    public IContentAssistant getContentAssistant(ISourceViewer sourceViewer) {
        ContentAssistant assistant = new ContentAssistant();
        assistant.setDocumentPartitioning(this.getConfiguredDocumentPartitioning(sourceViewer));
        assistant.setContentAssistProcessor((IContentAssistProcessor)new TLACompletionProcessor(), "__dftl_partition_content_type");
        assistant.setContentAssistProcessor((IContentAssistProcessor)new PCalCompletionProcessor(), "__tla_pcal");
        assistant.enableColoredLabels(true);
        assistant.enableAutoActivation(true);
        assistant.setAutoActivationDelay(500);
        assistant.setInformationControlCreator(new IInformationControlCreator(){

            public IInformationControl createInformationControl(Shell parent) {
                return new DefaultInformationControl(parent, null);
            }
        });
        assistant.setSorter(new ICompletionProposalSorter(){

            public int compare(ICompletionProposal p1, ICompletionProposal p2) {
                return 0;
            }
        });
        assistant.setProposalPopupOrientation(10);
        assistant.setContextInformationPopupOrientation(20);
        assistant.setContextInformationPopupBackground(TLAEditorActivator.getDefault().getTLAColorProvider().getColor("content_assist.background"));
        return assistant;
    }

    public ITextHover getTextHover(ISourceViewer sourceViewer, String contentType) {
        if ("__tla_pcal".equals(contentType)) {
            return new PCalHover();
        }
        return new ToolboxHover();
    }

    public IInformationControlCreator getInformationControlCreator(ISourceViewer sourceViewer) {
        return new IInformationControlCreator(){

            public IInformationControl createInformationControl(Shell parent) {
                return new MonospacedDefaultInformationControl(parent);
            }
        };
    }

    public IAnnotationHover getAnnotationHover(ISourceViewer sourceViewer) {
        return new TLAAnnotationHover();
    }

    public IReconciler getReconciler(ISourceViewer sourceViewer) {
        TLAReconcilingStrategy strategy = new TLAReconcilingStrategy();
        strategy.setEditor(this.editor);
        if (sourceViewer instanceof ProjectionViewer) {
            strategy.setProjectionViewer((ProjectionViewer)sourceViewer);
        }
        return new MonoReconciler((IReconcilingStrategy)strategy, false);
    }

    public String[] getDefaultPrefixes(ISourceViewer sourceViewer, String contentType) {
        return new String[]{"\\*", ""};
    }

    public static class MonospacedDefaultInformationControl
    extends DefaultInformationControl {
        public MonospacedDefaultInformationControl(Shell parent) {
            super(parent, null);
        }

        protected void createContent(Composite parent) {
            super.createContent(parent);
            try {
                Field f = DefaultInformationControl.class.getDeclaredField("fText");
                f.setAccessible(true);
                StyledText fText = (StyledText)f.get((Object)this);
                fText.setFont(JFaceResources.getFont((String)"org.eclipse.jface.textfont"));
            }
            catch (NoSuchFieldException noSuchFieldException) {
            }
            catch (SecurityException securityException) {
            }
            catch (IllegalArgumentException illegalArgumentException) {
            }
            catch (IllegalAccessException illegalAccessException) {
                // empty catch block
            }
        }
    }

    public static class SingleTokenScanner
    extends BufferedRuleBasedScanner {
        public SingleTokenScanner(TextAttribute attribute) {
            this.setDefaultReturnToken((IToken)new Token((Object)attribute));
        }
    }
}

