/*
 * Decompiled with CFR 0.152.
 */
package org.lamport.tla.toolbox.editor.basic.handlers;

import java.util.Arrays;
import java.util.Comparator;
import java.util.HashMap;
import org.eclipse.core.commands.AbstractHandler;
import org.eclipse.core.commands.ExecutionEvent;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.commands.IHandler;
import org.eclipse.core.resources.IMarker;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.dialogs.PopupDialog;
import org.eclipse.jface.text.IRegion;
import org.eclipse.swt.events.KeyEvent;
import org.eclipse.swt.events.KeyListener;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.List;
import org.eclipse.swt.widgets.Shell;
import org.lamport.tla.toolbox.Activator;
import org.lamport.tla.toolbox.editor.basic.TLAEditor;
import org.lamport.tla.toolbox.editor.basic.TLAEditorActivator;
import org.lamport.tla.toolbox.editor.basic.tla.TokenSpec;
import org.lamport.tla.toolbox.editor.basic.util.EditorUtil;
import org.lamport.tla.toolbox.spec.Spec;
import org.lamport.tla.toolbox.tool.ToolboxHandle;
import org.lamport.tla.toolbox.util.AdapterFactory;
import org.lamport.tla.toolbox.util.ResourceHelper;
import org.lamport.tla.toolbox.util.UIHelper;
import tla2sany.parser.SyntaxTreeNode;
import tla2sany.semantic.ModuleNode;
import tla2sany.semantic.OpApplNode;
import tla2sany.semantic.SemanticNode;
import tla2sany.semantic.SymbolNode;
import tla2sany.st.Location;
import tla2sany.st.SyntaxTreeConstants;

public class ShowUsesHandler
extends AbstractHandler
implements IHandler,
SyntaxTreeConstants {
    public static final String SHOW_USE_MARKER_TYPE = "org.lamport.tla.toolbox.editor.basic.showUse";

    public static String titleText(String prefix) {
        if (prefix == "") {
            return "Definitions and Declarations";
        }
        return prefix;
    }

    public Object execute(ExecutionEvent event) throws ExecutionException {
        TLAEditor tlaEditor;
        IResource resource;
        Spec spec = ToolboxHandle.getCurrentSpec();
        if (spec == null) {
            return null;
        }
        String oldModuleName = spec.getModuleToShow();
        if (oldModuleName != null && (resource = ResourceHelper.getResourceByModuleName((String)oldModuleName)) != null) {
            try {
                resource.deleteMarkers(SHOW_USE_MARKER_TYPE, false, 99);
            }
            catch (CoreException e) {
                e.printStackTrace();
            }
            spec.setMarkersToShow(null);
        }
        if ((tlaEditor = EditorUtil.getTLAEditorWithFocus()) == null) {
            return null;
        }
        String moduleName = tlaEditor.getModuleName();
        ModuleNode moduleNode = ResourceHelper.getModuleNode((String)moduleName);
        if (moduleNode == null) {
            return null;
        }
        TokenSpec currentTokenSpec = TokenSpec.findCurrentTokenSpec();
        if (currentTokenSpec == null || currentTokenSpec.resolvedSymbol == null) {
            return null;
        }
        SymbolNode resolvedSymbol = currentTokenSpec.resolvedSymbol;
        String[] tempModuleNames = ResourceHelper.getModuleNames();
        int numberOfModulesUsedIn = 0;
        SemanticNode[][] tempUsesArray = new SemanticNode[tempModuleNames.length][];
        int i = 0;
        while (i < tempModuleNames.length) {
            tempUsesArray[i] = ResourceHelper.getUsesOfSymbol((SymbolNode)resolvedSymbol, (SemanticNode)ResourceHelper.getModuleNode((String)tempModuleNames[i]));
            if (tempUsesArray[i] != null && tempUsesArray[i].length > 0) {
                ++numberOfModulesUsedIn;
            }
            ++i;
        }
        if (numberOfModulesUsedIn == 0) {
            MessageDialog.openWarning((Shell)UIHelper.getShellProvider().getShell(), (String)"Cannot find uses", (String)("There are no uses of the symbol " + String.valueOf(resolvedSymbol.getName())));
            return null;
        }
        SemanticNode[][] usesArray = new SemanticNode[numberOfModulesUsedIn][];
        String[] moduleNames = new String[numberOfModulesUsedIn];
        int j = 0;
        int i2 = 0;
        while (i2 < tempModuleNames.length) {
            if (tempUsesArray[i2] != null && tempUsesArray[i2].length > 0) {
                usesArray[j] = tempUsesArray[i2];
                moduleNames[j] = tempModuleNames[i2];
                ++j;
            }
            ++i2;
        }
        j = -1;
        i2 = 0;
        while (i2 < moduleNames.length) {
            if (moduleName.equals(moduleNames[i2])) {
                j = i2;
                break;
            }
            ++i2;
        }
        if (j > 0) {
            SemanticNode[] savedUses = usesArray[j];
            int i3 = j - 1;
            while (i3 > -1) {
                usesArray[i3 + 1] = usesArray[i3];
                moduleNames[i3 + 1] = moduleNames[i3];
                --i3;
            }
            usesArray[0] = savedUses;
            moduleNames[0] = moduleName;
        }
        String moduleToShow = null;
        if (moduleNames.length > 1) {
            Shell parent = UIHelper.getShellProvider().getShell();
            ShowUsesPopupDialog popup = new ShowUsesPopupDialog(parent, moduleNames, usesArray);
            popup.open();
        } else {
            moduleToShow = moduleName = moduleNames[0];
            spec.setModuleToShow(moduleToShow);
            int moduleIndex = -1;
            int i4 = 0;
            while (i4 < moduleNames.length) {
                if (moduleNames[i4].equals(moduleToShow)) {
                    moduleIndex = i4;
                    break;
                }
                ++i4;
            }
            if (moduleIndex < 0) {
                Activator.getDefault().logDebug("Could not find module name in array in which it should be.  This is a bug.");
                return null;
            }
            SemanticNode[] uses = usesArray[moduleIndex];
            ShowUsesHandler.setUseMarkers(uses, moduleName, spec);
        }
        return null;
    }

    public boolean isEnabled() {
        if (EditorUtil.getTLAEditorWithFocus() == null) {
            return false;
        }
        return super.isEnabled();
    }

    private static void setUseMarkers(SemanticNode[] uses, String moduleName, Spec spec) {
        Location[] locations = new Location[uses.length];
        int i = 0;
        while (i < locations.length) {
            SyntaxTreeNode stn = (SyntaxTreeNode)uses[i].stn;
            switch (stn.getKind()) {
                case 387: {
                    stn = (SyntaxTreeNode)stn.heirs()[0];
                    break;
                }
                case 371: 
                case 395: {
                    stn = (SyntaxTreeNode)stn.heirs()[1];
                    break;
                }
                case 358: {
                    if (!(uses[i] instanceof OpApplNode)) break;
                    OpApplNode oan = (OpApplNode)uses[i];
                    if (oan.subExpressionOf == null || oan.subExpressionOf == oan.getOperator()) break;
                    while (stn.getKind() > 327 && stn.heirs() != null && stn.heirs().length > 0) {
                        stn = (SyntaxTreeNode)stn.heirs()[0];
                    }
                    break;
                }
                default: {
                    TLAEditorActivator.getDefault().logWarning("Found unexpected kind " + stn.getKind() + " for stn node of symbol use.");
                }
            }
            locations[i] = stn.getLocation();
            ++i;
        }
        Arrays.sort(locations, new LocationComparator());
        UIHelper.jumpToLocation((Location)locations[0]);
        spec.setCurrentSelection(0);
        IResource resource = ResourceHelper.getResourceByModuleName((String)spec.getModuleToShow());
        if (resource == null) {
            TLAEditorActivator.getDefault().logWarning("Why is the resource null?");
            return;
        }
        try {
            resource.deleteMarkers(SHOW_USE_MARKER_TYPE, false, 99);
            spec.setMarkersToShow(null);
            IMarker[] markersToShow = new IMarker[locations.length];
            int i2 = 0;
            while (i2 < markersToShow.length) {
                IRegion iregion = AdapterFactory.locationToRegion((Location)locations[i2]);
                IMarker marker = resource.createMarker(SHOW_USE_MARKER_TYPE);
                HashMap<String, Integer> markerAttributes = new HashMap<String, Integer>(2);
                markerAttributes.put("charStart", new Integer(iregion.getOffset()));
                markerAttributes.put("charEnd", new Integer(iregion.getOffset() + iregion.getLength()));
                marker.setAttributes(markerAttributes);
                markersToShow[i2] = marker;
                ++i2;
            }
            spec.setMarkersToShow(markersToShow);
        }
        catch (CoreException e) {
            e.printStackTrace();
        }
    }

    private static int selectString(String[] strArray, String str) {
        int i = 0;
        while (i < strArray.length) {
            if (strArray[i].equals(str)) {
                return i;
            }
            ++i;
        }
        return -1;
    }

    private static class LocationComparator
    implements Comparator<Location> {
        private LocationComparator() {
        }

        @Override
        public int compare(Location loc1, Location loc2) {
            if (loc1.beginLine() < loc2.beginLine()) {
                return -1;
            }
            if (loc1.beginLine() > loc2.beginLine()) {
                return 1;
            }
            if (loc1.beginColumn() == loc2.beginColumn()) {
                return 0;
            }
            return loc1.beginColumn() < loc2.beginColumn() ? -1 : 1;
        }
    }

    public static class ShowUsesKeyListener
    implements KeyListener {
        ShowUsesPopupDialog popup;

        public ShowUsesKeyListener(ShowUsesPopupDialog popup) {
            this.popup = popup;
        }

        public void keyPressed(KeyEvent e) {
            char keyPressed = e.character;
            int keyCode = e.keyCode;
            List list = this.popup.list;
            int selection = list.getSelectionIndex();
            e.doit = false;
            if (keyCode == 0x1000002 || keyCode == 0x1000004) {
                if (list.getItemCount() == 0 || selection == -1) {
                    return;
                }
                list.select(Math.min(list.getItemCount(), selection + 1));
            } else if (keyCode == 0x1000001 || keyCode == 0x1000003) {
                if (list.getItemCount() == 0 || selection == -1) {
                    return;
                }
                list.select(Math.max(0, selection - 1));
            } else if (keyCode == 13 || keyCode == 0x1000050) {
                Spec spec = ToolboxHandle.getCurrentSpec();
                if (spec != null) {
                    String moduleName = list.getSelection()[0];
                    spec.setModuleToShow(list.getSelection()[0]);
                    int idx = ShowUsesHandler.selectString(this.popup.moduleList, moduleName);
                    if (idx != -1) {
                        ShowUsesHandler.setUseMarkers(this.popup.showUses[idx], moduleName, spec);
                    }
                }
                this.popup.close();
            } else if (Character.isLetterOrDigit(keyPressed) || keyPressed == '_' || keyPressed == '!') {
                this.popup.filterPrefix = this.popup.filterPrefix + keyPressed;
                this.popup.setList();
                this.popup.setTitleText(ShowUsesHandler.titleText(this.popup.filterPrefix));
                if (list.getItemCount() > 0) {
                    list.select(0);
                }
            } else if (!(keyCode != 127 && keyCode != 8 || this.popup.filterPrefix.equals(""))) {
                this.popup.filterPrefix = this.popup.filterPrefix.substring(0, this.popup.filterPrefix.length() - 1);
                this.popup.setList();
                this.popup.setTitleText(ShowUsesHandler.titleText(this.popup.filterPrefix));
                if (list.getItemCount() > 0) {
                    list.select(0);
                }
            }
        }

        public void keyReleased(KeyEvent e) {
        }
    }

    public static class ShowUsesPopupDialog
    extends PopupDialog {
        Shell parent;
        String[] moduleList;
        SemanticNode[][] showUses;
        List list;
        boolean showAll = true;
        String filterPrefix = "";
        TLAEditor editor;
        ModuleNode module;

        public ShowUsesPopupDialog(Shell parent, String[] moduleList, SemanticNode[][] usesArray) {
            super(parent, 8, true, false, true, true, true, "Choose Module", "Click or choose by typing prefix or arrow keys and enter.");
            this.parent = parent;
            this.moduleList = moduleList;
            this.showUses = usesArray;
            this.editor = EditorUtil.getTLAEditorWithFocus();
            if (this.editor != null) {
                this.module = ResourceHelper.getModuleNode((String)this.editor.getModuleName());
            }
        }

        protected Control createDialogArea(Composite composite) {
            this.list = new List(composite, 532);
            this.setList();
            this.list.addSelectionListener((SelectionListener)new ShowUsesSelectionListener(this.showUses, this.moduleList));
            this.list.addKeyListener((KeyListener)new ShowUsesKeyListener(this));
            this.list.setSelection(0);
            return this.list;
        }

        public void setTitleText(String str) {
            super.setTitleText(str);
        }

        protected void setList() {
            this.list.removeAll();
            int i = 0;
            while (i < this.moduleList.length) {
                if (this.moduleList[i].startsWith(this.filterPrefix)) {
                    this.list.add(this.moduleList[i]);
                }
                ++i;
            }
        }
    }

    public static class ShowUsesSelectionListener
    implements SelectionListener {
        SemanticNode[][] showUses;
        String[] moduleNames;

        public ShowUsesSelectionListener(SemanticNode[][] showUses2, String[] moduleNames) {
            this.showUses = showUses2;
            this.moduleNames = moduleNames;
        }

        public void widgetDefaultSelected(SelectionEvent e) {
        }

        public void widgetSelected(SelectionEvent e) {
            List list = (List)e.widget;
            Spec spec = ToolboxHandle.getCurrentSpec();
            if (spec != null) {
                spec.setModuleToShow(list.getSelection()[0]);
                String moduleName = list.getSelection()[0];
                spec.setModuleToShow(list.getSelection()[0]);
                int idx = ShowUsesHandler.selectString(this.moduleNames, moduleName);
                if (idx != -1) {
                    ShowUsesHandler.setUseMarkers(this.showUses[idx], moduleName, spec);
                }
            }
        }
    }
}

