/*
 * Decompiled with CFR 0.152.
 */
package org.lamport.tla.toolbox.editor.basic.handlers;

import org.eclipse.core.commands.AbstractHandler;
import org.eclipse.core.commands.ExecutionEvent;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.commands.IHandler;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.IRegion;
import org.eclipse.jface.text.TextSelection;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.swt.widgets.Shell;
import org.lamport.tla.toolbox.Activator;
import org.lamport.tla.toolbox.editor.basic.TLAEditor;
import org.lamport.tla.toolbox.editor.basic.util.EditorUtil;
import org.lamport.tla.toolbox.util.UIHelper;
import util.StringHelper;

public class BoxedCommentHandler
extends AbstractHandler
implements IHandler {
    private int RightMargin;
    private IDocument doc;
    private String text;
    private ISelectionProvider selectionProvider;
    private TextSelection selection;
    private int offset;
    private IRegion lineInfo;
    int margin;
    int indent;
    int beginCommentOffset;
    int endCommentOffset;
    public final String startBoxedCommentId = "org.lamport.tla.toolbox.editor.basic.startBoxedComment";
    public final String boxCommentId = "org.lamport.tla.toolbox.editor.basic.boxComment";
    public final String unboxCommentId = "org.lamport.tla.toolbox.editor.basic.unboxComment";
    public final String formatCommentId = "org.lamport.tla.toolbox.editor.basic.formatComment";
    public final String formatAndBoxCommentId = "org.lamport.tla.toolbox.editor.basic.formatAndBoxComment";

    public Object execute(ExecutionEvent event) throws ExecutionException {
        TLAEditor editor = EditorUtil.getTLAEditorWithFocus();
        if (editor == null) {
            return null;
        }
        this.doc = editor.getDocumentProvider().getDocument((Object)editor.getEditorInput());
        this.text = this.doc.get();
        this.selectionProvider = editor.getSelectionProvider();
        this.selection = (TextSelection)this.selectionProvider.getSelection();
        this.offset = this.selection.getOffset();
        this.RightMargin = Activator.getDefault().getPreferenceStore().getInt("editorRightMargin");
        if (this.offset < 0) {
            return null;
        }
        try {
            this.lineInfo = this.doc.getLineInformationOfOffset(this.offset);
            String cmd = event.getCommand().getId();
            if (cmd.equals("org.lamport.tla.toolbox.editor.basic.startBoxedComment")) {
                this.startBoxedComment();
            } else if (cmd.equals("org.lamport.tla.toolbox.editor.basic.boxComment")) {
                this.boxComment();
            } else if (cmd.equals("org.lamport.tla.toolbox.editor.basic.formatAndBoxComment")) {
                this.formatAndBoxComment();
            } else if (cmd.equals("org.lamport.tla.toolbox.editor.basic.unboxComment")) {
                this.unboxComment();
            } else if (cmd.equals("org.lamport.tla.toolbox.editor.basic.formatComment")) {
                this.formatComment();
            } else {
                Activator.getDefault().logInfo("Unrecognized boxing command.");
            }
        }
        catch (BadLocationException e) {
            Activator.getDefault().logError("Error executing comment-boxing command", (Throwable)e);
        }
        this.doc = null;
        this.text = null;
        this.selectionProvider = null;
        this.selection = null;
        this.lineInfo = null;
        return null;
    }

    private void startBoxedComment() throws BadLocationException {
        int indent = this.offset - this.lineInfo.getOffset() + 1;
        int restOfLineLength = this.lineInfo.getOffset() - this.offset + this.lineInfo.getLength();
        String restOfLine = this.doc.get(this.offset, restOfLineLength);
        boolean dontAddNewLine = StringHelper.onlySpaces((String)restOfLine);
        String asterisks = StringHelper.copyString((String)"*", (int)Math.max(3, this.RightMargin - indent - 1));
        String newText = "(" + asterisks + StringHelper.PLATFORM_NEWLINE + StringHelper.PLATFORM_NEWLINE + StringHelper.copyString((String)" ", (int)indent) + asterisks + ")" + (dontAddNewLine ? "" : StringHelper.PLATFORM_NEWLINE);
        this.doc.replace(this.selection.getOffset(), this.selection.getLength(), newText);
        this.selectionProvider.setSelection((ISelection)new TextSelection(this.offset + 1 + asterisks.length() + StringHelper.PLATFORM_NEWLINE.length(), 0));
    }

    private void formatAndBoxComment() throws BadLocationException {
        if (this.formatComment()) {
            this.text = this.doc.get();
            this.selection = (TextSelection)this.selectionProvider.getSelection();
            this.offset = this.selection.getOffset();
            this.boxComment();
        }
    }

    private boolean boxComment() throws BadLocationException {
        this.setCommentFields();
        if (this.beginCommentOffset < 0 || this.endCommentOffset < 2) {
            return false;
        }
        int beginCommentLength = 2;
        while (this.text.charAt(this.beginCommentOffset + beginCommentLength) == '*') {
            ++beginCommentLength;
        }
        int endCommentLength = 2;
        while (this.text.charAt(this.endCommentOffset - 1 - endCommentLength) == '*') {
            ++endCommentLength;
        }
        int beginLine = this.doc.getLineOfOffset(this.beginCommentOffset);
        int endLine = this.doc.getLineOfOffset(this.endCommentOffset);
        StringBuffer buffer = new StringBuffer(4 * this.margin);
        buffer.append(this.makeCommentBoxStart());
        buffer.append(StringHelper.PLATFORM_NEWLINE);
        if (beginLine == endLine) {
            String singleLine = this.doc.get(this.beginCommentOffset + beginCommentLength, this.endCommentOffset - (this.beginCommentOffset + beginCommentLength) - endCommentLength);
            buffer.append(this.makeCommentBoxLine(StringHelper.trimFront((String)singleLine)));
            buffer.append(StringHelper.PLATFORM_NEWLINE);
        } else {
            String restOfLine = this.doc.get(this.beginCommentOffset + beginCommentLength, this.doc.getLineOffset(beginLine) + this.doc.getLineLength(beginLine) - (this.beginCommentOffset + beginCommentLength));
            if (!StringHelper.onlySpaces((String)restOfLine)) {
                buffer.append(this.makeCommentBoxLine(StringHelper.trimFront((String)restOfLine)));
                buffer.append(StringHelper.PLATFORM_NEWLINE);
            }
            int i = beginLine + 1;
            while (i < endLine) {
                buffer.append(this.makeCommentBoxLine(this.doc.get(this.doc.getLineOffset(i), this.doc.getLineLength(i))));
                buffer.append(StringHelper.PLATFORM_NEWLINE);
                ++i;
            }
            int lineOffset = this.doc.getLineOffset(endLine);
            String startOfLine = this.doc.get(lineOffset, this.endCommentOffset - endCommentLength - lineOffset);
            if (!StringHelper.onlySpaces((String)startOfLine)) {
                buffer.append(this.makeCommentBoxLine(startOfLine));
                buffer.append(StringHelper.PLATFORM_NEWLINE);
            }
        }
        buffer.append(this.makeCommentBoxEnd());
        if (!StringHelper.onlySpaces((String)this.doc.get(this.endCommentOffset, this.doc.getLineOffset(endLine) - this.endCommentOffset + this.doc.getLineLength(endLine)))) {
            buffer.append(StringHelper.PLATFORM_NEWLINE);
        }
        this.doc.replace(this.beginCommentOffset, this.endCommentOffset - this.beginCommentOffset, buffer.toString());
        return true;
    }

    private final void unboxComment() throws BadLocationException {
        int endLine;
        if (this.offset > 2 && this.text.charAt(this.offset) == ')') {
            --this.offset;
        }
        if (this.offset > 1 && this.text.charAt(this.offset) == '*') {
            --this.offset;
        }
        String errorMsg = "Unbox Coment command called when not inside a boxed comment.";
        int startOffset = this.text.lastIndexOf("(**", this.offset);
        int endOffset = this.text.indexOf("**)", this.offset) + 3;
        if (startOffset < 0 || endOffset < 0) {
            this.displayNotInBoxedCommentError(errorMsg);
            return;
        }
        int startIndent = startOffset - this.doc.getLineOffset(this.doc.getLineOfOffset(startOffset));
        int asteriskLength = this.RightMargin - startIndent - 1;
        String asterisks = StringHelper.copyString((String)"*", (int)asteriskLength);
        int beginLine = this.doc.getLineOfOffset(startOffset);
        if (beginLine == (endLine = this.doc.getLineOfOffset(endOffset))) {
            if (this.text.substring(startOffset + 1, endOffset - 1).equals(StringHelper.copyString((String)"*", (int)(endOffset - startOffset - 2)))) {
                this.displayNotInBoxedCommentError("You are at the beginning or ending line of a boxed comment,\nnot inside the boxed comment");
            } else {
                this.displayNotInBoxedCommentError(errorMsg);
            }
            return;
        }
        StringBuffer buffer = null;
        int bufferSize = endOffset - startOffset - 6 * (endLine - beginLine);
        buffer = bufferSize > 0 ? new StringBuffer(bufferSize) : new StringBuffer();
        buffer.append(asterisks);
        buffer.append(StringHelper.PLATFORM_NEWLINE);
        int i = beginLine + 1;
        while (i < endLine) {
            IRegion lineInfo = this.doc.getLineInformation(i);
            String currentLine = this.doc.get(lineInfo.getOffset(), lineInfo.getLength());
            int beginTokenIndex = currentLine.indexOf("(*");
            int endTokenIndex = currentLine.indexOf("*)");
            if (beginTokenIndex >= 0 && beginTokenIndex <= endTokenIndex) {
                buffer.append(StringHelper.trimEnd((String)currentLine.substring(beginTokenIndex + 3, endTokenIndex)));
                buffer.append(StringHelper.PLATFORM_NEWLINE);
            } else {
                buffer.append(currentLine);
                buffer.append(StringHelper.PLATFORM_NEWLINE);
            }
            ++i;
        }
        buffer.append(StringHelper.copyString((String)" ", (int)startIndent));
        buffer.append(asterisks);
        this.doc.replace(startOffset + 1, endOffset - 2 - startOffset, buffer.toString());
    }

    void displayNotInBoxedCommentError(String msg) {
        Shell shell = UIHelper.getShellProvider().getShell();
        MessageDialog.openError((Shell)shell, (String)"Not inside a boxed comment", (String)msg);
    }

    private final boolean formatComment() throws BadLocationException {
        this.setCommentFields();
        int beginCommentLine = this.doc.getLineOfOffset(this.beginCommentOffset);
        int endCommentLine = this.doc.getLineOfOffset(this.endCommentOffset);
        if (endCommentLine - beginCommentLine < 2) {
            return false;
        }
        int beginReplacementOffset = this.doc.getLineOffset(beginCommentLine + 1);
        int endReplacementOffset = this.doc.getLineOffset(endCommentLine);
        StringBuffer buffer = new StringBuffer(50 * (endCommentLine - beginCommentLine));
        int lineWidth = this.margin - this.indent - 6;
        int unfinishedLineWidth = 0;
        int i = beginCommentLine + 1;
        while (i < endCommentLine) {
            IRegion lineInfo = this.doc.getLineInformation(i);
            String currentLine = this.doc.get(lineInfo.getOffset(), lineInfo.getLength());
            if (currentLine.length() == 0 || Character.isSpaceChar(currentLine.charAt(0))) {
                if (unfinishedLineWidth > 0) {
                    buffer.append(StringHelper.PLATFORM_NEWLINE);
                    unfinishedLineWidth = 0;
                }
                buffer.append(currentLine);
                buffer.append(StringHelper.PLATFORM_NEWLINE);
            } else {
                String[] words = StringHelper.getWords((String)currentLine);
                int nextPos = 0;
                while (nextPos < words.length) {
                    String nextWord = words[nextPos];
                    if (unfinishedLineWidth == 0) {
                        buffer.append(nextWord);
                        unfinishedLineWidth = nextWord.length();
                    } else {
                        boolean followsPeriod = buffer.charAt(buffer.length() - 1) == '.';
                        int nextWidth = unfinishedLineWidth + (followsPeriod ? 2 : 1) + nextWord.length();
                        if (nextWidth > lineWidth) {
                            buffer.append(StringHelper.PLATFORM_NEWLINE);
                            buffer.append(nextWord);
                            unfinishedLineWidth = nextWord.length();
                        } else {
                            buffer.append(followsPeriod ? "  " : " ");
                            buffer.append(nextWord);
                            unfinishedLineWidth = nextWidth;
                        }
                    }
                    ++nextPos;
                }
            }
            ++i;
        }
        if (unfinishedLineWidth > 0) {
            buffer.append(StringHelper.PLATFORM_NEWLINE);
            unfinishedLineWidth = 0;
        }
        this.doc.replace(beginReplacementOffset, endReplacementOffset - beginReplacementOffset, buffer.toString());
        return true;
    }

    private void setCommentFields() throws BadLocationException {
        int searchOffset = this.offset;
        if (this.offset > 0 && this.text.charAt(this.offset - 1) == '(') {
            ++searchOffset;
        }
        this.beginCommentOffset = this.text.lastIndexOf("(*", searchOffset);
        searchOffset = this.offset;
        if (this.text.charAt(this.offset) == ')') {
            --searchOffset;
        }
        this.endCommentOffset = this.text.indexOf("*)", searchOffset) + 2;
        IRegion beginCommentLineInfo = this.doc.getLineInformationOfOffset(this.beginCommentOffset);
        this.indent = this.beginCommentOffset - beginCommentLineInfo.getOffset();
        this.margin = Math.max(this.RightMargin, this.indent + 4);
    }

    private final String makeCommentBoxEnd() {
        return StringHelper.copyString((String)" ", (int)this.indent) + "(*" + StringHelper.copyString((String)"*", (int)(this.margin - this.indent - 4)) + "*)";
    }

    private final String makeCommentBoxStart() {
        return "(*" + StringHelper.copyString((String)"*", (int)(this.margin - this.indent - 4)) + "*)";
    }

    private final String makeCommentBoxLine(String str) {
        String trimmed = StringHelper.trimEnd((String)str);
        int endSpaces = Math.max(0, this.margin - trimmed.length() - this.indent - 6);
        return StringHelper.copyString((String)" ", (int)this.indent) + "(* " + trimmed + StringHelper.copyString((String)" ", (int)endSpaces) + " *)";
    }

    public boolean isEnabled() {
        if (EditorUtil.getTLAEditorWithFocus() == null) {
            return false;
        }
        return super.isEnabled();
    }
}

