/*
 * Decompiled with CFR 0.152.
 */
package org.lamport.tla.toolbox.editor.basic;

import java.util.Dictionary;
import java.util.Hashtable;
import org.eclipse.e4.ui.css.swt.theme.ITheme;
import org.eclipse.e4.ui.css.swt.theme.IThemeEngine;
import org.eclipse.e4.ui.css.swt.theme.IThemeManager;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.text.rules.IPartitionTokenScanner;
import org.eclipse.jface.text.rules.ITokenScanner;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;
import org.lamport.tla.toolbox.AbstractTLCActivator;
import org.lamport.tla.toolbox.Activator;
import org.lamport.tla.toolbox.editor.basic.TLAColorProvider;
import org.lamport.tla.toolbox.editor.basic.TLAPartitionScanner;
import org.lamport.tla.toolbox.editor.basic.tla.PCALCodeScanner;
import org.lamport.tla.toolbox.editor.basic.tla.TLACodeScanner;
import org.osgi.framework.BundleContext;
import org.osgi.framework.ServiceReference;
import org.osgi.framework.ServiceRegistration;
import org.osgi.service.event.Event;
import org.osgi.service.event.EventHandler;

public class TLAEditorActivator
extends AbstractTLCActivator {
    public static final String PLUGIN_ID = "org.lamport.tla.toolbox.editor.basic";
    private static TLAEditorActivator plugin;
    private static final String DARK_THEME_ID_PREFIX = "org.eclipse.e4.ui.css.theme.e4_dark";
    private TLAPartitionScanner partitionTokenScanner;
    private TLAColorProvider colorProvider;
    private TLACodeScanner tlaCodeScanner;
    private PCALCodeScanner pcalCodeScanner;
    private ServiceRegistration<?> themeChangeEventRegistration;
    private Boolean currentThemeIsDark;

    public static TLAEditorActivator getDefault() {
        return plugin;
    }

    public TLAEditorActivator() {
        super(PLUGIN_ID);
    }

    public void start(BundleContext context) throws Exception {
        plugin = this;
        super.start(context);
        Hashtable<String, String> serviceRegistrationProperties = new Hashtable<String, String>();
        ((Dictionary)serviceRegistrationProperties).put("event.topics", "org/eclipse/e4/ui/css/swt/theme/ThemeManager/themeChanged");
        this.themeChangeEventRegistration = context.registerService(EventHandler.class.getName(), (Object)new EventHandler(){

            public void handleEvent(Event event) {
                TLAEditorActivator.this.tlaCodeScanner = null;
                TLAEditorActivator.this.pcalCodeScanner = null;
                TLAEditorActivator.this.setDarkThemeStatus();
            }
        }, serviceRegistrationProperties);
    }

    public void stop(BundleContext context) throws Exception {
        this.themeChangeEventRegistration.unregister();
        plugin = null;
        super.stop(context);
    }

    private void setDarkThemeStatus() {
        Display d;
        IThemeEngine engine;
        ITheme it;
        IThemeManager manager;
        BundleContext context = Activator.getDefault().getBundle().getBundleContext();
        ServiceReference serviceReference = context.getServiceReference(IThemeManager.class);
        if (serviceReference != null && (manager = (IThemeManager)context.getService(serviceReference)) != null && (it = (engine = manager.getEngineForDisplay(d = Display.getDefault())).getActiveTheme()) != null) {
            boolean newThemeStatus = it.getId().startsWith(DARK_THEME_ID_PREFIX);
            if (this.currentThemeIsDark == null || this.currentThemeIsDark != newThemeStatus) {
                if (this.currentThemeIsDark != null) {
                    d.asyncExec(() -> MessageDialog.openInformation((Shell)d.getActiveShell(), (String)"Theme Change", (String)"You will need to close any open views and editors, then re-open them, to have your theme change fully reflected (or restart the Toolbox.)"));
                }
                this.currentThemeIsDark = newThemeStatus;
            }
        }
    }

    public boolean isCurrentThemeDark() {
        return this.currentThemeIsDark == null ? false : this.currentThemeIsDark;
    }

    public IPartitionTokenScanner getTLAPartitionScanner() {
        if (this.partitionTokenScanner == null) {
            this.partitionTokenScanner = new TLAPartitionScanner();
        }
        return this.partitionTokenScanner;
    }

    public TLAColorProvider getTLAColorProvider() {
        if (this.colorProvider == null) {
            this.colorProvider = new TLAColorProvider();
        }
        return this.colorProvider;
    }

    public ITokenScanner getTLACodeScanner() {
        if (this.tlaCodeScanner == null) {
            this.tlaCodeScanner = new TLACodeScanner();
        }
        return this.tlaCodeScanner;
    }

    public ITokenScanner getPCALCodeScanner() {
        if (this.pcalCodeScanner == null) {
            this.pcalCodeScanner = new PCALCodeScanner();
        }
        return this.pcalCodeScanner;
    }
}

