/*
 * Decompiled with CFR 0.152.
 */
package org.lamport.tla.toolbox.editor.basic;

import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.RGB;
import org.eclipse.swt.widgets.Display;
import org.lamport.tla.toolbox.editor.basic.TLAEditorActivator;

public class TLAColorProvider {
    public static final String CONTENT_ASSIST_BACKGROUND_KEY = "content_assist.background";
    public static final String DEFAULT_TEXT_KEY = "all.default";
    public static final String PCAL_KEYWORD_KEY = "pcal.keyword";
    public static final String TLA_KEYWORD_KEY = "tla.keyword";
    public static final String TLA_MULTI_LINE_COMMENT_KEY = "tla.comment.multiline";
    public static final String TLA_SINGLE_LINE_COMMENT_KEY = "tla.comment.single";
    public static final String TLA_VALUE_KEY = "tla.value";
    private static final RGB CONTENT_ASSIST_BACKGROUND_RGB = new RGB(150, 150, 0);
    private static final RGB DEFAULT_RGB = new RGB(0, 0, 0);
    private static final RGB PCAL_KEYWORD_RGB = new RGB(175, 40, 10);
    private static final RGB TLA_KEYWORD_RGB = new RGB(128, 0, 128);
    private static final RGB TLA_MULTI_LINE_COMMENT_RGB = new RGB(64, 64, 255);
    private static final RGB TLA_SINGLE_LINE_COMMENT_RGB = new RGB(0, 128, 64);
    private static final RGB TLA_VALUE_RGB = new RGB(0, 0, 255);
    private static final RGB CONTENT_ASSIST_BACKGROUND_DARK_RGB = new RGB(150, 150, 0);
    private static final RGB DEFAULT_DARK_RGB = new RGB(3, 167, 226);
    private static final RGB PCAL_KEYWORD_DARK_RGB = new RGB(245, 115, 67);
    private static final RGB TLA_KEYWORD_DARK_RGB = new RGB(172, 226, 156);
    private static final RGB TLA_MULTI_LINE_COMMENT_DARK_RGB = new RGB(245, 235, 191);
    private static final RGB TLA_SINGLE_LINE_COMMENT_DARK_RGB = new RGB(0, 207, 104);
    private static final RGB TLA_VALUE_DARK_RGB = new RGB(226, 200, 99);
    private static final Map<String, RGB> COLOR_KEY_RGB_MAP = new HashMap<String, RGB>();
    private final Map<String, Color> keyColorMap = new HashMap<String, Color>();

    static {
        COLOR_KEY_RGB_MAP.put(TLAColorProvider.getThemeContextualizedKey(CONTENT_ASSIST_BACKGROUND_KEY, false), CONTENT_ASSIST_BACKGROUND_RGB);
        COLOR_KEY_RGB_MAP.put(TLAColorProvider.getThemeContextualizedKey(DEFAULT_TEXT_KEY, false), DEFAULT_RGB);
        COLOR_KEY_RGB_MAP.put(TLAColorProvider.getThemeContextualizedKey(PCAL_KEYWORD_KEY, false), PCAL_KEYWORD_RGB);
        COLOR_KEY_RGB_MAP.put(TLAColorProvider.getThemeContextualizedKey(TLA_KEYWORD_KEY, false), TLA_KEYWORD_RGB);
        COLOR_KEY_RGB_MAP.put(TLAColorProvider.getThemeContextualizedKey(TLA_MULTI_LINE_COMMENT_KEY, false), TLA_MULTI_LINE_COMMENT_RGB);
        COLOR_KEY_RGB_MAP.put(TLAColorProvider.getThemeContextualizedKey(TLA_SINGLE_LINE_COMMENT_KEY, false), TLA_SINGLE_LINE_COMMENT_RGB);
        COLOR_KEY_RGB_MAP.put(TLAColorProvider.getThemeContextualizedKey(TLA_VALUE_KEY, false), TLA_VALUE_RGB);
        COLOR_KEY_RGB_MAP.put(TLAColorProvider.getThemeContextualizedKey(CONTENT_ASSIST_BACKGROUND_KEY, true), CONTENT_ASSIST_BACKGROUND_DARK_RGB);
        COLOR_KEY_RGB_MAP.put(TLAColorProvider.getThemeContextualizedKey(DEFAULT_TEXT_KEY, true), DEFAULT_DARK_RGB);
        COLOR_KEY_RGB_MAP.put(TLAColorProvider.getThemeContextualizedKey(PCAL_KEYWORD_KEY, true), PCAL_KEYWORD_DARK_RGB);
        COLOR_KEY_RGB_MAP.put(TLAColorProvider.getThemeContextualizedKey(TLA_KEYWORD_KEY, true), TLA_KEYWORD_DARK_RGB);
        COLOR_KEY_RGB_MAP.put(TLAColorProvider.getThemeContextualizedKey(TLA_MULTI_LINE_COMMENT_KEY, true), TLA_MULTI_LINE_COMMENT_DARK_RGB);
        COLOR_KEY_RGB_MAP.put(TLAColorProvider.getThemeContextualizedKey(TLA_SINGLE_LINE_COMMENT_KEY, true), TLA_SINGLE_LINE_COMMENT_DARK_RGB);
        COLOR_KEY_RGB_MAP.put(TLAColorProvider.getThemeContextualizedKey(TLA_VALUE_KEY, true), TLA_VALUE_DARK_RGB);
    }

    private static String getThemeContextualizedKey(String key, boolean themeIsDark) {
        return key + "_" + (themeIsDark ? "dunkel" : "hell");
    }

    public void dispose() {
        Iterator<Color> e = this.keyColorMap.values().iterator();
        while (e.hasNext()) {
            e.next().dispose();
        }
    }

    public Color getColor(String colorKey) {
        RGB rgb;
        String key = TLAColorProvider.getThemeContextualizedKey(colorKey, TLAEditorActivator.getDefault().isCurrentThemeDark());
        Color color = this.keyColorMap.get(key);
        if (color == null && (rgb = COLOR_KEY_RGB_MAP.get(key)) != null) {
            color = new Color((Device)Display.getCurrent(), rgb);
            this.keyColorMap.put(key, color);
        }
        return color;
    }
}

