/*
 * Decompiled with CFR 0.152.
 */
package org.lamport.tla.toolbox.editor.basic.handlers;

import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.Set;
import java.util.Vector;
import org.eclipse.core.commands.AbstractHandler;
import org.eclipse.core.commands.ExecutionEvent;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.commands.IHandler;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.resource.JFaceResources;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.IRegion;
import org.eclipse.jface.text.TextSelection;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.swt.events.DisposeEvent;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IEditorReference;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.editors.text.FileDocumentProvider;
import org.eclipse.ui.part.FileEditorInput;
import org.lamport.tla.toolbox.Activator;
import org.lamport.tla.toolbox.editor.basic.TLAEditor;
import org.lamport.tla.toolbox.editor.basic.util.EditorUtil;
import org.lamport.tla.toolbox.spec.Spec;
import org.lamport.tla.toolbox.spec.parser.ModuleParserLauncher;
import org.lamport.tla.toolbox.spec.parser.ParseResult;
import org.lamport.tla.toolbox.util.HelpButton;
import org.lamport.tla.toolbox.util.ResourceHelper;
import org.lamport.tla.toolbox.util.UIHelper;
import tla2sany.parser.SyntaxTreeNode;
import tla2sany.semantic.ASTConstants;
import tla2sany.semantic.AssumeProveNode;
import tla2sany.semantic.DefStepNode;
import tla2sany.semantic.ExprNode;
import tla2sany.semantic.ExprOrOpArgNode;
import tla2sany.semantic.FormalParamNode;
import tla2sany.semantic.InstanceNode;
import tla2sany.semantic.LeafProofNode;
import tla2sany.semantic.LevelNode;
import tla2sany.semantic.ModuleNode;
import tla2sany.semantic.NewSymbNode;
import tla2sany.semantic.NonLeafProofNode;
import tla2sany.semantic.OpApplNode;
import tla2sany.semantic.OpDefNode;
import tla2sany.semantic.ProofNode;
import tla2sany.semantic.SemanticNode;
import tla2sany.semantic.SubstInNode;
import tla2sany.semantic.SymbolNode;
import tla2sany.semantic.TheoremNode;
import tla2sany.st.Location;
import util.StringHelper;
import util.UniqueString;

public class OldDecomposeProofHandler
extends AbstractHandler
implements IHandler {
    private IDocument doc;
    private ISelectionProvider selectionProvider;
    private TextSelection selection;
    private int offset;
    private ModuleNode moduleNode;
    private TheoremNode theorem;
    private TheoremNode step;
    private NodeRepresentation stepRep;
    private ProofNode proof;
    private int proofLevel;
    private String proofLevelString;
    private String stepNumber;
    private int stepColumn;
    private static final boolean USE_SUFFICES_DEFAULT = true;
    private static final boolean USE_CASE_DEFAULT = true;
    private static final boolean SUBEXPRESSION_DEFAULT = false;
    private static final int PROOF_INDENT = 2;
    private static final boolean BLANK_LINE_BETWEEN_STEPS = false;
    private static final boolean OBVIOUS_HAS_PROOF = false;
    private static final boolean NUMBER_QED_STEP = true;
    private static final String STEP_NUMBER_PUNCTUATION = ".";
    private static final String RENAMING_SUFFIX = "_";
    private Vector<NodeRepresentation> assumeReps;
    private NodeRepresentation goalRep;
    private Shell windowShell;
    private Point location = null;
    private TLAEditor editor;
    private IFile editorIFile;
    boolean hasChanged;
    int chosenSplit;
    boolean needsStepNumber;
    boolean hasAssumes;
    int andSplitBegin;
    int andSplitEnd;
    private HashSet<String> goalDefinitions;
    private HashSet<String> assumpDefinitions;
    private HashSet<String> declaredIdentifiers;
    private boolean useSufficesValue = true;
    private Button useSufficesButton;
    private boolean useCaseValue = true;
    private Button useCaseButton;
    private boolean subexpressionValue = false;
    private Button subexpressionButton;
    public static final int MENU = 1;
    public static final int ACTION = 2;
    public static final int CHECK = 3;
    public static final int PROVE_BUTTON = 1;
    public static final int TEST_BUTTON = 99;

    private String getCurrentName(FormalParamNode node, Renaming rename) {
        String newName = null;
        int i = 0;
        while (i < rename.identifiers.size() && newName == null) {
            if (rename.identifiers.elementAt(i) == node) {
                newName = rename.newNames.elementAt(i);
            }
            ++i;
        }
        if (newName == null) {
            return node.getName().toString();
        }
        return newName;
    }

    private void addCurrentName(FormalParamNode node, String name, Renaming rename) {
        int i = 0;
        while (i < rename.identifiers.size() && rename.identifiers.elementAt(i) != node) {
            ++i;
        }
        if (i < rename.identifiers.size()) {
            rename.newNames.remove(i);
            rename.newNames.insertElementAt(name, i);
        } else if (!name.equals(node.getName().toString())) {
            rename.identifiers.add(node);
            rename.newNames.add(name);
        }
    }

    private String getNewName(FormalParamNode node, HashSet<String> currentlyDeclared, Renaming rename) {
        String curName = this.getCurrentName(node, rename);
        if (!currentlyDeclared.contains(curName)) {
            return curName;
        }
        String oldName = this.getNewNamePrefix(node.getName().toString());
        int i = 1;
        while (currentlyDeclared.contains(oldName + i)) {
            ++i;
        }
        return oldName + i;
    }

    private String getNewNamePrefix(String oldname) {
        if (oldname.length() < 2 || !Character.isDigit(oldname.charAt(oldname.length() - 1))) {
            return oldname + RENAMING_SUFFIX;
        }
        String newname = oldname.substring(0, oldname.length() - 1);
        while (newname.length() > RENAMING_SUFFIX.length() && Character.isDigit(newname.charAt(newname.length() - 1)) && !newname.endsWith(RENAMING_SUFFIX)) {
            newname = newname.substring(0, newname.length() - 1);
        }
        if (newname.endsWith(RENAMING_SUFFIX)) {
            return newname;
        }
        return oldname + RENAMING_SUFFIX;
    }

    private void readButtons() {
        this.useSufficesValue = this.useSufficesButton.getSelection();
        this.useCaseValue = this.useCaseButton.getSelection();
        this.subexpressionValue = this.subexpressionButton.getSelection();
    }

    public Object realExecute() throws ExecutionException {
        Activator.getDefault().logDebug("Decompose Proof Called");
        String[] blankLine = new String[]{""};
        String[] oneline = new String[]{"1"};
        if (this.windowShell != null && !this.windowShell.isDisposed()) {
            System.out.println("Command called when being executed.");
            return null;
        }
        if (this.existDirtyModules()) {
            MessageDialog.openError((Shell)UIHelper.getShellProvider().getShell(), (String)"Decompose Proof Command", (String)"There is an unsaved module.");
            return null;
        }
        Spec spec = Activator.getSpecManager().getSpecLoaded();
        if (spec == null || spec.getStatus() != 0) {
            MessageDialog.openError((Shell)UIHelper.getShellProvider().getShell(), (String)"Decompose Proof Command", (String)"The spec status must be \"parsed\" to execute this command.");
            return null;
        }
        if (this.editor == null) {
            Activator.getDefault().logDebug("2nd call of getTLAEditorWithFocus returned null");
            return null;
        }
        this.editorIFile = ((FileEditorInput)this.editor.getEditorInput()).getFile();
        if (this.editor.isDirty()) {
            MessageDialog.openError((Shell)UIHelper.getShellProvider().getShell(), (String)"Decompose Proof Command", (String)"The module is dirty; this should not happen.");
            return null;
        }
        this.hasChanged = false;
        this.chosenSplit = -1;
        this.needsStepNumber = false;
        this.andSplitBegin = -1;
        this.andSplitEnd = -1;
        this.goalDefinitions = new HashSet();
        this.assumpDefinitions = new HashSet();
        Location selectedLocation = EditorUtil.getLocationAt(this.doc, this.offset, this.selection.getLength());
        TheoremNode[] allTheorems = this.moduleNode.getTheorems();
        this.theorem = null;
        int i = 0;
        String moduleFile = this.moduleNode.stn.getFilename();
        while (this.theorem == null & i < allTheorems.length) {
            if (allTheorems[i].stn.getFilename().equals(moduleFile) && EditorUtil.lineLocationContainment(selectedLocation, allTheorems[i].stn.getLocation())) {
                this.theorem = allTheorems[i];
            }
            ++i;
        }
        if (this.theorem == null) {
            MessageDialog.openError((Shell)UIHelper.getShellProvider().getShell(), (String)"Decompose Proof Command", (String)"The cursor is not in a theorem.");
            return null;
        }
        this.declaredIdentifiers = ResourceHelper.declaredSymbolsInScope((ModuleNode)this.moduleNode, (Location)this.theorem.stn.getLocation());
        this.step = this.theorem;
        boolean notDone = true;
        this.proofLevel = -1;
        this.proof = this.step.getProof();
        while (notDone && this.proof != null && this.proof instanceof NonLeafProofNode) {
            LevelNode[] pfsteps = ((NonLeafProofNode)this.proof).getSteps();
            LevelNode foundLevelNode = null;
            i = 0;
            this.proofLevel = -1;
            while (foundLevelNode == null && i < pfsteps.length) {
                if (this.proofLevel == -1 && !(pfsteps[i] instanceof DefStepNode) && !(pfsteps[i] instanceof InstanceNode)) {
                    this.proofLevel = OldDecomposeProofHandler.stepLevel((SemanticNode)pfsteps[i]);
                }
                if (EditorUtil.lineLocationContainment(selectedLocation, pfsteps[i].stn.getLocation())) {
                    foundLevelNode = pfsteps[i];
                    if (!this.step.isSuffices() && this.step.getTheorem() instanceof AssumeProveNode) {
                        SemanticNode[] assumptions = ((AssumeProveNode)this.step.getTheorem()).getAssumes();
                        int j = 0;
                        while (j < assumptions.length) {
                            if (assumptions[j] instanceof NewSymbNode) {
                                this.declaredIdentifiers.add(((NewSymbNode)assumptions[j]).getOpDeclNode().getName().toString());
                            }
                            ++j;
                        }
                    }
                } else {
                    if (pfsteps[i] instanceof TheoremNode) {
                        OpApplNode oanode;
                        TheoremNode node = (TheoremNode)pfsteps[i];
                        if (node.isSuffices() && node.getTheorem() instanceof AssumeProveNode) {
                            SemanticNode[] assumptions = ((AssumeProveNode)node.getTheorem()).getAssumes();
                            int j = 0;
                            while (j < assumptions.length) {
                                if (assumptions[j] instanceof NewSymbNode) {
                                    this.declaredIdentifiers.add(((NewSymbNode)assumptions[j]).getOpDeclNode().getName().toString());
                                }
                                ++j;
                            }
                        } else if (node.getTheorem() instanceof OpApplNode && (oanode = (OpApplNode)node.getTheorem()).getOperator().getName().toString().equals("$Pick")) {
                            FormalParamNode[] fp = oanode.getUnbdedQuantSymbols();
                            if (fp != null) {
                                int j = 0;
                                while (j < fp.length) {
                                    this.declaredIdentifiers.add(fp[j].getName().toString());
                                    ++j;
                                }
                            } else {
                                FormalParamNode[][] fpn = oanode.getBdedQuantSymbolLists();
                                int j = 0;
                                while (j < fpn.length) {
                                    int k = 0;
                                    while (k < fpn[j].length) {
                                        this.declaredIdentifiers.add(fpn[j][k].getName().toString());
                                        ++k;
                                    }
                                    ++j;
                                }
                            }
                        }
                    }
                    if (pfsteps[i] instanceof DefStepNode) {
                        OpDefNode[] defs = ((DefStepNode)pfsteps[i]).getDefs();
                        int j = 0;
                        while (j < defs.length) {
                            this.declaredIdentifiers.add(defs[j].getName().toString());
                            ++j;
                        }
                    }
                    if (pfsteps[i] instanceof InstanceNode) {
                        ResourceHelper.addDeclaredSymbolsInScope(this.declaredIdentifiers, (ModuleNode)((InstanceNode)pfsteps[i]).getModule(), (Location)ResourceHelper.infiniteLoc);
                    }
                }
                ++i;
            }
            if (foundLevelNode == null) {
                notDone = false;
                continue;
            }
            if (!(foundLevelNode instanceof TheoremNode)) {
                MessageDialog.openError((Shell)UIHelper.getShellProvider().getShell(), (String)"Decompose Proof Command", (String)"The cursor is in a non-provable step.");
                return null;
            }
            this.step = (TheoremNode)foundLevelNode;
            this.proof = this.step.getProof();
        }
        if (this.step.isSuffices()) {
            MessageDialog.openError((Shell)UIHelper.getShellProvider().getShell(), (String)"Decompose Proof Command", (String)"Cannot decompose a SUFFICES step.");
            return null;
        }
        int level = this.proofLevel;
        if (level < 0) {
            level = 0;
        }
        this.proofLevelString = "<" + (level + 1) + ">";
        SyntaxTreeNode nd = (SyntaxTreeNode)this.step.stn;
        if (this.step == this.theorem) {
            this.stepNumber = null;
        } else {
            this.stepNumber = nd.getHeirs()[0].image.toString();
            if (this.stepNumber.indexOf(62) == this.stepNumber.length() - 1) {
                this.stepNumber = null;
            } else {
                i = this.stepNumber.indexOf(62) + 1;
                while (i < this.stepNumber.length() && (Character.isLetterOrDigit(this.stepNumber.charAt(i)) || this.stepNumber.charAt(i) == '_')) {
                    ++i;
                }
                if (i < this.stepNumber.length()) {
                    this.stepNumber = this.stepNumber.substring(0, i);
                }
            }
        }
        this.stepColumn = nd.getLocation().beginColumn();
        if (this.proof != null && !(this.proof instanceof LeafProofNode)) {
            MessageDialog.openError((Shell)UIHelper.getShellProvider().getShell(), (String)"Decompose Proof Command", (String)"You have selected a step that already has a non-leaf proof.");
            return null;
        }
        try {
            this.stepRep = new NodeRepresentation(this.doc, (SemanticNode)this.step);
        }
        catch (BadLocationException e) {
            e.printStackTrace();
            System.out.println("threw exception");
        }
        LevelNode thm = this.step.getTheorem();
        if (thm instanceof AssumeProveNode) {
            this.hasAssumes = true;
            SemanticNode[] assump = ((AssumeProveNode)thm).getAssumes();
            Vector<SemanticNode> assumes = new Vector<SemanticNode>();
            this.assumeReps = new Vector();
            int rowOfLastNew = -1;
            i = 0;
            while (i < assump.length) {
                if (assump[i] instanceof AssumeProveNode) {
                    MessageDialog.openError((Shell)UIHelper.getShellProvider().getShell(), (String)"Decompose Proof Command", (String)"Cannot decompose a step with a nested ASSUME/PROVE.");
                    return null;
                }
                assumes.add(assump[i]);
                NodeRepresentation nodeRep = this.stepRep.subNodeRep(assump[i], this.assumeReps, null, null, null);
                if (nodeRep.nodeType == 1) {
                    Location loc = nodeRep.semanticNode.stn.getLocation();
                    if (loc.beginLine() == loc.endLine()) {
                        if (loc.beginLine() == rowOfLastNew) {
                            this.assumeReps.elementAt((int)(i - 1)).onSameLineAsNext = true;
                        }
                        rowOfLastNew = loc.beginLine();
                    } else {
                        rowOfLastNew = -1;
                    }
                } else {
                    rowOfLastNew = -1;
                }
                this.assumeReps.add(nodeRep);
                ExprNode goal = ((AssumeProveNode)thm).getProve();
                if (!(goal instanceof OpApplNode)) {
                    MessageDialog.openError((Shell)UIHelper.getShellProvider().getShell(), (String)"Decompose Proof Command", (String)"This step has a weird goal that cannot\n be processed.");
                    return null;
                }
                this.goalRep = this.stepRep.subNodeRep((SemanticNode)goal, null, null, null, null);
                ++i;
            }
        } else {
            this.hasAssumes = false;
            Vector assumes = new Vector();
            this.assumeReps = new Vector();
            if (!(thm instanceof OpApplNode)) {
                MessageDialog.openError((Shell)UIHelper.getShellProvider().getShell(), (String)"Decompose Proof Command", (String)"This is a weird step that cannot\n be processed.");
                return null;
            }
            LevelNode goal = thm;
            UniqueString goalOpName = null;
            if (goal instanceof OpApplNode) {
                goalOpName = ((OpApplNode)goal).getOperator().getName();
            }
            if (goalOpName == null || goalOpName == ASTConstants.OP_qed || goalOpName == ASTConstants.OP_pfcase || goalOpName == ASTConstants.OP_have || goalOpName == ASTConstants.OP_pick || goalOpName == ASTConstants.OP_witness || goalOpName == ASTConstants.OP_suffices) {
                MessageDialog.openError((Shell)UIHelper.getShellProvider().getShell(), (String)"Decompose Proof Command", (String)"Cannot decompose this kind of step.");
                return null;
            }
            this.goalRep = this.stepRep.subNodeRep((SemanticNode)goal, null, null, null, null);
        }
        this.editorIFile.setReadOnly(true);
        this.raiseWindow();
        return null;
    }

    public Object execute(ExecutionEvent event) throws ExecutionException {
        this.editor = EditorUtil.getTLAEditorWithFocus();
        this.doc = this.editor.getDocumentProvider().getDocument((Object)this.editor.getEditorInput());
        this.selectionProvider = this.editor.getSelectionProvider();
        this.selection = (TextSelection)this.selectionProvider.getSelection();
        this.offset = this.selection.getOffset();
        String moduleName = this.editor.getModuleName();
        this.moduleNode = ResourceHelper.getModuleNode((String)moduleName);
        boolean proceed = UIHelper.promptUserForDirtyModules();
        if (!proceed) {
            return null;
        }
        if (this.editor == null) {
            Activator.getDefault().logDebug("getTLAEditorWithFocus returned null");
            return null;
        }
        this.editorIFile = ((FileEditorInput)this.editor.getEditorInput()).getFile();
        ParseResult parseResult = ResourceHelper.getValidParseResult((IFile)this.editorIFile);
        if (parseResult == null) {
            parseResult = new ModuleParserLauncher().parseModule((IResource)this.editorIFile, (IProgressMonitor)new NullProgressMonitor());
        }
        DecomposeProofRunnable runnable = new DecomposeProofRunnable(this);
        UIHelper.runUISync((Runnable)runnable);
        return null;
    }

    private void raiseWindow() {
        if (this.windowShell != null && !this.windowShell.isDisposed()) {
            this.location = this.windowShell.getLocation();
            this.windowShell.close();
            this.windowShell.dispose();
        }
        Shell topshell = UIHelper.getShellProvider().getShell();
        this.windowShell = new Shell(topshell, 112);
        this.windowShell.setText("Decompose Proof - Old Version");
        this.windowShell.addDisposeListener((DisposeListener)new WindowDisposeListener(this));
        Composite shell = new Composite((Composite)this.windowShell, 0);
        GridLayout gridLayout = new GridLayout(3, false);
        shell.setLayout((Layout)gridLayout);
        Composite topMenu = new Composite(shell, 0);
        gridLayout = new GridLayout(5, false);
        gridLayout.marginBottom = 0;
        topMenu.setLayout((Layout)gridLayout);
        GridData gridData = new GridData();
        gridData.horizontalSpan = 3;
        topMenu.setLayoutData((Object)gridData);
        Button replaceButton = new Button(topMenu, 8);
        this.setupMenuButton(replaceButton, 1, "P");
        replaceButton.setFont(JFaceResources.getFontRegistry().get("org.eclipse.jface.headerfont"));
        replaceButton.setEnabled(this.hasChanged && this.chosenSplit == -1 && this.andSplitEnd == -1);
        this.useSufficesButton = new Button(topMenu, 32);
        this.setupCheckButton(this.useSufficesButton, "Use SUFFICES");
        this.useSufficesButton.setSelection(this.useSufficesValue);
        this.useCaseButton = new Button(topMenu, 32);
        this.setupCheckButton(this.useCaseButton, "Use CASE");
        this.useCaseButton.setSelection(this.useCaseValue);
        this.subexpressionButton = new Button(topMenu, 32);
        this.setupCheckButton(this.subexpressionButton, "Use subexpression names");
        this.subexpressionButton.setSelection(this.subexpressionValue);
        gridData = new GridData();
        gridData.horizontalAlignment = 4;
        gridData.grabExcessHorizontalSpace = true;
        this.subexpressionButton.setLayoutData((Object)gridData);
        this.subexpressionButton.setVisible(false);
        Button helpButton = HelpButton.helpButton((Composite)topMenu, (String)"prover/old-decompose.html");
        gridData = new GridData();
        gridData.horizontalIndent = 20;
        helpButton.setLayoutData((Object)gridData);
        gridData = new GridData();
        gridData.horizontalSpan = 3;
        Label assumeLabel = new Label(shell, 0);
        assumeLabel.setText("ASSUME");
        assumeLabel.setFont(JFaceResources.getFontRegistry().get("org.eclipse.jface.headerfont"));
        assumeLabel.setLayoutData((Object)gridData);
        if (this.assumeReps != null) {
            this.addAssumptionsToComposite(this.assumeReps, shell);
        }
        gridData = new GridData();
        gridData.horizontalSpan = 3;
        assumeLabel = new Label(shell, 0);
        assumeLabel.setLayoutData((Object)gridData);
        assumeLabel.setText("PROVE");
        assumeLabel.setFont(JFaceResources.getFontRegistry().get("org.eclipse.jface.headerfont"));
        String labelText = null;
        boolean isProver = false;
        boolean disable = false;
        switch (this.goalRep.nodeSubtype) {
            case 0: {
                labelText = "/\\";
                isProver = true;
                disable = this.chosenSplit != -1 || this.andSplitBegin != -1;
                break;
            }
            case 3: {
                labelText = "\\A";
                break;
            }
            case 2: {
                labelText = "=>";
                break;
            }
            default: {
                labelText = null;
            }
        }
        if (labelText != null) {
            Button goalButton = new Button(shell, 8);
            this.setupActionButton(goalButton, this.goalRep, labelText);
            goalButton.setEnabled(!disable);
        } else {
            assumeLabel = new Label(shell, 0);
            assumeLabel.setText("  ");
        }
        Composite comp = new Composite(shell, 0);
        gridLayout = new GridLayout(1, false);
        comp.setLayout((Layout)gridLayout);
        if (isProver && !disable) {
            assumeLabel = new Label(comp, 0);
            assumeLabel.setText("P");
            assumeLabel.setFont(JFaceResources.getFontRegistry().get("org.eclipse.jface.headerfont"));
        }
        comp.setSize(0, 5);
        assumeLabel = new Label(shell, 0);
        assumeLabel.setText(OldDecomposeProofHandler.stringArrayToString(this.goalRep.primedNodeText()));
        gridData = new GridData();
        gridData.verticalAlignment = 128;
        assumeLabel.setLayoutData((Object)gridData);
        assumeLabel.setFont(JFaceResources.getFontRegistry().get("org.eclipse.jface.textfont"));
        shell.pack();
        Point shellSize = shell.getSize();
        this.windowShell.pack();
        this.windowShell.update();
        if (this.location != null) {
            this.windowShell.setLocation(this.location);
        }
        this.windowShell.open();
        this.editorIFile.setReadOnly(true);
    }

    void addAssumptionsToComposite(Vector<NodeRepresentation> nodeRepVector, Composite composite) {
        int assumeWidth = 0;
        int i = 0;
        while (i < nodeRepVector.size()) {
            int j = 0;
            while (j < nodeRepVector.elementAt((int)i).nodeText.length) {
                assumeWidth = Math.max(assumeWidth, nodeRepVector.elementAt((int)i).nodeText[j].length());
                ++j;
            }
            ++i;
        }
        i = 0;
        while (i < nodeRepVector.size()) {
            GridData gridData;
            Label assumeLabel;
            GridLayout gridLayout;
            Composite comp;
            NodeRepresentation aRep = nodeRepVector.elementAt(i);
            if (aRep.nodeType != 2) {
                String labelText = null;
                if (aRep.semanticNode != null && aRep.semanticNode.getKind() == 9) {
                    switch (aRep.nodeSubtype) {
                        case 0: {
                            labelText = "/\\";
                            break;
                        }
                        case 1: 
                        case 5: {
                            labelText = "\\/";
                            break;
                        }
                        case 4: {
                            labelText = "\\E";
                            break;
                        }
                        default: {
                            labelText = null;
                        }
                    }
                }
                if (labelText != null) {
                    Button button = new Button(composite, 8);
                    this.setupActionButton(button, nodeRepVector.elementAt(i), labelText);
                    if (this.chosenSplit != -1 && i != this.chosenSplit || this.andSplitBegin != -1 && (i < this.andSplitBegin || i > this.andSplitEnd)) {
                        button.setEnabled(false);
                    }
                } else {
                    comp = new Composite(composite, 0);
                    gridLayout = new GridLayout(1, false);
                    comp.setLayout((Layout)gridLayout);
                    assumeLabel = new Label(comp, 0);
                    assumeLabel.setText("  ");
                    gridData = new GridData();
                    gridData.horizontalIndent = 25;
                    comp.setLayoutData((Object)gridData);
                }
                comp = new Composite(composite, 0);
                gridLayout = new GridLayout(1, false);
                comp.setLayout((Layout)gridLayout);
                comp.setSize(0, 5);
                comp = new Composite(composite, 0);
                gridLayout = new GridLayout(3, false);
                comp.setLayout((Layout)gridLayout);
                if (this.chosenSplit == -1 && this.andSplitBegin <= i && i <= this.andSplitEnd) {
                    Button arrowButton = new Button(comp, 132);
                    arrowButton.addSelectionListener((SelectionListener)new ArrowSelectionListener(i, 128, this));
                    gridData = new GridData();
                    gridData.verticalAlignment = 128;
                    arrowButton.setLayoutData((Object)gridData);
                    if (i == this.andSplitBegin) {
                        arrowButton.setEnabled(false);
                    }
                    arrowButton = new Button(comp, 1028);
                    arrowButton.addSelectionListener((SelectionListener)new ArrowSelectionListener(i, 1024, this));
                    gridData = new GridData();
                    gridData.verticalAlignment = 128;
                    arrowButton.setLayoutData((Object)gridData);
                    if (i == this.andSplitEnd) {
                        arrowButton.setEnabled(false);
                    }
                }
                assumeLabel = new Label(comp, 2048);
                Object text = OldDecomposeProofHandler.stringArrayToString(nodeRepVector.elementAt(i).primedNodeText());
                while (nodeRepVector.elementAt((int)i).onSameLineAsNext) {
                    text = (String)text + ", " + OldDecomposeProofHandler.stringArrayToString(nodeRepVector.elementAt((int)(++i)).nodeText);
                }
                assumeLabel.setText((String)text);
                assumeLabel.setFont(JFaceResources.getFontRegistry().get("org.eclipse.jface.textfont"));
                gridData = new GridData();
                gridData.horizontalIndent = 0;
                gridData.verticalAlignment = 128;
                gridData.horizontalAlignment = 16384;
                assumeLabel.setLayoutData((Object)gridData);
            } else {
                Button goalButton = new Button(composite, 8);
                this.setupActionButton(goalButton, aRep, "P");
                gridData = new GridData();
                gridData.horizontalIndent = 15;
                goalButton.setLayoutData((Object)gridData);
                goalButton.setFont(JFaceResources.getFontRegistry().get("org.eclipse.jface.headerfont"));
                comp = new Composite(composite, 0);
                gridLayout = new GridLayout(1, false);
                comp.setLayout((Layout)gridLayout);
                Composite inner = new Composite(composite, 0);
                gridLayout = new GridLayout(2, false);
                inner.setLayout((Layout)gridLayout);
                int j = 0;
                while (j < aRep.children.size()) {
                    assumeLabel = new Label(inner, 0);
                    assumeLabel.setText("CASE");
                    assumeLabel.setFont(JFaceResources.getFontRegistry().get("org.eclipse.jface.textfont"));
                    Composite caseComp = new Composite(inner, 2048);
                    gridLayout = new GridLayout(3, false);
                    caseComp.setLayout((Layout)gridLayout);
                    this.addCaseToComposite(aRep.children.elementAt(j), caseComp);
                    gridData = new GridData();
                    gridData.verticalAlignment = 128;
                    caseComp.setLayoutData((Object)gridData);
                    ++j;
                }
            }
            ++i;
        }
    }

    void addCaseToComposite(Vector<NodeRepresentation> nodeRepVector, Composite composite) {
        int i = 0;
        while (i < nodeRepVector.size()) {
            GridLayout gridLayout;
            Composite comp;
            GridData gridData;
            Label assumeLabel;
            NodeRepresentation aRep = nodeRepVector.elementAt(i);
            if (aRep.nodeType == 1 || aRep.nodeType == 5 || aRep.nodeType == 0 && aRep.nodeSubtype != 1 && aRep.nodeSubtype != 4 && aRep.nodeSubtype != 5) {
                Object text = OldDecomposeProofHandler.stringArrayToString(nodeRepVector.elementAt(i).primedNodeText());
                while (nodeRepVector.elementAt((int)i).onSameLineAsNext) {
                    text = (String)text + ", " + OldDecomposeProofHandler.stringArrayToString(nodeRepVector.elementAt(++i).primedNodeText());
                }
                assumeLabel = new Label(composite, 0);
                assumeLabel.setText((String)text);
                assumeLabel.setFont(JFaceResources.getFontRegistry().get("org.eclipse.jface.textfont"));
                gridData = new GridData();
                gridData.horizontalSpan = 3;
                assumeLabel.setLayoutData((Object)gridData);
            } else if (aRep.nodeType != 2) {
                String labelText = null;
                if (aRep.semanticNode != null && aRep.semanticNode.getKind() == 9) {
                    switch (aRep.nodeSubtype) {
                        case 0: {
                            labelText = null;
                            break;
                        }
                        case 1: 
                        case 5: {
                            labelText = "\\/";
                            break;
                        }
                        case 4: {
                            labelText = "\\E";
                            break;
                        }
                        default: {
                            labelText = null;
                        }
                    }
                }
                if (labelText != null) {
                    Button button = new Button(composite, 8);
                    this.setupActionButton(button, nodeRepVector.elementAt(i), labelText);
                    if (aRep.nodeSubtype == 0 || aRep.nodeSubtype == 3) {
                        button.setEnabled(false);
                    }
                } else {
                    comp = new Composite(composite, 0);
                    gridLayout = new GridLayout(1, false);
                    comp.setLayout((Layout)gridLayout);
                    assumeLabel = new Label(comp, 0);
                    assumeLabel.setText("  ");
                    gridData = new GridData();
                    gridData.horizontalIndent = 25;
                    comp.setLayoutData((Object)gridData);
                }
                comp = new Composite(composite, 0);
                gridLayout = new GridLayout(1, false);
                comp.setLayout((Layout)gridLayout);
                comp.setSize(0, 5);
                comp = new Composite(composite, 0);
                gridLayout = new GridLayout(3, false);
                comp.setLayout((Layout)gridLayout);
                if (this.chosenSplit == -1 && this.andSplitBegin <= i && i <= this.andSplitEnd) {
                    Button arrowButton = new Button(comp, 132);
                    arrowButton.addSelectionListener((SelectionListener)new ArrowSelectionListener(i, 128, this));
                    gridData = new GridData();
                    gridData.verticalAlignment = 128;
                    arrowButton.setLayoutData((Object)gridData);
                    if (i == this.andSplitBegin) {
                        arrowButton.setEnabled(false);
                    }
                    arrowButton = new Button(comp, 1028);
                    arrowButton.addSelectionListener((SelectionListener)new ArrowSelectionListener(i, 1024, this));
                    gridData = new GridData();
                    gridData.verticalAlignment = 128;
                    arrowButton.setLayoutData((Object)gridData);
                    if (i == this.andSplitEnd) {
                        arrowButton.setEnabled(false);
                    }
                }
                assumeLabel = new Label(comp, 0);
                String text = OldDecomposeProofHandler.stringArrayToString(nodeRepVector.elementAt(i).primedNodeText());
                assumeLabel.setText(text);
                assumeLabel.setFont(JFaceResources.getFontRegistry().get("org.eclipse.jface.textfont"));
                gridData = new GridData();
                gridData.horizontalIndent = 0;
                gridData.verticalAlignment = 128;
                gridData.horizontalAlignment = 16384;
                assumeLabel.setLayoutData((Object)gridData);
            } else {
                assumeLabel = new Label(composite, 0);
                assumeLabel.setText("  ");
                comp = new Composite(composite, 0);
                gridLayout = new GridLayout(1, false);
                comp.setLayout((Layout)gridLayout);
                comp = new Composite(composite, 0);
                gridLayout = new GridLayout(1, false);
                comp.setLayout((Layout)gridLayout);
                Composite inner = new Composite(composite, 0);
                gridLayout = new GridLayout(2, false);
                inner.setLayout((Layout)gridLayout);
                int j = 0;
                while (j < aRep.children.size()) {
                    assumeLabel = new Label(inner, 0);
                    assumeLabel.setText("CASE");
                    assumeLabel.setFont(JFaceResources.getFontRegistry().get("org.eclipse.jface.textfont"));
                    Composite caseComp = new Composite(inner, 2048);
                    gridLayout = new GridLayout(3, false);
                    caseComp.setLayout((Layout)gridLayout);
                    this.addCaseToComposite(aRep.children.elementAt(j), caseComp);
                    gridData = new GridData();
                    gridData.verticalAlignment = 128;
                    caseComp.setLayoutData((Object)gridData);
                    ++j;
                }
            }
            ++i;
        }
    }

    void andAction(NodeRepresentation nodeRep) {
        if (nodeRep.parentVector == null) {
            this.makeProof(nodeRep, true, false);
        } else {
            int idx = nodeRep.getParentIndex();
            Decomposition decomp = nodeRep.decomposition;
            this.hasChanged = true;
            if (decomp.definedOp != null) {
                this.assumpDefinitions.add(decomp.definedOp);
            }
            Vector<SemanticNode> addedAssumps = decomp.children;
            Vector<NodeRepresentation> addedToAssumeReps = new Vector<NodeRepresentation>();
            int i = 0;
            while (i < addedAssumps.size()) {
                NodeRepresentation rep = this.decompositionChildToNodeRep(nodeRep, i, this.assumeReps, null);
                rep.isCreated = true;
                addedToAssumeReps.add(rep);
                ++i;
            }
            this.assumeReps.remove(idx);
            i = 0;
            while (i < addedToAssumeReps.size()) {
                this.assumeReps.add(idx + i, (NodeRepresentation)addedToAssumeReps.elementAt(i));
                ++i;
            }
            if (this.andSplitBegin == -1) {
                this.andSplitBegin = idx;
                this.andSplitEnd = idx + addedAssumps.size() - 1;
            } else {
                this.andSplitEnd = this.andSplitEnd + addedAssumps.size() - 1;
            }
            this.raiseWindow();
        }
    }

    void forAllAction(NodeRepresentation nodeRep) {
        Decomposition decomp = nodeRep.decomposition;
        this.hasChanged = true;
        if (decomp.definedOp != null) {
            this.assumpDefinitions.add(decomp.definedOp);
        }
        QuantifierDecomposition qdc = this.decomposeQuantifier(nodeRep, true);
        this.goalRep = qdc.body;
        int i = 0;
        while (i < qdc.news.size()) {
            this.assumeReps.add(qdc.news.elementAt(i));
            ++i;
        }
        this.raiseWindow();
    }

    void existsAction(NodeRepresentation nodeRep) {
        int idx = nodeRep.getParentIndex();
        Vector<NodeRepresentation> parentVec = nodeRep.parentVector;
        Decomposition decomp = nodeRep.decomposition;
        this.hasChanged = true;
        if (decomp.definedOp != null) {
            if (parentVec == this.assumeReps) {
                this.assumpDefinitions.add(decomp.definedOp);
            } else {
                this.goalDefinitions.add(decomp.definedOp);
            }
        }
        if (!nodeRep.isCreated && this.hasAssumes) {
            this.needsStepNumber = true;
        }
        QuantifierDecomposition qdc = this.decomposeQuantifier(nodeRep, false);
        qdc.body.isCreated = true;
        parentVec.remove(idx);
        if (parentVec == this.assumeReps && this.andSplitBegin != -1) {
            this.andSplitEnd += qdc.news.size();
        }
        int i = 0;
        while (i < qdc.news.size()) {
            parentVec.add(idx + i, qdc.news.elementAt(i));
            ++i;
        }
        parentVec.add(idx + qdc.news.size(), qdc.body);
        this.raiseWindow();
    }

    void impliesAction(NodeRepresentation nodeRep) {
        Decomposition decomp = nodeRep.decomposition;
        this.hasChanged = true;
        if (decomp.definedOp != null) {
            this.assumpDefinitions.add(decomp.definedOp);
        }
        NodeTextRep newNodeText = null;
        if (decomp.definedOp != null && this.subexpressionButton.getSelection()) {
            newNodeText = decomp.definedOpRep;
        } else if (nodeRep.isSubexpressionName) {
            newNodeText = new NodeTextRep(nodeRep.nodeText, nodeRep.mapping);
        }
        NodeRepresentation nrep = this.decompositionChildToNodeRep(nodeRep, 0, this.assumeReps, nodeRep.parentNode);
        nrep.isCreated = true;
        nrep.isPrimed = nrep.isPrimed || decomp.primed;
        this.assumeReps.add(nrep);
        nrep = this.decompositionChildToNodeRep(nodeRep, 1, nodeRep.parentVector, nodeRep.parentNode);
        nrep.isCreated = true;
        this.goalRep = nrep;
        this.raiseWindow();
    }

    void orAction(NodeRepresentation nodeRep) {
        int idx = nodeRep.getParentIndex();
        Vector<NodeRepresentation> parentVec = nodeRep.parentVector;
        if (parentVec == this.assumeReps) {
            this.chosenSplit = idx;
        }
        Decomposition decomp = nodeRep.decomposition;
        this.hasChanged = true;
        if (decomp.definedOp != null) {
            this.goalDefinitions.add(decomp.definedOp);
        }
        nodeRep.nodeType = 2;
        nodeRep.nodeSubtype = 99;
        nodeRep.children = new Vector();
        int i = 0;
        while (i < decomp.children.size()) {
            Vector<NodeRepresentation> repVec = new Vector<NodeRepresentation>();
            nodeRep.children.add(repVec);
            NodeRepresentation rep = this.decompositionChildToNodeRep(nodeRep, i, repVec, nodeRep);
            repVec.add(rep);
            ++i;
        }
        this.raiseWindow();
    }

    void sqsubAction(NodeRepresentation nodeRep) {
        int idx = nodeRep.getParentIndex();
        Vector<NodeRepresentation> parentVec = nodeRep.parentVector;
        if (parentVec == this.assumeReps) {
            this.chosenSplit = idx;
        }
        Decomposition decomp = nodeRep.decomposition;
        this.hasChanged = true;
        if (decomp.definedOp != null) {
            this.goalDefinitions.add(decomp.definedOp);
        }
        nodeRep.nodeType = 2;
        nodeRep.nodeSubtype = 99;
        nodeRep.children = new Vector();
        int i = 0;
        while (i < decomp.children.size()) {
            Vector<NodeRepresentation> repVec = new Vector<NodeRepresentation>();
            nodeRep.children.add(repVec);
            NodeRepresentation rep = this.decompositionChildToNodeRep(nodeRep, i, repVec, nodeRep);
            if (i == 1) {
                rep.nodeType = 5;
                rep.nodeSubtype = 99;
                rep.nodeText = OldDecomposeProofHandler.prependToStringArray(rep.nodeText, "UNCHANGED ");
            }
            repVec.add(rep);
            ++i;
        }
        this.raiseWindow();
    }

    void caseAction(NodeRepresentation nodeRep) {
        this.makeProof(nodeRep, false, false);
    }

    void makeProof(NodeRepresentation nodeRep, boolean isAndProof, boolean sufficesOnly) {
        int i;
        boolean hasSufficesStep;
        HashSet<String> aaTestSet = new HashSet<String>();
        this.addDeclaredSymbols(aaTestSet, this.goalRep);
        int proofIndent = 2;
        String proofIndentString = StringHelper.copyString((String)" ", (int)proofIndent);
        String[] assumptionsText = this.createdAssumptions();
        String[] proofText = null;
        if (this.proof != null) {
            proofText = this.stepRep.subNodeText((SemanticNode)this.proof).nodeText;
            proofText = OldDecomposeProofHandler.prependToStringArray(proofText, proofIndentString);
            try {
                IRegion proofRegion = EditorUtil.getRegionOf(this.doc, ((SyntaxTreeNode)this.proof.stn).getLocation());
                this.doc.replace(proofRegion.getOffset(), proofRegion.getLength(), "");
            }
            catch (BadLocationException e) {
                MessageDialog.openError((Shell)UIHelper.getShellProvider().getShell(), (String)"Decompose Proof Command", (String)"An error that should not happen has occurred in line 1266 of DecomposeProofHandler.");
                e.printStackTrace();
            }
        }
        boolean addStepNumber = this.stepNumber != null && this.needsStepNumber;
        String[] sufficesStep = null;
        boolean bl = hasSufficesStep = this.useSufficesButton.getSelection() && assumptionsText.length != 0;
        if (hasSufficesStep || sufficesOnly) {
            Object sufficesProof = null;
            String[] suffices = OldDecomposeProofHandler.prependToStringArray(OldDecomposeProofHandler.concatStringArrays(OldDecomposeProofHandler.prependToStringArray(assumptionsText, "ASSUME "), OldDecomposeProofHandler.prependToStringArray(this.goalRep.primedNodeText(), "PROVE  ")), this.proofLevelString + " SUFFICES ");
            if (this.assumpDefinitions.isEmpty() && !addStepNumber) {
                sufficesProof = "OBVIOUS";
            } else {
                sufficesProof = "BY ";
                if (addStepNumber) {
                    sufficesProof = (String)sufficesProof + this.stepNumber + " ";
                }
                if (!this.assumpDefinitions.isEmpty()) {
                    sufficesProof = (String)sufficesProof + "DEF " + OldDecomposeProofHandler.setOfStringsToList(this.assumpDefinitions);
                }
            }
            sufficesStep = OldDecomposeProofHandler.concatStringArrays(suffices, new String[]{proofIndentString + (String)sufficesProof});
        }
        String[][] mainProofSteps = null;
        int numberOfSteps = 0;
        String proofDef = null;
        if (!sufficesOnly) {
            if (isAndProof) {
                Decomposition decomp = nodeRep.decomposition;
                numberOfSteps = decomp.children.size();
                mainProofSteps = new String[numberOfSteps][];
                proofDef = decomp.definedOp;
                i = 0;
                while (i < numberOfSteps) {
                    String[] step;
                    NodeRepresentation stepGoalRep = this.decompositionChildToNodeRep(nodeRep, i, null, null);
                    String[] goalArray = stepGoalRep.primedNodeText();
                    boolean isAssumeProve = false;
                    if (sufficesStep == null && assumptionsText != null && assumptionsText.length != 0) {
                        step = OldDecomposeProofHandler.concatStringArrays(OldDecomposeProofHandler.prependToStringArray(assumptionsText, "ASSUME "), OldDecomposeProofHandler.prependToStringArray(goalArray, "PROVE  "));
                        isAssumeProve = true;
                    } else {
                        step = goalArray;
                    }
                    String stepNum = this.proofLevelString + (i + 1);
                    step = OldDecomposeProofHandler.prependToStringArray(step, stepNum + ". ");
                    if (proofText != null) {
                        String[] newProofText = (String[])proofText.clone();
                        if (isAssumeProve) {
                            this.addStepNumToProof(stepNum, newProofText);
                        }
                        step = OldDecomposeProofHandler.concatStringArrays(step, newProofText);
                    }
                    mainProofSteps[i] = step;
                    ++i;
                }
            } else {
                Vector<String[]> pfStepVec = new Vector<String[]>();
                i = 0;
                while (i < nodeRep.children.size()) {
                    String[] assumpArray;
                    Vector<NodeRepresentation> childVec = nodeRep.children.elementAt(i);
                    if (!hasSufficesStep) {
                        assumpArray = new String[assumptionsText.length];
                        int j = 0;
                        while (j < assumptionsText.length) {
                            assumpArray[j] = assumptionsText[j];
                            ++j;
                        }
                    } else {
                        assumpArray = new String[]{};
                    }
                    this.addCaseProofs(pfStepVec, childVec, assumpArray, proofText);
                    ++i;
                }
                mainProofSteps = new String[pfStepVec.size()][];
                i = 0;
                while (i < mainProofSteps.length) {
                    mainProofSteps[i] = (String[])pfStepVec.elementAt(i);
                    ++i;
                }
                numberOfSteps = mainProofSteps.length;
            }
        }
        String[] qedStep = new String[2];
        qedStep[0] = this.proofLevelString;
        if (numberOfSteps != 0) {
            qedStep[0] = qedStep[0] + (numberOfSteps + 1) + STEP_NUMBER_PUNCTUATION;
        }
        qedStep[0] = qedStep[0] + " QED";
        qedStep[1] = proofIndentString + "BY " + (String)(numberOfSteps > 0 ? this.proofLevelString + "1" : "");
        i = 2;
        while (i <= numberOfSteps) {
            qedStep[1] = qedStep[1] + ", " + this.proofLevelString + i;
            ++i;
        }
        if (sufficesStep == null && this.needsStepNumber && this.stepNumber != null) {
            qedStep[1] = qedStep[1] + ", " + this.stepNumber;
        }
        boolean hasGoalDefs = !this.assumpDefinitions.isEmpty() && sufficesStep == null;
        boolean hasAssumeDefs = !this.goalDefinitions.isEmpty();
        String goalAndAssumeDefs = (hasGoalDefs ? OldDecomposeProofHandler.setOfStringsToList(this.assumpDefinitions) : "") + (hasGoalDefs && hasAssumeDefs ? ", " : "") + (hasAssumeDefs ? OldDecomposeProofHandler.setOfStringsToList(this.goalDefinitions) : "");
        if (sufficesOnly) {
            if (this.proof != null) {
                qedStep = OldDecomposeProofHandler.concatStringArrays(new String[]{qedStep[0]}, OldDecomposeProofHandler.prependToStringArray(proofText, proofIndentString));
            } else {
                qedStep[1] = "";
            }
        } else {
            boolean hasDEF = false;
            if (hasGoalDefs || hasAssumeDefs) {
                hasDEF = true;
                qedStep[1] = qedStep[1] + " DEF " + goalAndAssumeDefs;
            }
            if (proofDef != null) {
                qedStep[1] = hasDEF ? qedStep[1] + ", " + proofDef : qedStep[1] + " DEF " + proofDef;
            }
        }
        String[] blankLine = new String[]{""};
        String[] completeProof = new String[]{};
        if (sufficesStep != null) {
            completeProof = sufficesStep;
        }
        if (mainProofSteps != null) {
            completeProof = OldDecomposeProofHandler.concatStringArrays(completeProof, mainProofSteps[0]);
            int i2 = 1;
            while (i2 < mainProofSteps.length) {
                completeProof = OldDecomposeProofHandler.concatStringArrays(completeProof, mainProofSteps[i2]);
                ++i2;
            }
        }
        completeProof = OldDecomposeProofHandler.concatStringArrays(completeProof, qedStep);
        completeProof = OldDecomposeProofHandler.prependToStringArray(completeProof, StringHelper.copyString((String)" ", (int)(this.step.getLocation().beginColumn() - 1 + proofIndent)));
        try {
            int nextLineOffset = this.doc.getLineInformation(this.step.getTheorem().getLocation().endLine()).getOffset();
            this.doc.replace(nextLineOffset, 0, OldDecomposeProofHandler.stringArrayToString(completeProof) + "\n");
        }
        catch (BadLocationException e) {
            MessageDialog.openError((Shell)UIHelper.getShellProvider().getShell(), (String)"Decompose Proof Command", (String)"An error that should not happen has occurred in line 1465 of DecomposeProofHandler.");
            e.printStackTrace();
        }
        this.windowShell.dispose();
    }

    void addCaseProofs(Vector<String[]> pfStepVec, Vector<NodeRepresentation> childVec, String[] assumpArray, String[] proofText) {
        int newAssumpCount = assumpArray.length;
        NodeRepresentation lastChildNode = childVec.elementAt(childVec.size() - 1);
        int lenOfChildAssumps = childVec.size();
        if (lastChildNode.nodeType == 2) {
            --lenOfChildAssumps;
        }
        int i = 0;
        while (i < lenOfChildAssumps) {
            newAssumpCount += childVec.elementAt(i).primedNodeText().length;
            ++i;
        }
        String[] newAssumpArray = new String[newAssumpCount];
        int i2 = 0;
        while (i2 < assumpArray.length) {
            newAssumpArray[i2] = assumpArray[i2];
            ++i2;
        }
        if (lenOfChildAssumps > 0) {
            if (assumpArray.length > 0) {
                newAssumpArray[assumpArray.length - 1] = newAssumpArray[assumpArray.length - 1] + ",";
            }
            int idx = assumpArray.length;
            int i3 = 0;
            while (i3 < lenOfChildAssumps) {
                String[] assump = childVec.elementAt(i3).primedNodeText();
                int j = 0;
                while (j < assump.length) {
                    newAssumpArray[idx] = assump[j];
                    ++idx;
                    ++j;
                }
                if (i3 != lenOfChildAssumps - 1) {
                    newAssumpArray[idx - 1] = newAssumpArray[idx - 1] + ",";
                }
                ++i3;
            }
        }
        if (lastChildNode.nodeType == 2) {
            i2 = 0;
            while (i2 < lastChildNode.children.size()) {
                this.addCaseProofs(pfStepVec, lastChildNode.children.elementAt(i2), newAssumpArray, proofText);
                ++i2;
            }
        } else {
            String[] step = newAssumpArray.length == 1 && this.useCaseButton.getSelection() ? OldDecomposeProofHandler.prependToStringArray(lastChildNode.primedNodeText(), "CASE ") : OldDecomposeProofHandler.concatStringArrays(OldDecomposeProofHandler.prependToStringArray(newAssumpArray, "ASSUME "), OldDecomposeProofHandler.prependToStringArray(this.goalRep.primedNodeText(), "PROVE  "));
            String stepNum = this.proofLevelString + (pfStepVec.size() + 1);
            step = OldDecomposeProofHandler.prependToStringArray(step, stepNum + ". ");
            if (proofText != null) {
                String[] newProofText = (String[])proofText.clone();
                this.addStepNumToProof(stepNum, newProofText);
                step = OldDecomposeProofHandler.concatStringArrays(step, newProofText);
            }
            pfStepVec.add(step);
        }
    }

    private void addStepNumToProof(String stepNum, String[] proofText) {
        LeafProofNode pfNode = (LeafProofNode)this.proof;
        if (pfNode.getOmitted()) {
            return;
        }
        if (!(pfNode.getFacts() != null && pfNode.getFacts().length != 0 || pfNode.getDefs() != null && pfNode.getDefs().length != 0)) {
            int i = 0;
            boolean notDone = true;
            while (notDone && i < proofText.length) {
                int idx = proofText[i].indexOf("OBVIOUS");
                if (idx != -1) {
                    proofText[i] = proofText[i].replaceFirst("OBVIOUS", "BY " + stepNum);
                    notDone = false;
                }
                ++i;
            }
        } else {
            String comesAfter = "BY";
            if (pfNode.getOnlyFlag()) {
                comesAfter = "ONLY";
            }
            Object stepNumAdded = stepNum;
            if (pfNode.getFacts() != null && pfNode.getFacts().length > 0) {
                stepNumAdded = stepNum + ",";
            }
            int i = 0;
            boolean notDone = true;
            while (notDone && i < proofText.length) {
                int idx = proofText[i].indexOf(comesAfter);
                if (idx != -1) {
                    proofText[i] = proofText[i].replaceFirst(comesAfter, comesAfter + " " + (String)stepNumAdded);
                    notDone = false;
                }
                ++i;
            }
        }
    }

    /*
     * Unable to fully structure code
     */
    NodeRepresentation decompositionChildToNodeRep(NodeRepresentation nodeRep, int i, Vector<NodeRepresentation> vec, NodeRepresentation father) {
        decomp = nodeRep.decomposition;
        newNodeText = null;
        if (decomp.definedOp != null && this.subexpressionButton.getSelection()) {
            newNodeText = OldDecomposeProofHandler.appendToNodeText(decomp.definedOpRep, decomp.namePath.elementAt(i));
        } else if (nodeRep.isSubexpressionName) {
            newNodeText = OldDecomposeProofHandler.appendToNodeText(new NodeTextRep(nodeRep.nodeText, nodeRep.mapping), decomp.namePath.elementAt(i));
        }
        childDoc = this.doc;
        if (decomp.moduleName != null && !this.moduleNode.getName().toString().equals(decomp.moduleName)) {
            moduleIFile = (IFile)ResourceHelper.getResourceByModuleName((String)decomp.moduleName);
            fileEditorInput = new FileEditorInput(moduleIFile);
            moduleFileDocProvider = new FileDocumentProvider();
            try {
                moduleFileDocProvider.connect((Object)fileEditorInput);
            }
            catch (CoreException var11_12) {
                // empty catch block
            }
            childDoc = moduleFileDocProvider.getDocument((Object)fileEditorInput);
        }
        if (decomp.definedOp != null && newNodeText == null) {
            try {
                res = new NodeRepresentation(childDoc, decomp.children.elementAt(i));
                ntext = this.decompSubstituteInNodeText(nodeRep, (ExprNode)decomp.children.elementAt(i), new NodeTextRep(res.nodeText, res.mapping), nodeRep);
                res.nodeText = ntext.nodeText;
                res.mapping = ntext.mapping;
                result = res.subNodeRep(decomp.children.elementAt(i), vec, father, null, decomp);
                result.isPrimed = nodeRep.isPrimed;
                if (decomp.children.elementAt(i) instanceof ExprNode) ** GOTO lbl35
                MessageDialog.openError((Shell)UIHelper.getShellProvider().getShell(), (String)"Decompose Proof Command", (String)"An error that should not happen has occurred in line 2534 of DecomposeProofHandler.");
            }
            catch (BadLocationException e) {
                e.printStackTrace();
                MessageDialog.openError((Shell)UIHelper.getShellProvider().getShell(), (String)"Decompose Proof Command", (String)"An error that should not happen has occurred in line 2714 of DecomposeProofHandler.");
                return null;
            }
        } else {
            result = nodeRep.subNodeRep(decomp.children.elementAt(i), vec, father, newNodeText, decomp);
        }
lbl35:
        // 3 sources

        result.isPrimed = result.isPrimed != false || decomp.primed != false;
        result.isSubexpressionName = nodeRep.isSubexpressionName != false || newNodeText != null;
        return result;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    QuantifierDecomposition decomposeQuantifier(NodeRepresentation nodeRepArg, boolean isForAll) {
        QuantifierDecomposition result = new QuantifierDecomposition();
        NodeRepresentation nodeRep = nodeRepArg;
        result.news = new Vector();
        Decomposition decomp = nodeRep.decomposition;
        NodeTextRep newNodeText = null;
        if (decomp.definedOp != null && this.subexpressionButton.getSelection()) {
            newNodeText = decomp.definedOpRep;
        } else if (nodeRep.isSubexpressionName) {
            newNodeText = new NodeTextRep(nodeRep.nodeText, nodeRep.mapping);
        } else if (decomp.definedOp != null) {
            try {
                OpApplNode oan = (OpApplNode)nodeRepArg.semanticNode;
                if (oan.getOperator().getName() == ASTConstants.OP_prime) {
                    if (!(oan instanceof OpApplNode)) {
                        return null;
                    }
                    oan = (OpApplNode)oan.getArgs()[0];
                }
                ExprNode sn = ((OpDefNode)oan.getOperator()).getBody();
                NodeRepresentation res = new NodeRepresentation(this.doc, (SemanticNode)sn);
                nodeRep = res.subNodeRep((SemanticNode)sn, nodeRepArg.parentVector, nodeRepArg.parentNode, null, decomp);
                nodeRep.isPrimed = nodeRepArg.isPrimed;
                nodeRep.decomposition.formalParams = nodeRepArg.decomposition.formalParams;
                nodeRep.decomposition.arguments = nodeRepArg.decomposition.arguments;
                nodeRep.decomposition.argNodes = nodeRepArg.decomposition.argNodes;
                NodeTextRep ntext = this.decompSubstituteInNodeText(nodeRep, sn, new NodeTextRep(nodeRep.nodeText, nodeRep.mapping), nodeRepArg);
                nodeRep.nodeText = ntext.nodeText;
                nodeRep.mapping = ntext.mapping;
            }
            catch (BadLocationException e) {
                e.printStackTrace();
                MessageDialog.openError((Shell)UIHelper.getShellProvider().getShell(), (String)"Decompose Proof Command", (String)"An error that should not happen has occurred in line 2624 of DecomposeProofHandler.");
                return null;
            }
        }
        Vector<FormalParamNode> idsToRename = new Vector<FormalParamNode>();
        Vector<String> idNewNames = new Vector<String>();
        if (!isForAll) {
            HashSet prevDeclared = (HashSet)this.declaredIdentifiers.clone();
            this.addDeclaredSymbols(prevDeclared, nodeRepArg);
            this.addSymbolsDeclaredLater(prevDeclared, nodeRepArg, true);
            int i = 0;
            while (i < decomp.quantIds.size()) {
                FormalParamNode id = decomp.quantIds.elementAt(i);
                if (prevDeclared.contains(this.getCurrentName(id, decomp.renaming))) {
                    idsToRename.add(id);
                    idNewNames.add(this.getNewName(id, prevDeclared, decomp.renaming));
                }
                ++i;
            }
            FormalParamNode[] formalParams = new FormalParamNode[idsToRename.size()];
            String[] arguments = new String[idsToRename.size()];
            boolean[] isBoundedIdRenaming = new boolean[idsToRename.size()];
            SemanticNode[] argNodes = new SemanticNode[idsToRename.size()];
            int i2 = 0;
            while (i2 < idsToRename.size()) {
                formalParams[i2] = (FormalParamNode)idsToRename.elementAt(i2);
                arguments[i2] = (String)idNewNames.elementAt(i2);
                isBoundedIdRenaming[i2] = true;
                argNodes[i2] = null;
                ++i2;
            }
            NodeTextRep nText = this.substituteInNodeText(formalParams, arguments, isBoundedIdRenaming, argNodes, (ExprNode)nodeRep.semanticNode, new NodeTextRep(nodeRep.nodeText, nodeRep.mapping), nodeRep.decomposition);
            nodeRep.nodeText = nText.nodeText;
            nodeRep.mapping = nText.mapping;
            int i3 = 0;
            while (i3 < idsToRename.size()) {
                this.addCurrentName((FormalParamNode)idsToRename.elementAt(i3), (String)idNewNames.elementAt(i3), nodeRep.decomposition.renaming);
                ++i3;
            }
        }
        int lastLine = -1;
        int i = 0;
        while (i < decomp.quantIds.size()) {
            NodeRepresentation rep = new NodeRepresentation();
            rep.semanticNode = null;
            rep.nodeType = 1;
            rep.newId = this.getCurrentName(decomp.quantIds.elementAt(i), nodeRep.decomposition.renaming);
            rep.isCreated = true;
            rep.parentNode = nodeRep.parentNode;
            rep.parentVector = nodeRep.parentVector != null ? nodeRep.parentVector : this.assumeReps;
            NodeTextRep ntrep = new NodeTextRep();
            String id = "NEW " + rep.newId;
            int beginLine = ((SyntaxTreeNode)decomp.quantIds.elementAt((int)i).stn).getLocation().beginLine();
            if (decomp.quantBounds == null) {
                ntrep.nodeText = new String[1];
                ntrep.nodeText[0] = id;
                ntrep.mapping = new Vector[1];
                ntrep.mapping[0] = new Vector();
                ntrep.mapping[0].addElement(new MappingPair(1, -1));
            } else {
                if (newNodeText == null) {
                    ntrep = nodeRep.subNodeText((SemanticNode)decomp.quantBounds.elementAt(i));
                    if (decomp.primed || nodeRep.isPrimed) {
                        ntrep = OldDecomposeProofHandler.primingNeedsParens((SemanticNode)decomp.quantBounds.elementAt(i)) ? OldDecomposeProofHandler.prependToNodeText(OldDecomposeProofHandler.appendToNodeText(ntrep, ")'"), "(") : OldDecomposeProofHandler.appendToNodeText(ntrep, "'");
                    }
                } else {
                    Object str = decomp.quantBoundsubexpNames.elementAt(i);
                    if (decomp.primed) {
                        str = (String)str + "'";
                    }
                    ntrep = OldDecomposeProofHandler.appendToNodeText(newNodeText, (String)str);
                }
                ntrep = OldDecomposeProofHandler.prependToNodeText(ntrep, " \\in ");
                if (ntrep.nodeText.length > 1) {
                    beginLine = -1;
                }
            }
            if (decomp.quantBounds != null) {
                ntrep = OldDecomposeProofHandler.prependToNodeText(ntrep, id);
            }
            rep.nodeText = ntrep.nodeText;
            rep.mapping = ntrep.mapping;
            result.news.add(rep);
            if (beginLine != -1 && beginLine == lastLine) {
                result.news.elementAt((int)(i - 1)).onSameLineAsNext = true;
            }
            lastLine = beginLine;
            ++i;
        }
        if (newNodeText != null) {
            Object str = "!(";
            int i4 = 0;
            while (i4 < decomp.quantIds.size()) {
                if (i4 != 0) {
                    str = (String)str + ", ";
                }
                str = (String)str + decomp.quantIds.elementAt(i4).getName().toString();
                ++i4;
            }
            str = (String)str + ")";
            newNodeText = OldDecomposeProofHandler.appendToNodeText(newNodeText, (String)str);
        }
        result.body = nodeRep.subNodeRep(decomp.children.elementAt(0), nodeRep.parentVector, nodeRep.parentNode, newNodeText, nodeRep.decomposition);
        result.body.isCreated = isForAll;
        result.body.isPrimed = result.body.isPrimed || decomp.primed;
        result.body.isSubexpressionName = nodeRep.isSubexpressionName || newNodeText != null;
        return result;
    }

    String[] createdAssumptions() {
        Boolean sufficesSelected = this.useSufficesButton.getSelection();
        Vector<String[]> vec = new Vector<String[]>();
        int i = 0;
        while (i < this.assumeReps.size()) {
            NodeRepresentation rep = this.assumeReps.elementAt(i);
            if (rep.isCreated && (sufficesSelected.booleanValue() || rep.nodeType != 2)) {
                Object newDecls = null;
                while (rep.onSameLineAsNext) {
                    newDecls = newDecls != null ? newDecls + ", " : "";
                    newDecls = (String)newDecls + rep.nodeText[0];
                    rep = this.assumeReps.elementAt(++i);
                }
                if (newDecls == null) {
                    vec.add(rep.primedNodeText());
                } else {
                    vec.add(new String[]{(String)newDecls + ", " + rep.nodeText[0]});
                }
            }
            ++i;
        }
        Vector<String> resVec = new Vector<String>();
        int i2 = 0;
        while (i2 < vec.size()) {
            String[] strArray = (String[])vec.elementAt(i2);
            int j = 0;
            while (j < strArray.length) {
                Object str = strArray[j];
                if (j == strArray.length - 1 && i2 != vec.size() - 1) {
                    str = (String)str + ",";
                }
                resVec.add((String)str);
                ++j;
            }
            ++i2;
        }
        String[] result = new String[resVec.size()];
        int i3 = 0;
        while (i3 < result.length) {
            result[i3] = (String)resVec.elementAt(i3);
            ++i3;
        }
        return result;
    }

    NodeTextRep substituteInNodeText(FormalParamNode[] formalParams, String[] arguments, boolean[] isBoundedIdRenaming, SemanticNode[] argNodes, ExprNode sn, NodeTextRep nodeTextRep, Decomposition decomp) {
        NodeTextRep result = nodeTextRep.clone();
        int numOfLines = result.nodeText.length;
        Vector[] inserts = new Vector[numOfLines];
        int i = 0;
        while (i < numOfLines) {
            inserts[i] = new Vector();
            ++i;
        }
        int beginLine = sn.stn.getLocation().beginLine();
        int i2 = 0;
        while (i2 < arguments.length) {
            Location useLocation;
            SemanticNode[] uses = ResourceHelper.getUsesOfSymbol((SymbolNode)formalParams[i2], (SemanticNode)sn);
            String replacementText = arguments[i2];
            int sourceTextLength = this.getCurrentName(formalParams[i2], decomp.renaming).length();
            boolean mayNeedParens = false;
            if (OldDecomposeProofHandler.primingNeedsParens(argNodes[i2]) && (replacementText.charAt(replacementText.length() - 1) != '\'' || replacementText.startsWith("\\/") || replacementText.startsWith("/\\"))) {
                mayNeedParens = true;
            }
            int j = 0;
            while (j < uses.length) {
                if (!(uses[j] instanceof OpApplNode)) {
                    MessageDialog.openError((Shell)UIHelper.getShellProvider().getShell(), (String)"Decompose Proof Command", (String)"An error that should not happen has occurred in line 2842 of DecomposeProofHandler.");
                    return result;
                }
                Location useLocation2 = uses[j].stn.getLocation();
                int useIdx = useLocation2.beginLine() - beginLine;
                int offset = this.colToLoc(useLocation2.beginColumn(), result.mapping[useIdx]);
                Object thisReplaceText = replacementText;
                if (mayNeedParens) {
                    String[] precedingSafe = new String[]{"(", "[", "{", ",", "<<", "->", ":"};
                    String[] followingSafe = new String[]{")", "]", "}", ",", ">>", "->", "~>"};
                    String testString = result.nodeText[useIdx].substring(0, offset).trim();
                    int line = useIdx;
                    while (testString.equals("") && line > 0) {
                        testString = result.nodeText[--line];
                    }
                    boolean terminated = testString.equals("");
                    int k = 0;
                    while (!terminated && k < precedingSafe.length) {
                        terminated = testString.endsWith(precedingSafe[k]);
                        ++k;
                    }
                    if (terminated) {
                        testString = result.nodeText[useIdx].substring(offset + sourceTextLength).trim();
                        line = useIdx;
                        while (testString.equals("") && line < result.nodeText.length - 1) {
                            testString = result.nodeText[++line];
                        }
                        terminated = testString.equals("");
                        k = 0;
                        while (!terminated && k < precedingSafe.length) {
                            terminated = testString.startsWith(followingSafe[k]);
                            ++k;
                        }
                    }
                    if (!terminated) {
                        thisReplaceText = "(" + replacementText + ")";
                    }
                }
                result.nodeText[useIdx] = result.nodeText[useIdx].substring(0, offset) + (String)thisReplaceText + result.nodeText[useIdx].substring(offset + sourceTextLength);
                OldDecomposeProofHandler.adjustMappingPairVector(useLocation2.beginColumn() + sourceTextLength, ((String)thisReplaceText).length() - sourceTextLength, result.mapping[useIdx]);
                inserts[useIdx].add(new Insertion(offset, sourceTextLength, ((String)thisReplaceText).length()));
                ++j;
            }
            if (isBoundedIdRenaming[i2] && EditorUtil.locationContainment(useLocation = formalParams[i2].stn.getLocation(), sn.stn.getLocation())) {
                int useIdx = useLocation.beginLine() - beginLine;
                int offset = this.colToLoc(useLocation.beginColumn(), result.mapping[useIdx]);
                result.nodeText[useIdx] = result.nodeText[useIdx].substring(0, offset) + replacementText + result.nodeText[useIdx].substring(offset + sourceTextLength);
                OldDecomposeProofHandler.adjustMappingPairVector(useLocation.beginColumn() + sourceTextLength, replacementText.length() - sourceTextLength, result.mapping[useIdx]);
                inserts[useIdx].add(new Insertion(offset, sourceTextLength, replacementText.length()));
            }
            ++i2;
        }
        OldDecomposeProofHandler.adjustIndentation(nodeTextRep, result, inserts);
        return result;
    }

    NodeTextRep decompSubstituteInNodeText(NodeRepresentation nodeRep, ExprNode sn, NodeTextRep nodeTextRep, NodeRepresentation originalNodeRep) {
        Decomposition decomp = nodeRep.decomposition;
        HashSet prevDeclared = (HashSet)this.declaredIdentifiers.clone();
        this.addDeclaredSymbols(prevDeclared, originalNodeRep);
        this.addSymbolsDeclaredLater(prevDeclared, originalNodeRep, false);
        Renaming rename = decomp.renaming.clone();
        this.addToRenaming(rename, prevDeclared, sn);
        int decompParamsLen = 0;
        if (decomp.formalParams != null) {
            decompParamsLen = decomp.formalParams.length;
        }
        FormalParamNode[] formalParams = new FormalParamNode[decompParamsLen + rename.identifiers.size()];
        String[] arguments = new String[formalParams.length];
        boolean[] isBoundedIdRenaming = new boolean[formalParams.length];
        SemanticNode[] argNodes = new SemanticNode[formalParams.length];
        int i = 0;
        while (i < decompParamsLen) {
            formalParams[i] = decomp.formalParams[i];
            arguments[i] = decomp.arguments[i];
            isBoundedIdRenaming[i] = false;
            argNodes[i] = decomp.argNodes[i];
            ++i;
        }
        i = 0;
        while (i < rename.identifiers.size()) {
            formalParams[i + decompParamsLen] = rename.identifiers.elementAt(i);
            arguments[i + decompParamsLen] = rename.newNames.elementAt(i);
            isBoundedIdRenaming[i + decompParamsLen] = true;
            argNodes[i + decompParamsLen] = null;
            ++i;
        }
        NodeTextRep result = this.substituteInNodeText(formalParams, arguments, isBoundedIdRenaming, argNodes, sn, nodeTextRep, decomp);
        decomp.renaming = rename;
        return result;
    }

    private void addToRenaming(Renaming renaming, HashSet<String> prevDeclared, ExprNode expr) {
        int i;
        if (!(expr instanceof OpApplNode)) {
            return;
        }
        HashSet newDeclared = (HashSet)prevDeclared.clone();
        OpApplNode node = (OpApplNode)expr;
        if (node.getUnbdedQuantSymbols() != null) {
            i = 0;
            while (i < node.getUnbdedQuantSymbols().length) {
                FormalParamNode id = node.getUnbdedQuantSymbols()[i];
                if (newDeclared.contains(this.getCurrentName(id, renaming))) {
                    String newname = this.getNewName(id, newDeclared, renaming);
                    newDeclared.add(newname);
                    this.addCurrentName(id, newname, renaming);
                }
                ++i;
            }
        }
        if (node.getBdedQuantSymbolLists() != null) {
            i = 0;
            while (i < node.getBdedQuantSymbolLists().length) {
                this.addToRenaming(renaming, prevDeclared, node.getBdedQuantBounds()[i]);
                FormalParamNode[] nodeList = node.getBdedQuantSymbolLists()[i];
                int j = 0;
                while (j < nodeList.length) {
                    FormalParamNode id = nodeList[j];
                    if (newDeclared.contains(this.getCurrentName(id, renaming))) {
                        String newname = this.getNewName(id, newDeclared, renaming);
                        newDeclared.add(newname);
                        this.addCurrentName(id, newname, renaming);
                    }
                    ++j;
                }
                ++i;
            }
        }
        i = 0;
        while (i < node.getArgs().length) {
            if (node.getArgs()[i] instanceof ExprNode) {
                this.addToRenaming(renaming, newDeclared, (ExprNode)node.getArgs()[i]);
            }
            ++i;
        }
    }

    static NodeTextRep appendToNodeText(NodeTextRep nodeRep, String str) {
        NodeTextRep result = nodeRep.clone();
        result.nodeText[result.nodeText.length - 1] = result.nodeText[result.nodeText.length - 1] + str;
        return result;
    }

    static NodeTextRep prependToNodeText(NodeTextRep nodeRep, String str) {
        NodeTextRep result = nodeRep.clone();
        int i = 0;
        while (i < nodeRep.nodeText.length) {
            if (i == 0) {
                result.nodeText[0] = str + result.nodeText[0];
            } else {
                result.nodeText[i] = StringHelper.copyString((String)" ", (int)str.length()) + result.nodeText[i];
            }
            OldDecomposeProofHandler.adjustMappingPairVector(1, str.length(), result.mapping[i]);
            ++i;
        }
        return result;
    }

    static String[] appendToStringArray(String[] array, String str) {
        String[] result = new String[array.length];
        int i = 0;
        while (i < result.length) {
            result[i] = array[i];
            ++i;
        }
        result[result.length - 1] = array[result.length - 1] + str;
        return result;
    }

    static String[] prependToStringArray(String[] array, String str) {
        String[] result = new String[array.length];
        int i = 0;
        while (i < result.length) {
            if (i == 0) {
                result[0] = str + array[0];
            } else {
                result[i] = StringHelper.copyString((String)" ", (int)str.length()) + array[i];
            }
            ++i;
        }
        return result;
    }

    static String[] concatStringArrays(String[] array1, String[] array2) {
        String[] result = new String[array1.length + array2.length];
        int i = 0;
        while (i < array1.length) {
            result[i] = array1[i];
            ++i;
        }
        i = 0;
        while (i < array2.length) {
            result[i + array1.length] = array2[i];
            ++i;
        }
        return result;
    }

    static String setOfStringsToList(Set<String> set) {
        Object result = "";
        Iterator<String> iter = set.iterator();
        boolean first = true;
        while (iter.hasNext()) {
            if (first) {
                first = false;
            } else {
                result = (String)result + ", ";
            }
            result = (String)result + iter.next();
        }
        return result;
    }

    private void addDeclaredSymbols(HashSet<String> result, NodeRepresentation node) {
        Vector<NodeRepresentation> parentVec = node.parentVector;
        if (parentVec == null) {
            parentVec = this.assumeReps;
        }
        int i = 0;
        while (i < parentVec.size() && parentVec.elementAt(i) != node) {
            NodeRepresentation parent = parentVec.elementAt(i);
            if (parent.nodeType == 1) {
                result.add(parent.newId);
            }
            ++i;
        }
        if (parentVec != this.assumeReps) {
            if (node.parentNode != null) {
                this.addDeclaredSymbols(result, node.parentNode);
            } else {
                System.out.println("Bug found in DecomposeProofHandler.addDeclaredSymbols.");
            }
        }
    }

    private void addSymbolsDeclaredLater(HashSet<String> prevDeclared, NodeRepresentation nodeRepArg, boolean includeGoal) {
        NodeRepresentation assumpRepNode = nodeRepArg;
        while (assumpRepNode.parentNode != null) {
            assumpRepNode = assumpRepNode.parentNode;
        }
        int idx = 0;
        while (idx < this.assumeReps.size() && this.assumeReps.elementAt(idx) != assumpRepNode) {
            ++idx;
        }
        if (idx == this.assumeReps.size()) {
            return;
        }
        int i = idx + 1;
        while (i < this.assumeReps.size()) {
            NodeRepresentation anode = this.assumeReps.elementAt(i);
            if (anode.nodeType == 1) {
                prevDeclared.add(anode.newId);
            }
            ++i;
        }
        if (includeGoal) {
            FormalParamNode[] goalIdents = ResourceHelper.getBoundIdentifiers((ExprNode)((ExprNode)this.goalRep.semanticNode));
            int i2 = 0;
            while (i2 < goalIdents.length) {
                prevDeclared.add(goalIdents[i2].getName().toString());
                ++i2;
            }
        }
    }

    public static String nodeSubTypeToString(int subType) {
        String val = "?";
        switch (subType) {
            case 0: {
                val = "AND_TYPE";
                break;
            }
            case 1: {
                val = "OR_TYPE";
                break;
            }
            case 2: {
                val = "IMPLIES_TYPE";
                break;
            }
            case 3: {
                val = "FORALL_TYPE";
                break;
            }
            case 4: {
                val = "EXISTS_TYPE";
                break;
            }
            case 5: {
                val = "SQSUB_TYPE";
                break;
            }
            case 99: {
                val = "OTHER_TYPE";
            }
        }
        return val;
    }

    private static int operatorNameToNodeSubtype(UniqueString opId) {
        String opName = opId.toString();
        if (opId == ASTConstants.OP_cl || opName.equals("\\land")) {
            return 0;
        }
        if (opId == ASTConstants.OP_dl || opName.equals("\\lor")) {
            return 1;
        }
        if (opName.equals("=>")) {
            return 2;
        }
        if (opId == ASTConstants.OP_bf || opId == ASTConstants.OP_uf) {
            return 3;
        }
        if (opId == ASTConstants.OP_be || opId == ASTConstants.OP_ue) {
            return 4;
        }
        if (opId == ASTConstants.OP_sa) {
            return 5;
        }
        return 99;
    }

    private Decomposition decompose(NodeRepresentation nodeRep, Decomposition decomp) {
        OpApplNode node;
        SemanticNode sn = nodeRep.semanticNode;
        if (!(sn instanceof OpApplNode)) {
            return null;
        }
        OpApplNode unprimedNode = node = (OpApplNode)sn;
        Decomposition result = new Decomposition();
        if (decomp != null) {
            result.renaming.identifiers = (Vector)decomp.renaming.identifiers.clone();
            result.renaming.newNames = (Vector)decomp.renaming.newNames.clone();
        }
        if (node.getOperator().getName() == ASTConstants.OP_prime) {
            if (!(node.getArgs()[0] instanceof OpApplNode)) {
                return null;
            }
            unprimedNode = node = (OpApplNode)node.getArgs()[0];
            result.primed = true;
        }
        if (!nodeRep.isSubexpressionName && node.getOperator().getKind() == 5) {
            OpDefNode definition = (OpDefNode)node.getOperator();
            String operatorName = definition.getName().toString();
            ExprNode opDef = definition.getBody();
            if (opDef instanceof SubstInNode) {
                return null;
            }
            if (opDef instanceof OpApplNode) {
                ExprOrOpArgNode[] args = node.getArgs();
                int i = 0;
                while (i < args.length) {
                    SyntaxTreeNode stn = (SyntaxTreeNode)args[i].stn;
                    Location stnLoc = stn.getLocation();
                    if (stnLoc.beginLine() != stnLoc.endLine()) {
                        return null;
                    }
                    ++i;
                }
                node = (OpApplNode)opDef;
                result.moduleName = ((SyntaxTreeNode)node.stn).getLocation().source();
                result.definedOp = operatorName;
                result.definedOpRep = nodeRep.subNodeText((SemanticNode)unprimedNode);
                result.formalParams = definition.getParams();
                result.arguments = new String[result.formalParams.length];
                result.argNodes = unprimedNode.getArgs();
                i = 0;
                while (i < result.arguments.length) {
                    result.arguments[i] = OldDecomposeProofHandler.stringArrayToString(nodeRep.subNodeText((SemanticNode)unprimedNode.getArgs()[i]).nodeText);
                    ++i;
                }
            } else {
                return null;
            }
        }
        boolean isAndOrOr = false;
        boolean isJunction = false;
        boolean isQuantifier = false;
        boolean isBoundedQuantifier = false;
        if (!(node.getOperator() instanceof OpDefNode)) {
            return null;
        }
        UniqueString opId = ((OpDefNode)node.getOperator()).getName();
        String opName = opId.toString();
        if (opId == ASTConstants.OP_cl || opName.equals("\\land")) {
            result.type = 0;
            if (opId == ASTConstants.OP_cl) {
                isJunction = true;
            } else {
                isAndOrOr = true;
            }
        } else if (opId == ASTConstants.OP_dl || opName.equals("\\lor")) {
            result.type = 1;
            if (opId == ASTConstants.OP_dl) {
                isJunction = true;
            } else {
                isAndOrOr = true;
            }
        } else if (opName.equals("=>")) {
            result.type = 2;
        } else if (opId == ASTConstants.OP_bf || opId == ASTConstants.OP_uf) {
            result.type = 3;
            isQuantifier = true;
            if (opId == ASTConstants.OP_bf) {
                isBoundedQuantifier = true;
            }
        } else if (opId == ASTConstants.OP_be || opId == ASTConstants.OP_ue) {
            result.type = 4;
            isQuantifier = true;
            if (opId == ASTConstants.OP_be) {
                isBoundedQuantifier = true;
            }
        } else if (opId == ASTConstants.OP_sa) {
            result.type = 5;
        } else {
            return null;
        }
        if (isAndOrOr) {
            OldDecomposeProofHandler.processAndOrOr(result, (SemanticNode)node, "", opName);
        } else if (isJunction) {
            ExprOrOpArgNode[] juncts = node.getArgs();
            int i = 0;
            while (i < juncts.length) {
                result.children.add((SemanticNode)juncts[i]);
                result.namePath.add("!" + (i + 1));
                ++i;
            }
        } else if (isQuantifier) {
            result.children.add((SemanticNode)node.getArgs()[0]);
            Object namePath = "!(";
            result.quantIds = new Vector();
            if (isBoundedQuantifier) {
                result.quantBounds = new Vector();
                result.quantBoundsubexpNames = new Vector();
                FormalParamNode[][] quantIdsArray = node.getBdedQuantSymbolLists();
                ExprNode[] quantBounds = node.getBdedQuantBounds();
                int i = 0;
                while (i < quantIdsArray.length) {
                    if (node.isBdedQuantATuple()[i]) {
                        return null;
                    }
                    FormalParamNode[] quantIds = quantIdsArray[i];
                    int j = 0;
                    while (j < quantIds.length) {
                        result.quantIds.add(quantIds[j]);
                        result.quantBounds.add(quantBounds[i]);
                        result.quantBoundsubexpNames.add("!" + (i + 1));
                        if (i != 0 || j != 0) {
                            namePath = (String)namePath + ",";
                        }
                        namePath = (String)namePath + quantIds[j].getName().toString();
                        ++j;
                    }
                    ++i;
                }
            } else {
                FormalParamNode[] quantIds = node.getUnbdedQuantSymbols();
                int i = 0;
                while (i < quantIds.length) {
                    result.quantIds.add(quantIds[i]);
                    if (i != 0) {
                        namePath = (String)namePath + ",";
                    }
                    namePath = (String)namePath + quantIds[i].getName().toString();
                    ++i;
                }
            }
            namePath = (String)namePath + ")";
            result.namePath.add((String)namePath);
        } else if (result.type == 2 || result.type == 5) {
            result.children.add((SemanticNode)node.getArgs()[0]);
            result.namePath.add("!1");
            result.children.add((SemanticNode)node.getArgs()[1]);
            result.namePath.add("!2");
        }
        return result;
    }

    private static void processAndOrOr(Decomposition decomp, SemanticNode node, String namePathPrefix, String op) {
        if (!(node instanceof OpApplNode)) {
            decomp.children.add(node);
            decomp.namePath.add(namePathPrefix);
            return;
        }
        OpApplNode aonode = (OpApplNode)node;
        SymbolNode sym = aonode.getOperator();
        UniqueString opId = null;
        String opName = null;
        if (sym instanceof OpDefNode) {
            opId = ((OpDefNode)sym).getName();
            opName = opId.toString();
        }
        if (opName == null || !opName.equals(op)) {
            decomp.children.add(node);
            decomp.namePath.add(namePathPrefix);
            return;
        }
        OldDecomposeProofHandler.processAndOrOr(decomp, (SemanticNode)aonode.getArgs()[0], namePathPrefix + "!1", op);
        decomp.children.add((SemanticNode)aonode.getArgs()[1]);
        decomp.namePath.add(namePathPrefix + "!2");
    }

    private int colToLoc(int col, Vector<MappingPair> vec) {
        int loc = col;
        int i = 0;
        while (i < vec.size() && vec.elementAt((int)i).col <= col) {
            loc += vec.elementAt((int)i).inc;
            ++i;
        }
        return loc;
    }

    private static void adjustMappingPairVector(int col, int incr, Vector<MappingPair> vec) {
        int i = 0;
        while (i < vec.size() && vec.elementAt((int)i).col < col) {
            ++i;
        }
        if (i == vec.size()) {
            vec.add(new MappingPair(col, incr));
        } else if (vec.elementAt((int)i).col == col) {
            vec.elementAt((int)i).inc += incr;
        } else {
            vec.insertElementAt(new MappingPair(col, incr), i);
        }
    }

    private static Vector<MappingPair> cloneMappingPairVector(Vector<MappingPair> vec) {
        Vector<MappingPair> result = new Vector<MappingPair>();
        int i = 0;
        while (i < vec.size()) {
            result.add(vec.elementAt(i).clone());
            ++i;
        }
        return result;
    }

    static int newInsertPos(int oldPos, Insertion ins) {
        if (oldPos <= ins.pos) {
            return oldPos;
        }
        if (oldPos < ins.pos + ins.oldLen) {
            if (oldPos < ins.pos + ins.newLen) {
                return oldPos;
            }
            return ins.pos + ins.newLen - ins.oldLen;
        }
        return oldPos + ins.newLen - ins.oldLen;
    }

    static int newVecInsertPos(int oldPos, Vector<Insertion> vec) {
        return OldDecomposeProofHandler.innerNewVecInsertPos(oldPos, 0, vec);
    }

    static int innerNewVecInsertPos(int oldPos, int idx, Vector<Insertion> vec) {
        if (vec.size() <= idx) {
            return oldPos;
        }
        return OldDecomposeProofHandler.innerNewVecInsertPos(OldDecomposeProofHandler.newInsertPos(oldPos, vec.elementAt(idx)), idx + 1, vec);
    }

    static void adjustIndentation(NodeTextRep oldTextRep, NodeTextRep newTextRep, Vector<Insertion>[] insVecArray) {
        int numOfLines = insVecArray.length;
        int[] startingPos = new int[numOfLines];
        int i = 0;
        while (i < numOfLines) {
            int coveringLine;
            String str = oldTextRep.nodeText[i];
            startingPos[i] = StringHelper.leadingSpaces((String)str);
            if (startingPos[i] == str.length()) {
                startingPos[i] = -1;
            }
            if (startingPos[i] == -1) {
                coveringLine = -1;
            } else {
                int j = i - 1;
                while (j >= 0 && (startingPos[j] > startingPos[i] || startingPos[j] == -1)) {
                    --j;
                }
                coveringLine = j;
            }
            int addSpace = coveringLine == -1 ? 0 : OldDecomposeProofHandler.newVecInsertPos(startingPos[i], insVecArray[coveringLine]) - startingPos[i];
            str = newTextRep.nodeText[i];
            if (addSpace > 0) {
                newTextRep.nodeText[i] = StringHelper.copyString((String)" ", (int)addSpace) + str;
            } else if (addSpace < 0) {
                newTextRep.nodeText[i] = str.substring(-addSpace);
            }
            OldDecomposeProofHandler.adjustMappingPairVector(1, addSpace, newTextRep.mapping[i]);
            ++i;
        }
    }

    public static String stringArrayToString(String[] A) {
        if (A.length == 0) {
            return A[0];
        }
        Object result = A[0];
        int i = 1;
        while (i < A.length) {
            result = (String)result + "\n" + A[i];
            ++i;
        }
        return result;
    }

    public static String stringArrayToIndentedString(String[] A, int indent) {
        if (A.length == 0) {
            return A[0];
        }
        Object result = A[0];
        int i = 1;
        while (i < A.length) {
            result = (String)result + "\n" + StringHelper.copyString((String)" ", (int)indent) + A[i];
            ++i;
        }
        return result;
    }

    private void setupMenuButton(Button button, int whichOne, String text) {
        button.addSelectionListener((SelectionListener)new DecomposeProofButtonListener(this, new Integer(whichOne), 1));
        button.setText(text);
        GridData gridData = new GridData();
        gridData.horizontalIndent = 5;
        button.setLayoutData((Object)gridData);
    }

    private void setupCheckButton(Button button, String text) {
        button.setText(text);
        GridData gridData = new GridData();
        gridData.horizontalIndent = 10;
        button.setLayoutData((Object)gridData);
    }

    private void setupActionButton(Button button, NodeRepresentation nodeRep, String text) {
        button.setText(text);
        GridData gridData = new GridData();
        gridData.horizontalIndent = 15;
        gridData.verticalAlignment = 128;
        button.setLayoutData((Object)gridData);
        button.addSelectionListener((SelectionListener)new DecomposeProofButtonListener(this, nodeRep, 2));
        button.setFont(JFaceResources.getFontRegistry().get("org.eclipse.jface.textfont"));
        if (text.equals("  ")) {
            button.setEnabled(false);
        }
    }

    static int getBeginLine(SemanticNode nd) {
        if (nd.stn == null) {
            System.out.println("getBeginLine called on node with null stn field.");
            return -1;
        }
        return nd.stn.getLocation().beginLine();
    }

    static int getEndLine(SemanticNode nd) {
        if (nd.stn == null) {
            System.out.println("getEndLine called on node with null stn field.");
            return -1;
        }
        return nd.stn.getLocation().endLine();
    }

    static int stepLevel(SemanticNode nd) {
        String stepStr = ((SyntaxTreeNode)nd.stn).getHeirs()[0].image.toString();
        String stepNum = stepStr.substring(stepStr.indexOf(60) + 1, stepStr.indexOf(62));
        return Integer.valueOf(stepNum);
    }

    static boolean primingNeedsParens(SemanticNode node) {
        if (!(node instanceof OpApplNode)) {
            return false;
        }
        if (((OpApplNode)node).getArgs().length == 0) {
            return false;
        }
        SymbolNode ops = ((OpApplNode)node).getOperator();
        if (ops instanceof OpDefNode) {
            OpDefNode odn = (OpDefNode)ops;
            return odn.getKind() == 7 || !StringHelper.isIdentifier((String)odn.getName().toString());
        }
        return false;
    }

    public boolean existDirtyModules() {
        LinkedList<IEditorReference> dirtyEditors = new LinkedList<IEditorReference>();
        IEditorReference[] references = UIHelper.getActivePage().getEditorReferences();
        if (references != null) {
            int i = 0;
            while (i < references.length) {
                try {
                    if (references[i].isDirty() && references[i].getEditorInput().getName().endsWith(".tla")) {
                        dirtyEditors.add(references[i]);
                    }
                }
                catch (PartInitException e) {
                    Activator.getDefault().logError("Error getting unsaved resources.", (Throwable)e);
                }
                ++i;
            }
        }
        return dirtyEditors.size() > 0;
    }

    class ArrowSelectionListener
    implements SelectionListener {
        int index;
        int direction;
        OldDecomposeProofHandler handler;

        ArrowSelectionListener(int idx, int dir, OldDecomposeProofHandler han) {
            this.index = idx;
            this.direction = dir;
            this.handler = han;
        }

        public void widgetSelected(SelectionEvent e) {
            NodeRepresentation rep = this.handler.assumeReps.elementAt(this.index);
            this.handler.assumeReps.remove(this.index);
            int inc = this.direction == 1024 ? 1 : -1;
            this.handler.assumeReps.add(this.index + inc, rep);
            this.handler.raiseWindow();
        }

        public void widgetDefaultSelected(SelectionEvent e) {
            this.widgetSelected(e);
        }
    }

    public class DecomposeProofButtonListener
    extends SelectionAdapter
    implements SelectionListener {
        OldDecomposeProofHandler decomposeHandler;
        int type;
        Object object;

        public Object execute(ExecutionEvent event) throws ExecutionException {
            return null;
        }

        public DecomposeProofButtonListener(OldDecomposeProofHandler dHandler, Object but, int tp) {
            this.decomposeHandler = dHandler;
            this.type = tp;
            this.object = but;
        }

        public void widgetSelected(SelectionEvent e) {
            OldDecomposeProofHandler.this.readButtons();
            block0 : switch (this.type) {
                case 1: {
                    int buttonId = (Integer)this.object;
                    switch (buttonId) {
                        case 1: {
                            OldDecomposeProofHandler.this.makeProof(null, false, true);
                            break;
                        }
                        case 99: {
                            OldDecomposeProofHandler.this.windowShell = this.decomposeHandler.windowShell;
                            this.decomposeHandler.location = OldDecomposeProofHandler.this.windowShell.getLocation();
                            OldDecomposeProofHandler.this.windowShell.close();
                            if (OldDecomposeProofHandler.this.windowShell != null) {
                                if (OldDecomposeProofHandler.this.windowShell.isDisposed()) {
                                    System.out.println("closing disposes of window");
                                } else {
                                    OldDecomposeProofHandler.this.windowShell.dispose();
                                }
                                if (OldDecomposeProofHandler.this.windowShell == null) {
                                    System.out.println("Closing nullifies");
                                }
                            }
                            OldDecomposeProofHandler.this.raiseWindow();
                        }
                    }
                    break;
                }
                case 2: {
                    OldDecomposeProofHandler.this.hasChanged = true;
                    NodeRepresentation nodeObj = (NodeRepresentation)this.object;
                    if (nodeObj.nodeType == 2) {
                        this.decomposeHandler.caseAction(nodeObj);
                        break;
                    }
                    switch (nodeObj.nodeSubtype) {
                        case 0: {
                            this.decomposeHandler.andAction(nodeObj);
                            break block0;
                        }
                        case 1: {
                            this.decomposeHandler.orAction(nodeObj);
                            break block0;
                        }
                        case 2: {
                            this.decomposeHandler.impliesAction(nodeObj);
                            break block0;
                        }
                        case 3: {
                            this.decomposeHandler.forAllAction(nodeObj);
                            break block0;
                        }
                        case 4: {
                            this.decomposeHandler.existsAction(nodeObj);
                            break block0;
                        }
                        case 5: {
                            this.decomposeHandler.sqsubAction(nodeObj);
                            break block0;
                        }
                    }
                }
            }
        }

        public void widgetDefaultSelected(SelectionEvent e) {
            this.widgetSelected(e);
        }
    }

    public class DecomposeProofRunnable
    implements Runnable {
        OldDecomposeProofHandler handler;

        DecomposeProofRunnable(OldDecomposeProofHandler h) {
            this.handler = h;
        }

        @Override
        public void run() {
            try {
                this.handler.editor = EditorUtil.getTLAEditorWithFocus();
                this.handler.doc = OldDecomposeProofHandler.this.editor.getDocumentProvider().getDocument((Object)OldDecomposeProofHandler.this.editor.getEditorInput());
                this.handler.selectionProvider = OldDecomposeProofHandler.this.editor.getSelectionProvider();
                this.handler.selection = (TextSelection)OldDecomposeProofHandler.this.selectionProvider.getSelection();
                this.handler.offset = OldDecomposeProofHandler.this.selection.getOffset();
                String moduleName = OldDecomposeProofHandler.this.editor.getModuleName();
                this.handler.moduleNode = ResourceHelper.getModuleNode((String)moduleName);
                this.handler.realExecute();
            }
            catch (ExecutionException e) {
                e.printStackTrace();
            }
        }
    }

    static class Decomposition {
        int type;
        String definedOp = null;
        FormalParamNode[] formalParams = null;
        String[] arguments = null;
        SemanticNode[] argNodes = null;
        NodeTextRep definedOpRep = null;
        Renaming renaming = new Renaming();
        String moduleName = null;
        Vector<SemanticNode> children = new Vector();
        Vector<String> namePath = new Vector();
        Vector<FormalParamNode> quantIds = null;
        Vector<ExprNode> quantBounds = null;
        Vector<String> quantBoundsubexpNames = null;
        boolean primed = false;

        Decomposition() {
        }

        public String toString() {
            String val = "type: " + OldDecomposeProofHandler.nodeSubTypeToString(this.type);
            if (this.definedOp != null) {
                val = val + "\ndefinedOp: " + this.definedOp;
                val = val + "\ndefinedOpRep: " + this.definedOpRep.toString();
            }
            val = val + "\nmoduleName: " + this.moduleName;
            val = val + "\nchildren: ";
            int i = 0;
            while (i < this.children.size()) {
                val = val + "\nchildren[" + i + "]:\n " + this.children.elementAt(i).toString();
                ++i;
            }
            val = val + "\nnamePath: " + this.namePath.toString();
            if (this.quantIds != null) {
                val = val + "\nquantIds: ";
                i = 0;
                while (i < this.quantIds.size()) {
                    if (i != 0) {
                        val = val + ", ";
                    }
                    val = val + this.quantIds.elementAt(i).getName().toString();
                    ++i;
                }
            }
            if (this.quantBounds != null) {
                i = 0;
                while (i < this.quantBounds.size()) {
                    val = val + "\nquantBounds[" + i + "]:\n " + this.quantBounds.elementAt(i).toString();
                    ++i;
                }
                val = val + "quantBoundsubexpNames: ";
                i = 0;
                while (i < this.quantBounds.size()) {
                    val = val + (i == 0 ? "" : ", ") + this.quantBoundsubexpNames.elementAt(i);
                    ++i;
                }
            }
            val = val + "\nprimed: " + this.primed;
            return val;
        }
    }

    private static class Insertion {
        int pos;
        int oldLen;
        int newLen;

        private Insertion(int pos, int oldLen, int newLen) {
            this.pos = pos;
            this.oldLen = oldLen;
            this.newLen = newLen;
        }

        public String toString() {
            return "[pos: " + this.pos + ", oldLen: " + this.oldLen + ", newLen: " + this.newLen + "]";
        }
    }

    private static class MappingPair {
        int col;
        int inc;

        MappingPair(int c, int p) {
            this.col = c;
            this.inc = p;
        }

        public MappingPair clone() {
            return new MappingPair(this.col, this.inc);
        }

        public String toString() {
            return "<" + this.col + ", " + this.inc + ">";
        }
    }

    public class NodeRepresentation {
        SemanticNode semanticNode;
        String[] nodeText;
        Vector<MappingPair>[] mapping;
        private static final int EXPR_NODE = 0;
        private static final int NEW_NODE = 1;
        private static final int OR_DECOMP = 2;
        private static final int PROOF_NODE = 4;
        private static final int OTHER_NODE = 5;
        private int nodeType = 0;
        private static final int AND_TYPE = 0;
        private static final int OR_TYPE = 1;
        private static final int IMPLIES_TYPE = 2;
        private static final int FORALL_TYPE = 3;
        private static final int EXISTS_TYPE = 4;
        private static final int SQSUB_TYPE = 5;
        private static final int OTHER_TYPE = 99;
        public int nodeSubtype = 99;
        public String newId = null;
        Vector<Vector<NodeRepresentation>> children = null;
        NodeRepresentation parentNode = null;
        Vector<NodeRepresentation> parentVector = null;
        boolean isCreated = false;
        boolean onSameLineAsNext = false;
        boolean isPrimed = false;
        boolean isSubexpressionName = false;
        Decomposition decomposition = null;

        int getParentIndex() {
            if (this.parentVector == null) {
                return -1;
            }
            int i = 0;
            while (i < this.parentVector.size()) {
                if (this == this.parentVector.elementAt(i)) {
                    return i;
                }
                ++i;
            }
            return -1;
        }

        int getParentVectorIndex() {
            int i = 0;
            while (i < this.parentNode.children.size()) {
                if (this.parentVector == this.parentNode.children.elementAt(i)) {
                    return i;
                }
                ++i;
            }
            return -1;
        }

        NodeRepresentation subNodeRep(SemanticNode sn, Vector<NodeRepresentation> vec, NodeRepresentation father, NodeTextRep setNodeText, Decomposition decomp) {
            NodeRepresentation result = new NodeRepresentation();
            result.parentNode = father;
            result.parentVector = vec;
            result.semanticNode = sn;
            result.isPrimed = this.isPrimed;
            result.isSubexpressionName = this.isSubexpressionName;
            result.isCreated = this.isCreated;
            NodeTextRep nodeTextRep = setNodeText;
            if (nodeTextRep == null) {
                nodeTextRep = this.subNodeText(sn);
            } else {
                result.isSubexpressionName = true;
            }
            result.nodeText = nodeTextRep.nodeText;
            result.mapping = nodeTextRep.mapping;
            switch (sn.getKind()) {
                case 9: {
                    result.nodeType = 0;
                    result.decomposition = OldDecomposeProofHandler.this.decompose(result, decomp);
                    if (result.decomposition == null) {
                        result.nodeSubtype = 99;
                        break;
                    }
                    result.nodeSubtype = result.decomposition.type;
                    break;
                }
                case 22: {
                    result.nodeType = 1;
                    NewSymbNode newNode = (NewSymbNode)sn;
                    result.newId = newNode.getOpDeclNode().getName().toString();
                    break;
                }
                case 33: {
                    result.nodeType = 4;
                    break;
                }
                default: {
                    result.nodeType = 5;
                }
            }
            return result;
        }

        NodeTextRep subNodeText(SemanticNode sn) {
            NodeTextRep result = new NodeTextRep();
            int beginIdx = OldDecomposeProofHandler.getBeginLine(sn) - OldDecomposeProofHandler.getBeginLine(this.semanticNode);
            result.nodeText = new String[OldDecomposeProofHandler.getEndLine(sn) - OldDecomposeProofHandler.getBeginLine(sn) + 1];
            result.mapping = new Vector[result.nodeText.length];
            int beginCol = sn.stn.getLocation().beginColumn();
            int beginPos = OldDecomposeProofHandler.this.colToLoc(beginCol, this.mapping[beginIdx]);
            result.nodeText[0] = this.nodeText[beginIdx].substring(beginPos);
            Vector<MappingPair> mv = OldDecomposeProofHandler.cloneMappingPairVector(this.mapping[beginIdx]);
            OldDecomposeProofHandler.adjustMappingPairVector(beginCol, -beginPos, mv);
            result.mapping[0] = mv;
            int minPos = beginPos;
            int i = 1;
            while (i < result.mapping.length) {
                result.nodeText[i] = this.nodeText[i + beginIdx];
                if (!StringHelper.onlySpaces((String)result.nodeText[i])) {
                    minPos = Math.min(minPos, StringHelper.leadingSpaces((String)result.nodeText[i]));
                }
                result.mapping[i] = new Vector();
                int j = 0;
                while (j < this.mapping[i + beginIdx].size()) {
                    result.mapping[i].add(this.mapping[i + beginIdx].elementAt(j).clone());
                    ++j;
                }
                ++i;
            }
            result.nodeText[result.nodeText.length - 1] = result.nodeText[result.nodeText.length - 1].substring(0, OldDecomposeProofHandler.this.colToLoc(sn.stn.getLocation().endColumn() + 1, result.mapping[result.mapping.length - 1]));
            int spacesAddedToFirstLine = beginPos - minPos;
            result.nodeText[0] = StringHelper.copyString((String)" ", (int)spacesAddedToFirstLine) + result.nodeText[0];
            OldDecomposeProofHandler.adjustMappingPairVector(beginCol, spacesAddedToFirstLine, result.mapping[0]);
            int i2 = 1;
            while (i2 < result.nodeText.length) {
                if (!StringHelper.onlySpaces((String)result.nodeText[i2])) {
                    result.nodeText[i2] = result.nodeText[i2].substring(minPos);
                    OldDecomposeProofHandler.adjustMappingPairVector(1, -minPos, result.mapping[i2]);
                }
                ++i2;
            }
            return result;
        }

        String[] primedNodeText() {
            if (!this.isPrimed) {
                return this.nodeText;
            }
            boolean needsParens = !this.isSubexpressionName && OldDecomposeProofHandler.primingNeedsParens(this.semanticNode);
            String[] result = (String[])this.nodeText.clone();
            if (needsParens) {
                result = OldDecomposeProofHandler.prependToStringArray(result, "(");
                result[result.length - 1] = StringHelper.trimEnd((String)result[result.length - 1]) + ")'";
            } else {
                result[result.length - 1] = StringHelper.trimEnd((String)result[result.length - 1]) + "'";
            }
            return result;
        }

        NodeRepresentation(IDocument document, SemanticNode node) throws BadLocationException {
            this.semanticNode = node;
            Location location = node.stn.getLocation();
            this.nodeText = new String[location.endLine() - location.beginLine() + 1];
            this.mapping = new Vector[this.nodeText.length];
            int i = 0;
            while (i < this.mapping.length) {
                this.mapping[i] = new Vector();
                this.mapping[i].add(new MappingPair(1, -node.stn.getLocation().beginColumn()));
                ++i;
            }
            if (location.beginLine() == location.endLine()) {
                String str;
                IRegion thmregion = EditorUtil.getRegionOf(document, node.stn.getLocation());
                this.nodeText[0] = str = document.get(thmregion.getOffset(), thmregion.getLength());
                return;
            }
            IRegion region = document.getLineInformation(location.beginLine() - 1);
            this.nodeText[0] = document.get(region.getOffset() + location.beginColumn() - 1, region.getLength() - location.beginColumn() + 1);
            int minCol = location.beginColumn() - 1;
            int i2 = 1;
            while (i2 < this.nodeText.length) {
                region = document.getLineInformation(location.beginLine() - 1 + i2);
                this.nodeText[i2] = document.get(region.getOffset(), region.getLength());
                if (!StringHelper.onlySpaces((String)this.nodeText[i2])) {
                    minCol = Math.min(minCol, StringHelper.leadingSpaces((String)this.nodeText[i2]));
                }
                ++i2;
            }
            this.nodeText[this.nodeText.length - 1] = this.nodeText[this.nodeText.length - 1].substring(0, location.endColumn());
            int spacesAddedToFirstLine = location.beginColumn() - minCol - 1;
            this.nodeText[0] = StringHelper.copyString((String)" ", (int)spacesAddedToFirstLine) + this.nodeText[0];
            this.mapping[0].elementAt((int)0).inc = -minCol - 1;
            int i3 = 1;
            while (i3 < this.nodeText.length) {
                if (!StringHelper.onlySpaces((String)this.nodeText[i3])) {
                    this.nodeText[i3] = this.nodeText[i3].substring(minCol);
                    this.mapping[i3].elementAt((int)0).inc = -1 - minCol;
                }
                ++i3;
            }
        }

        public NodeRepresentation() {
        }

        public String toString() {
            Object val = "";
            val = (String)val + "nodeText: |=\n" + OldDecomposeProofHandler.stringArrayToString(this.nodeText) + "=|";
            int i = 0;
            while (i < this.mapping.length) {
                val = (String)val + "\n" + i + ":";
                int j = 0;
                while (j < this.mapping[i].size()) {
                    val = (String)val + "  " + this.mapping[i].elementAt(j).toString();
                    ++j;
                }
                ++i;
            }
            return val;
        }
    }

    static class NodeTextRep {
        String[] nodeText = null;
        Vector<MappingPair>[] mapping = null;

        public NodeTextRep(String[] text, Vector<MappingPair>[] map) {
            this.nodeText = text;
            this.mapping = map;
        }

        public NodeTextRep() {
        }

        public NodeTextRep clone() {
            NodeTextRep result = new NodeTextRep();
            result.nodeText = new String[this.nodeText.length];
            int i = 0;
            while (i < result.nodeText.length) {
                result.nodeText[i] = this.nodeText[i];
                ++i;
            }
            result.mapping = (Vector[])this.mapping.clone();
            i = 0;
            while (i < result.mapping.length) {
                result.mapping[i] = new Vector();
                int j = 0;
                while (j < this.mapping[i].size()) {
                    result.mapping[i].add(this.mapping[i].elementAt(j));
                    ++j;
                }
                ++i;
            }
            return result;
        }

        public String toString() {
            Object val = "";
            val = (String)val + "nodeText: |=\n" + OldDecomposeProofHandler.stringArrayToString(this.nodeText) + "=|";
            int i = 0;
            while (i < this.mapping.length) {
                val = (String)val + "\n" + i + ":";
                int j = 0;
                while (j < this.mapping[i].size()) {
                    val = (String)val + "  " + this.mapping[i].elementAt(j).toString();
                    ++j;
                }
                ++i;
            }
            return val;
        }
    }

    static class QuantifierDecomposition {
        Vector<NodeRepresentation> news;
        NodeRepresentation body;

        QuantifierDecomposition() {
        }
    }

    private static class Renaming {
        Vector<FormalParamNode> identifiers = new Vector();
        Vector<String> newNames = new Vector();

        private Renaming() {
        }

        public Renaming clone() {
            Renaming result = new Renaming();
            result.identifiers = (Vector)this.identifiers.clone();
            result.newNames = this.newNames;
            return result;
        }
    }

    class WindowDisposeListener
    implements DisposeListener {
        OldDecomposeProofHandler commandHandler;

        WindowDisposeListener(OldDecomposeProofHandler handler) {
            this.commandHandler = handler;
        }

        public void widgetDisposed(DisposeEvent e) {
            this.commandHandler.location = OldDecomposeProofHandler.this.windowShell.getLocation();
            this.commandHandler.editorIFile.setReadOnly(false);
        }
    }
}

