/*
 * Decompiled with CFR 0.152.
 */
package org.lamport.tla.toolbox.editor.basic.actions;

import java.util.ResourceBundle;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.ITextSelection;
import org.eclipse.jface.text.Position;
import org.eclipse.jface.text.source.Annotation;
import org.eclipse.jface.text.source.IAnnotationModel;
import org.eclipse.jface.text.source.projection.ProjectionAnnotation;
import org.eclipse.jface.text.source.projection.ProjectionAnnotationModel;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.ui.texteditor.ITextEditor;
import org.eclipse.ui.texteditor.TextEditorAction;

public class DefineFoldingRegionAction
extends TextEditorAction {
    public DefineFoldingRegionAction(ResourceBundle bundle, String prefix, ITextEditor editor) {
        super(bundle, prefix, editor);
    }

    private IAnnotationModel getAnnotationModel(ITextEditor editor) {
        return (IAnnotationModel)editor.getAdapter(ProjectionAnnotationModel.class);
    }

    public void run() {
        IAnnotationModel model;
        ITextSelection textSelection;
        ITextEditor editor = this.getTextEditor();
        ISelection selection = editor.getSelectionProvider().getSelection();
        if (selection instanceof ITextSelection && (textSelection = (ITextSelection)selection).getLength() != 0 && (model = this.getAnnotationModel(editor)) != null) {
            int start = textSelection.getStartLine();
            int end = textSelection.getEndLine();
            try {
                IDocument document = editor.getDocumentProvider().getDocument((Object)editor.getEditorInput());
                int offset = document.getLineOffset(start);
                int endOffset = document.getLineOffset(end + 1);
                Position position = new Position(offset, endOffset - offset);
                model.addAnnotation((Annotation)new ProjectionAnnotation(), position);
            }
            catch (BadLocationException badLocationException) {
                // empty catch block
            }
        }
    }
}

