/*
 * Decompiled with CFR 0.152.
 */
package org.lamport.tla.toolbox.editor.basic;

import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.rules.IPartitionTokenScanner;
import org.eclipse.jface.text.rules.IToken;
import org.eclipse.jface.text.rules.Token;
import org.lamport.tla.toolbox.editor.basic.util.BufferedDocumentScanner;

public class TLAPartitionScanner
implements IPartitionTokenScanner {
    public static final String TLA_PARTITIONING = "__tla_partitioning";
    public static final String TLA_MULTI_LINE_COMMENT = "__tla_multiline_comment";
    public static final String TLA_SINGLE_LINE_COMMENT = "__tla_singleline_comment";
    public static final String TLA_PCAL = "__tla_pcal";
    public static final String TLA_STRING = "__tla_string";
    public static final String TLA_START_PCAL_COMMENT = "__tla_start_pcal_comment";
    public static final String TLA_END_PCAL_COMMENT = "__tla_end_pcal_comment";
    public static final String[] TLA_PARTITION_TYPES = new String[]{"__tla_multiline_comment", "__tla_singleline_comment", "__tla_string", "__tla_start_pcal_comment", "__tla_end_pcal_comment"};
    private static final int TLA = 0;
    private static final int SINGLE_LINE_COMMENT = 1;
    private static final int MULTI_LINE_COMMENT = 2;
    private static final int PCAL = 3;
    private static final int STRING = 4;
    private static final int START_PCAL_COMMENT = 5;
    private static final int END_PCAL_COMMENT = 6;
    private final IToken[] fTokens = new IToken[]{new Token(null), new Token((Object)"__tla_singleline_comment"), new Token((Object)"__tla_multiline_comment"), new Token((Object)"__tla_pcal"), new Token((Object)"__tla_string"), new Token((Object)"__tla_start_pcal_comment"), new Token((Object)"__tla_end_pcal_comment")};
    private static final int NONE = 0;
    private static final int BACKSLASH = 1;
    private static final int O_BRACKET = 2;
    private static final int C_BRACKET = 3;
    private static final int STAR = 4;
    private static final int CARRIAGE_RETURN = 5;
    private static final int C_BRACKET_STAR = 6;
    private static final int O_BRACKET_STAR = 7;
    private static final int MINUS = 8;
    private static final int MINUS_MINUS = 9;
    private final BufferedDocumentScanner fScanner = new BufferedDocumentScanner(1000);
    private int fTokenOffset;
    private int fTokenLength;
    private int fPrefixLength;
    private int fLast;
    private int fState;
    private boolean fEmulate = false;
    private int fTLAOffset;
    private int fTLALength;
    private int fCommentDepth;
    private IDocument fDocument;
    private int fpcalMode;
    private boolean outputEndPcalComment = false;

    public IToken nextToken() {
        if (this.fEmulate) {
            if (this.fTLAOffset != -1 && this.fTokenOffset + this.fTokenLength != this.fTLAOffset + this.fTLALength) {
                this.fTokenOffset += this.fTokenLength;
                return this.fTokens[0];
            }
            this.fTLAOffset = -1;
            this.fTLALength = 0;
        }
        this.fTokenOffset += this.fTokenLength;
        this.fTokenLength = this.fPrefixLength;
        if (this.outputEndPcalComment) {
            this.outputEndPcalComment = false;
            this.fPrefixLength = 0;
            return this.fTokens[6];
        }
        block46: while (true) {
            int ch = this.fScanner.read();
            switch (ch) {
                case -1: {
                    if (this.fTokenLength > 0) {
                        this.fLast = 0;
                        return this.preFix(this.fState, 0, 0, 0);
                    }
                    this.fLast = 0;
                    this.fPrefixLength = 0;
                    return Token.EOF;
                }
                case 13: {
                    if (!this.fEmulate && this.fLast != 5) {
                        this.fLast = 5;
                        ++this.fTokenLength;
                        continue block46;
                    }
                    switch (this.fState) {
                        case 1: 
                        case 4: {
                            if (this.fTokenLength > 0) {
                                IToken token = this.fTokens[this.fState];
                                if (this.fEmulate) {
                                    ++this.fTokenLength;
                                    this.fLast = 0;
                                    this.fPrefixLength = 0;
                                } else {
                                    this.fLast = 5;
                                    this.fPrefixLength = 1;
                                }
                                this.fState = 0;
                                return token;
                            }
                            this.consume();
                            continue block46;
                        }
                    }
                    this.consume();
                    continue block46;
                }
                case 10: {
                    switch (this.fState) {
                        case 1: 
                        case 4: {
                            return this.postFix(this.fState);
                        }
                    }
                    this.consume();
                    continue block46;
                }
            }
            if (!this.fEmulate && this.fLast == 5) {
                switch (this.fState) {
                    case 1: 
                    case 4: {
                        int newState;
                        int last;
                        switch (ch) {
                            case 40: {
                                last = 2;
                                newState = 0;
                                break;
                            }
                            case 41: {
                                last = 3;
                                newState = 0;
                                break;
                            }
                            case 42: {
                                last = 4;
                                newState = 0;
                                break;
                            }
                            case 34: {
                                last = 0;
                                newState = 4;
                                break;
                            }
                            case 13: {
                                last = 5;
                                newState = 0;
                                break;
                            }
                            case 92: {
                                last = 1;
                                newState = 0;
                                break;
                            }
                            default: {
                                last = 0;
                                newState = 0;
                            }
                        }
                        this.fLast = 0;
                        return this.preFix(this.fState, newState, last, 1);
                    }
                }
            }
            block23 : switch (this.fState) {
                case 0: {
                    switch (ch) {
                        case 92: {
                            this.fLast = 1;
                            ++this.fTokenLength;
                            break;
                        }
                        case 40: {
                            this.fLast = 2;
                            ++this.fTokenLength;
                            break;
                        }
                        case 42: {
                            if (this.fLast == 1) {
                                if (this.fTokenLength - this.getLastLength() > 0) {
                                    return this.preFix(0, 1, 0, 2);
                                }
                                this.preFix(0, 1, 0, 2);
                                this.fTokenOffset += this.fTokenLength;
                                this.fTokenLength = this.fPrefixLength;
                                break;
                            }
                            if (this.fLast == 2) {
                                ++this.fCommentDepth;
                                if (this.fTokenLength - this.getLastLength() > 0) {
                                    return this.preFix(0, 2, 7, 2);
                                }
                                this.preFix(0, 2, 7, 2);
                                this.fTokenOffset += this.fTokenLength;
                                this.fTokenLength = this.fPrefixLength;
                                break;
                            }
                            ++this.fTokenLength;
                            this.fLast = 4;
                            break;
                        }
                        case 34: {
                            this.fLast = 0;
                            if (this.fTokenLength > 0) {
                                return this.preFix(0, 4, 0, 1);
                            }
                            this.preFix(0, 4, 0, 1);
                            this.fTokenOffset += this.fTokenLength;
                            this.fTokenLength = this.fPrefixLength;
                            break;
                        }
                        case 41: {
                            if (this.fpcalMode == 1 && this.fLast == 4) {
                                this.fpcalMode = 2;
                                if (this.fTokenLength - this.getLastLength() > 0) {
                                    this.outputEndPcalComment = true;
                                    return this.preFix(0, 0, 0, 2);
                                }
                                return this.postFix(6);
                            }
                        }
                        default: {
                            this.consume();
                            break;
                        }
                    }
                    break;
                }
                case 1: {
                    this.consume();
                    break;
                }
                case 2: {
                    switch (ch) {
                        case 42: {
                            if (this.fLast == 2) {
                                ++this.fCommentDepth;
                                this.consume();
                                break;
                            }
                            ++this.fTokenLength;
                            this.fLast = 4;
                            break;
                        }
                        case 41: {
                            if (this.fLast == 4) {
                                --this.fCommentDepth;
                                if (this.fCommentDepth == 0) {
                                    return this.postFix(2);
                                }
                                this.consume();
                                break;
                            }
                            this.consume();
                            break;
                        }
                        case 40: {
                            this.fLast = 2;
                            ++this.fTokenLength;
                            break;
                        }
                        case 45: {
                            if (this.fCommentDepth == 1 && this.fpcalMode == 0 && this.fLast == 8) {
                                int nxtPos = this.fTokenLength + this.fTokenOffset + 1;
                                try {
                                    if (this.fDocument.getLength() >= nxtPos + 4 && this.fDocument.get(nxtPos, 4).equals("fair") || this.fDocument.getLength() >= nxtPos + 9 && this.fDocument.get(nxtPos, 9).equals("algorithm")) {
                                        this.fCommentDepth = 0;
                                        this.fpcalMode = 1;
                                        return this.preFix(5, 0, 9, 2);
                                    }
                                }
                                catch (BadLocationException badLocationException) {
                                    // empty catch block
                                }
                            }
                            this.fLast = 8;
                            ++this.fTokenLength;
                            break;
                        }
                        default: {
                            this.consume();
                            break;
                        }
                    }
                    break;
                }
                case 4: {
                    switch (ch) {
                        case 34: {
                            if (this.fLast != 1) {
                                return this.postFix(4);
                            }
                            this.consume();
                            break block23;
                        }
                        default: {
                            this.consume();
                        }
                    }
                }
            }
        }
    }

    public void setRange(IDocument document, int offset, int length) {
        this.fScanner.setRange(document, offset, length);
        this.fTokenOffset = offset;
        this.fTokenLength = 0;
        this.fPrefixLength = 0;
        this.fCommentDepth = 0;
        this.fLast = 0;
        this.fState = 0;
        this.fDocument = document;
        this.fpcalMode = 0;
        this.outputEndPcalComment = false;
        if (this.fEmulate) {
            this.fTLAOffset = -1;
            this.fTLALength = 0;
        }
    }

    public void setPartialRange(IDocument document, int offset, int length, String contentType, int partitionOffset) {
    }

    public void setPartialRange(IDocument document, int offset, int length, String contentType, int partitionOffset, int pcalMode) {
        this.fScanner.setRange(document, offset, length);
        this.fTokenOffset = partitionOffset;
        this.fTokenLength = 0;
        this.fPrefixLength = offset - partitionOffset;
        this.fLast = 0;
        this.fDocument = document;
        this.fpcalMode = pcalMode;
        if (pcalMode != 1 && contentType != null && contentType.equals(TLA_PCAL)) {
            System.out.println("TLAPartitionScanner.setPartialRange called with contentType/pcalMode mismatch.");
        }
        this.outputEndPcalComment = false;
        this.fState = offset == partitionOffset ? 0 : TLAPartitionScanner.getState(contentType);
        this.fCommentDepth = this.fState == 2 ? this.getCommentDepth(document, partitionOffset, this.fPrefixLength) : 0;
        if (this.fEmulate) {
            this.fTLAOffset = -1;
            this.fTLALength = 0;
        }
    }

    private int getCommentDepth(IDocument document, int offset, int length) {
        try {
            String partitionText = document.get(offset, length);
            return partitionText.split("\\(\\*").length - partitionText.split("\\*\\)").length;
        }
        catch (BadLocationException e) {
            e.printStackTrace();
            return 1;
        }
    }

    public int getTokenLength() {
        return this.fTokenLength;
    }

    public int getTokenOffset() {
        return this.fTokenOffset;
    }

    private static int getState(String contentType) {
        if (contentType == null) {
            return 0;
        }
        if (contentType.equals(TLA_MULTI_LINE_COMMENT)) {
            return 2;
        }
        if (contentType.equals(TLA_SINGLE_LINE_COMMENT)) {
            return 1;
        }
        if (contentType.equals(TLA_PCAL)) {
            return 0;
        }
        if (contentType.equals(TLA_STRING)) {
            return 4;
        }
        return 0;
    }

    private final void consume() {
        ++this.fTokenLength;
        this.fLast = 0;
    }

    private final IToken postFix(int state) {
        ++this.fTokenLength;
        this.fLast = 0;
        this.fState = 0;
        this.fPrefixLength = 0;
        return this.fTokens[state];
    }

    private final IToken preFix(int state, int newState, int last, int prefixLength) {
        if (this.fEmulate && state == 0 && this.fTokenLength - this.getLastLength() > 0) {
            this.fTokenLength -= this.getLastLength();
            this.fLast = last;
            this.fTLAOffset = this.fTokenOffset;
            this.fTLALength = this.fTokenLength;
            this.fPrefixLength = prefixLength;
            this.fTokenLength = 1;
            this.fState = newState;
            return this.fTokens[state];
        }
        this.fTokenLength -= this.getLastLength();
        this.fLast = last;
        this.fPrefixLength = prefixLength;
        IToken token = this.fTokens[state];
        this.fState = newState;
        return token;
    }

    private int getLastLength() {
        switch (this.fLast) {
            default: {
                return -1;
            }
            case 0: {
                return 0;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 8: {
                return 1;
            }
            case 6: 
            case 7: 
            case 9: 
        }
        return 2;
    }
}

