/*
 * Decompiled with CFR 0.152.
 */
package util;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.util.Enumeration;
import util.SetEntry;
import util.SetEnumerator;

public class Set
implements Serializable {
    private transient SetEntry[] set;
    private transient int count;
    private int threshold;
    private float loadFactor;
    private static final long serialVersionUID = 1421746759512286392L;

    public Set(int initialCapacity, float loadFactor) {
        if (initialCapacity <= 0 || (double)loadFactor <= 0.0) {
            throw new IllegalArgumentException();
        }
        this.loadFactor = loadFactor;
        this.set = new SetEntry[initialCapacity];
        this.threshold = (int)((float)initialCapacity * loadFactor);
    }

    public Set(int initialCapacity) {
        this(initialCapacity, 0.75f);
    }

    public Set() {
        this(101, 0.75f);
    }

    public Set(Set s) {
        this.loadFactor = s.loadFactor;
        this.count = s.count;
        this.threshold = s.threshold;
        this.set = new SetEntry[s.set.length];
        int i = 0;
        while (i < this.set.length) {
            SetEntry toCopy = s.set[i];
            if (toCopy != null) {
                this.set[i] = new SetEntry(toCopy);
            }
            ++i;
        }
    }

    public int size() {
        return this.count;
    }

    public boolean isEmpty() {
        return this.count == 0;
    }

    public synchronized Enumeration elements() {
        return new SetEnumerator(this.set);
    }

    public synchronized boolean contains(Object key) {
        SetEntry[] tab = this.set;
        int hash = key.hashCode();
        int index = (hash & Integer.MAX_VALUE) % tab.length;
        SetEntry e = tab[index];
        while (e != null) {
            if (e.hash == hash && e.key.equals(key)) {
                return true;
            }
            e = e.next;
        }
        return false;
    }

    protected void rehash() {
        int oldCapacity = this.set.length;
        SetEntry[] oldSet = this.set;
        int newCapacity = oldCapacity * 2 + 1;
        SetEntry[] newSet = new SetEntry[newCapacity];
        this.threshold = (int)((float)newCapacity * this.loadFactor);
        this.set = newSet;
        int i = oldCapacity;
        while (i-- > 0) {
            SetEntry old = oldSet[i];
            while (old != null) {
                SetEntry e = old;
                old = old.next;
                int index = (e.hash & Integer.MAX_VALUE) % newCapacity;
                e.next = newSet[index];
                newSet[index] = e;
            }
        }
    }

    public synchronized Object put(Object key) {
        SetEntry[] tab = this.set;
        int hash = key.hashCode();
        int index = (hash & Integer.MAX_VALUE) % tab.length;
        SetEntry e = tab[index];
        while (e != null) {
            if (e.hash == hash && e.key.equals(key)) {
                Object old = e.key;
                e.key = key;
                return old;
            }
            e = e.next;
        }
        if (this.count >= this.threshold) {
            this.rehash();
            return this.put(key);
        }
        e = new SetEntry();
        e.hash = hash;
        e.key = key;
        e.next = tab[index];
        tab[index] = e;
        ++this.count;
        return null;
    }

    public synchronized Object remove(Object key) {
        SetEntry[] tab = this.set;
        int hash = key.hashCode();
        int index = (hash & Integer.MAX_VALUE) % tab.length;
        SetEntry e = tab[index];
        SetEntry prev = null;
        while (e != null) {
            if (e.hash == hash && e.key.equals(key)) {
                if (prev != null) {
                    prev.next = e.next;
                } else {
                    tab[index] = e.next;
                }
                --this.count;
                return e.key;
            }
            prev = e;
            e = e.next;
        }
        return null;
    }

    public synchronized void clear() {
        SetEntry[] tab = this.set;
        int index = tab.length;
        while (--index >= 0) {
            tab[index] = null;
        }
        this.count = 0;
    }

    public synchronized String toString() {
        int max = this.size() - 1;
        StringBuffer buf = new StringBuffer();
        Enumeration e = this.elements();
        buf.append("{");
        int i = 0;
        while (i <= max) {
            String s1 = e.nextElement().toString();
            buf.append(s1);
            if (i < max) {
                buf.append(", ");
            }
            ++i;
        }
        buf.append("}");
        return buf.toString();
    }

    private synchronized void writeObject(ObjectOutputStream s) throws IOException {
        s.defaultWriteObject();
        s.writeInt(this.set.length);
        s.writeInt(this.count);
        int index = this.set.length - 1;
        while (index >= 0) {
            SetEntry entry = this.set[index];
            while (entry != null) {
                s.writeObject(entry.key);
                entry = entry.next;
            }
            --index;
        }
    }

    private synchronized void readObject(ObjectInputStream s) throws IOException, ClassNotFoundException {
        s.defaultReadObject();
        int origlength = s.readInt();
        int elements = s.readInt();
        int length = (int)((float)elements * this.loadFactor) + elements / 20 + 3;
        if (length > elements && (length & 1) == 0) {
            --length;
        }
        if (origlength > 0 && length > origlength) {
            length = origlength;
        }
        this.set = new SetEntry[length];
        this.count = 0;
        while (elements > 0) {
            Object key = s.readObject();
            this.put(key);
            --elements;
        }
    }

    public synchronized boolean in(Object x) {
        return this.contains(x);
    }

    public void intersection(Set x) {
        Enumeration elements = this.elements();
        while (elements.hasMoreElements()) {
            Object a = elements.nextElement();
            if (x.in(a)) continue;
            this.remove(a);
        }
    }

    public static Set intersection(Set x, Set y) {
        Set result;
        if (x.size() < y.size()) {
            result = new Set(x);
            result.intersection(y);
        } else {
            result = new Set(x);
            result.intersection(y);
        }
        return result;
    }

    public void union(Set x) {
        Enumeration elements = x.elements();
        while (elements.hasMoreElements()) {
            this.put(elements.nextElement());
        }
    }

    public static Set union(Set x, Set y) {
        Set result;
        if (x.size() > y.size()) {
            result = new Set(x);
            result.union(y);
        } else {
            result = new Set(x);
            result.union(y);
        }
        return result;
    }

    public void minus(Set x) {
        if (this.size() > x.size()) {
            Enumeration elements = x.elements();
            while (elements.hasMoreElements()) {
                this.remove(elements.nextElement());
            }
        } else {
            Enumeration elements = this.elements();
            while (elements.hasMoreElements()) {
                Object a = elements.nextElement();
                if (!x.in(a)) continue;
                this.remove(a);
            }
        }
    }

    public static Set minus(Set x, Set y) {
        Set result = new Set(x);
        result.minus(y);
        return result;
    }

    public static Set complement(Set x, Set u) {
        return Set.minus(u, x);
    }

    public boolean subset(Set x) {
        Enumeration elements = this.elements();
        while (elements.hasMoreElements()) {
            if (x.in(elements.nextElement())) continue;
            return false;
        }
        return true;
    }

    public static boolean subset(Set x, Set y) {
        return x.subset(y);
    }

    public boolean equal(Set x) {
        return this.subset(x) && x.subset(this);
    }

    public static boolean equal(Set x, Set y) {
        return x.equal(y);
    }
}

