/*
 * Decompiled with CFR 0.152.
 */
package util;

import java.io.IOException;
import java.net.URL;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import util.ResourceLocator;

class FilesystemResourceLocator
implements ResourceLocator {
    private final Path prefix;

    public FilesystemResourceLocator(Path prefix) {
        this.prefix = prefix;
    }

    @Override
    public URL locate(String filename) throws IOException {
        Path result = this.prefix.resolve(filename);
        return Files.exists(result, new LinkOption[0]) ? result.toUri().toURL() : null;
    }

    @Override
    public String describeSearchLocations() {
        return this.prefix.toString();
    }
}

