/*
 * Decompiled with CFR 0.152.
 */
package tlc2.util;

import java.io.Serializable;
import util.Assert;

public class ReadersWriterLock
implements Serializable {
    private int numReaders = 0;
    private boolean hasWriter = false;
    private int waitingWriters = 0;

    public void BeginRead() {
        while (this.hasWriter || this.waitingWriters > 0) {
            try {
                this.wait();
            }
            catch (InterruptedException e) {
                Assert.fail(2138);
            }
        }
        ++this.numReaders;
    }

    public void EndRead() {
        --this.numReaders;
        if (this.numReaders == 0) {
            this.notifyAll();
        }
    }

    public void BeginWrite() {
        while (this.numReaders > 0 || this.hasWriter) {
            ++this.waitingWriters;
            try {
                this.wait();
            }
            catch (InterruptedException e) {
                Assert.fail(2138);
            }
            --this.waitingWriters;
        }
        this.hasWriter = true;
    }

    public void EndWrite() {
        this.hasWriter = false;
        this.notifyAll();
    }
}

