/*
 * Decompiled with CFR 0.152.
 */
package tlc2.util;

import tlc2.util.IntStack;
import tlc2.util.MemBasedSet;

public final class MemIntStack
extends MemBasedSet
implements IntStack {
    private static final int MIN_CAPACITY = 1024;

    public MemIntStack(String diskdir, String name) {
        super(1024);
    }

    @Override
    public final synchronized void pushInt(int x) {
        if (this.size == this.elems.length) {
            int[] newElems = this.ensureCapacity(1024);
            System.arraycopy(this.elems, 0, newElems, 0, this.size);
            this.elems = newElems;
        }
        this.elems[this.size] = x;
        ++this.size;
    }

    @Override
    public final synchronized void pushLong(long x) {
        this.pushInt((int)(x & 0xFFFFFFFFL));
        this.pushInt((int)(x >>> 32));
    }

    @Override
    public final synchronized int popInt() {
        return this.elems[--this.size];
    }

    @Override
    public final synchronized int peakInt() {
        return this.peakInt(this.size - 1);
    }

    public final synchronized int peakInt(int pos) {
        return this.elems[pos];
    }

    @Override
    public final synchronized long popLong() {
        long high = this.popInt();
        long low = this.popInt();
        return high << 32 | low & 0xFFFFFFFFL;
    }

    @Override
    public final synchronized long peakLong() {
        long high = this.peakInt();
        long low = this.peakInt();
        return high << 32 | low & 0xFFFFFFFFL;
    }

    public final synchronized long peakLong(int pos) {
        long high = this.peakInt(pos + 1);
        long low = this.peakInt(pos);
        return high << 32 | low & 0xFFFFFFFFL;
    }

    @Override
    public final void reset() {
        this.size = 0;
    }
}

