/*
 * Decompiled with CFR 0.152.
 */
package tlc2.model;

import java.util.List;
import tlc2.model.Formula;
import tlc2.output.SpecWriterUtilities;

public class TraceExpressionInformationHolder {
    private String expression;
    private String identifier;
    private String variableName;
    private int level;

    public static TraceExpressionInformationHolder[] createHolders(List<Formula> expressions, String attributeName) {
        TraceExpressionInformationHolder[] holders = new TraceExpressionInformationHolder[expressions.size()];
        int position = 0;
        for (Formula formula : expressions) {
            String expression = formula.getFormula();
            if (expression != null && expression.length() > 0) {
                String varname;
                String identifier = SpecWriterUtilities.getValidIdentifier("trace_def");
                if (formula.isNamed()) {
                    varname = formula.getLeftHandSide();
                    String rightHandSide = formula.getRightHandSide();
                    holders[position] = new TraceExpressionInformationHolder(rightHandSide, identifier, varname);
                } else {
                    varname = SpecWriterUtilities.getValidIdentifier("__trace_var");
                    holders[position] = new TraceExpressionInformationHolder(expression, identifier, varname);
                }
            }
            ++position;
        }
        return holders;
    }

    public void setExpression(String expression) {
        this.expression = expression;
    }

    public void setIdentifier(String identifier) {
        this.identifier = identifier;
    }

    public void setVariableName(String variableName) {
        this.variableName = variableName;
    }

    public void setLevel(int level) {
        this.level = level;
    }

    public TraceExpressionInformationHolder(String expression, String identifier, String variableName) {
        this.expression = expression;
        this.identifier = identifier;
        this.variableName = variableName;
    }

    public String getExpression() {
        return this.expression;
    }

    public String getIdentifier() {
        return this.identifier;
    }

    public String getVariableName() {
        return this.variableName;
    }

    public int getLevel() {
        return this.level;
    }
}

