/*
 * Decompiled with CFR 0.152.
 */
package tlc2.model;

import java.util.ArrayList;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class Formula {
    private static final Pattern PATTERN = Pattern.compile("^\\s*(\\w+)\\s*==(.*)$", 32);
    private String formula;

    public static List<Formula> deserializeFormulaList(List<String> serializedList) {
        ArrayList<Formula> result = new ArrayList<Formula>(serializedList.size());
        for (String entry : serializedList) {
            if (!"1".equals(entry.substring(0, 1))) continue;
            result.add(new Formula(entry.substring(1)));
        }
        return result;
    }

    public Formula(String formulaString) {
        this.formula = formulaString;
    }

    public String getFormula() {
        return this.formula;
    }

    public String toString() {
        return this.formula;
    }

    public void setFormula(String formulaString) {
        this.formula = formulaString;
    }

    public boolean isNamed() {
        return !this.getLeftHandSide().equals(this.getFormula());
    }

    public String getLeftHandSide() {
        Matcher matcher = PATTERN.matcher(this.formula);
        if (matcher.find()) {
            return matcher.group(1).trim();
        }
        return this.getFormula();
    }

    public String getRightHandSide() {
        Matcher matcher = PATTERN.matcher(this.formula);
        if (matcher.find()) {
            return matcher.group(2).trim();
        }
        return this.getFormula();
    }
}

