/*
 * Decompiled with CFR 0.152.
 */
package tlc2.tool.distributed;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.nio.file.Path;
import java.rmi.RemoteException;
import java.util.HashMap;
import java.util.Map;
import tlc2.tool.distributed.TLCServerRMI;
import util.FilenameToStream;

public class RMIFilenameToStreamResolver
implements FilenameToStream {
    private TLCServerRMI server;
    private final Map<String, File> fileCache = new HashMap<String, File>();
    private final Path tmpDir = this.newExclusiveTemporaryDirectory();

    public RMIFilenameToStreamResolver() {
    }

    public RMIFilenameToStreamResolver(String[] libraryPaths) {
    }

    public void setTLCServer(TLCServerRMI aServer) {
        this.server = aServer;
    }

    @Override
    public File resolve(String filename, boolean isModule) {
        String name = new FilenameToStream.TLAFile(filename, this).getName();
        File file = this.fileCache.get(name);
        if (file == null || !file.exists()) {
            byte[] bs = new byte[]{};
            try {
                bs = this.server.getFile(name);
            }
            catch (RemoteException e) {
                e.printStackTrace();
            }
            file = this.writeToNewTempFile(name, bs);
            this.fileCache.put(name, file);
        }
        return file;
    }

    @Override
    public boolean isStandardModule(String moduleName) {
        return false;
    }

    private Path newExclusiveTemporaryDirectory() {
        Path result = FilenameToStream.getTempDirectory();
        result.toFile().deleteOnExit();
        return result;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private File writeToNewTempFile(String name, byte[] bs) {
        FilenameToStream.TLAFile f = new FilenameToStream.TLAFile(this.tmpDir.resolve(name).toString(), this);
        f.deleteOnExit();
        FileOutputStream outputStream = null;
        try {
            try {
                outputStream = new FileOutputStream(f);
                outputStream.write(bs);
                return f;
            }
            catch (FileNotFoundException e) {
                e.printStackTrace();
                if (outputStream == null) return f;
                try {
                    outputStream.close();
                    return f;
                }
                catch (IOException e2) {
                    e2.printStackTrace();
                }
                return f;
            }
            catch (IOException e) {
                e.printStackTrace();
                if (outputStream == null) return f;
                try {
                    outputStream.close();
                    return f;
                }
                catch (IOException e3) {
                    e3.printStackTrace();
                }
                return f;
            }
        }
        finally {
            if (outputStream != null) {
                try {
                    outputStream.close();
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
        }
    }

    @Override
    public String getFullPath() {
        StringBuffer buf = new StringBuffer();
        String[] strings = this.fileCache.keySet().toArray(new String[this.fileCache.size()]);
        int i = 0;
        while (i < strings.length) {
            String string = strings[i];
            buf.append(string);
            if (i < string.length() - 1) {
                buf.append(", ");
            }
            ++i;
        }
        return buf.toString();
    }
}

