/*
 * Decompiled with CFR 0.152.
 */
package tlc2.tool.coverage;

import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.Map;
import tla2sany.semantic.SemanticNode;
import tla2sany.st.Location;
import tlc2.TLCGlobals;
import tlc2.tool.coverage.CostModel;
import tlc2.util.statistics.CounterStatistic;

public abstract class CostModelNode
implements CostModel {
    protected final Map<SemanticNode, CostModelNode> children = new LinkedHashMap<SemanticNode, CostModelNode>();
    protected final CounterStatistic stats = CounterStatistic.getInstance(() -> TLCGlobals.isCoverageEnabled() || TLCGlobals.Coverage.isEnabled());
    protected final CounterStatistic secondary = CounterStatistic.getInstance(() -> TLCGlobals.isCoverageEnabled() || TLCGlobals.Coverage.isEnabled());

    @Override
    public long getPrimary() {
        return this.getEvalCount();
    }

    protected long getEvalCount() {
        return this.stats.getCount();
    }

    @Override
    public long getSecondary() {
        return this.secondary.getCount();
    }

    @Override
    public boolean hasValues() {
        return true;
    }

    protected abstract Location getLocation();

    @Override
    public final CostModel getChild() {
        Iterator<CostModelNode> iterator = this.children.values().iterator();
        if (iterator.hasNext()) {
            CostModelNode costModelNode = iterator.next();
            return costModelNode;
        }
        return this;
    }

    void addChild(CostModelNode child) {
        boolean newlyInserted;
        boolean bl = newlyInserted = this.children.put(child.getNode(), child) == null;
        assert (newlyInserted);
    }

    abstract SemanticNode getNode();

    @Override
    public abstract CostModelNode getRoot();

    boolean isRoot() {
        return false;
    }

    int getLevel() {
        return 0;
    }

    @Override
    public final CostModel getAndIncrement(SemanticNode eon) {
        return this.get(eon).incInvocations();
    }

    @Override
    public final CostModel incInvocations(long size) {
        this.stats.add(size);
        return this;
    }

    @Override
    public final CostModel incInvocations() {
        this.stats.increment();
        return this;
    }

    @Override
    public final CostModel incSecondary() {
        this.secondary.increment();
        return this;
    }

    @Override
    public final CostModel incSecondary(long value) {
        this.secondary.add(value);
        return this;
    }
}

