/*
 * Decompiled with CFR 0.152.
 */
package tlc2.tool.coverage;

import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import tla2sany.semantic.OpApplNode;
import tla2sany.semantic.SemanticNode;
import tla2sany.st.Location;
import tlc2.TLCGlobals;
import tlc2.output.MP;
import tlc2.tool.coverage.ActionWrapper;
import tlc2.tool.coverage.CostModel;
import tlc2.tool.coverage.CostModelNode;

public class OpApplNodeWrapper
extends CostModelNode
implements Comparable<OpApplNodeWrapper>,
CostModel {
    private final Set<Pair> childCounts = new HashSet<Pair>();
    private final CostModelNode root;
    private final OpApplNode node;
    private long snapshotEvalCount = 0L;
    private long snapshotSecondCount = 0L;
    private boolean primed = false;
    private int level;
    private CostModelNode recursive;
    protected final Map<SemanticNode, CostModelNode> lets = new LinkedHashMap<SemanticNode, CostModelNode>();
    private final Set<Integer> seen = new HashSet<Integer>();

    OpApplNodeWrapper(OpApplNode node, CostModelNode root) {
        this.node = node;
        this.root = root;
        this.level = 0;
    }

    OpApplNodeWrapper() {
        this(null, null);
    }

    OpApplNodeWrapper(OpApplNode node, long samples) {
        this(node, null);
        this.incInvocations(samples);
    }

    @Override
    public int compareTo(OpApplNodeWrapper arg0) {
        return this.getLocation().compareTo(arg0.getLocation());
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.node.getLocation() == null ? 0 : this.node.getLocation().hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        OpApplNodeWrapper other = (OpApplNodeWrapper)obj;
        return !(this.node.getLocation() == null ? other.node.getLocation() != null : !this.node.getLocation().equals(other.node.getLocation()));
    }

    public String toString() {
        if (this.node == null) {
            return "root";
        }
        return this.node.toString();
    }

    @Override
    protected Location getLocation() {
        return this.node != null ? this.node.getLocation() : Location.nullLoc;
    }

    @Override
    public OpApplNode getNode() {
        return this.node;
    }

    @Override
    public boolean isRoot() {
        return this.node == null;
    }

    public OpApplNodeWrapper addLets(OpApplNodeWrapper lets) {
        this.lets.put(lets.getNode(), lets);
        return this;
    }

    public OpApplNodeWrapper setRecursive(CostModelNode recursive) {
        assert (this.recursive == null);
        this.recursive = recursive;
        return this;
    }

    @Override
    public CostModelNode getRoot() {
        assert (this.root instanceof ActionWrapper);
        return this.root;
    }

    @Override
    public final CostModelNode get(SemanticNode eon) {
        if (eon == this.node || !(eon instanceof OpApplNode)) {
            return this;
        }
        CostModelNode child = (CostModelNode)this.children.get(eon);
        if (child != null) {
            return child;
        }
        if (this.recursive != null && (child = this.recursive.children.get(eon)) != null) {
            return child;
        }
        if (this.lets != null && (child = this.lets.get(eon)) != null) {
            return child;
        }
        if (TLCGlobals.warn && this.seen.add(eon.myUID)) {
            MP.printMessage(2776, eon.toString(), this.toString());
        }
        return this;
    }

    @Override
    public int getLevel() {
        return this.level;
    }

    public OpApplNodeWrapper setLevel(int level) {
        this.level = level;
        return this;
    }

    public OpApplNodeWrapper setPrimed() {
        assert (!this.isPrimed());
        this.primed = true;
        return this;
    }

    protected boolean isPrimed() {
        return this.primed;
    }

    protected long getEvalCount(Calculate fresh) {
        if (fresh == Calculate.FRESH) {
            return super.getEvalCount();
        }
        return this.snapshotEvalCount;
    }

    protected long getSecondCount(Calculate fresh) {
        if (fresh == Calculate.FRESH) {
            return super.getSecondary();
        }
        return this.snapshotSecondCount;
    }

    @Override
    public CostModel report() {
        this.print(0, Calculate.FRESH);
        return this;
    }

    protected void print(int level, Calculate fresh) {
        HashSet<Pair> collectedEvalCounts = new HashSet<Pair>();
        this.collectChildren(collectedEvalCounts, fresh);
        if (collectedEvalCounts.isEmpty()) {
            if (this.getEvalCount(fresh) == 0L && !this.isPrimed()) {
                return;
            }
            this.printSelf(level++);
            return;
        }
        Pair node = new Pair(this.getEvalCount(fresh), this.getSecondCount(fresh));
        if (collectedEvalCounts.size() == 1) {
            Pair consistentChildren = this.getCount(collectedEvalCounts);
            if (consistentChildren.primary < node.primary || consistentChildren.secondary < consistentChildren.secondary) {
                this.printSelf(level++);
                this.printChildren(level);
                return;
            }
            if (!this.isPrimed() && node.isZero() && consistentChildren.isNonZero()) {
                if (consistentChildren.secondary == 0L) {
                    this.printSelf(level++, consistentChildren.primary);
                } else {
                    this.printSelf(level++, consistentChildren.primary, consistentChildren.secondary);
                }
                return;
            }
            if (node.isZero() && consistentChildren.isZero()) {
                if (this.isPrimed()) {
                    this.printSelf(level++);
                }
                this.printChildren(level);
                return;
            }
            if (node.equals(consistentChildren)) {
                this.printSelf(level++);
                return;
            }
        }
        if (node.isNonZero() || this.isPrimed()) {
            this.printSelf(level++);
        }
        this.printChildren(level);
    }

    private Pair getCount(Set<Pair> collectWeights) {
        assert (collectWeights.size() == 1);
        Iterator<Pair> iterator = collectWeights.iterator();
        if (iterator.hasNext()) {
            Pair l = iterator.next();
            return l;
        }
        return null;
    }

    protected void printChildren(int level) {
        for (CostModelNode cmn : this.children.values()) {
            ((OpApplNodeWrapper)cmn).print(level, Calculate.CACHED);
        }
    }

    protected void printSelf(int level, long count) {
        MP.printMessage(2221, OpApplNodeWrapper.indentBegin(level, '|', this.getLocation().toString()), String.valueOf(count));
    }

    protected void printSelf(int level, long count, long cost) {
        MP.printMessage(2775, OpApplNodeWrapper.indentBegin(level, '|', this.getLocation().toString()), String.valueOf(count), String.valueOf(cost));
    }

    protected void printSelf(int level) {
        if (this.getSecondary() > 0L) {
            this.printSelf(level, this.getEvalCount(), this.getSecondary());
        } else {
            this.printSelf(level, this.getEvalCount());
        }
    }

    protected static String indentBegin(int n, char c, String str) {
        assert (n >= 0);
        String whitespaces = new String(new char[n]).replace('\u0000', c);
        return whitespaces + str;
    }

    protected void collectChildren(Set<Pair> result, Calculate c) {
        for (CostModelNode cmn : this.children.values()) {
            ((OpApplNodeWrapper)cmn).collectAndFreezeEvalCounts(result, c);
        }
    }

    protected void collectAndFreezeEvalCounts(Set<Pair> result, Calculate c) {
        if (c == Calculate.FRESH) {
            this.snapshotEvalCount = this.getEvalCount(c);
            this.snapshotSecondCount = this.getSecondCount(c);
            this.childCounts.clear();
            if (this.snapshotEvalCount > 0L || this.snapshotSecondCount > 0L || this.isPrimed()) {
                this.childCounts.add(new Pair(this.snapshotEvalCount, this.snapshotSecondCount));
            }
            this.collectChildren(this.childCounts, c);
        }
        result.addAll(this.childCounts);
    }

    protected static enum Calculate {
        FRESH,
        CACHED;

    }

    static class Pair {
        public final long primary;
        public final long secondary;

        public Pair(long primary, long secondary) {
            this.primary = primary;
            this.secondary = secondary;
        }

        public boolean isZero() {
            return this.primary == 0L && this.secondary == 0L;
        }

        public boolean isNonZero() {
            return this.primary > 0L || this.secondary > 0L;
        }

        public int hashCode() {
            return Objects.hash(this.primary, this.secondary);
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            Pair other = (Pair)obj;
            return this.primary == other.primary && this.secondary == other.secondary;
        }

        public String toString() {
            return "<<" + this.primary + ", " + this.secondary + ">>";
        }
    }
}

