/*
 * Decompiled with CFR 0.152.
 */
package tla2tex;

import java.util.Vector;
import tla2tex.BuiltInSymbols;
import tla2tex.CToken;
import tla2tex.Debug;
import tla2tex.FormatComments;
import tla2tex.Misc;
import tla2tex.TokenizeSpec;

public class TokenizeComment {
    private static Vector vspec = new Vector(50, 50);
    private static Vector linev = new Vector(40, 40);
    private static Vector argVec;
    private static char nextChar;
    private static String token;
    private static boolean inDQuote;
    private static boolean inSQuote;
    private static int col;
    private static int ncol;
    private static int line;
    private static String curString;
    private static final int START = 1;
    private static final int ID = 2;
    private static final int NUM_OR_ID = 3;
    private static final int BS = 4;
    private static final int NUM_OR_BI = 5;
    private static final int NUM = 6;
    private static final int BSBUILT_IN = 7;
    private static final int BUILT_IN = 8;
    private static final int REPEAT_CHAR = 9;
    private static final int STRING = 10;
    private static final int ESC_STRING = 11;
    private static final int LEFT_DQUOTE = 12;
    private static final int RIGHT_DQUOTE = 13;
    private static final int LEFT_SQUOTE = 14;
    private static final int RIGHT_SQUOTE = 15;
    private static final int TEX = 16;
    private static final int TEX_CARET = 17;
    private static final int THROW_AWAY = 18;
    private static final int THROW_AWAY_TILDE = 19;
    private static final int VERB = 20;
    private static final int VERB_DOT = 21;
    private static final int DONE = 22;
    private static int state;

    static {
        token = "";
        inDQuote = false;
        inSQuote = false;
        ncol = 0;
        line = 0;
        curString = "";
        state = 1;
    }

    private static boolean isAllUnderscores() {
        int i = 0;
        boolean result = true;
        while (result && i < token.length()) {
            if (token.charAt(i) != '_') {
                result = false;
            }
            ++i;
        }
        return result;
    }

    private static void skipNextChar() {
        if (++ncol < curString.length()) {
            nextChar = curString.charAt(ncol);
        } else if (ncol == curString.length()) {
            nextChar = (char)10;
        } else {
            if (++line < argVec.size()) {
                curString = (String)argVec.elementAt(line);
                if (curString == null) {
                    curString = "";
                }
            } else {
                curString = "\t";
            }
            ncol = 0;
            nextChar = curString.length() == 0 ? (char)10 : curString.charAt(0);
        }
    }

    private static void addNextChar() {
        token = String.valueOf(token) + nextChar;
        TokenizeComment.skipNextChar();
    }

    private static void Backspace(int n) {
        if ((ncol -= n) < 0) {
            Debug.ReportBug("TokenizeComment: Backspacing off end of line");
        }
    }

    private static void gotoStart() {
        state = 1;
        col = ncol;
    }

    private static void CTokenOut(int type) {
        if (!token.equals("") || type == 3) {
            boolean tla = false;
            boolean amb = false;
            if (inSQuote && type != 9) {
                tla = true;
            } else {
                switch (type) {
                    case 1: {
                        if (FormatComments.isAmbiguous(token)) {
                            if (!TokenizeSpec.isUsedBuiltin(token)) break;
                            amb = true;
                            break;
                        }
                        tla = true;
                        break;
                    }
                    case 2: {
                        if (token.charAt(0) == '\\') {
                            tla = true;
                            break;
                        }
                        amb = true;
                        break;
                    }
                    case 3: {
                        tla = true;
                        break;
                    }
                    case 4: {
                        if (FormatComments.IsWord(token)) {
                            if (!TokenizeSpec.isIdent(token)) break;
                            amb = true;
                            break;
                        }
                        if (TokenizeSpec.isIdent(token)) {
                            tla = true;
                            break;
                        }
                        amb = true;
                        break;
                    }
                    case 9: {
                        if (token.indexOf("\\end{verbatim}") == -1) break;
                        Debug.ReportError("Sorry, but you can't put the string\n\n       \\end{verbatim}\n\n    between `. and .' ");
                        break;
                    }
                    case 5: 
                    case 6: 
                    case 7: 
                    case 8: 
                    case 10: {
                        break;
                    }
                    default: {
                        Debug.ReportBug("TokenizeComment.CTokenOut called with illegal type");
                    }
                }
            }
            linev.addElement(new CToken(token, col, type, tla, amb));
        }
        token = "";
    }

    private static void startNewLine() {
        vspec.addElement(linev);
        linev = new Vector(30, 30);
        col = 0;
        ncol = 0;
    }

    private static CToken[][] vspecToArray() {
        CToken[][] aspec = new CToken[vspec.size()][];
        int n = 0;
        while (n < vspec.size()) {
            aspec[n] = new CToken[((Vector)vspec.elementAt(n)).size()];
            int m = 0;
            while (m < aspec[n].length) {
                aspec[n][m] = (CToken)((Vector)vspec.elementAt(n)).elementAt(m);
                ++m;
            }
            ++n;
        }
        vspec = new Vector(50, 50);
        return aspec;
    }

    public static CToken[][] Tokenize(Vector vec) {
        if (vec == null || vec.size() == 0) {
            return null;
        }
        argVec = vec;
        line = 0;
        curString = argVec.elementAt(line) == null ? "" : (String)argVec.elementAt(line);
        nextChar = curString.equals("") ? (char)10 : curString.charAt(0);
        col = 0;
        ncol = 0;
        char repChar = ' ';
        state = 1;
        while (state != 22) {
            switch (state) {
                case 1: {
                    if (Misc.IsSpace(nextChar)) {
                        TokenizeComment.skipNextChar();
                        TokenizeComment.gotoStart();
                        break;
                    }
                    if (Misc.IsLetter(nextChar)) {
                        TokenizeComment.addNextChar();
                        state = 2;
                        break;
                    }
                    if (Misc.IsDigit(nextChar)) {
                        TokenizeComment.addNextChar();
                        state = 3;
                        break;
                    }
                    if (nextChar == '\n') {
                        TokenizeComment.skipNextChar();
                        TokenizeComment.startNewLine();
                        TokenizeComment.gotoStart();
                        break;
                    }
                    if (nextChar == '\\') {
                        TokenizeComment.addNextChar();
                        state = 4;
                        break;
                    }
                    if (FormatComments.isRepeatChar(nextChar)) {
                        repChar = nextChar;
                        TokenizeComment.addNextChar();
                        state = 9;
                        break;
                    }
                    if (nextChar == '\"') {
                        if (inDQuote) {
                            TokenizeComment.addNextChar();
                            state = 13;
                            break;
                        }
                        TokenizeComment.skipNextChar();
                        state = 10;
                        break;
                    }
                    if (nextChar == '`') {
                        TokenizeComment.addNextChar();
                        state = 14;
                        break;
                    }
                    if (nextChar == '\'') {
                        if (inSQuote) {
                            TokenizeComment.skipNextChar();
                            inSQuote = false;
                            TokenizeComment.gotoStart();
                            break;
                        }
                        TokenizeComment.addNextChar();
                        state = 15;
                        break;
                    }
                    if (BuiltInSymbols.IsBuiltInPrefix("" + nextChar)) {
                        TokenizeComment.addNextChar();
                        state = 8;
                        break;
                    }
                    if (nextChar == '\t') {
                        state = 22;
                        break;
                    }
                    TokenizeComment.addNextChar();
                    TokenizeComment.CTokenOut(5);
                    TokenizeComment.gotoStart();
                    break;
                }
                case 2: {
                    if (token.length() == 3 && (token.equals("WF_") || token.equals("SF_"))) {
                        TokenizeComment.CTokenOut(1);
                        TokenizeComment.gotoStart();
                        break;
                    }
                    if (Misc.IsLetter(nextChar) || Misc.IsDigit(nextChar)) {
                        TokenizeComment.addNextChar();
                        break;
                    }
                    if (BuiltInSymbols.IsBuiltInSymbol(token)) {
                        TokenizeComment.CTokenOut(1);
                        TokenizeComment.gotoStart();
                        break;
                    }
                    if (TokenizeComment.isAllUnderscores()) {
                        TokenizeComment.CTokenOut(6);
                    } else {
                        TokenizeComment.CTokenOut(4);
                    }
                    TokenizeComment.gotoStart();
                    break;
                }
                case 3: {
                    if (Misc.IsDigit(nextChar)) {
                        TokenizeComment.addNextChar();
                        state = 3;
                        break;
                    }
                    if (Misc.IsLetter(nextChar)) {
                        TokenizeComment.addNextChar();
                        state = 2;
                        break;
                    }
                    TokenizeComment.CTokenOut(2);
                    TokenizeComment.gotoStart();
                    break;
                }
                case 4: {
                    if (nextChar == 'b' || nextChar == 'B' || nextChar == 'o' || nextChar == 'O' || nextChar == 'h' || nextChar == 'H') {
                        TokenizeComment.addNextChar();
                        state = 5;
                        break;
                    }
                    if (Misc.IsLetter(nextChar)) {
                        state = 7;
                        break;
                    }
                    state = 8;
                    break;
                }
                case 5: {
                    if (Misc.IsDigit(nextChar)) {
                        state = 6;
                        break;
                    }
                    state = 7;
                    break;
                }
                case 6: {
                    if (Misc.IsDigit(nextChar)) {
                        TokenizeComment.addNextChar();
                        state = 6;
                        break;
                    }
                    if (Misc.IsLetter(nextChar) && token.charAt(0) != '\\') {
                        TokenizeComment.addNextChar();
                        state = 2;
                        break;
                    }
                    TokenizeComment.CTokenOut(2);
                    TokenizeComment.gotoStart();
                    break;
                }
                case 7: {
                    if (Misc.IsLetter(nextChar)) {
                        TokenizeComment.addNextChar();
                        state = 7;
                        break;
                    }
                    if (BuiltInSymbols.IsBuiltInSymbol(token)) {
                        TokenizeComment.CTokenOut(1);
                        TokenizeComment.gotoStart();
                        break;
                    }
                    TokenizeComment.CTokenOut(5);
                    TokenizeComment.gotoStart();
                    break;
                }
                case 8: {
                    if (BuiltInSymbols.IsBuiltInPrefix(token + nextChar)) {
                        TokenizeComment.addNextChar();
                        break;
                    }
                    if (!BuiltInSymbols.IsBuiltInSymbol(token)) {
                        while (!BuiltInSymbols.IsBuiltInSymbol(token)) {
                            TokenizeComment.Backspace(1);
                            if (token.length() == 0) {
                                Debug.ReportBug("Error tokenizing built-in symbol");
                            }
                            token = token.substring(0, token.length() - 1);
                        }
                        nextChar = curString.charAt(ncol);
                    }
                    TokenizeComment.CTokenOut(1);
                    TokenizeComment.gotoStart();
                    break;
                }
                case 9: {
                    if (nextChar == repChar) {
                        TokenizeComment.addNextChar();
                        break;
                    }
                    if (token.length() >= FormatComments.getRepeatCharMin(repChar)) {
                        TokenizeComment.CTokenOut(6);
                        state = 1;
                        break;
                    }
                    state = 8;
                    break;
                }
                case 10: {
                    if (nextChar == '\\') {
                        TokenizeComment.addNextChar();
                        state = 11;
                        break;
                    }
                    if (BuiltInSymbols.IsStringChar(nextChar)) {
                        TokenizeComment.addNextChar();
                        state = 10;
                        break;
                    }
                    if (nextChar == '\"' && (TokenizeSpec.isString(token) || inSQuote)) {
                        TokenizeComment.skipNextChar();
                        TokenizeComment.CTokenOut(3);
                        TokenizeComment.gotoStart();
                        break;
                    }
                    state = 12;
                    break;
                }
                case 11: {
                    if (nextChar == '\"' || nextChar == '\\' || nextChar == 't' || nextChar == 'n' || nextChar == 'f' || nextChar == 'r') {
                        TokenizeComment.addNextChar();
                        state = 10;
                        break;
                    }
                    state = 12;
                    break;
                }
                case 12: {
                    TokenizeComment.Backspace(token.length() + 1);
                    token = "\"";
                    TokenizeComment.CTokenOut(7);
                    inDQuote = true;
                    TokenizeComment.skipNextChar();
                    TokenizeComment.gotoStart();
                    break;
                }
                case 13: {
                    TokenizeComment.CTokenOut(8);
                    inDQuote = false;
                    TokenizeComment.gotoStart();
                    break;
                }
                case 14: {
                    if (nextChar == '`') {
                        TokenizeComment.addNextChar();
                        TokenizeComment.CTokenOut(5);
                        TokenizeComment.gotoStart();
                        break;
                    }
                    if (nextChar == '^') {
                        TokenizeComment.skipNextChar();
                        token = "  ";
                        state = 16;
                        break;
                    }
                    if (nextChar == '~') {
                        TokenizeComment.skipNextChar();
                        token = "  ";
                        state = 18;
                        break;
                    }
                    if (nextChar == '.') {
                        TokenizeComment.skipNextChar();
                        token = "  ";
                        state = 20;
                        break;
                    }
                    token = "";
                    inSQuote = true;
                    col = ncol - 1;
                    state = 1;
                    break;
                }
                case 15: {
                    if (nextChar == '\'') {
                        TokenizeComment.addNextChar();
                        TokenizeComment.CTokenOut(5);
                        TokenizeComment.gotoStart();
                        break;
                    }
                    state = 8;
                    break;
                }
                case 16: {
                    if (nextChar == '^') {
                        TokenizeComment.skipNextChar();
                        state = 17;
                        break;
                    }
                    if (nextChar == '\n') {
                        TokenizeComment.skipNextChar();
                        if (token.equals("")) {
                            token = " ";
                        }
                        TokenizeComment.CTokenOut(10);
                        TokenizeComment.startNewLine();
                        break;
                    }
                    if (nextChar == '\t') {
                        if (!Misc.isBlank(token)) {
                            TokenizeComment.CTokenOut(10);
                        }
                        token = "";
                        state = 22;
                        break;
                    }
                    TokenizeComment.addNextChar();
                    break;
                }
                case 17: {
                    if (nextChar == '\'') {
                        TokenizeComment.skipNextChar();
                        if (!Misc.isBlank(token)) {
                            TokenizeComment.CTokenOut(10);
                        }
                        token = "";
                        TokenizeComment.gotoStart();
                        break;
                    }
                    token = String.valueOf(token) + "^";
                    state = 16;
                    break;
                }
                case 18: {
                    if (nextChar == '~') {
                        TokenizeComment.skipNextChar();
                        state = 19;
                        break;
                    }
                    if (nextChar == '\n') {
                        TokenizeComment.skipNextChar();
                        if (linev.size() != 0) {
                            TokenizeComment.startNewLine();
                        }
                        col = 0;
                        ncol = 0;
                        break;
                    }
                    if (nextChar == '\t') {
                        state = 22;
                        break;
                    }
                    TokenizeComment.addNextChar();
                    break;
                }
                case 19: {
                    if (nextChar == '\'') {
                        TokenizeComment.skipNextChar();
                        token = "";
                        TokenizeComment.gotoStart();
                        break;
                    }
                    TokenizeComment.skipNextChar();
                    state = 18;
                    break;
                }
                case 20: {
                    if (nextChar == '.') {
                        TokenizeComment.skipNextChar();
                        state = 21;
                        break;
                    }
                    if (nextChar == '\n') {
                        TokenizeComment.skipNextChar();
                        if (!Misc.isBlank(token)) {
                            TokenizeComment.CTokenOut(9);
                        }
                        token = "";
                        TokenizeComment.startNewLine();
                        break;
                    }
                    if (nextChar == '\t') {
                        if (!Misc.isBlank(token)) {
                            TokenizeComment.CTokenOut(9);
                        }
                        state = 22;
                        break;
                    }
                    TokenizeComment.addNextChar();
                    break;
                }
                case 21: {
                    if (nextChar == '\'') {
                        TokenizeComment.skipNextChar();
                        TokenizeComment.CTokenOut(9);
                        TokenizeComment.gotoStart();
                        break;
                    }
                    token = String.valueOf(token) + ".";
                    state = 20;
                    break;
                }
                default: {
                    Debug.ReportBug("Unexpected state in comment-parsing algorithm");
                }
            }
        }
        return TokenizeComment.vspecToArray();
    }

    public static CToken[][] TeXTokenize(Vector vec) {
        if (vec == null || vec.size() == 0) {
            return null;
        }
        CToken[][] result = new CToken[vec.size()][];
        line = 0;
        while (line < vec.size()) {
            String curString = "";
            if (vec.elementAt(line) != null) {
                curString = (String)vec.elementAt(line);
            }
            result[TokenizeComment.line] = new CToken[1];
            result[TokenizeComment.line][0] = new CToken(curString, 0, 10, false, false);
            ++line;
        }
        return result;
    }
}

