/*
 * Decompiled with CFR 0.152.
 */
package tla2sany.explorer;

import java.io.EOFException;
import java.io.IOException;
import java.io.InputStreamReader;
import java.util.Arrays;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.List;
import java.util.StringTokenizer;
import tla2sany.explorer.DotExplorerVisitor;
import tla2sany.explorer.ExploreNode;
import tla2sany.explorer.ExplorerQuitException;
import tla2sany.semantic.Errors;
import tla2sany.semantic.ExternalModuleTable;
import tla2sany.semantic.FormalParamNode;
import tla2sany.semantic.OpDefOrDeclNode;
import tla2sany.semantic.SymbolNode;
import tla2sany.st.TreeNode;
import tla2sany.utilities.Vector;
import util.UniqueString;

public class Explorer {
    private final InputStreamReader inStream = new InputStreamReader(System.in);
    private final int inCapacity = 100;
    private StringBuffer input = new StringBuffer(100);
    private int lineLength;
    private final Hashtable<Integer, ExploreNode> semNodesTable = new Hashtable();
    private int ntokens;
    private StringTokenizer inputTokens;
    private String firstToken;
    private String secondToken;
    private Integer icmd;
    private Integer icmd2 = null;
    private ExploreNode obj;
    private ExternalModuleTable mt;
    private final Errors errors;

    public Explorer(ExternalModuleTable mtarg, Errors errors) {
        this.mt = mtarg;
        this.errors = errors;
    }

    private boolean getLine() {
        try {
            this.lineLength = 0;
            this.input.setLength(100);
            do {
                this.input.setCharAt(this.lineLength, (char)this.inStream.read());
                ++this.lineLength;
            } while (this.input.charAt(this.lineLength - 1) != '\n' & this.lineLength < 100);
            this.input.setLength(this.lineLength);
        }
        catch (EOFException e) {
            return false;
        }
        catch (IOException e) {
            System.out.println("***I/O exception on keyboard input; " + String.valueOf(e));
            System.exit(-1);
        }
        if (this.lineLength >= 100) {
            System.out.println("Input line too long; line limited to 100 chars.  Line ignored.");
            this.input.setLength(0);
        }
        return true;
    }

    private void printNode(int depth) {
        this.obj = this.semNodesTable.get(this.icmd);
        if (this.obj != null) {
            System.out.println(this.obj.toString(depth, this.errors));
            System.out.print("\n" + this.obj.levelDataToString());
        } else {
            System.out.println("No such node encountered yet");
        }
    }

    private void lookUpAndPrintSyntaxTree(String symbName) {
        Vector<SymbolNode> symbolVect = new Vector<SymbolNode>(8);
        Enumeration<ExploreNode> Enum2 = this.semNodesTable.elements();
        while (Enum2.hasMoreElements()) {
            ExploreNode semNode = Enum2.nextElement();
            if (!(semNode instanceof SymbolNode) || ((SymbolNode)semNode).getName() != UniqueString.uniqueStringOf(symbName)) continue;
            symbolVect.addElement((SymbolNode)semNode);
        }
        int i = 0;
        while (i < symbolVect.size()) {
            SymbolNode sym = (SymbolNode)symbolVect.elementAt(i);
            sym.getTreeNode().printST(0);
            System.out.println();
            ++i;
        }
    }

    private void lookUpAndPrintDef(String symbName) {
        Vector<SymbolNode> symbolVect = new Vector<SymbolNode>(8);
        Enumeration<ExploreNode> Enum2 = this.semNodesTable.elements();
        while (Enum2.hasMoreElements()) {
            ExploreNode semNode = Enum2.nextElement();
            if (!(semNode instanceof SymbolNode) || ((SymbolNode)semNode).getName() != UniqueString.uniqueStringOf(symbName)) continue;
            symbolVect.addElement((SymbolNode)semNode);
        }
        int i = 0;
        while (i < symbolVect.size()) {
            SymbolNode sym = (SymbolNode)symbolVect.elementAt(i);
            if (sym instanceof OpDefOrDeclNode) {
                if (((OpDefOrDeclNode)sym).getOriginallyDefinedInModuleNode() != null) {
                    System.out.print("Module: " + String.valueOf(((OpDefOrDeclNode)sym).getOriginallyDefinedInModuleNode().getName()) + "\n");
                } else {
                    System.out.print("Module: null\n");
                }
            } else if (sym instanceof FormalParamNode) {
                System.out.print("Module: " + String.valueOf(((FormalParamNode)sym).getModuleNode().getName()));
            }
            System.out.println(((SymbolNode)symbolVect.elementAt(i)).toString(100, this.errors) + "\n");
            ++i;
        }
    }

    private void levelDataPrint(String symbName) {
        Vector<SymbolNode> symbolVect = new Vector<SymbolNode>(8);
        Enumeration<ExploreNode> Enum2 = this.semNodesTable.elements();
        while (Enum2.hasMoreElements()) {
            ExploreNode semNode = Enum2.nextElement();
            if (!(semNode instanceof SymbolNode) || ((SymbolNode)semNode).getName() != UniqueString.uniqueStringOf(symbName)) continue;
            symbolVect.addElement((SymbolNode)semNode);
        }
        int i = 0;
        while (i < symbolVect.size()) {
            SymbolNode sym = (SymbolNode)symbolVect.elementAt(i);
            if (sym instanceof OpDefOrDeclNode) {
                if (((OpDefOrDeclNode)sym).getOriginallyDefinedInModuleNode() != null) {
                    System.out.print("Module: " + String.valueOf(((OpDefOrDeclNode)sym).getOriginallyDefinedInModuleNode().getName()) + "\n");
                } else {
                    System.out.print("Module: null\n");
                }
            } else if (sym instanceof FormalParamNode) {
                System.out.print("Module: " + String.valueOf(((FormalParamNode)sym).getModuleNode().getName()) + "\n");
            }
            System.out.println(sym.levelDataToString());
            System.out.println();
            ++i;
        }
    }

    private void executeCommand() throws ExplorerQuitException {
        if (this.icmd != null) {
            this.printNode(this.icmd2);
        } else {
            if (this.firstToken.toLowerCase().startsWith("qu")) {
                throw new ExplorerQuitException();
            }
            if (this.firstToken.toLowerCase().equals("mt")) {
                if (this.icmd2 != null) {
                    this.mt.printExternalModuleTable(this.icmd2, false, this.errors);
                } else {
                    this.mt.printExternalModuleTable(2, false, this.errors);
                }
            } else if (this.firstToken.toLowerCase().equals("mt*")) {
                if (this.icmd2 != null) {
                    this.mt.printExternalModuleTable(this.icmd2, true, this.errors);
                } else {
                    this.mt.printExternalModuleTable(2, true, this.errors);
                }
            } else if (this.firstToken.equalsIgnoreCase("dot")) {
                this.dotSemanticGraph();
            } else if (this.firstToken.toLowerCase().startsWith("cst")) {
                this.printSyntaxTree();
            } else if (this.firstToken.toLowerCase().startsWith("s")) {
                if (this.secondToken != null) {
                    this.lookUpAndPrintSyntaxTree(this.secondToken);
                } else {
                    System.out.println("***Error: You must indicate what name you want to print the syntax tree of.");
                }
            } else if (this.firstToken.toLowerCase().startsWith("d")) {
                if (this.secondToken != null) {
                    this.lookUpAndPrintDef(this.secondToken);
                } else {
                    System.out.println("***Error: You must indicate what name you want to print the definition of.");
                }
            } else if (this.firstToken.toLowerCase().startsWith("l")) {
                if (this.secondToken != null) {
                    this.levelDataPrint(this.secondToken);
                } else {
                    System.out.println("***Error: You must indicate what name you want to print the level data of.");
                }
            } else {
                System.out.println("Unknown command: " + this.firstToken.toString());
                return;
            }
        }
    }

    private void parseAndExecuteCommand() throws ExplorerQuitException {
        this.icmd = null;
        this.icmd2 = null;
        this.ntokens = 0;
        if (!this.inputTokens.hasMoreElements()) {
            return;
        }
        ++this.ntokens;
        this.firstToken = (String)this.inputTokens.nextElement();
        try {
            this.icmd = Integer.valueOf(this.firstToken);
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (this.inputTokens.hasMoreElements()) {
            ++this.ntokens;
            this.secondToken = (String)this.inputTokens.nextElement();
            try {
                this.icmd2 = Integer.valueOf(this.secondToken);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        if (this.ntokens < 2 || this.icmd2 != null && this.icmd2 < 0) {
            this.icmd2 = this.firstToken.toLowerCase().startsWith("mt") ? Integer.valueOf(2) : Integer.valueOf(4);
        }
        if (this.inputTokens.hasMoreElements()) {
            System.out.println("Command has too many tokens");
            return;
        }
        this.executeCommand();
    }

    public void dotSemanticGraph() {
        DotExplorerVisitor visitor = new DotExplorerVisitor(this.mt.getRootModule());
        this.mt.getRootModule().walkGraph(visitor.getTable(), visitor);
        visitor.done();
    }

    public void printSyntaxTree() {
        Iterator<ExternalModuleTable.ExternalModuleTableEntry> modules = this.mt.moduleHashTable.values().iterator();
        while (modules.hasNext()) {
            int key = -1;
            ExternalModuleTable.ExternalModuleTableEntry mte = modules.next();
            if (mte != null) {
                if (mte.getModuleNode() != null) {
                    key = mte.getModuleNode().getUid();
                    this.semNodesTable.put(key, mte.getModuleNode());
                    System.out.println("\n*** Concrete Syntax Tree for Module " + key);
                    TreeNode stn = mte.getModuleNode().getTreeNode();
                    stn.printST(0);
                    System.out.println("\n*** End of concrete syntax tree for Module " + key);
                    continue;
                }
                System.out.println("\n*** Null ExternalModuleTableEntry.  \n*** Next module did not parse, and cannot be printed.");
                continue;
            }
            System.out.println("*** Null SemanticNode in ExternalModuleTableEntry.  /n*** Next module did not parse, and cannot be printed.");
        }
    }

    public void main(String[] args) throws ExplorerQuitException {
        if (this.mt == null) {
            System.out.println("*** module table == null in Explorer.main() ***");
            return;
        }
        List<String> asList = Arrays.asList(args);
        if (asList.contains("cst")) {
            this.inputTokens = new StringTokenizer("cst");
            this.parseAndExecuteCommand();
            System.exit(0);
        } else if (asList.contains("dot")) {
            this.inputTokens = new StringTokenizer("dot");
            this.parseAndExecuteCommand();
            System.exit(0);
        } else if (asList.contains("mt")) {
            this.inputTokens = new StringTokenizer("mt");
            this.parseAndExecuteCommand();
            System.exit(0);
        } else if (asList.contains("mt*")) {
            this.inputTokens = new StringTokenizer("mt*");
            this.parseAndExecuteCommand();
            System.exit(0);
        } else {
            this.mt.walkGraph(this.semNodesTable);
            System.out.println("\n\n*** TLA+ semantic graph exploration tool v 1.0 (DRJ)");
            System.out.print("\n>>");
            while (this.getLine()) {
                this.inputTokens = new StringTokenizer(this.input.toString());
                this.parseAndExecuteCommand();
                System.out.print("\n>>");
            }
        }
    }
}

