/*
 * Decompiled with CFR 0.152.
 */
package tlc2.value.impl;

import java.io.IOException;
import java.util.Enumeration;
import java.util.Hashtable;
import tlc2.tool.FingerprintException;
import tlc2.util.FP64;
import tlc2.value.IMVPerm;
import tlc2.value.IModelValue;
import tlc2.value.IValue;
import tlc2.value.IValueOutputStream;
import tlc2.value.Values;
import tlc2.value.impl.Value;
import tlc2.value.impl.ValueExcept;
import util.Assert;
import util.UniqueString;

public class ModelValue
extends Value
implements IModelValue {
    private static int count;
    private static Hashtable<String, ModelValue> mvTable;
    public static ModelValue[] mvs;
    public UniqueString val;
    public int index;
    public char type;
    private Object data;

    static {
        ModelValue.init();
    }

    public static void init() {
        count = 0;
        mvTable = new Hashtable();
        mvs = null;
    }

    private ModelValue(String val) {
        this.val = UniqueString.uniqueStringOf(val);
        this.index = count++;
        this.type = val.length() > 2 && val.charAt(1) == '_' ? val.charAt(0) : (char)'\u0000';
    }

    public static Value make(String str) {
        ModelValue mv = mvTable.get(str);
        if (mv != null) {
            return mv;
        }
        mv = new ModelValue(str);
        mvTable.put(str, mv);
        return mv;
    }

    public static Value add(String str) {
        ModelValue mv = mvTable.get(str);
        if (mv != null) {
            return mv;
        }
        mv = new ModelValue(str);
        mvTable.put(str, mv);
        ModelValue.setValues();
        return mv;
    }

    public static void setValues() {
        mvs = new ModelValue[mvTable.size()];
        Enumeration<ModelValue> Enum2 = mvTable.elements();
        while (Enum2.hasMoreElements()) {
            ModelValue mv;
            ModelValue.mvs[mv.index] = mv = Enum2.nextElement();
        }
    }

    @Override
    public final byte getKind() {
        return 21;
    }

    @Override
    public final int compareTo(Object obj) {
        block7: {
            if (this.type != '\u0000') break block7;
            if (obj instanceof ModelValue) {
                return this.val.compareTo(((ModelValue)obj).val);
            }
            return -1;
        }
        try {
            if (obj instanceof ModelValue) {
                ModelValue mobj = (ModelValue)obj;
                if (mobj.type == this.type || mobj.type == '\u0000') {
                    return this.val.compareTo(((ModelValue)obj).val);
                }
                Assert.fail("Attempted to compare the differently-typed model values " + Values.ppr(this.toString()) + " and " + Values.ppr(mobj.toString()), this.getSource());
            }
            Assert.fail("Attempted to compare the typed model value " + Values.ppr(this.toString()) + " and non-model value\n" + Values.ppr(obj.toString()), this.getSource());
            return -1;
        }
        catch (OutOfMemoryError | RuntimeException e) {
            if (this.hasSource()) {
                throw FingerprintException.getNewHead(this, e);
            }
            throw e;
        }
    }

    public final boolean equals(Object obj) {
        try {
            if (this.type == '\u0000') {
                return obj instanceof ModelValue && this.val.equals(((ModelValue)obj).val);
            }
            if (obj instanceof ModelValue) {
                ModelValue mobj = (ModelValue)obj;
                if (mobj.type == this.type || mobj.type == '\u0000') {
                    return mobj.val == this.val;
                }
                Assert.fail("Attempted to check equality of the differently-typed model values " + Values.ppr(this.toString()) + " and " + Values.ppr(mobj.toString()), this.getSource());
            }
            Assert.fail("Attempted to check equality of typed model value " + Values.ppr(this.toString()) + " and non-model value\n" + Values.ppr(obj.toString()), this.getSource());
            return false;
        }
        catch (OutOfMemoryError | RuntimeException e) {
            if (this.hasSource()) {
                throw FingerprintException.getNewHead(this, e);
            }
            throw e;
        }
    }

    public final int modelValueCompareTo(Object obj) {
        try {
            if (this.type != '\u0000') {
                Assert.fail("Attempted to compare the typed model value " + Values.ppr(this.toString()) + " and the non-model value\n" + Values.ppr(obj.toString()), this.getSource());
            }
            return 1;
        }
        catch (OutOfMemoryError | RuntimeException e) {
            if (this.hasSource()) {
                throw FingerprintException.getNewHead(this, e);
            }
            throw e;
        }
    }

    public final boolean modelValueEquals(Object obj) {
        try {
            if (this.type != '\u0000') {
                Assert.fail("Attempted to check equality of the typed model value " + Values.ppr(this.toString()) + " and the non-model value\n" + Values.ppr(obj.toString()), this.getSource());
            }
            return false;
        }
        catch (OutOfMemoryError | RuntimeException e) {
            if (this.hasSource()) {
                throw FingerprintException.getNewHead(this, e);
            }
            throw e;
        }
    }

    public final boolean modelValueMember(Object obj) {
        try {
            if (this.type != '\u0000') {
                Assert.fail("Attempted to check if the typed model value " + Values.ppr(this.toString()) + " is an element of\n" + Values.ppr(obj.toString()), this.getSource());
            }
            return false;
        }
        catch (OutOfMemoryError | RuntimeException e) {
            if (this.hasSource()) {
                throw FingerprintException.getNewHead(this, e);
            }
            throw e;
        }
    }

    @Override
    public final boolean member(Value elem) {
        try {
            Assert.fail("Attempted to check if the value:\n" + Values.ppr(elem.toString()) + "\nis an element of the model value " + Values.ppr(this.toString()), this.getSource());
            return false;
        }
        catch (OutOfMemoryError | RuntimeException e) {
            if (this.hasSource()) {
                throw FingerprintException.getNewHead(this, e);
            }
            throw e;
        }
    }

    @Override
    public final boolean isFinite() {
        try {
            Assert.fail("Attempted to check if the model value " + Values.ppr(this.toString()) + " is a finite set.", this.getSource());
            return false;
        }
        catch (OutOfMemoryError | RuntimeException e) {
            if (this.hasSource()) {
                throw FingerprintException.getNewHead(this, e);
            }
            throw e;
        }
    }

    @Override
    public final Value takeExcept(ValueExcept ex) {
        try {
            if (ex.idx < ex.path.length) {
                Assert.fail("Attempted to apply EXCEPT construct to the model value " + Values.ppr(this.toString()) + ".", this.getSource());
            }
            return ex.value;
        }
        catch (OutOfMemoryError | RuntimeException e) {
            if (this.hasSource()) {
                throw FingerprintException.getNewHead(this, e);
            }
            throw e;
        }
    }

    @Override
    public final Value takeExcept(ValueExcept[] exs) {
        try {
            if (exs.length != 0) {
                Assert.fail("Attempted to apply EXCEPT construct to the model value " + Values.ppr(this.toString()) + ".", this.getSource());
            }
            return this;
        }
        catch (OutOfMemoryError | RuntimeException e) {
            if (this.hasSource()) {
                throw FingerprintException.getNewHead(this, e);
            }
            throw e;
        }
    }

    @Override
    public final int size() {
        try {
            Assert.fail("Attempted to compute the number of elements in the model value " + Values.ppr(this.toString()) + ".", this.getSource());
            return 0;
        }
        catch (OutOfMemoryError | RuntimeException e) {
            if (this.hasSource()) {
                throw FingerprintException.getNewHead(this, e);
            }
            throw e;
        }
    }

    @Override
    public boolean mutates() {
        return false;
    }

    @Override
    public final boolean isNormalized() {
        return true;
    }

    @Override
    public final Value normalize() {
        return this;
    }

    @Override
    public final boolean isDefined() {
        return true;
    }

    @Override
    public final IValue deepCopy() {
        return this;
    }

    @Override
    public void write(IValueOutputStream vos) throws IOException {
        vos.writeByte((byte)21);
        vos.writeShort((short)this.index);
    }

    @Override
    public final long fingerPrint(long fp) {
        try {
            return this.val.fingerPrint(FP64.Extend(fp, (byte)21));
        }
        catch (OutOfMemoryError | RuntimeException e) {
            if (this.hasSource()) {
                throw FingerprintException.getNewHead(this, e);
            }
            throw e;
        }
    }

    @Override
    public final IValue permute(IMVPerm perm) {
        try {
            IValue res = perm.get(this);
            if (res == null) {
                return this;
            }
            return res;
        }
        catch (OutOfMemoryError | RuntimeException e) {
            if (this.hasSource()) {
                throw FingerprintException.getNewHead(this, e);
            }
            throw e;
        }
    }

    @Override
    public final StringBuffer toString(StringBuffer sb, int offset, boolean ignored) {
        try {
            return sb.append(this.val);
        }
        catch (OutOfMemoryError | RuntimeException e) {
            if (this.hasSource()) {
                throw FingerprintException.getNewHead(this, e);
            }
            throw e;
        }
    }

    @Override
    public boolean hasData() {
        return this.data != null;
    }

    @Override
    public Object getData() {
        return this.data;
    }

    @Override
    public Object setData(Object obj) {
        this.data = obj;
        return obj;
    }
}

