/*
 * Decompiled with CFR 0.152.
 */
package tlc2.tool.liveness;

import tlc2.output.MP;

public class NodePtrTable {
    private int count = 0;
    private int length;
    private int thresh;
    private long[] keys;
    private long[] elems;

    public NodePtrTable(int size) {
        this.length = size;
        this.thresh = (int)((double)size * 0.75);
        this.keys = new long[size];
        this.elems = new long[size];
        int i = 0;
        while (i < size) {
            this.elems[i] = -1L;
            ++i;
        }
    }

    public final void put(long k, long elem) {
        if (this.count >= this.thresh) {
            this.grow();
        }
        int loc = ((int)k & Integer.MAX_VALUE) % this.length;
        while (true) {
            if (this.elems[loc] == -1L) {
                this.keys[loc] = k;
                this.elems[loc] = elem;
                ++this.count;
                return;
            }
            if (this.keys[loc] == k) {
                this.elems[loc] = elem;
                return;
            }
            loc = (loc + 1) % this.length;
        }
    }

    public final int getLoc(long k) {
        if (this.count >= this.thresh) {
            this.grow();
        }
        int loc = ((int)k & Integer.MAX_VALUE) % this.length;
        while (this.elems[loc] != -1L) {
            if (this.keys[loc] == k) {
                return loc;
            }
            loc = (loc + 1) % this.length;
        }
        return -1;
    }

    public final long get(long k) {
        if (this.count >= this.thresh) {
            this.grow();
        }
        int loc = ((int)k & Integer.MAX_VALUE) % this.length;
        while (this.elems[loc] != -1L) {
            if (this.keys[loc] == k) {
                return this.elems[loc];
            }
            loc = (loc + 1) % this.length;
        }
        return -1L;
    }

    public final long getByLoc(int loc) {
        return this.elems[loc];
    }

    public final long getKeyByLoc(int loc) {
        return this.keys[loc];
    }

    public final void putByLoc(long k, long elem, int loc) {
        this.keys[loc] = k;
        this.elems[loc] = elem;
    }

    public void resetElems() {
        int i = 0;
        while (i < this.keys.length) {
            int n = i++;
            this.elems[n] = this.elems[n] & Long.MAX_VALUE;
        }
    }

    private final void grow() {
        int newLength = 2 * this.length + 1;
        this.grow(newLength);
    }

    private final void grow(int newLength) {
        try {
            long[] oldKeys = this.keys;
            long[] oldElems = this.elems;
            this.keys = new long[newLength];
            this.elems = new long[newLength];
            int i = 0;
            while (i < newLength) {
                this.elems[i] = -1L;
                ++i;
            }
            this.count = 0;
            i = 0;
            while (i < oldElems.length) {
                long elem = oldElems[i];
                if (elem != -1L) {
                    int loc = ((int)oldKeys[i] & Integer.MAX_VALUE) % newLength;
                    while (true) {
                        if (this.elems[loc] == -1L) {
                            this.keys[loc] = oldKeys[i];
                            this.elems[loc] = elem;
                            ++this.count;
                            break;
                        }
                        if (this.keys[loc] == oldKeys[i]) {
                            this.elems[loc] = elem;
                            break;
                        }
                        loc = (loc + 1) % newLength;
                    }
                }
                ++i;
            }
            this.length = newLength;
            this.thresh = (int)((double)newLength * 0.75);
        }
        catch (OutOfMemoryError t) {
            System.gc();
            if (newLength <= this.length + 1) {
                MP.printError(1001, t);
                System.exit(1);
            }
            try {
                this.grow(newLength - (newLength >> 2));
            }
            catch (OutOfMemoryError inner) {
                MP.printError(1001, inner);
                System.exit(1);
            }
        }
    }

    public final int size() {
        return this.count;
    }

    public final int getSize() {
        return this.length;
    }
}

