/*
 * Decompiled with CFR 0.152.
 */
package tlc2.debug;

import java.io.FileInputStream;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import tla2sany.drivers.SemanticException;
import tla2sany.output.SanyOutput;
import tla2sany.output.SilentSanyOutput;
import tla2sany.parser.ParseException;
import tla2sany.parser.SyntaxTreeNode;
import tla2sany.parser.TLAplusParser;
import tla2sany.semantic.AbortException;
import tla2sany.semantic.ErrorCode;
import tla2sany.semantic.Errors;
import tla2sany.semantic.ExternalModuleTable;
import tla2sany.semantic.FormalParamNode;
import tla2sany.semantic.Generator;
import tla2sany.semantic.LetInNode;
import tla2sany.semantic.LevelNode;
import tla2sany.semantic.ModuleNode;
import tla2sany.semantic.OpApplNode;
import tla2sany.semantic.OpArgNode;
import tla2sany.semantic.OpDefNode;
import tla2sany.semantic.SemanticNode;
import tla2sany.semantic.SymbolNode;
import tla2sany.st.Location;
import tlc2.tool.impl.SpecProcessor;
import util.ToolIO;
import util.UniqueString;

public abstract class TLCDebuggerExpression {
    private TLCDebuggerExpression() {
    }

    public static OpDefNode process(SpecProcessor processor, ModuleNode semanticRoot, String conditionExpr) throws ParseException, SemanticException, AbortException {
        return TLCDebuggerExpression.process(processor, semanticRoot, Location.nullLoc, conditionExpr);
    }

    public static OpDefNode process(SpecProcessor processor, ModuleNode semanticRoot, Location location, String conditionExpr) throws ParseException, SemanticException, AbortException {
        if (conditionExpr == null || conditionExpr.isBlank()) {
            return null;
        }
        OpDefNode bpOp = semanticRoot.getOpDef(conditionExpr);
        if (bpOp != null) {
            return bpOp;
        }
        LinkedList<SemanticNode> scope = semanticRoot.pathTo(location, false);
        Set letDefs = scope.stream().filter(LetInNode.class::isInstance).map(LetInNode.class::cast).flatMap(node -> Arrays.stream(node.getLets())).collect(Collectors.toSet());
        String letExpr = letDefs.isEmpty() ? "" : letDefs.stream().map(def -> "LOCAL " + def.getSignature() + " == TRUE").collect(Collectors.joining("\n", "", "\n"));
        Set<SymbolNode> identifiers = TLCDebuggerExpression.getScopedSymbols(semanticRoot, scope);
        Set letNames = letDefs.stream().map(SymbolNode::getName).collect(Collectors.toSet());
        identifiers.removeIf(id -> letNames.contains(id.getName()));
        Set paramNames = identifiers.stream().map(node -> node.getName().toString() + (String)(node.getArity() == 0 ? "" : "(" + String.join((CharSequence)",", Collections.nCopies(node.getArity(), "_")) + ")")).collect(Collectors.toSet());
        String rootModName = semanticRoot.getName().toString();
        String bpModName = semanticRoot.generateUnusedName("__DebuggerModule__%s");
        String bpOpName = semanticRoot.generateUnusedName("__DebuggerExpr__%s");
        String params = paramNames.size() > 0 ? "(" + String.join((CharSequence)", ", paramNames) + ")" : "";
        String bpOpDef = bpOpName + params;
        String wrapper = "---- MODULE %s ----\nEXTENDS %s\n%s\n%s == %s\n====";
        String wrappedConditionExpr = String.format("---- MODULE %s ----\nEXTENDS %s\n%s\n%s == %s\n====", bpModName, rootModName, letExpr, bpOpDef, conditionExpr);
        byte[] wrappedConditionExprBytes = wrappedConditionExpr.getBytes(StandardCharsets.UTF_8);
        TLAplusParser parser = new TLAplusParser((SanyOutput)new SilentSanyOutput(), wrappedConditionExprBytes);
        boolean syntaxParseSuccess = parser.parse();
        SyntaxTreeNode syntaxRoot = parser.ParseTree;
        if (!syntaxParseSuccess || syntaxRoot == null) {
            throw new ParseException("Syntax error while parsing breakpoint expression \"" + conditionExpr + "\"");
        }
        Errors semanticLog = new Errors();
        ExternalModuleTable emt = processor.getModuleTbl();
        TLCDebuggerExpression.resolveDependencies(processor, emt, Stream.of(parser.dependencies()).filter(dep -> emt.getModuleNode((String)dep) == null).collect(Collectors.toList()), semanticLog);
        Generator semanticChecker = new Generator(emt, semanticLog);
        ModuleNode bpModule = semanticChecker.generate(syntaxRoot);
        if (bpModule == null || semanticLog.isFailure()) {
            throw new SemanticException(semanticLog.addMessage(ErrorCode.GENERAL, location, "Semantic error while parsing breakpoint expression \"%s\"", conditionExpr));
        }
        Errors levelCheckingErrors = new Errors();
        boolean levelCheckingSuccess = bpModule.levelCheck(levelCheckingErrors);
        if (!levelCheckingSuccess || levelCheckingErrors.isFailure() || !bpModule.levelCorrect) {
            throw new SemanticException(levelCheckingErrors.addMessage(ErrorCode.GENERAL, location, "Level-checking error while parsing breakpoint expression \"%s\"", conditionExpr));
        }
        bpOp = bpModule.getOpDef(bpOpName);
        if (bpOp == null) {
            throw new SemanticException(semanticLog.addMessage(ErrorCode.GENERAL, location, "Unable to find debugger expression op %s", bpOpName));
        }
        if (bpOp.getLevel() != 0 && 1 != bpOp.getLevel() && 2 != bpOp.getLevel()) {
            throw new SemanticException(semanticLog.addMessage(ErrorCode.OPERATOR_LEVEL_CONSTRAINTS_EXCEEDED, location, "Debug expressions must be action-level or below; actual level: %s", SemanticNode.levelToString(bpOp.getLevel())));
        }
        processor.processConstantsDynamicExtendee(bpModule);
        processor.processModuleOverrides(bpModule, emt);
        for (OpDefNode def2 : letDefs) {
            bpModule.substituteFor(def2, bpModule.getOpDef(def2.getName()));
        }
        return bpOp;
    }

    private static ExternalModuleTable resolveDependencies(SpecProcessor processor, ExternalModuleTable emt, List<String> dependencies, Errors log) throws AbortException, ParseException, SemanticException {
        for (String moduleName : dependencies) {
            try {
                Throwable throwable = null;
                Object var7_9 = null;
                try (FileInputStream moduleSource = new FileInputStream(ToolIO.getDefaultResolver().resolve(moduleName + ".tla", false));){
                    TLAplusParser parser = new TLAplusParser((SanyOutput)new SilentSanyOutput(), moduleSource);
                    boolean syntaxParseSuccess = parser.parse();
                    SyntaxTreeNode syntaxRoot = parser.ParseTree;
                    if (!syntaxParseSuccess || syntaxRoot == null) {
                        throw new ParseException("Syntax error while parsing breakpoint expression's dependency \"" + moduleName + "\"");
                    }
                    String[] stringArray = parser.dependencies();
                    int n = stringArray.length;
                    int n2 = 0;
                    while (n2 < n) {
                        String dep = stringArray[n2];
                        if (emt.getModuleNode(dep) == null) {
                            TLCDebuggerExpression.resolveDependencies(processor, emt, List.of(dep), log);
                        }
                        ++n2;
                    }
                    Generator semanticParser = new Generator(emt, log);
                    ModuleNode module = semanticParser.generate(parser.rootNode());
                    if (log.isFailure()) continue;
                    module.levelCheck(log);
                    processor.processConstantsDynamicExtendee(module);
                    emt.put(UniqueString.of(moduleName), semanticParser.getSymbolTable().getExternalContext(), module);
                }
                catch (Throwable throwable2) {
                    if (throwable == null) {
                        throwable = throwable2;
                    } else if (throwable != throwable2) {
                        throwable.addSuppressed(throwable2);
                    }
                    throw throwable;
                }
            }
            catch (IOException e) {
                log.addMessage(ErrorCode.MODULE_FILE_CANNOT_BE_FOUND, Location.nullLoc, "IO error while reading module \"%s\": %s", moduleName, e.getMessage());
            }
        }
        return emt;
    }

    static Set<String> getScopedIdentifiers(ModuleNode semanticRoot, Location location) {
        LinkedList<SemanticNode> path = semanticRoot.pathTo(location, false);
        Set<SymbolNode> ids = TLCDebuggerExpression.getScopedSymbols(semanticRoot, path);
        return ids.stream().map(node -> node.getName().toString() + (String)(node.getArity() == 0 ? "" : "(" + String.join((CharSequence)",", Collections.nCopies(node.getArity(), "_")) + ")")).collect(Collectors.toSet());
    }

    private static Set<SymbolNode> getScopedSymbols(ModuleNode semanticRoot, List<SemanticNode> path) {
        HashSet<SymbolNode> identifiers = new HashSet<SymbolNode>();
        for (SemanticNode current : path) {
            SymbolNode opSymbol;
            LevelNode node;
            if (current instanceof LetInNode) {
                node = (LetInNode)current;
                OpDefNode[] opDefNodeArray = ((LetInNode)node).getLets();
                int n = opDefNodeArray.length;
                int n2 = 0;
                while (n2 < n) {
                    OpDefNode def = opDefNodeArray[n2];
                    identifiers.add(def);
                    ++n2;
                }
                continue;
            }
            if (current instanceof OpDefNode) {
                node = (OpDefNode)current;
                if (semanticRoot.getOpDef(((SymbolNode)node).getName()) == null) {
                    identifiers.add((SymbolNode)node);
                }
                FormalParamNode[] formalParamNodeArray = ((OpDefNode)node).getParams();
                int n = formalParamNodeArray.length;
                int n3 = 0;
                while (n3 < n) {
                    FormalParamNode param = formalParamNodeArray[n3];
                    identifiers.add(param);
                    ++n3;
                }
                continue;
            }
            if (current instanceof OpApplNode) {
                node = (OpApplNode)current;
                for (FormalParamNode param : ((OpApplNode)node).getQuantSymbolLists()) {
                    identifiers.add(param);
                }
                continue;
            }
            if (!(current instanceof OpArgNode) || !((opSymbol = ((OpArgNode)(node = (OpArgNode)current)).getOp()) instanceof OpDefNode)) continue;
            OpDefNode op = (OpDefNode)opSymbol;
            FormalParamNode[] formalParamNodeArray = op.getParams();
            int n = formalParamNodeArray.length;
            int n4 = 0;
            while (n4 < n) {
                FormalParamNode param = formalParamNodeArray[n4];
                identifiers.add(param);
                ++n4;
            }
        }
        return identifiers;
    }
}

