/*
 * Decompiled with CFR 0.152.
 */
package tlc2;

import java.io.BufferedWriter;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.Writer;
import java.lang.reflect.Method;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.LinkedHashMap;
import org.jline.reader.EndOfFileException;
import org.jline.reader.LineReader;
import org.jline.reader.LineReaderBuilder;
import org.jline.reader.UserInterruptException;
import org.jline.reader.impl.DefaultParser;
import org.jline.reader.impl.history.DefaultHistory;
import org.jline.terminal.Terminal;
import org.jline.terminal.TerminalBuilder;
import tla2sany.semantic.ModuleNode;
import tla2sany.semantic.OpDefNode;
import tlc2.TLCGlobals;
import tlc2.module.TLC;
import tlc2.output.MP;
import tlc2.tool.EvalException;
import tlc2.tool.impl.FastTool;
import tlc2.tool.impl.Tool;
import tlc2.value.impl.Value;
import util.Assert;
import util.ExecutionStatisticsCollector;
import util.SimpleFilenameToStream;
import util.TLCRuntime;
import util.ToolIO;

public class REPL {
    private static final String HISTORY_PATH = System.getProperty("user.home", "") + File.separator + ".tlaplus" + File.separator + "history.repl";
    private File specFile = null;
    static final String TEMP_DIR_PREFIX = "tlarepl";
    final String REPL_SPEC_NAME = "tlarepl";
    private static final String prompt = "(tla+) ";
    private final Writer replWriter = new PrintWriter(System.out);
    Path replTempDir;

    public REPL(Path tempDir) {
        this.replTempDir = tempDir;
    }

    public void setSpecFile(File pSpecFile) {
        this.specFile = pSpecFile;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public String processInput(String evalExpr) {
        Object moduleExtends = "Reals,Sequences,Bags,FiniteSets,TLC,Randomization";
        try {
            Class<?> clazz = Class.forName("tlc2.overrides.CommunityModules");
            Method m = clazz.getDeclaredMethod("popularModules", new Class[0]);
            moduleExtends = (String)moduleExtends + String.format(",%s", m.invoke(null, new Object[0]));
        }
        catch (Exception | NoClassDefFoundError clazz) {
            // empty catch block
        }
        if (this.specFile != null) {
            String mainModuleName = this.specFile.getName().replaceFirst(".tla$", "");
            moduleExtends = (String)moduleExtends + "," + mainModuleName;
        }
        try {
            File tempFile = new File(this.replTempDir.toString(), "tlarepl.tla");
            File configFile = new File(this.replTempDir.toString(), "tlarepl.cfg");
            BufferedWriter cfgWriter = new BufferedWriter(new FileWriter(configFile.getAbsolutePath(), false));
            cfgWriter.append("INIT replinit");
            cfgWriter.newLine();
            cfgWriter.append("NEXT replnext");
            cfgWriter.newLine();
            cfgWriter.close();
            ArrayList<Object> lines = new ArrayList<Object>();
            String replValueVarName = "replvalue";
            lines.add("---- MODULE tlarepl ----");
            lines.add("EXTENDS " + (String)moduleExtends);
            lines.add("VARIABLE replvar");
            lines.add("replinit == replvar = 0");
            lines.add("replnext == replvar' = 0");
            lines.add(replValueVarName + " == " + evalExpr);
            lines.add("====");
            BufferedWriter writer = new BufferedWriter(new FileWriter(tempFile.getAbsolutePath(), false));
            Iterator iterator = lines.iterator();
            while (true) {
                if (!iterator.hasNext()) {
                    writer.close();
                    ToolIO.setMode(1);
                    ToolIO.reset();
                    try {
                        SimpleFilenameToStream simpleFilenameToStream = new SimpleFilenameToStream(this.replTempDir.toAbsolutePath().toString());
                        FastTool tool = new FastTool(TEMP_DIR_PREFIX, TEMP_DIR_PREFIX, simpleFilenameToStream);
                        ModuleNode module = ((Tool)tool).getSpecProcessor().getRootModule();
                        OpDefNode valueNode = module.getOpDef(replValueVarName);
                        TLC.OUTPUT = this.replWriter;
                        Value exprVal = (Value)tool.eval(valueNode.getBody());
                        String string = exprVal.toString();
                        return string;
                    }
                    catch (EvalException evalException) {
                        System.out.printf("Error evaluating expression: '%s'%n%s%n", evalExpr, evalException);
                        return "";
                    }
                    catch (Assert.TLCRuntimeException tLCRuntimeException) {
                        if (tLCRuntimeException.parameters != null && tLCRuntimeException.parameters.length > 0) {
                            System.out.printf("Error evaluating expression: '%s'%n%s%n", evalExpr, Arrays.toString(tLCRuntimeException.parameters));
                            return "";
                        }
                        if (tLCRuntimeException.getMessage() != null) {
                            String msg = tLCRuntimeException.getMessage().trim();
                            msg = msg.replaceFirst("\\nline [0-9]+, col [0-9]+ to line [0-9]+, col [0-9]+ of module tlarepl$", "");
                            msg = msg.replaceAll("\\n", " ").trim();
                            System.out.printf("Error evaluating expression: '%s'%n%s%n", evalExpr, msg);
                            return "";
                        }
                        System.out.printf("Error evaluating expression: '%s'%n", evalExpr);
                        return "";
                    }
                }
                String string = (String)iterator.next();
                writer.append(string);
                writer.newLine();
            }
            finally {
                this.replWriter.flush();
                TLC.OUTPUT = null;
            }
        }
        catch (IOException pe) {
            pe.printStackTrace();
        }
        return "";
    }

    public void runREPL(LineReader reader) throws IOException {
        while (true) {
            try {
                String expr = reader.readLine(prompt);
                String res = this.processInput(expr);
                if (res.equals("")) continue;
                try {
                    System.out.println(res);
                    continue;
                }
                catch (UserInterruptException e) {
                    return;
                }
                catch (EndOfFileException e) {
                    String partial = e.getPartialLine();
                    if (partial != null && !partial.isBlank()) {
                        System.err.println("Warning: ignoring partial line '" + partial + "'");
                    }
                    return;
                }
            }
            finally {
                reader.getHistory().save();
                continue;
            }
            break;
        }
    }

    public static void main(String[] args) {
        try {
            Path tempDir = Files.createTempDirectory(TEMP_DIR_PREFIX, new FileAttribute[0]);
            REPL repl = new REPL(tempDir);
            if (args.length == 1) {
                String res = repl.processInput(args[0]);
                if (!res.equals("")) {
                    System.out.println(res);
                }
                System.exit(0);
            }
            DefaultParser parser = new DefaultParser();
            parser.setEscapeChars(null);
            Terminal terminal = TerminalBuilder.builder().build();
            LineReader reader = LineReaderBuilder.builder().parser(parser).terminal(terminal).history(new DefaultHistory()).build();
            reader.setVariable("history-file", HISTORY_PATH);
            System.out.println("Welcome to the TLA+ REPL!");
            MP.printMessage(2262, TLCGlobals.versionOfTLC);
            System.out.println("Enter a constant-level TLA+ expression.");
            REPL.reportExecutionStatistics();
            repl.runREPL(reader);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private static void reportExecutionStatistics() {
        Runtime runtime = Runtime.getRuntime();
        long heapMemory = runtime.maxMemory() / 1024L / 1024L;
        TLCRuntime tlcRuntime = TLCRuntime.getInstance();
        long offHeapMemory = tlcRuntime.getNonHeapPhysicalMemory() / 1024L / 1024L;
        LinkedHashMap<String, String> udc = new LinkedHashMap<String, String>();
        udc.put("ver", TLCGlobals.getRevisionOrDev());
        udc.put("mode", "repl");
        udc.put("workers", String.valueOf(TLCGlobals.getNumWorkers()));
        udc.put("cores", Integer.toString(Runtime.getRuntime().availableProcessors()));
        udc.put("osName", System.getProperty("os.name"));
        udc.put("osVersion", System.getProperty("os.version"));
        udc.put("osArch", System.getProperty("os.arch"));
        udc.put("jvmVendor", System.getProperty("java.vendor"));
        udc.put("jvmVersion", System.getProperty("java.version"));
        udc.put("jvmArch", tlcRuntime.getArchitecture().name());
        udc.put("jvmHeapMem", Long.toString(heapMemory));
        udc.put("jvmOffHeapMem", Long.toString(offHeapMemory));
        udc.put("toolbox", Boolean.toString(TLCGlobals.tool));
        udc.put("ide", System.getProperty(tlc2.TLC.class.getName() + ".ide", TLCGlobals.tool ? "toolbox" : "cli"));
        new ExecutionStatisticsCollector().collect(udc);
    }
}

