/*
 * Decompiled with CFR 0.152.
 */
package tla2tex;

import tla2tex.Debug;
import tla2tex.OutputFileWriter;

public final class Misc {
    private static final int MAXLEN = 48;

    public static float stringToFloat(String str) {
        int pointPos = str.indexOf(".");
        if (pointPos == -1) {
            Debug.Assert(str.length() > 0, "stringToFloat called with empty string");
            if (str.length() > 18) {
                String substr = str.substring(0, 18);
                float multiplier = 1.0f;
                float exponent = str.length() - 18;
                while (exponent > 0.0f) {
                    multiplier *= 10.0f;
                    exponent -= 1.0f;
                }
                return (float)Long.parseLong(substr) * multiplier;
            }
            return Long.parseLong(str);
        }
        Object strMinusPoint = str.substring(0, pointPos) + str.substring(pointPos + 1);
        Debug.Assert(((String)strMinusPoint).length() > 0, "stringToFloat called with the string \".\"");
        if (((String)strMinusPoint).length() > 18) {
            strMinusPoint = ((String)strMinusPoint).substring(0, 18);
        }
        long divisor = 1L;
        long exponent = ((String)strMinusPoint).length() - pointPos;
        while (exponent > 0L) {
            divisor *= 10L;
            --exponent;
        }
        return (float)Long.parseLong((String)strMinusPoint) / (float)divisor;
    }

    /*
     * Unable to fully structure code
     */
    public static String floatToString(float f, int d) {
        fStr = "" + f;
        ePos = fStr.indexOf("E");
        shiftRight = 0;
        tenToTheMinusD = 1.0f;
        i = d;
        while (i > 0) {
            tenToTheMinusD /= 10.0f;
            --i;
        }
        if (f <= tenToTheMinusD) {
            return "0";
        }
        if (ePos != -1) {
            shiftRight = Integer.parseInt(fStr.substring(ePos + 1));
            fStr = fStr.substring(0, ePos);
            ptPos = fStr.indexOf(".");
            fStr = fStr.substring(0, ptPos) + fStr.substring(ptPos + 1);
            ptPos += shiftRight;
            while (ptPos < 0) {
                fStr = "0" + (String)fStr;
                ++ptPos;
            }
            while (ptPos > fStr.length()) {
                fStr = (String)fStr + "0";
            }
            if (ptPos != fStr.length()) {
                fStr = fStr.substring(0, ptPos) + "." + fStr.substring(ptPos);
            }
        }
        if ((ptPos = fStr.indexOf(".")) != -1) ** GOTO lbl30
        return fStr;
lbl-1000:
        // 1 sources

        {
            fStr = fStr.substring(0, fStr.length() - 1);
lbl30:
            // 2 sources

            ** while (fStr.length() - ptPos > d + 1)
        }
lbl31:
        // 1 sources

        return fStr;
    }

    public static void WriteIfNonNull(OutputFileWriter writer, String str) {
        if (!str.equals("")) {
            Misc.BreakStringOut(writer, str);
        }
    }

    public static void BreakStringOut(OutputFileWriter output, String str) {
        String restOfString = str;
        boolean done = false;
        boolean cut = false;
        while (!done && restOfString.length() > 78) {
            int lastSpace = restOfString.lastIndexOf(32, 77);
            if (lastSpace == -1) {
                lastSpace = restOfString.indexOf(32);
            }
            if (lastSpace <= 19) {
                done = true;
                continue;
            }
            cut = true;
            String outputLine = Misc.EliminateLeadingBlanks(restOfString.substring(0, lastSpace));
            restOfString = restOfString.substring(lastSpace);
            if (outputLine.equals("")) continue;
            output.putLine(" " + outputLine);
        }
        if (cut) {
            if (!(restOfString = Misc.EliminateLeadingBlanks(restOfString)).equals("")) {
                output.putLine(" " + restOfString);
            }
        } else {
            output.putLine(restOfString);
        }
    }

    public static String EliminateLeadingBlanks(String str) {
        int firstNonBlank = 0;
        while (firstNonBlank < str.length() && str.charAt(firstNonBlank) == ' ') {
            ++firstNonBlank;
        }
        return str.substring(firstNonBlank);
    }

    public static String TeXify(String str) {
        Object result = "";
        int pos = 0;
        while (pos < str.length()) {
            switch (str.charAt(pos)) {
                case '_': {
                    result = (String)result + "\\_";
                    break;
                }
                case '{': {
                    result = (String)result + "\\{";
                    break;
                }
                case '}': {
                    result = (String)result + "\\}";
                    break;
                }
                case '\\': {
                    result = (String)result + "\\ensuremath{\\backslash}";
                    break;
                }
                case '&': {
                    result = (String)result + "\\&";
                    break;
                }
                case '%': {
                    result = (String)result + "\\%";
                    break;
                }
                case '$': {
                    result = (String)result + "\\$";
                    break;
                }
                case '#': {
                    result = (String)result + "\\#";
                    break;
                }
                case '~': {
                    result = (String)result + "\\ensuremath{\\sim}";
                    break;
                }
                case '^': {
                    result = (String)result + "\\ensuremath{\\ct}";
                    break;
                }
                case '<': {
                    result = (String)result + "\\ensuremath{<}";
                    break;
                }
                case '>': {
                    result = (String)result + "\\ensuremath{>}";
                    break;
                }
                case '|': {
                    result = (String)result + "\\ensuremath{|}";
                    break;
                }
                default: {
                    result = (String)result + str.charAt(pos);
                }
            }
            ++pos;
        }
        return result;
    }

    public static String TeXifyIdent(String str) {
        Object out = str;
        int nextUS = str.indexOf("_");
        while (nextUS != -1) {
            out = nextUS == 0 ? "\\" + (String)out : ((String)out).substring(0, nextUS) + "\\_" + ((String)out).substring(nextUS + 1);
            nextUS = ((String)out).indexOf("_", nextUS + 2);
        }
        return out;
    }

    public static String TeXifyPcalLabel(String str) {
        Object out = "";
        int next = 0;
        while (next < str.length() && Misc.IsLetter(str.charAt(next)) || Misc.IsDigit(str.charAt(next))) {
            char nextChar = str.charAt(next);
            ++next;
            if (nextChar == '_') {
                out = (String)out + "\\";
            }
            out = (String)out + nextChar;
        }
        int numberOfSpaces = 0;
        while (next < str.length() && Misc.IsSpace(str.charAt(next))) {
            ++numberOfSpaces;
            ++next;
        }
        out = numberOfSpaces == 0 ? (String)out + "\\@s{.5}" : (String)out + "\\@s{2.5}";
        out = (String)out + "\\textrm{";
        while (next < str.length()) {
            char nextChar = str.charAt(next);
            ++next;
            if (Misc.IsSpace(nextChar)) continue;
            out = (String)out + nextChar;
        }
        out = (String)out + (numberOfSpaces == 0 ? "}\\@s{3}" : "}\\@s{4}");
        return out;
    }

    public static String BreakLine(String str) {
        int lineLen = 0;
        int nextChar = 0;
        Object newStr = "";
        char ch = '0';
        while (nextChar < str.length()) {
            ch = str.charAt(nextChar);
            if (ch == '\t') {
                if (lineLen > 48) {
                    newStr = (String)newStr + "\n       ";
                    lineLen = 7;
                }
            } else {
                newStr = (String)newStr + ch;
                ++lineLen;
            }
            ++nextChar;
        }
        return newStr;
    }

    public static boolean IsAscii(int c) {
        return c >= 0 && c < 128;
    }

    public static char AsAscii(int c) {
        return (char)c;
    }

    public static boolean IsLetter(char c) {
        return 'a' <= c && c <= 'z' || 'A' <= c && c <= 'Z' || c == '_';
    }

    public static boolean IsLetter(int c) {
        return Misc.IsAscii(c) && Misc.IsLetter(Misc.AsAscii(c));
    }

    public static boolean hasLetter(String str) {
        boolean notFound = true;
        int i = 0;
        while (notFound && i < str.length()) {
            if (Misc.IsLetter(str.charAt(i))) {
                notFound = false;
            }
            ++i;
        }
        return !notFound;
    }

    public static boolean IsDigit(char c) {
        return '0' <= c && c <= '9';
    }

    public static boolean IsDigit(int c) {
        return Misc.IsAscii(c) && Misc.IsDigit(Misc.AsAscii(c));
    }

    public static boolean IsSpace(char c) {
        return c == ' ' | c == '\f' | c == '\r';
    }

    public static boolean IsSpace(int c) {
        return Misc.IsAscii(c) && Misc.IsSpace(Misc.AsAscii(c));
    }

    public static boolean isBlank(String str) {
        return str.trim().equals("");
    }

    public static boolean IsLowerCase(String str) {
        int i = 0;
        boolean result = true;
        while (i < str.length() && result) {
            char c = str.charAt(i);
            if ('a' > c || c > 'z') {
                result = false;
            }
            ++i;
        }
        return result;
    }

    public static boolean IsUpperCase(String str) {
        int i = 0;
        boolean result = true;
        while (i < str.length() && result) {
            char c = str.charAt(i);
            if ('A' > c || c > 'Z') {
                result = false;
            }
            ++i;
        }
        return result;
    }

    public static boolean IsCapitalized(String str) {
        if (str.length() > 0) {
            char c = str.charAt(0);
            return 'A' <= c && c <= 'Z' && Misc.IsLowerCase(str.substring(1));
        }
        return false;
    }
}

