/*
 * Decompiled with CFR 0.152.
 */
package tlc2.util;

import java.io.File;
import tlc2.util.IntStack;
import util.Assert;
import util.BufferedDataInputStream;
import util.BufferedDataOutputStream;
import util.FileUtil;

public final class DiskIntStack
implements IntStack {
    private static final int BufSize = 16384;
    private long size = 0L;
    private String filePrefix;
    private File poolFile;
    private int[] buf1 = new int[16384];
    private int[] buf2 = new int[16384];
    private int[] buf;
    private int[] rwbuf = new int[16384];
    private int index = 0;
    private int hiPool = 0;
    private boolean isIdle = true;
    private Reader reader;
    private Writer writer;

    public DiskIntStack(String diskdir, String name) {
        this.buf = this.buf1;
        this.filePrefix = diskdir + FileUtil.separator + name;
        this.poolFile = null;
        this.reader = new Reader();
        this.writer = new Writer();
        this.reader.start();
        this.writer.start();
    }

    @Override
    public final long size() {
        return this.size;
    }

    @Override
    public final synchronized void pushInt(int x) {
        if (this.index == 16384 && this.buf == this.buf2) {
            try {
                while (!this.isIdle) {
                    this.wait();
                }
                this.buf = this.rwbuf;
                this.rwbuf = this.buf1;
                this.poolFile = new File(this.filePrefix + Integer.toString(this.hiPool++));
                this.isIdle = false;
                this.writer.notify();
                this.buf1 = this.buf2;
                this.buf2 = this.buf;
                this.index = 0;
            }
            catch (Exception e) {
                Assert.fail(2175, new String[]{"stack", e.getMessage()});
            }
        }
        this.buf[this.index++] = x;
        ++this.size;
    }

    @Override
    public final synchronized void pushLong(long x) {
        this.pushInt((int)(x & 0xFFFFFFFFL));
        this.pushInt((int)(x >>> 32));
    }

    @Override
    public final synchronized int popInt() {
        if (this.buf == this.buf1 && this.index < 8192 && this.hiPool != 0) {
            try {
                while (!this.isIdle) {
                    this.wait();
                }
                this.buf = this.rwbuf;
                this.rwbuf = this.buf2;
                --this.hiPool;
                if (this.hiPool > 0) {
                    this.poolFile = new File(this.filePrefix + Integer.toString(this.hiPool - 1));
                    this.isIdle = false;
                    this.reader.notify();
                }
                this.buf2 = this.buf1;
                this.buf1 = this.buf;
                this.buf = this.buf2;
            }
            catch (Exception e) {
                Assert.fail(2174, new String[]{"stack", e.getMessage()});
            }
        }
        --this.size;
        return this.buf[--this.index];
    }

    @Override
    public final synchronized long popLong() {
        long high = this.popInt();
        long low = this.popInt();
        return high << 32 | low & 0xFFFFFFFFL;
    }

    @Override
    public void reset() {
    }

    class Reader
    extends Thread {
        Reader() {
        }

        @Override
        public void run() {
            try {
                Reader reader = this;
                synchronized (reader) {
                    while (true) {
                        if (DiskIntStack.this.poolFile == null) {
                            this.wait();
                            continue;
                        }
                        BufferedDataInputStream bdis = FileUtil.newBdFIS(false, DiskIntStack.this.poolFile);
                        int len = DiskIntStack.this.rwbuf.length;
                        int i = 0;
                        while (i < len) {
                            DiskIntStack.this.rwbuf[i] = bdis.readInt();
                            ++i;
                        }
                        bdis.close();
                        DiskIntStack.this.poolFile = null;
                        DiskIntStack.this.isIdle = true;
                        DiskIntStack.this.notify();
                    }
                }
            }
            catch (Exception e) {
                Assert.fail(2161, e);
                return;
            }
        }
    }

    class Writer
    extends Thread {
        Writer() {
        }

        @Override
        public void run() {
            try {
                Writer writer = this;
                synchronized (writer) {
                    while (true) {
                        if (DiskIntStack.this.poolFile == null) {
                            this.wait();
                            continue;
                        }
                        BufferedDataOutputStream bdos = FileUtil.newBdFOS(false, DiskIntStack.this.poolFile);
                        int len = DiskIntStack.this.buf.length;
                        int i = 0;
                        while (i < len) {
                            bdos.writeInt(DiskIntStack.this.buf[i]);
                            ++i;
                        }
                        bdos.close();
                        DiskIntStack.this.poolFile = null;
                        DiskIntStack.this.isIdle = true;
                        DiskIntStack.this.notify();
                    }
                }
            }
            catch (Exception e) {
                Assert.fail(2161, e);
                return;
            }
        }
    }
}

