/*
 * Decompiled with CFR 0.152.
 */
package tlc2.debug;

import java.util.LinkedList;
import org.eclipse.lsp4j.debug.Variable;
import tla2sany.semantic.SemanticNode;
import tla2sany.semantic.SymbolNode;
import tlc2.debug.TLCStackFrame;
import tlc2.debug.TLCStateStackFrame;
import tlc2.tool.Action;
import tlc2.tool.EvalException;
import tlc2.tool.FingerprintException;
import tlc2.tool.TLCState;
import tlc2.tool.impl.Tool;
import tlc2.util.Context;
import tlc2.value.IValue;
import tlc2.value.impl.LazyValue;
import tlc2.value.impl.RecordValue;
import tlc2.value.impl.Value;
import util.Assert;

public class TLCActionStackFrame
extends TLCStateStackFrame {
    public static final String SCOPE = "Action";

    @Override
    protected String getScope() {
        return SCOPE;
    }

    public TLCActionStackFrame(TLCStackFrame parent, SemanticNode expr, Context c, Tool tool, TLCState predecessor, Action a, TLCState ps) {
        this(parent, expr, c, tool, predecessor, a, ps, null);
    }

    public TLCActionStackFrame(TLCStackFrame parent, SemanticNode expr, Context c, Tool tool, TLCState predecessor, Action a, TLCState ps, RuntimeException e) {
        super(parent, expr, c, tool, ps, e);
        assert (predecessor != null);
        assert (a != null);
        assert (ps != null);
        assert (predecessor.getLevel() == ps.getLevel() || ps.getPredecessor() != null || ps.isInitial());
    }

    @Override
    protected TLCState getS() {
        return this.state.getPredecessor();
    }

    @Override
    protected TLCState getT() {
        return this.state;
    }

    @Override
    protected RecordValue toRecordValue() {
        return new RecordValue(this.getS(), this.getT(), (Value)NOT_EVAL);
    }

    @Override
    protected Variable getVariable(LinkedList<SemanticNode> path) {
        SymbolNode var;
        assert (!path.isEmpty());
        if (this.isPrimeScope(path) && (var = this.tool.getPrimedVar(path.getFirst(), this.ctxt, false)) != null) {
            IValue value = this.getT().lookup(var.getName());
            if (value != null) {
                return this.getVariable(value, String.valueOf(var.getName()) + "'");
            }
            Variable v = new Variable();
            v.setName(String.valueOf(var.getName()) + "'");
            v.setValue("?");
            return v;
        }
        return super.getVariable(path);
    }

    @Override
    protected Object unlazy(LazyValue lv) {
        return this.unlazy(lv, null);
    }

    @Override
    protected Object unlazy(LazyValue lv, Object fallback) {
        return this.tool.eval(() -> {
            try {
                return lv.eval(this.tool, this.getS(), this.getT());
            }
            catch (EvalException | FingerprintException | Assert.TLCRuntimeException e) {
                return fallback == null ? e : fallback;
            }
        });
    }

    @Override
    protected IValue evaluate(SemanticNode expr, Context ctxt) throws Exception {
        return this.tool.eval(() -> this.tool.noDebug().eval(expr, ctxt, this.getS(), this.getT(), 0));
    }
}

