/*
 * Decompiled with CFR 0.152.
 */
package tla2sany.modanalyzer;

import java.io.PrintWriter;
import tla2sany.parser.SyntaxTreeNode;
import tla2sany.st.Location;
import tla2sany.st.ParseTree;
import tla2sany.st.TreeNode;

public class SyntaxTreePrinter {
    public static final void print(ParseTree pt, PrintWriter output) {
        output.println("%% Output of parse tree for module " + pt.moduleName());
        String[] dependencies = pt.dependencies();
        if (dependencies.length == 0) {
            output.println("%% no dependencies");
        } else {
            output.print("%% dependends on:");
            int lvi = 0;
            while (lvi < dependencies.length) {
                output.print(" " + dependencies[lvi]);
                ++lvi;
            }
            output.println(".");
        }
        SyntaxTreePrinter.printSubTree(output, "", pt.rootNode());
    }

    private static void printSubTree(PrintWriter o, String offset, TreeNode node) {
        StringBuffer outS = new StringBuffer(offset);
        Location l = node.getLocation();
        String image = node.getImage();
        if (image != null) {
            outS.append(image);
        } else {
            outS.append("-- no name --");
        }
        outS.append(" [").append(l.beginLine()).append(" ").append(l.beginColumn()).append("] ");
        TreeNode[] h = node.heirs();
        outS.append(" (kind: " + ((SyntaxTreeNode)node).getKind() + ") ");
        outS.append(" (level: " + node.getLevel() + ") ");
        if (h != null) {
            if (h.length == 0) {
                int length = node.getPreComments().length;
                outS.append(length);
                outS.append(" pre-comments ");
            }
            outS.append(" {");
            o.println(outS);
            int i = 0;
            while (i < h.length) {
                SyntaxTreePrinter.printSubTree(o, offset + ".", h[i]);
                ++i;
            }
            o.print(offset);
            o.println("}");
        } else {
            outS.append(" ***WARNING***  null array reference ");
            o.println(outS);
        }
    }
}

