/*
 * Decompiled with CFR 0.152.
 */
package util;

public class StringHelper {
    public static String PLATFORM_NEWLINE = System.getProperty("line.separator");

    public static final String copyString(String str, int copies) {
        Object result = "";
        Object powerOf2Copies = str;
        int remaining = copies;
        while (remaining > 0) {
            if (remaining % 2 != 0) {
                result = (String)result + (String)powerOf2Copies;
            }
            if ((remaining /= 2) == 0) continue;
            powerOf2Copies = (String)powerOf2Copies + (String)powerOf2Copies;
        }
        return result;
    }

    public static final boolean onlySpaces(String str) {
        return str.trim().equals("");
    }

    public static final String trimFront(String str) {
        int position = 0;
        while (position < str.length() && Character.isWhitespace(str.charAt(position))) {
            ++position;
        }
        return str.substring(position, str.length());
    }

    public static final String trimEnd(String str) {
        int position = str.length();
        while (position > 0 && Character.isWhitespace(str.charAt(position - 1))) {
            --position;
        }
        return str.substring(0, position);
    }

    public static final int leadingSpaces(String str) {
        return str.length() - StringHelper.trimFront(str).length();
    }

    public static final void printArray(Object[] array) {
        if (array == null) {
            System.out.println("null array");
            return;
        }
        if (array.length == 0) {
            System.out.println("zero-length array");
            return;
        }
        System.out.println("0-" + array[0].toString() + "-0");
        int i = 1;
        while (i < array.length) {
            System.out.println("*-" + array[i].toString() + "-*");
            ++i;
        }
    }

    public static final String[] getWords(String str) {
        String[] result = StringHelper.trimFront(str).split("\\s+");
        return result;
    }

    public static final boolean isIdentifier(String str) {
        boolean result = true;
        boolean allChars = true;
        int i = 0;
        while (result && i < str.length()) {
            char ch = str.charAt(i);
            result = Character.isLetterOrDigit(ch) || ch == '_';
            allChars = allChars && Character.isDigit(ch);
            ++i;
        }
        return result && !allChars;
    }
}

