/*
 * Decompiled with CFR 0.152.
 */
package tlc2.tool.fp.dfid;

import java.io.IOException;
import java.rmi.RemoteException;
import tlc2.tool.fp.dfid.FPIntSet;
import tlc2.tool.fp.dfid.MemFPIntSet;

public class MultiFPIntSet
extends FPIntSet {
    private FPIntSet[] sets;
    private int fpbits;

    public MultiFPIntSet(int bits) throws RemoteException {
        int len = 1 << bits;
        this.sets = new FPIntSet[len];
        int i = 0;
        while (i < len) {
            this.sets[i] = new MemFPIntSet();
            ++i;
        }
        this.fpbits = 64 - bits;
    }

    @Override
    public final void init(int numThreads, String metadir, String filename) throws IOException {
        int i = 0;
        while (i < this.sets.length) {
            this.sets[i].init(numThreads, metadir, filename + "_" + i);
            ++i;
        }
    }

    @Override
    public final long size() {
        int sum = 0;
        int i = 0;
        while (i < this.sets.length) {
            sum = (int)((long)sum + this.sets[i].size());
            ++i;
        }
        return sum;
    }

    @Override
    public final void setLeveled(long fp) {
        int idx = (int)(fp >>> this.fpbits);
        this.sets[idx].setLeveled(fp);
    }

    @Override
    public final int setStatus(long fp, int status) {
        int idx = (int)(fp >>> this.fpbits);
        return this.sets[idx].setStatus(fp, status);
    }

    @Override
    public final int getStatus(long fp) {
        int idx = (int)(fp >>> this.fpbits);
        return this.sets[idx].getStatus(fp);
    }

    @Override
    public final boolean allLeveled() {
        int i = 0;
        while (i < this.sets.length) {
            if (!this.sets[i].allLeveled()) {
                return false;
            }
            ++i;
        }
        return true;
    }

    @Override
    public final void close() {
        int i = 0;
        while (i < this.sets.length) {
            this.sets[i].close();
            ++i;
        }
    }

    @Override
    public final long checkFPs() throws IOException {
        long res = Long.MIN_VALUE;
        int i = 0;
        while (i < this.sets.length) {
            res = Math.max(res, this.sets[i].checkFPs());
            ++i;
        }
        return res;
    }

    @Override
    public final void exit(boolean cleanup) throws IOException {
        int i = 0;
        while (i < this.sets.length) {
            this.sets[i].exit(cleanup);
            ++i;
        }
    }

    @Override
    public final void beginChkpt() throws IOException {
        int i = 0;
        while (i < this.sets.length) {
            this.sets[i].beginChkpt();
            ++i;
        }
    }

    @Override
    public final void commitChkpt() throws IOException {
        int i = 0;
        while (i < this.sets.length) {
            this.sets[i].commitChkpt();
            ++i;
        }
    }

    @Override
    public final void recover() throws IOException {
        int i = 0;
        while (i < this.sets.length) {
            this.sets[i].recover();
            ++i;
        }
    }

    @Override
    public final void beginChkpt(String filename) throws IOException {
        int i = 0;
        while (i < this.sets.length) {
            this.sets[i].beginChkpt(filename);
            ++i;
        }
    }

    @Override
    public final void commitChkpt(String filename) throws IOException {
        int i = 0;
        while (i < this.sets.length) {
            this.sets[i].commitChkpt(filename);
            ++i;
        }
    }

    @Override
    public final void recover(String filename) throws IOException {
        int i = 0;
        while (i < this.sets.length) {
            this.sets[i].recover(filename);
            ++i;
        }
    }
}

