/*
 * Decompiled with CFR 0.152.
 */
package tlc2.tool.distributed;

import java.net.MalformedURLException;
import java.rmi.Naming;
import java.rmi.NoSuchObjectException;
import java.rmi.NotBoundException;
import java.rmi.RemoteException;
import java.util.Date;
import java.util.Timer;
import java.util.TimerTask;
import java.util.logging.Level;
import java.util.logging.Logger;
import tlc2.output.MP;
import tlc2.tool.distributed.TLCServerRMI;
import tlc2.tool.distributed.TLCWorker;

public class TLCTimerTask
extends TimerTask {
    public static final long PERIOD = 60000L;
    private static final Logger LOGGER = Logger.getLogger(TLCTimerTask.class.getName());
    private static final int TIMEOUT = Integer.getInteger(TLCTimerTask.class.getName() + ".timeout", 60) * 1000;
    private final String serverUrl;
    private final TLCWorker.TLCWorkerRunnable[] runnables;
    private final Timer timer;

    public TLCTimerTask(Timer keepAliveTimer, TLCWorker.TLCWorkerRunnable[] runnables, String anUrl) {
        this.timer = keepAliveTimer;
        this.runnables = runnables;
        this.serverUrl = anUrl;
    }

    @Override
    public void run() {
        if (this.noActivityWithin(TIMEOUT)) {
            try {
                TLCServerRMI server = (TLCServerRMI)Naming.lookup(this.serverUrl);
                if (server.isDone()) {
                    this.exitWorker(null);
                }
            }
            catch (MalformedURLException e) {
                LOGGER.log(Level.FINEST, "Failed to exit worker", e);
            }
            catch (RemoteException e) {
                this.exitWorker(e);
            }
            catch (NotBoundException e) {
                this.exitWorker(e);
            }
        }
    }

    private boolean noActivityWithin(int timeout) {
        long lastInvocation = this.getMostRecentInvocation();
        if (lastInvocation == -1L) {
            return false;
        }
        long now = new Date().getTime();
        return lastInvocation == 0L || now - lastInvocation > (long)timeout;
    }

    private long getMostRecentInvocation() {
        long minInvocation = 0L;
        int i = 0;
        while (i < this.runnables.length) {
            TLCWorker tlcWorker = this.runnables[i].getTLCWorker();
            if (tlcWorker.isComputing()) {
                return -1L;
            }
            long lastInvocation = tlcWorker.getLastInvocation();
            minInvocation = Math.max(minInvocation, lastInvocation);
            ++i;
        }
        return minInvocation;
    }

    private void exitWorker(Throwable e) {
        if (e != null) {
            MP.printError(7004, e);
        } else {
            MP.printError(7010);
        }
        int i = 0;
        while (i < this.runnables.length) {
            try {
                TLCWorker.TLCWorkerRunnable runnable = this.runnables[i];
                runnable.getTLCWorker().exit();
            }
            catch (NoSuchObjectException ex) {
                LOGGER.log(Level.FINEST, "Failed to exit worker", ex);
            }
            ++i;
        }
        this.timer.cancel();
    }
}

