/*
 * Decompiled with CFR 0.152.
 */
package pcal;

import java.util.Vector;
import pcal.PcalDebug;

public class PcalCharReader {
    private Vector<String> vec;
    private int[] currentLine = null;
    protected int line = 0;
    private int column = 0;
    private int vcolumn = 0;
    private int lastLine = 0;
    private int lastColumn = 0;
    private boolean tabToSpaces = false;

    private static int[] stringToCodepoints(String input) {
        return input.codePoints().toArray();
    }

    public int getLineNumber() {
        return this.line;
    }

    public int getColumnNumber() {
        return this.vcolumn;
    }

    public int getNextChar() {
        if (this.currentLine == null) {
            return 9;
        }
        if (this.tabToSpaces) {
            ++this.vcolumn;
            if (this.vcolumn % 8 == 0) {
                this.tabToSpaces = false;
            }
            return 32;
        }
        if (this.line > this.lastLine || this.line == this.lastLine && this.column >= this.lastColumn) {
            return 9;
        }
        if (this.currentLine.length == this.column) {
            ++this.line;
            this.column = 0;
            this.vcolumn = 0;
            this.currentLine = (int[])(this.line >= this.vec.size() ? null : PcalCharReader.stringToCodepoints(this.vec.elementAt(this.line)));
            return 10;
        }
        int readChar = this.currentLine[this.column];
        ++this.column;
        ++this.vcolumn;
        if (readChar == 9) {
            if (this.vcolumn % 8 != 0) {
                this.tabToSpaces = true;
            }
            return 32;
        }
        return readChar;
    }

    public void backspace() {
        if (this.column == 0) {
            if (this.line == 0) {
                PcalDebug.ReportBug("PcalCharReader.backspace trying to move past beginning of reader");
            }
            --this.line;
            this.currentLine = PcalCharReader.stringToCodepoints(this.vec.elementAt(this.line));
            this.column = 0;
            this.vcolumn = 0;
            while (this.column < this.currentLine.length - 1) {
                this.getNextChar();
            }
        } else {
            --this.column;
            --this.vcolumn;
        }
    }

    public String peek() {
        int next = this.getNextChar();
        while (next == 32 || next == 10) {
            next = this.getNextChar();
        }
        if (next == 9) {
            return "\t";
        }
        this.backspace();
        return new String(this.currentLine, this.column, this.currentLine.length - this.column) + "\n";
    }

    public PcalCharReader(Vector<String> vector, int firstLine, int firstCol, int lastLine, int lastCol) {
        this.vec = vector;
        this.line = firstLine;
        this.column = firstCol;
        this.lastLine = lastLine;
        this.lastColumn = lastCol;
        if (firstLine < vector.size()) {
            int i = 0;
            String ln = vector.elementAt(firstLine);
            while (i < firstCol) {
                this.vcolumn = ln.charAt(i) == '\t' ? (this.vcolumn / 8 + 1) * 8 : ++this.vcolumn;
                ++i;
            }
        }
        if (firstLine < vector.size()) {
            this.currentLine = PcalCharReader.stringToCodepoints(vector.elementAt(firstLine));
        }
    }
}

