/*
 * Decompiled with CFR 0.152.
 */
package tlc2.tool.queue;

import java.io.EOFException;
import java.io.File;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.nio.file.Files;
import java.nio.file.attribute.FileAttribute;
import java.util.Arrays;
import tlc2.output.MP;
import tlc2.tool.queue.ByteArrayQueue;
import tlc2.tool.queue.DiskStateQueue;
import tlc2.value.IValue;
import tlc2.value.IValueInputStream;
import tlc2.value.IValueOutputStream;
import tlc2.value.ValueConstants;
import tlc2.value.impl.BoolValue;
import tlc2.value.impl.FcnRcdValue;
import tlc2.value.impl.IntValue;
import tlc2.value.impl.IntervalValue;
import tlc2.value.impl.ModelValue;
import tlc2.value.impl.RecordValue;
import tlc2.value.impl.SetEnumValue;
import tlc2.value.impl.StringValue;
import tlc2.value.impl.TupleValue;
import util.Assert;
import util.BufferedDataInputStream;
import util.BufferedDataOutputStream;
import util.FileUtil;
import util.IDataInputStream;
import util.IDataOutputStream;
import util.UniqueString;
import util.WrongInvocationException;

public class DiskByteArrayQueue
extends ByteArrayQueue {
    private static final int BufSize = Integer.getInteger(DiskStateQueue.class.getName() + ".BufSize", 8192);
    private final String filePrefix;
    protected byte[][] deqBuf = new byte[BufSize][];
    protected byte[][] enqBuf = new byte[BufSize][];
    protected int deqIndex = BufSize;
    protected int enqIndex = 0;
    protected ByteArrayPoolReader reader;
    protected ByteArrayPoolWriter writer;
    protected final StatePoolCleaner cleaner;
    private int loPool = 1;
    private int hiPool = 0;
    private int lastLoPool = 0;
    private int newLastLoPool;
    private File loFile;

    DiskByteArrayQueue() throws IOException {
        this(Files.createTempDirectory("DiskByteArrayQueue", new FileAttribute[0]).toFile().toString());
    }

    public DiskByteArrayQueue(String diskdir) {
        this.filePrefix = diskdir + FileUtil.separator;
        File rFile = new File(this.filePrefix + Integer.toString(0));
        this.reader = new ByteArrayPoolReader(BufSize, rFile);
        this.reader.setDaemon(true);
        this.loFile = new File(this.filePrefix + Integer.toString(this.loPool));
        this.reader.start();
        this.writer = new ByteArrayPoolWriter(BufSize, this.reader);
        this.writer.setDaemon(true);
        this.writer.start();
        this.cleaner = new StatePoolCleaner();
        this.cleaner.setDaemon(true);
        this.cleaner.start();
    }

    @Override
    final void enqueueInner(byte[] state) {
        if (this.enqIndex == this.enqBuf.length) {
            try {
                String pstr = Integer.toString(this.hiPool);
                File file = new File(this.filePrefix + pstr);
                this.enqBuf = this.writer.doWork(this.enqBuf, file);
                ++this.hiPool;
                this.enqIndex = 0;
            }
            catch (Exception e) {
                Assert.fail(2175, new String[]{"queue", e.getMessage() == null ? e.toString() : e.getMessage()});
            }
        }
        this.enqBuf[this.enqIndex++] = state;
    }

    @Override
    final byte[] dequeueInner() {
        if (this.deqIndex == this.deqBuf.length) {
            this.fillDeqBuffer();
        }
        return this.deqBuf[this.deqIndex++];
    }

    @Override
    byte[] peekInner() {
        if (this.deqIndex == this.deqBuf.length) {
            this.fillDeqBuffer();
        }
        return this.deqBuf[this.deqIndex];
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void fillDeqBuffer() {
        block10: {
            try {
                if (this.loPool + 1 <= this.hiPool) {
                    if (this.loPool + 1 >= this.hiPool) {
                        this.writer.ensureWritten();
                    }
                    this.deqBuf = this.reader.doWork(this.deqBuf, this.loFile);
                    this.deqIndex = 0;
                    ++this.loPool;
                    String string = Integer.toString(this.loPool);
                    this.loFile = new File(this.filePrefix + string);
                } else {
                    this.writer.ensureWritten();
                    byte[][] byArray = this.reader.getCache(this.deqBuf, this.loFile);
                    if (byArray != null) {
                        this.deqBuf = byArray;
                        this.deqIndex = 0;
                        ++this.loPool;
                        String pstr = Integer.toString(this.loPool);
                        this.loFile = new File(this.filePrefix + pstr);
                    } else {
                        this.deqIndex = this.deqBuf.length - this.enqIndex;
                        System.arraycopy(this.enqBuf, 0, this.deqBuf, this.deqIndex, this.enqIndex);
                        this.enqIndex = 0;
                    }
                }
                if (this.loPool - this.lastLoPool <= 100) break block10;
                StatePoolCleaner statePoolCleaner = this.cleaner;
                synchronized (statePoolCleaner) {
                    this.cleaner.deleteUpTo = this.loPool - 1;
                    this.cleaner.notifyAll();
                }
            }
            catch (Exception exception) {
                Assert.fail(2174, new String[]{"queue", exception.getMessage() == null ? exception.toString() : exception.getMessage()});
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final void beginChkpt() throws IOException {
        StatePoolCleaner statePoolCleaner = this.cleaner;
        synchronized (statePoolCleaner) {
            this.cleaner.finished = true;
            this.cleaner.notifyAll();
        }
        String filename = this.filePrefix + "queue.tmp";
        BufferedDataOutputStream vos = new BufferedDataOutputStream(filename);
        vos.writeLong(this.len);
        vos.writeInt(this.loPool);
        vos.writeInt(this.hiPool);
        vos.writeInt(this.enqIndex);
        vos.writeInt(this.deqIndex);
        int i = 0;
        while (i < this.enqIndex) {
            vos.writeInt(this.enqBuf[i].length);
            vos.write(this.enqBuf[i]);
            ++i;
        }
        i = this.deqIndex;
        while (i < this.deqBuf.length) {
            vos.writeInt(this.deqBuf[i].length);
            vos.write(this.deqBuf[i]);
            ++i;
        }
        vos.close();
        this.newLastLoPool = this.loPool - 1;
    }

    @Override
    public final void commitChkpt() throws IOException {
        int i = this.lastLoPool;
        while (i < this.newLastLoPool) {
            String pstr = Integer.toString(i);
            File oldPool = new File(this.filePrefix + pstr);
            if (!oldPool.delete()) {
                String msg = "DiskStateQueue.commitChkpt: cannot delete " + String.valueOf(oldPool);
                throw new IOException(msg);
            }
            ++i;
        }
        this.lastLoPool = this.newLastLoPool;
        File oldChkpt = new File(this.filePrefix + "queue.chkpt");
        File newChkpt = new File(this.filePrefix + "queue.tmp");
        if (oldChkpt.exists() && !oldChkpt.delete() || !newChkpt.renameTo(oldChkpt)) {
            String msg = "DiskStateQueue.commitChkpt: cannot delete " + String.valueOf(oldChkpt);
            throw new IOException(msg);
        }
    }

    @Override
    public final void recover() throws IOException {
        String filename = this.filePrefix + "queue.chkpt";
        BufferedDataInputStream vis = new BufferedDataInputStream(filename);
        this.len = vis.readLong();
        this.loPool = vis.readInt();
        this.hiPool = vis.readInt();
        this.enqIndex = vis.readInt();
        this.deqIndex = vis.readInt();
        this.lastLoPool = this.loPool - 1;
        int i = 0;
        while (i < this.enqIndex) {
            this.enqBuf[i] = new byte[vis.readInt()];
            vis.read(this.enqBuf[i]);
            ++i;
        }
        i = this.deqIndex;
        while (i < this.deqBuf.length) {
            this.deqBuf[i] = new byte[vis.readInt()];
            vis.read(this.deqBuf[i]);
            ++i;
        }
        vis.close();
        File file = new File(this.filePrefix + Integer.toString(this.lastLoPool));
        boolean canRead = this.lastLoPool < this.hiPool;
        this.reader.restart(file, canRead);
        String pstr = Integer.toString(this.loPool);
        this.loFile = new File(this.filePrefix + pstr);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void finishAll() {
        super.finishAll();
        Thread thread = this.writer;
        synchronized (thread) {
            this.writer.notifyAll();
        }
        thread = this.reader;
        synchronized (thread) {
            this.reader.setFinished();
            this.reader.notifyAll();
        }
        thread = this.cleaner;
        synchronized (thread) {
            this.cleaner.finished = true;
            this.cleaner.notifyAll();
        }
    }

    @Override
    public void delete() {
        this.finishAll();
        new File(this.filePrefix).delete();
    }

    private static final class ByteArrayPoolReader
    extends Thread {
        private byte[][] buf;
        private File poolFile;
        private boolean isFull;
        private boolean canRead;
        private boolean finished = false;

        public ByteArrayPoolReader(int bufSize, File file) {
            super("RawTLCStatePoolReader");
            this.buf = new byte[bufSize][];
            this.poolFile = file;
            this.isFull = false;
            this.canRead = false;
        }

        public final synchronized void wakeup() {
            this.canRead = true;
            this.notify();
        }

        public final synchronized void restart(File file, boolean canRead) {
            this.poolFile = file;
            this.isFull = false;
            this.canRead = canRead;
            this.notify();
        }

        public final synchronized byte[][] doWork(byte[][] deqBuf, File file) throws IOException, ClassNotFoundException {
            if (this.isFull) {
                assert (this.poolFile == null) : 2137;
                byte[][] res = this.buf;
                this.buf = deqBuf;
                this.poolFile = file;
                this.isFull = false;
                this.canRead = true;
                this.notify();
                return res;
            }
            if (this.poolFile != null) {
                BufferedDataInputStream vis = new BufferedDataInputStream(this.poolFile);
                int i = 0;
                while (i < deqBuf.length) {
                    deqBuf[i] = new byte[vis.readInt()];
                    vis.read(deqBuf[i]);
                    ++i;
                }
                vis.close();
                this.poolFile = file;
                this.canRead = true;
                this.notify();
                return deqBuf;
            }
            BufferedDataInputStream vis = new BufferedDataInputStream(this.poolFile);
            int i = 0;
            while (i < deqBuf.length) {
                deqBuf[i] = new byte[vis.readInt()];
                vis.read(deqBuf[i]);
                ++i;
            }
            vis.close();
            return deqBuf;
        }

        public final synchronized byte[][] getCache(byte[][] deqBuf, File file) throws IOException, ClassNotFoundException {
            if (this.isFull) {
                assert (this.poolFile == null) : 2137;
                byte[][] res = this.buf;
                this.buf = deqBuf;
                this.poolFile = file;
                this.isFull = false;
                this.canRead = false;
                return res;
            }
            if (this.poolFile != null && this.canRead) {
                BufferedDataInputStream vis = new BufferedDataInputStream(this.poolFile);
                int i = 0;
                while (i < deqBuf.length) {
                    deqBuf[i] = new byte[vis.readInt()];
                    vis.read(deqBuf[i]);
                    ++i;
                }
                vis.close();
                this.poolFile = file;
                this.canRead = false;
                return deqBuf;
            }
            return null;
        }

        public final synchronized void beginChkpt(ObjectOutputStream oos) throws IOException {
            boolean hasFile = this.poolFile != null;
            oos.writeBoolean(hasFile);
            oos.writeBoolean(this.canRead);
            oos.writeBoolean(this.isFull);
            if (hasFile) {
                oos.writeObject(this.poolFile);
            }
            if (this.isFull) {
                int i = 0;
                while (i < this.buf.length) {
                    oos.writeObject(this.buf[i]);
                    ++i;
                }
            }
        }

        public final void recover(ObjectInputStream ois) throws IOException {
            boolean hasFile = ois.readBoolean();
            this.canRead = ois.readBoolean();
            this.isFull = ois.readBoolean();
            try {
                if (hasFile) {
                    this.poolFile = (File)ois.readObject();
                }
                if (this.isFull) {
                    int i = 0;
                    while (i < this.buf.length) {
                        this.buf[i] = (byte[])ois.readObject();
                        ++i;
                    }
                }
            }
            catch (ClassNotFoundException e) {
                Assert.fail(2126, e);
            }
        }

        @Override
        public void run() {
            try {
                ByteArrayPoolReader byteArrayPoolReader = this;
                synchronized (byteArrayPoolReader) {
                    while (true) {
                        if (this.poolFile == null || this.isFull || !this.canRead) {
                            this.wait();
                            if (!this.finished) continue;
                            return;
                        }
                        BufferedDataInputStream vis = new BufferedDataInputStream(this.poolFile);
                        int i = 0;
                        while (i < this.buf.length) {
                            this.buf[i] = new byte[vis.readInt()];
                            vis.read(this.buf[i]);
                            ++i;
                        }
                        vis.close();
                        this.poolFile = null;
                        this.isFull = true;
                    }
                }
            }
            catch (Exception e) {
                String[] stringArray;
                if (this.poolFile == null) {
                    String[] stringArray2 = new String[1];
                    stringArray = stringArray2;
                    stringArray2[0] = e.getMessage();
                } else {
                    String[] stringArray3 = new String[2];
                    stringArray3[0] = e.getMessage();
                    stringArray = stringArray3;
                    stringArray3[1] = this.poolFile.getName();
                }
                String[] cause = stringArray;
                MP.printError(2125, cause, (Throwable)e);
                System.exit(1);
                return;
            }
        }

        public void setFinished() {
            this.finished = true;
        }
    }

    private static final class ByteArrayPoolWriter
    extends Thread {
        private byte[][] buf;
        private File poolFile;
        private final ByteArrayPoolReader reader;

        public ByteArrayPoolWriter(int bufSize, ByteArrayPoolReader reader) {
            super("RawTLCStatePoolWriter");
            this.buf = new byte[bufSize][];
            this.poolFile = null;
            this.reader = reader;
        }

        public final synchronized byte[][] doWork(byte[][] enqBuf, File file) throws IOException {
            if (this.poolFile != null) {
                BufferedDataOutputStream vos = new BufferedDataOutputStream(this.poolFile);
                int i = 0;
                while (i < this.buf.length) {
                    vos.writeInt(this.buf[i].length);
                    vos.write(this.buf[i]);
                    ++i;
                }
                vos.close();
            }
            byte[][] res = this.buf;
            this.buf = enqBuf;
            this.poolFile = file;
            this.notify();
            return res;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public final void ensureWritten() throws InterruptedException {
            ByteArrayPoolWriter byteArrayPoolWriter = this;
            synchronized (byteArrayPoolWriter) {
                while (this.poolFile != null) {
                    this.wait();
                }
            }
        }

        public final synchronized void beginChkpt(ObjectOutputStream oos) throws IOException {
            boolean hasFile = this.poolFile != null;
            oos.writeBoolean(hasFile);
            if (hasFile) {
                oos.writeObject(this.poolFile);
                int i = 0;
                while (i < this.buf.length) {
                    oos.writeObject(this.buf[i]);
                    ++i;
                }
            }
        }

        public final void recover(ObjectInputStream ois) throws IOException {
            boolean hasFile = ois.readBoolean();
            if (hasFile) {
                try {
                    this.poolFile = (File)ois.readObject();
                    int i = 0;
                    while (i < this.buf.length) {
                        this.buf[i] = (byte[])ois.readObject();
                        ++i;
                    }
                }
                catch (ClassNotFoundException e) {
                    Assert.fail(2126, e);
                }
            } else {
                this.poolFile = null;
            }
        }

        @Override
        public void run() {
            try {
                ByteArrayPoolWriter byteArrayPoolWriter = this;
                synchronized (byteArrayPoolWriter) {
                    while (true) {
                        if (this.poolFile == null) {
                            this.wait();
                            if (this.poolFile != null) continue;
                            return;
                        }
                        BufferedDataOutputStream vos = new BufferedDataOutputStream(this.poolFile);
                        int i = 0;
                        while (i < this.buf.length) {
                            vos.writeInt(this.buf[i].length);
                            vos.write(this.buf[i]);
                            ++i;
                        }
                        vos.close();
                        this.poolFile = null;
                        this.notify();
                        if (this.reader == null) continue;
                        this.reader.wakeup();
                    }
                }
            }
            catch (Exception e) {
                MP.printError(2127, e.getMessage(), (Throwable)e);
                System.exit(1);
                return;
            }
        }
    }

    static final class ByteValueInputStream
    implements ValueConstants,
    IValueInputStream,
    IDataInputStream {
        private final byte[] bytes;
        private int idx = 0;

        public ByteValueInputStream(byte[] bytes) {
            this.bytes = bytes;
        }

        @Override
        public final IValue read() throws IOException {
            byte kind = this.readByte();
            switch (kind) {
                case 0: {
                    return this.readBoolean() ? BoolValue.ValTrue : BoolValue.ValFalse;
                }
                case 1: {
                    return IntValue.gen(this.readInt());
                }
                case 3: {
                    return StringValue.createFrom(this);
                }
                case 21: {
                    return ModelValue.mvs[this.readShort()];
                }
                case 23: {
                    return new IntervalValue(this.readInt(), this.readInt());
                }
                case 4: {
                    return RecordValue.createFrom(this);
                }
                case 9: {
                    return FcnRcdValue.createFrom(this);
                }
                case 5: {
                    return SetEnumValue.createFrom(this);
                }
                case 7: {
                    return TupleValue.createFrom(this);
                }
            }
            throw new WrongInvocationException("ValueInputStream: Can not unpickle a value of kind " + kind);
        }

        private final boolean readBoolean() throws EOFException, IOException {
            return this.bytes[this.idx++] != 0;
        }

        @Override
        public final int readShort() throws IOException {
            return (short)(this.bytes[this.idx++] << 8 | this.bytes[this.idx++] & 0xFF);
        }

        @Override
        public final int readInt() throws IOException {
            int res = this.bytes[this.idx++];
            res <<= 8;
            res |= this.bytes[this.idx++] & 0xFF;
            res <<= 8;
            res |= this.bytes[this.idx++] & 0xFF;
            res <<= 8;
            return res |= this.bytes[this.idx++] & 0xFF;
        }

        @Override
        public final long readLong() throws IOException {
            long res = this.bytes[this.idx++];
            res <<= 8;
            res |= (long)(this.bytes[this.idx++] & 0xFF);
            res <<= 8;
            res |= (long)(this.bytes[this.idx++] & 0xFF);
            res <<= 8;
            res |= (long)(this.bytes[this.idx++] & 0xFF);
            res <<= 8;
            res |= (long)(this.bytes[this.idx++] & 0xFF);
            res <<= 8;
            res |= (long)(this.bytes[this.idx++] & 0xFF);
            res <<= 8;
            res |= (long)(this.bytes[this.idx++] & 0xFF);
            res <<= 8;
            return res |= (long)(this.bytes[this.idx++] & 0xFF);
        }

        @Override
        public final void close() throws IOException {
        }

        @Override
        public final int readNat() throws IOException {
            int res = this.readShort();
            if (res >= 0) {
                return res;
            }
            res = res << 16 | this.readShort() & 0xFFFF;
            return -res;
        }

        @Override
        public final short readShortNat() throws IOException {
            byte res = this.readByte();
            if (res >= 0) {
                return res;
            }
            return (short)(-(res << 8 | this.readByte() & 0xFF));
        }

        @Override
        public final long readLongNat() throws IOException {
            long res = this.readInt();
            if (res >= 0L) {
                return res;
            }
            res = res << 32 | (long)this.readInt() & 0xFFFFFFFFL;
            return -res;
        }

        @Override
        public final byte readByte() throws EOFException, IOException {
            return this.bytes[this.idx++];
        }

        @Override
        public final void assign(Object obj, int idx) {
        }

        @Override
        public final int getIndex() {
            return -1;
        }

        @Override
        public final IDataInputStream getInputStream() {
            return this;
        }

        @Override
        public final UniqueString getValue(int idx) {
            throw new WrongInvocationException("Not supported");
        }

        @Override
        public final String readString(int length) throws IOException {
            char[] s = new char[length];
            int i = 0;
            while (i < s.length) {
                s[i] = (char)this.bytes[this.idx++];
                ++i;
            }
            return new String(s);
        }
    }

    static final class ByteValueOutputStream
    implements IValueOutputStream,
    IDataOutputStream {
        private byte[] bytes = new byte[16];
        private int idx = 0;

        private void ensureCapacity(int minCap) {
            if (minCap - this.bytes.length > 0) {
                int oldCap = this.bytes.length;
                int newCap = oldCap << 1;
                if (newCap - minCap < 0) {
                    newCap = minCap;
                }
                this.bytes = Arrays.copyOf(this.bytes, newCap);
            }
        }

        @Override
        public final void writeShort(short s) throws IOException {
            this.ensureCapacity(this.idx + 2);
            this.bytes[this.idx++] = (byte)(s >>> 8 & 0xFF);
            this.bytes[this.idx++] = (byte)(s & 0xFF);
        }

        @Override
        public final void writeInt(int i) throws IOException {
            this.ensureCapacity(this.idx + 4);
            this.bytes[this.idx++] = (byte)(i >>> 24 & 0xFF);
            this.bytes[this.idx++] = (byte)(i >>> 16 & 0xFF);
            this.bytes[this.idx++] = (byte)(i >>> 8 & 0xFF);
            this.bytes[this.idx++] = (byte)(i & 0xFF);
        }

        @Override
        public final void writeLong(long l) throws IOException {
            this.ensureCapacity(this.idx + 8);
            this.bytes[this.idx++] = (byte)(l >>> 56 & 0xFFL);
            this.bytes[this.idx++] = (byte)(l >>> 48 & 0xFFL);
            this.bytes[this.idx++] = (byte)(l >>> 40 & 0xFFL);
            this.bytes[this.idx++] = (byte)(l >>> 32 & 0xFFL);
            this.bytes[this.idx++] = (byte)(l >>> 24 & 0xFFL);
            this.bytes[this.idx++] = (byte)(l >>> 16 & 0xFFL);
            this.bytes[this.idx++] = (byte)(l >>> 8 & 0xFFL);
            this.bytes[this.idx++] = (byte)(l & 0xFFL);
        }

        @Override
        public final void close() throws IOException {
        }

        @Override
        public final void writeShortNat(short x) throws IOException {
            if (x > 127) {
                this.writeShort(-x);
            } else {
                this.writeByte((byte)x);
            }
        }

        @Override
        public final void writeNat(int x) throws IOException {
            if (x > Short.MAX_VALUE) {
                this.writeInt(-x);
            } else {
                this.writeShort((short)x);
            }
        }

        @Override
        public final void writeLongNat(long x) throws IOException {
            if (x <= Integer.MAX_VALUE) {
                this.writeInt((int)x);
            } else {
                this.writeLong(-x);
            }
        }

        @Override
        public final void writeByte(byte b) throws IOException {
            this.ensureCapacity(this.idx + 1);
            this.bytes[this.idx++] = b;
        }

        @Override
        public final void writeBoolean(boolean bool) throws IOException {
            byte b = bool ? (byte)1 : 0;
            this.writeByte(b);
        }

        @Override
        public final IDataOutputStream getOutputStream() {
            return this;
        }

        @Override
        public final int put(Object obj) {
            return -1;
        }

        public final byte[] toByteArray() {
            byte[] copyOf = Arrays.copyOf(this.bytes, this.idx);
            this.idx = 0;
            return copyOf;
        }

        @Override
        public final void writeString(String str) throws IOException {
            int length = str.length();
            this.ensureCapacity(this.idx + length);
            char[] c = new char[length];
            str.getChars(0, length, c, 0);
            int i = 0;
            while (i < c.length) {
                this.bytes[this.idx++] = (byte)c[i];
                ++i;
            }
        }
    }

    private class StatePoolCleaner
    extends Thread {
        private volatile boolean finished;
        public int deleteUpTo;

        private StatePoolCleaner() {
            super("RawTLCStatePoolCleaner");
            this.finished = false;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            try {
                StatePoolCleaner statePoolCleaner = this;
                synchronized (statePoolCleaner) {
                    while (!this.finished) {
                        this.wait();
                        if (this.finished) {
                            return;
                        }
                        int i = DiskByteArrayQueue.this.lastLoPool;
                        while (i < this.deleteUpTo) {
                            File oldPoolFile = new File(DiskByteArrayQueue.this.filePrefix + Integer.toString(i));
                            if (!oldPoolFile.delete()) {
                                MP.printWarning(2270, oldPoolFile.getCanonicalPath());
                            }
                            ++i;
                        }
                        DiskByteArrayQueue.this.lastLoPool = this.deleteUpTo;
                    }
                }
            }
            catch (Exception e) {
                MP.printError(2270, e.getMessage(), (Throwable)e);
                System.exit(1);
            }
        }
    }
}

