/*
 * Decompiled with CFR 0.152.
 */
package tlc2.pprint;

import tlc2.output.MP;
import tlc2.pprint.Format;
import tlc2.pprint.FormatException;
import tlc2.pprint.Node;
import tlc2.pprint.Parse;
import tlc2.pprint.ParseException;
import util.ToolIO;

public class PrettyPrint {
    public static String mypp(String value, int width) {
        try {
            Node tree = Parse.parse(value, 0);
            if (tree.last() < value.length() - 1) {
                return value;
            }
            String format = Format.format(tree, width, 0, "");
            return format;
        }
        catch (Exception e) {
            return value;
        }
    }

    public static String pp(String value, int width) {
        return PrettyPrint.pp(value, width, "");
    }

    public static String pp(String value, int width, String padding) {
        try {
            Node tree = Parse.parse(value, 0);
            String format = Format.format(tree, width, 0, padding);
            return format;
        }
        catch (ParseException e) {
            MP.printTLCBug(2000, new String[]{value, e.getMessage()});
            return value;
        }
        catch (FormatException e) {
            MP.printTLCBug(2001, new String[]{value, e.getMessage()});
            return value;
        }
    }

    public static void main(String[] argv) {
        String value = argv[0];
        int width = Integer.parseInt(argv[1]);
        String padding = argv.length > 2 ? argv[2] : "";
        int i = 0;
        while (i < width) {
            ToolIO.out.print("*");
            ++i;
        }
        ToolIO.out.println("");
        ToolIO.out.println(PrettyPrint.pp(value, width, padding));
        i = 0;
        while (i < width) {
            ToolIO.out.print("*");
            ++i;
        }
        ToolIO.out.println("");
    }
}

