/*
 * Decompiled with CFR 0.152.
 */
package tlc2.debug;

import java.net.URI;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Random;
import java.util.Set;
import java.util.TreeSet;
import java.util.concurrent.CompletableFuture;
import org.eclipse.lsp4j.debug.ContinueResponse;
import org.eclipse.lsp4j.debug.EvaluateArguments;
import org.eclipse.lsp4j.debug.EvaluateResponse;
import org.eclipse.lsp4j.debug.Scope;
import org.eclipse.lsp4j.debug.Source;
import org.eclipse.lsp4j.debug.StackFrame;
import org.eclipse.lsp4j.debug.StackFramePresentationHint;
import org.eclipse.lsp4j.debug.StoppedEventArguments;
import org.eclipse.lsp4j.debug.Variable;
import tla2sany.parser.SyntaxTreeNode;
import tla2sany.semantic.ExprOrOpArgNode;
import tla2sany.semantic.FormalParamNode;
import tla2sany.semantic.ModuleNode;
import tla2sany.semantic.NumeralNode;
import tla2sany.semantic.OpApplNode;
import tla2sany.semantic.OpDeclNode;
import tla2sany.semantic.OpDefNode;
import tla2sany.semantic.OpDefOrDeclNode;
import tla2sany.semantic.SemanticNode;
import tla2sany.semantic.SymbolNode;
import tla2sany.st.Location;
import tlc2.debug.DebugTLCVariable;
import tlc2.debug.IDebugTarget;
import tlc2.debug.TLCDebugger;
import tlc2.debug.TLCDebuggerExpression;
import tlc2.debug.TLCSourceBreakpoint;
import tlc2.tool.EvalException;
import tlc2.tool.FingerprintException;
import tlc2.tool.INextStateFunctor;
import tlc2.tool.TLCState;
import tlc2.tool.impl.SpecProcessor;
import tlc2.tool.impl.Tool;
import tlc2.tool.impl.WorkerValue;
import tlc2.util.Context;
import tlc2.value.IValue;
import tlc2.value.impl.LazyValue;
import tlc2.value.impl.StringValue;
import tlc2.value.impl.TLCVariable;
import tlc2.value.impl.Value;
import util.Assert;
import util.UniqueString;

public class TLCStackFrame
extends StackFrame {
    private static final Map<SemanticNode, String> PATH_CACHE = new HashMap<SemanticNode, String>();
    public static final String EXCEPTION = "Exception";
    public static final String CONSTANTS = "Constants";
    public static final String SCOPE = "Context";
    public static final String STACK = "Stack";
    protected static final Random rnd = new Random();
    protected final transient Map<Integer, DebugTLCVariable> nestedVariables = new HashMap<Integer, DebugTLCVariable>();
    protected final transient Map<Integer, List<DebugTLCVariable>> nestedConstants = new HashMap<Integer, List<DebugTLCVariable>>();
    protected final transient SemanticNode node;
    protected final transient Context ctxt;
    protected final transient Tool tool;
    protected final transient RuntimeException exception;
    protected transient Value v;
    protected transient TLCStackFrame parent;
    protected final int ctxtId;

    TLCStackFrame(int id) {
        this.node = null;
        this.ctxt = null;
        this.tool = null;
        this.exception = null;
        this.ctxtId = -1;
        this.setId(id);
    }

    public TLCStackFrame(TLCStackFrame parent, SemanticNode node, Context ctxt, Tool tool, RuntimeException e) {
        this.parent = parent;
        this.tool = tool;
        Assert.check(this.tool != null, 1000);
        if (e instanceof Assert.TLCDetailedRuntimeException) {
            Assert.TLCDetailedRuntimeException dre = (Assert.TLCDetailedRuntimeException)e;
            this.node = dre.expr;
            this.ctxt = dre.ctxt;
        } else {
            this.node = node;
            this.ctxt = ctxt;
        }
        Assert.check(this.node != null, 1000);
        Assert.check(this.ctxt != null, 1000);
        this.exception = e;
        if (node instanceof NumeralNode) {
            this.setName(Integer.toString(((NumeralNode)node).val()));
        } else if (e instanceof INextStateFunctor.InvariantViolatedException) {
            this.setName(String.format("(Invariant) %s", node.getHumanReadableImage()));
            this.setPresentationHint(StackFramePresentationHint.SUBTLE);
        } else if (e != null) {
            this.setName(String.format("(Exception) %s", node.getHumanReadableImage()));
            this.setPresentationHint(StackFramePresentationHint.SUBTLE);
        } else {
            this.setName(node.getHumanReadableImage());
        }
        this.setId(node.myUID ^ rnd.nextInt(0x7FFFFFFE) + 1);
        Location location = node.getLocation();
        this.setLine(location.beginLine());
        this.setEndLine(location.endLine());
        this.setColumn(location.beginColumn());
        this.setEndColumn(location.endColumn() + 1);
        Source source = new Source();
        source.setName(node.getLocation().source());
        source.setPath(PATH_CACHE.computeIfAbsent(node, n -> tool.getResolver().resolve(n.getTreeNode().getFilename(), true).getAbsolutePath().toString()));
        this.setSource(source);
        this.ctxtId = rnd.nextInt(0x7FFFFFFE) + 1;
    }

    public TLCStackFrame(TLCStackFrame parent, SemanticNode node, Context ctxt, Tool tool) {
        this(parent, node, ctxt, tool, null);
    }

    protected DebugTLCVariable getStateAsVariable(IValue value, String varName) {
        DebugTLCVariable variable = this.getVariable(value, UniqueString.of(varName));
        variable.setType("State");
        variable.setVscodeVariableMenuContext("state");
        return variable;
    }

    private Variable getVariable(IValue val, SymbolNode expr) {
        if (!val.hasSource()) {
            val.setSource(expr);
        }
        return this.getVariable(val, expr.getName());
    }

    protected Variable getVariable(IValue value, String varName) {
        return this.getVariable(value, UniqueString.of(varName));
    }

    protected DebugTLCVariable getVariable(IValue value, UniqueString varName) {
        DebugTLCVariable variable = (DebugTLCVariable)value.toTLCVariable(new DebugTLCVariable(varName), rnd);
        this.nestedVariables.put(variable.getVariablesReference(), variable);
        return variable;
    }

    protected List<Variable> getStackVariables(List<Variable> vars) {
        Variable variable;
        if (this.v != null && !vars.contains(variable = this.getVariable((IValue)this.v, ((SyntaxTreeNode)this.node.getTreeNode()).getHumanReadableImage()))) {
            vars.add(variable);
        }
        if (this.parent != null) {
            return this.parent.getStackVariables(vars);
        }
        return vars;
    }

    protected boolean hasStackVariables() {
        if (this.v != null) {
            return true;
        }
        if (this.parent != null) {
            return this.parent.hasStackVariables();
        }
        return false;
    }

    Variable[] getVariables() {
        return this.getVariables(this.ctxtId);
    }

    Variable[] getConstants() {
        return this.getVariables(this.getConstantsId());
    }

    Variable[] getExceptionAsVariable() {
        Variable variable = new Variable();
        variable.setName(this.getNode().getHumanReadableImage());
        RuntimeException re = this.exception;
        variable.setValue(re.getMessage());
        variable.setType(re.getClass().getSimpleName());
        return new Variable[]{variable};
    }

    public Variable[] getVariables(int vr) {
        return this.tool.eval(() -> {
            ArrayList<Variable> vars = new ArrayList<Variable>();
            if (this.nestedVariables.containsKey(vr)) {
                List<TLCVariable> nested = this.nestedVariables.get(vr).getNested(rnd);
                for (TLCVariable n2 : nested) {
                    DebugTLCVariable d = (DebugTLCVariable)n2;
                    this.nestedVariables.put(d.getVariablesReference(), d);
                    vars.add(d);
                }
            }
            if (this.nestedConstants.containsKey(vr)) {
                List<DebugTLCVariable> cntsts = this.nestedConstants.get(vr);
                for (DebugTLCVariable c : cntsts) {
                    this.nestedVariables.put(c.getVariablesReference(), c);
                    List<TLCVariable> nested = c.getNested(rnd);
                    for (TLCVariable n3 : nested) {
                        DebugTLCVariable d = (DebugTLCVariable)n3;
                        this.nestedVariables.put(d.getVariablesReference(), d);
                    }
                }
                vars.addAll(cntsts);
            }
            if (this.ctxtId == vr) {
                Context c = this.ctxt;
                while (c.hasNext()) {
                    Variable variable;
                    Object val = WorkerValue.mux(c.getValue());
                    if (val instanceof LazyValue) {
                        val = this.unlazy((LazyValue)c.getValue());
                    }
                    if (val instanceof Value) {
                        vars.add(this.getVariable((IValue)((Value)val), c.getName()));
                    } else if (val instanceof SemanticNode) {
                        variable = new Variable();
                        variable.setName(c.getName().getSignature());
                        variable.setValue(((SemanticNode)val).getHumanReadableImage());
                        vars.add(variable);
                    } else if (val instanceof RuntimeException) {
                        variable = new Variable();
                        variable.setName(c.getName().getName().toString());
                        variable.setValue(WorkerValue.mux(c.getValue()).toString());
                        RuntimeException re = (RuntimeException)val;
                        variable.setType(re.getMessage());
                        vars.add(variable);
                    } else if (val != null || c.getName() != null) {
                        System.err.println("This is interesting!!! What's this??? " + String.valueOf(val));
                    }
                    c = c.next();
                }
            } else if (this.getConstantsId() == vr) {
                this.getConstants(vars);
            } else if (this.getStackId() == vr) {
                List<Variable> pVars = this.getStackVariables(new ArrayList<Variable>());
                return (Variable[])pVars.toArray(Variable[]::new);
            }
            return this.toSortedDistinctArray(vars);
        });
    }

    private void getConstants(List<Variable> vars) {
        SpecProcessor sp = this.tool.getSpecProcessor();
        Map<ModuleNode, Map<OpDefOrDeclNode, Object>> constantDefns = sp.getConstantDefns();
        for (Map.Entry<ModuleNode, Map<OpDefOrDeclNode, Object>> e : constantDefns.entrySet()) {
            if (constantDefns.size() == 1) {
                e.getValue().entrySet().stream().map(c -> this.getVariable((IValue)((Value)WorkerValue.mux(c.getValue())), ((OpDefOrDeclNode)c.getKey()).getName())).forEach(var -> {
                    boolean bl = vars.add((Variable)var);
                });
                continue;
            }
            ModuleNode module = e.getKey();
            Variable v = new Variable();
            v.setValue(e.getValue().keySet().stream().filter(OpDefNode.class::isInstance).map(OpDefNode.class::cast).map(OpDefNode::getPathName).findAny().orElse(UniqueString.of(module.getSignature())).toString());
            v.setName(module.getSignature());
            v.setVariablesReference(rnd.nextInt(0x7FFFFFFE) + 1);
            vars.add(v);
            ArrayList<DebugTLCVariable> l = new ArrayList<DebugTLCVariable>();
            Set<Map.Entry<OpDefOrDeclNode, Object>> entrySet = e.getValue().entrySet();
            for (Map.Entry<OpDefOrDeclNode, Object> entry : entrySet) {
                OpDefOrDeclNode odn;
                OpDefOrDeclNode oddn = entry.getKey();
                Object value = WorkerValue.mux(entry.getValue());
                if (oddn instanceof OpDefNode) {
                    odn = (OpDefNode)oddn;
                    l.add((DebugTLCVariable)((Value)value).toTLCVariable(new DebugTLCVariable(((OpDefNode)odn).getLocalName()), rnd));
                    continue;
                }
                odn = (OpDeclNode)oddn;
                l.add((DebugTLCVariable)((Value)value).toTLCVariable(new DebugTLCVariable(odn.getSignature()), rnd));
            }
            this.nestedConstants.put(v.getVariablesReference(), l);
        }
    }

    protected Variable[] toSortedDistinctArray(List<Variable> vars) {
        TreeSet<Variable> s = new TreeSet<Variable>(new Comparator<Variable>(){

            @Override
            public int compare(Variable o1, Variable o2) {
                if (o1 instanceof Comparable && o2 instanceof Comparable) {
                    return ((Comparable)((Object)o1)).compareTo(o2);
                }
                return o1.getName().compareTo(o2.getName());
            }
        });
        s.addAll(vars);
        return (Variable[])s.toArray(Variable[]::new);
    }

    protected Variable getVariable(LinkedList<SemanticNode> path) {
        Variable variable;
        assert (!path.isEmpty());
        SemanticNode sn = path.getFirst();
        Object o = sn instanceof SymbolNode ? this.tool.lookup((SymbolNode)sn, this.ctxt, false) : (sn instanceof ExprOrOpArgNode ? this.tool.getVal((ExprOrOpArgNode)path.stream().filter(seg -> seg instanceof OpApplNode).findFirst().orElse(sn), this.ctxt, false) : sn);
        if (o instanceof LazyValue) {
            o = this.unlazy((LazyValue)o, sn);
        }
        if (o instanceof Value) {
            variable = this.getVariable((IValue)o, sn.getHumanReadableImage());
            variable.setType(((Value)o).getTypeString());
        } else {
            variable = new Variable();
            variable.setValue(o instanceof SymbolNode && ((SymbolNode)o).isBuiltIn() ? ((SymbolNode)o).getLocation().toString() : o.toString());
            variable.setType(o.getClass().getSimpleName());
        }
        return variable;
    }

    public EvaluateResponse get(EvaluateArguments ea) {
        EvaluateResponse er = new EvaluateResponse();
        try {
            URI u = URI.create(ea.getExpression());
            String moduleName = Paths.get(u.getPath(), new String[0]).getFileName().toString().replaceAll(".tla$", "");
            Location location = Location.parseCoordinates(moduleName, u.getFragment());
            LinkedList<SemanticNode> path = this.tool.getModule(location.source()).pathTo(location);
            if (path.isEmpty()) {
                er.setResult(location.toString());
                return er;
            }
            Variable v = this.getVariable(path);
            if (v != null) {
                er.setResult(v.getValue());
                er.setType(v.getType());
                er.setVariablesReference(v.getVariablesReference());
            }
            return er;
        }
        catch (IllegalArgumentException e) {
            return er;
        }
    }

    protected TLCState getS() {
        return TLCState.Empty;
    }

    protected TLCState getT() {
        return TLCState.Empty;
    }

    public EvaluateResponse getWatch(OpDefNode odn) {
        Variable variable;
        if (odn == null) {
            return new EvaluateResponse();
        }
        try {
            variable = this.tool.eval(() -> this.getVariable(this.tool.eval(odn.getBody(), this.getContext(), this.getS(), this.getT(), 0), odn.getName()));
        }
        catch (EvalException | FingerprintException | Assert.TLCRuntimeException e) {
            variable = this.getVariable((IValue)new StringValue(e.getMessage() == null ? "" : e.getMessage()), odn.getName());
        }
        EvaluateResponse er = new EvaluateResponse();
        er.setResult(variable.getValue());
        er.setVariablesReference(variable.getVariablesReference());
        return er;
    }

    protected Object unlazy(LazyValue lv) {
        return this.unlazy(lv, null);
    }

    protected Object unlazy(LazyValue lv, Object fallback) {
        try {
            return this.tool.eval(() -> lv.eval(this.tool));
        }
        catch (NullPointerException | EvalException | FingerprintException | Assert.TLCRuntimeException e) {
            return fallback == null ? e : fallback;
        }
    }

    public Scope[] getScopes() {
        Scope scope;
        ArrayList<Scope> scopes = new ArrayList<Scope>();
        if (!this.ctxt.isEmpty()) {
            scope = new Scope();
            scope.setName(SCOPE);
            scope.setVariablesReference(this.ctxtId);
            scopes.add(scope);
        }
        if (!this.tool.getSpecProcessor().getConstantDefns().isEmpty()) {
            scope = new Scope();
            scope.setName(CONSTANTS);
            scope.setVariablesReference(this.getConstantsId());
            scope.setPresentationHint("registers");
            scopes.add(scope);
        }
        if (this.hasStackVariables()) {
            scope = new Scope();
            scope.setName(STACK);
            scope.setVariablesReference(this.getStackId());
            scopes.add(scope);
        }
        return scopes.toArray(new Scope[scopes.size()]);
    }

    public SemanticNode getNode() {
        return this.node;
    }

    public Context getContext() {
        return this.ctxt;
    }

    public Tool getTool() {
        return this.tool;
    }

    public boolean hasException() {
        return this.exception != null;
    }

    public Exception getException() {
        return this.exception;
    }

    @Override
    public String toString() {
        return "TLCStackFrame [node=" + String.valueOf(this.node) + "]";
    }

    public Value setValue(Value v) {
        assert (this.v == null);
        this.v = v;
        return v;
    }

    public int getConstantsId() {
        return this.ctxtId + 1;
    }

    public int getStackId() {
        return this.ctxtId + 3;
    }

    public StoppedEventArguments getStoppedEventArgument() {
        StoppedEventArguments eventArguments = new StoppedEventArguments();
        if (this.exception != null) {
            eventArguments.setReason("exception");
            eventArguments.setText(this.exception.getMessage().replaceAll("(?m)^@!@!@.*", ""));
        } else {
            eventArguments.setReason("");
        }
        return eventArguments;
    }

    public boolean matches(TLCStackFrame f) {
        if (this.node.getTreeNode().getLevel() == f.node.getTreeNode().getLevel()) {
            return SyntaxTreeNode.getOperatorDefinition(this.node.getTreeNode()) == SyntaxTreeNode.getOperatorDefinition(f.node.getTreeNode());
        }
        return false;
    }

    public boolean matches(TLCSourceBreakpoint bp) {
        return bp.matchesLocation(this.node.getLocation());
    }

    boolean matches(SemanticNode expr, RuntimeException e) {
        return this.node == expr || e instanceof Assert.TLCDetailedRuntimeException && ((Assert.TLCDetailedRuntimeException)e).expr == this.node;
    }

    public boolean matches(SemanticNode expr) {
        return this.node == expr;
    }

    public boolean isTarget(SemanticNode expr) {
        return this.node == expr;
    }

    public void postHalt(TLCDebugger tlcDebugger) {
    }

    public void preHalt(TLCDebugger tlcDebugger) {
    }

    public CompletableFuture<Void> stepOut(TLCDebugger debugger) {
        debugger.setGranularity(IDebugTarget.Granularity.Formula);
        debugger.notify();
        return CompletableFuture.completedFuture(null);
    }

    public CompletableFuture<Void> stepIn(TLCDebugger debugger) {
        debugger.setGranularity(IDebugTarget.Granularity.Formula);
        debugger.notify();
        return CompletableFuture.completedFuture(null);
    }

    public CompletableFuture<Void> stepOver(TLCDebugger debugger) {
        debugger.setGranularity(IDebugTarget.Granularity.Formula);
        debugger.notify();
        return CompletableFuture.completedFuture(null);
    }

    public CompletableFuture<ContinueResponse> continue_(TLCDebugger debugger) {
        debugger.setGranularity(IDebugTarget.Granularity.Formula);
        debugger.notify();
        return CompletableFuture.completedFuture(new ContinueResponse());
    }

    public CompletableFuture<Void> reverseContinue(TLCDebugger debugger) {
        debugger.setGranularity(IDebugTarget.Granularity.Formula);
        debugger.notify();
        return CompletableFuture.completedFuture(null);
    }

    public CompletableFuture<Void> stepBack(TLCDebugger debugger) {
        debugger.setGranularity(IDebugTarget.Granularity.Formula);
        debugger.notify();
        return CompletableFuture.completedFuture(null);
    }

    public CompletableFuture<Void> gotoState(TLCDebugger debugger, int id) {
        debugger.setGranularity(IDebugTarget.Granularity.Formula);
        debugger.notify();
        return CompletableFuture.completedFuture(null);
    }

    public boolean handle(TLCDebugger debugger) {
        return false;
    }

    public EvaluateResponse evaluate(String expression) {
        if (expression == null) {
            return new EvaluateResponse();
        }
        try {
            SpecProcessor proc = this.tool.getSpecProcessor();
            OpDefNode expr = TLCDebuggerExpression.process(proc, proc.getRootModule(), this.node.getLocation(), expression);
            if (expr == null) {
                EvaluateResponse er = new EvaluateResponse();
                er.setResult(expression);
                return er;
            }
            Context ctxt = this.getEvaluateContext();
            FormalParamNode[] formalParamNodeArray = expr.getParams();
            int n = formalParamNodeArray.length;
            int n2 = 0;
            while (n2 < n) {
                FormalParamNode p = formalParamNodeArray[n2];
                ctxt = ctxt.cons(p, this.getContext().lookup(sn -> sn.getName().equals(p.getName())));
                ++n2;
            }
            IValue eval = this.evaluate(expr.getBody(), ctxt);
            DebugTLCVariable variable = this.getVariable(eval, expr.getName());
            EvaluateResponse er = new EvaluateResponse();
            er.setResult(variable.getValue());
            er.setVariablesReference(variable.getVariablesReference());
            return er;
        }
        catch (Exception e) {
            Variable variable = this.getVariable((IValue)new StringValue(e.getMessage() == null ? "" : e.getMessage()), expression);
            EvaluateResponse er = new EvaluateResponse();
            er.setResult(variable.getValue());
            er.setVariablesReference(variable.getVariablesReference());
            return er;
        }
    }

    protected IValue evaluate(SemanticNode expr, Context ctxt) throws Exception {
        return this.tool.eval(() -> this.tool.noDebug().eval(expr, ctxt));
    }

    protected Context getEvaluateContext() {
        return this.ctxt;
    }
}

