/*
 * Decompiled with CFR 0.152.
 */
package tla2sany.semantic;

import java.util.ArrayList;
import java.util.Comparator;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.List;
import java.util.TreeSet;
import java.util.function.BiPredicate;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import tla2sany.explorer.ExploreNode;
import tla2sany.explorer.ExplorerVisitor;
import tla2sany.parser.SyntaxTreeNode;
import tla2sany.semantic.AbortException;
import tla2sany.semantic.AnyDefNode;
import tla2sany.semantic.ArgLevelParam;
import tla2sany.semantic.Context;
import tla2sany.semantic.ErrorCode;
import tla2sany.semantic.Errors;
import tla2sany.semantic.ExprNode;
import tla2sany.semantic.ExprOrOpArgNode;
import tla2sany.semantic.FormalParamNode;
import tla2sany.semantic.ModuleNode;
import tla2sany.semantic.OpArgNode;
import tla2sany.semantic.OpDefNode;
import tla2sany.semantic.ParamAndPosition;
import tla2sany.semantic.SemanticNode;
import tla2sany.semantic.SetOfArgLevelConstraints;
import tla2sany.semantic.SetOfLevelConstraints;
import tla2sany.semantic.SymbolNode;
import tla2sany.st.TreeNode;
import tla2sany.utilities.Strings;
import tla2sany.xml.SymbolContext;
import tlc2.tool.BuiltInOPs;
import tlc2.value.ITupleValue;
import tlc2.value.IValue;
import tlc2.value.Values;
import util.UniqueString;

public class OpApplNode
extends ExprNode
implements ExploreNode {
    protected SymbolNode operator;
    protected ExprOrOpArgNode[] operands;
    protected FormalParamNode[] unboundedBoundSymbols;
    protected FormalParamNode[][] boundedBoundSymbols;
    protected ExprNode[] ranges;
    protected boolean[] tupleOrs;
    public SymbolNode subExpressionOf = null;

    public OpApplNode(SymbolNode sn) {
        super(9, SyntaxTreeNode.nullSTN);
        this.operator = sn;
        this.operands = new ExprNode[0];
        this.unboundedBoundSymbols = null;
        this.boundedBoundSymbols = null;
        this.ranges = new ExprNode[0];
        this.tupleOrs = null;
    }

    public OpApplNode(SymbolNode op, ExprOrOpArgNode[] oprands, TreeNode stn, ModuleNode mn, Errors errors) throws AbortException {
        super(9, stn);
        this.operator = op;
        this.operands = oprands;
        this.unboundedBoundSymbols = null;
        this.boundedBoundSymbols = null;
        this.tupleOrs = null;
        this.ranges = new ExprNode[0];
        op.match(this, mn, errors);
    }

    public OpApplNode(UniqueString us, ExprOrOpArgNode[] ops, TreeNode stn, ModuleNode mn) {
        super(9, stn);
        this.operands = ops;
        this.unboundedBoundSymbols = null;
        this.boundedBoundSymbols = null;
        this.tupleOrs = null;
        this.ranges = new ExprNode[0];
        this.operator = Context.getGlobalContext().getSymbol(us);
    }

    public OpApplNode(UniqueString us, ExprOrOpArgNode[] ops, FormalParamNode[] odns, TreeNode stn, ModuleNode mn) {
        super(9, stn);
        this.operands = ops;
        this.unboundedBoundSymbols = odns;
        this.boundedBoundSymbols = null;
        this.tupleOrs = null;
        this.ranges = new ExprNode[0];
        this.operator = Context.getGlobalContext().getSymbol(us);
    }

    public OpApplNode(UniqueString us, FormalParamNode[] funcName, ExprOrOpArgNode[] ops, FormalParamNode[][] pars, boolean[] isT, ExprNode[] rs, TreeNode stn, ModuleNode mn) {
        super(9, stn);
        this.operands = ops;
        this.unboundedBoundSymbols = funcName;
        this.boundedBoundSymbols = pars;
        this.tupleOrs = isT;
        this.ranges = rs;
        this.operator = Context.getGlobalContext().getSymbol(us);
    }

    public final SymbolNode getOperator() {
        return this.operator;
    }

    public void resetOperator(OpDefNode odn) {
        this.operator = odn;
    }

    final void resetOperator(UniqueString us) {
        this.operator = Context.getGlobalContext().getSymbol(us);
    }

    final void makeNonRecursive() {
        this.unboundedBoundSymbols = null;
    }

    public final ExprOrOpArgNode[] getArgs() {
        return this.operands;
    }

    public final void setArgs(ExprOrOpArgNode[] args) {
        this.operands = args;
    }

    public final boolean argsContainOpArgNodes() {
        ExprOrOpArgNode[] exprOrOpArgNodeArray = this.operands;
        int n = this.operands.length;
        int n2 = 0;
        while (n2 < n) {
            ExprOrOpArgNode o = exprOrOpArgNodeArray[n2];
            if (o instanceof OpArgNode) {
                return true;
            }
            ++n2;
        }
        return false;
    }

    final int getNumberOfBoundedBoundSymbols() {
        if (this.boundedBoundSymbols == null) {
            return 0;
        }
        int num = 0;
        int i = 0;
        while (i < this.boundedBoundSymbols.length) {
            num = this.tupleOrs[i] ? ++num : (num += this.boundedBoundSymbols[i].length);
            ++i;
        }
        return num;
    }

    public final FormalParamNode[] getUnbdedQuantSymbols() {
        return this.unboundedBoundSymbols;
    }

    public final FormalParamNode[][] getBdedQuantSymbolLists() {
        return this.boundedBoundSymbols;
    }

    public final List<FormalParamNode> getQuantSymbolLists() {
        FormalParamNode[][] bdedQuantSymbolLists;
        int n;
        ArrayList<FormalParamNode> l = new ArrayList<FormalParamNode>();
        FormalParamNode[] unbdedQuantSymbols = this.getUnbdedQuantSymbols();
        if (unbdedQuantSymbols != null) {
            FormalParamNode[] formalParamNodeArray = unbdedQuantSymbols;
            n = unbdedQuantSymbols.length;
            int n2 = 0;
            while (n2 < n) {
                FormalParamNode s = formalParamNodeArray[n2];
                l.add(s);
                ++n2;
            }
        }
        if ((bdedQuantSymbolLists = this.getBdedQuantSymbolLists()) != null) {
            FormalParamNode[][] formalParamNodeArray = bdedQuantSymbolLists;
            int n3 = bdedQuantSymbolLists.length;
            n = 0;
            while (n < n3) {
                FormalParamNode[] outer;
                FormalParamNode[] formalParamNodeArray2 = outer = formalParamNodeArray[n];
                int n4 = outer.length;
                int n5 = 0;
                while (n5 < n4) {
                    FormalParamNode inner = formalParamNodeArray2[n5];
                    l.add(inner);
                    ++n5;
                }
                ++n;
            }
        }
        return l;
    }

    public final boolean[] isBdedQuantATuple() {
        return this.tupleOrs;
    }

    public final ExprNode[] getBdedQuantBounds() {
        return this.ranges;
    }

    private final ExprOrOpArgNode getArg(SymbolNode param) {
        AnyDefNode opDef = (AnyDefNode)((Object)this.operator);
        FormalParamNode[] formals = opDef.getParams();
        int i = 0;
        while (i < this.operands.length) {
            if (formals[i] == param) {
                return this.operands[i];
            }
            ++i;
        }
        return null;
    }

    @Override
    public final boolean levelCheck(int itr, Errors errors) {
        ExprNode arg;
        if (this.levelChecked >= itr) {
            return this.levelCorrect;
        }
        this.levelChecked = itr;
        this.levelCorrect = true;
        int i = 0;
        while (i < this.operands.length) {
            if (this.operands[i] != null && !this.operands[i].levelCheck(itr, errors)) {
                this.levelCorrect = false;
            }
            ++i;
        }
        i = 0;
        while (i < this.ranges.length) {
            if (this.ranges[i] != null && !this.ranges[i].levelCheck(itr, errors)) {
                this.levelCorrect = false;
            }
            ++i;
        }
        if (this.operator instanceof AnyDefNode) {
            AnyDefNode opDef = (AnyDefNode)((Object)this.operator);
            boolean opDefLevelCheck = opDef.levelCheck(itr, errors);
            int i2 = 0;
            while (i2 < this.operands.length) {
                ExprOrOpArgNode opd = this.operands[i2];
                if (opd != null) {
                    if (opd.getLevel() > opDef.getMaxLevel(i2)) {
                        if (opDefLevelCheck && opd.levelCheck(itr, errors)) {
                            errors.addError(ErrorCode.OPERATOR_LEVEL_CONSTRAINTS_EXCEEDED, this.stn.getLocation(), "Level error in applying operator " + String.valueOf(opDef.getName()) + ":\nThe level of argument " + (i2 + 1) + " exceeds the maximum level allowed by the operator.");
                        }
                        this.levelCorrect = false;
                    }
                    if (opd instanceof OpArgNode && ((OpArgNode)opd).getOp() instanceof AnyDefNode) {
                        AnyDefNode opdDef = (AnyDefNode)((Object)((OpArgNode)opd).getOp());
                        boolean opdDefLevelCheck = opdDef.levelCheck(itr, errors);
                        int alen = opdDef.getArity();
                        int j = 0;
                        while (j < alen) {
                            if (opdDef.getMaxLevel(j) < opDef.getMinMaxLevel(i2, j)) {
                                if (opDefLevelCheck && opd.levelCheck(itr, errors)) {
                                    errors.addError(ErrorCode.HIGHER_ORDER_OPERATOR_PARAMETER_LEVEL_CONSTRAINT_NOT_MET, this.stn.getLocation(), "Level error in applying operator " + String.valueOf(opDef.getName()) + ":\nThe permitted level of argument " + (j + 1) + " of the operator argument " + (i2 + 1) + " \nmust be at least " + opDef.getMinMaxLevel(i2, j) + ".");
                                }
                                this.levelCorrect = false;
                            }
                            ++j;
                        }
                        j = 0;
                        while (j < this.operands.length) {
                            int k = 0;
                            while (k < alen) {
                                if (opDef.getOpLevelCond(i2, j, k) && this.operands[j].getLevel() > opdDef.getMaxLevel(k)) {
                                    if (opd.levelCheck(itr, errors) && this.operands[j].levelCheck(itr, errors)) {
                                        errors.addError(ErrorCode.HIGHER_ORDER_OPERATOR_COPARAMETER_LEVEL_CONSTRAINTS_EXCEEDED, this.stn.getLocation(), "Level error in applying operator " + String.valueOf(opDef.getName()) + ":\nThe level of argument " + (j + 1) + " exceeds the maximum level allowed by the operator.");
                                    }
                                    this.levelCorrect = false;
                                }
                                ++k;
                            }
                            ++j;
                        }
                    }
                }
                ++i2;
            }
            i2 = 0;
            while (i2 < this.ranges.length) {
                ExprNode range = this.ranges[i2];
                if (range != null) {
                    boolean rangeLevelCheck = range.levelCheck(itr, errors);
                    if (range.getLevel() > 2) {
                        if (rangeLevelCheck) {
                            errors.addError(ErrorCode.QUANTIFICATION_WITH_TEMPORAL_LEVEL_BOUND, this.stn.getLocation(), "Level error in applying operator " + String.valueOf(opDef.getName()) + ":\nThe level of the range for the bounded variable " + String.valueOf(this.boundedBoundSymbols[i2][0]) + " \nexceeds the maximum level allowed by the operator.");
                        }
                        this.levelCorrect = false;
                    }
                }
                ++i2;
            }
            this.level = opDef.getLevel();
            i2 = 0;
            while (i2 < this.operands.length) {
                if (this.operands[i2] != null && opDef.getWeight(i2) == 1) {
                    this.level = Math.max(this.level, this.operands[i2].getLevel());
                }
                ++i2;
            }
            i2 = 0;
            while (i2 < this.ranges.length) {
                this.level = Math.max(this.level, this.ranges[i2].getLevel());
                ++i2;
            }
            this.levelParams.addAll(opDef.getLevelParams());
            this.allParams.addAll(opDef.getAllParams());
            this.nonLeibnizParams.addAll(opDef.getNonLeibnizParams());
            int ar = opDef.getArity();
            int i3 = 0;
            while (i3 < this.operands.length) {
                if (this.operands[i3] != null && opDef.getWeight(i3) == 1) {
                    this.levelParams.addAll(this.operands[i3].getLevelParams());
                }
                if (this.operands[i3] != null) {
                    this.allParams.addAll(this.operands[i3].getAllParams());
                    this.nonLeibnizParams.addAll(this.operands[i3].getNonLeibnizParams());
                }
                int ii = i3;
                if (ar == -1) {
                    ii = 0;
                }
                if (!opDef.getIsLeibnizArg()[ii]) {
                    this.nonLeibnizParams.addAll(this.operands[i3].getAllParams());
                }
                ++i3;
            }
            i3 = 0;
            while (i3 < this.ranges.length) {
                this.levelParams.addAll(this.ranges[i3].getLevelParams());
                this.allParams.addAll(this.ranges[i3].getAllParams());
                this.nonLeibnizParams.addAll(this.ranges[i3].getNonLeibnizParams());
                ++i3;
            }
            HashSet<FormalParamNode> allBoundSymbols = new HashSet<FormalParamNode>();
            if (this.unboundedBoundSymbols != null) {
                int i4 = 0;
                while (i4 < this.unboundedBoundSymbols.length) {
                    allBoundSymbols.add(this.unboundedBoundSymbols[i4]);
                    ++i4;
                }
            }
            if (this.boundedBoundSymbols != null) {
                int i5 = 0;
                while (i5 < this.boundedBoundSymbols.length) {
                    if (this.boundedBoundSymbols[i5] != null) {
                        int j = 0;
                        while (j < this.boundedBoundSymbols[i5].length) {
                            allBoundSymbols.add(this.boundedBoundSymbols[i5][j]);
                            ++j;
                        }
                    }
                    ++i5;
                }
            }
            for (FormalParamNode nextBoundSymbol : allBoundSymbols) {
                this.levelParams.remove(nextBoundSymbol);
                this.allParams.remove(nextBoundSymbol);
                this.nonLeibnizParams.remove(nextBoundSymbol);
            }
            this.levelConstraints.putAll(opDef.getLevelConstraints());
            int i6 = 0;
            while (i6 < this.operands.length) {
                if (this.operands[i6] != null) {
                    if (allBoundSymbols.size() == 0) {
                        this.levelConstraints.putAll(this.operands[i6].getLevelConstraints());
                    } else {
                        SetOfLevelConstraints lcons = this.operands[i6].getLevelConstraints();
                        for (SymbolNode param : lcons.keySet()) {
                            if (allBoundSymbols.contains(param)) continue;
                            this.levelConstraints.put(param, (Integer)lcons.get(param));
                        }
                    }
                }
                ++i6;
            }
            i6 = 0;
            while (i6 < this.ranges.length) {
                this.levelConstraints.putAll(this.ranges[i6].getLevelConstraints());
                ++i6;
            }
            i6 = 0;
            while (i6 < this.operands.length) {
                Integer mlevel = opDef.getMaxLevel(i6);
                if (this.operands[i6] != null) {
                    Iterator<SymbolNode> iter = this.operands[i6].getLevelParams().iterator();
                    while (iter.hasNext()) {
                        this.levelConstraints.put(iter.next(), mlevel);
                    }
                }
                ++i6;
            }
            i6 = 0;
            while (i6 < this.operands.length) {
                ExprOrOpArgNode opdi = this.operands[i6];
                if (opdi != null && opdi instanceof OpArgNode && ((OpArgNode)opdi).getOp() instanceof AnyDefNode) {
                    int k;
                    AnyDefNode argDef = (AnyDefNode)((Object)((OpArgNode)opdi).getOp());
                    argDef.levelCheck(itr, errors);
                    int alen = argDef.getArity();
                    int j = 0;
                    while (j < this.operands.length) {
                        k = 0;
                        while (k < alen) {
                            if (opDef.getOpLevelCond(i6, j, k)) {
                                Integer mlevel = argDef.getMaxLevel(k);
                                Iterator<SymbolNode> iter = this.operands[j].getLevelParams().iterator();
                                while (iter.hasNext()) {
                                    this.levelConstraints.put(iter.next(), mlevel);
                                }
                            }
                            ++k;
                        }
                        ++j;
                    }
                    if (!argDef.getIsLeibniz()) {
                        j = 0;
                        while (j < this.operands.length) {
                            k = 0;
                            while (k < alen) {
                                if (opDef.getOpLevelCond(i6, j, k) && !argDef.getIsLeibnizArg()[k]) {
                                    this.nonLeibnizParams.addAll(this.operands[j].getAllParams());
                                }
                                ++k;
                            }
                            ++j;
                        }
                    }
                }
                ++i6;
            }
            HashSet<ArgLevelParam> alpSet = opDef.getArgLevelParams();
            for (ArgLevelParam alp : alpSet) {
                ExprOrOpArgNode arg2 = this.getArg(alp.op);
                if (arg2 == null || !(arg2 instanceof OpArgNode) || !(((OpArgNode)arg2).getOp() instanceof AnyDefNode)) continue;
                AnyDefNode argDef = (AnyDefNode)((Object)((OpArgNode)arg2).getOp());
                argDef.levelCheck(itr, errors);
                Integer mlevel = argDef.getMaxLevel(alp.i);
                this.levelConstraints.put(alp.param, mlevel);
            }
            this.argLevelConstraints.putAll(opDef.getArgLevelConstraints());
            int i7 = 0;
            while (i7 < this.operands.length) {
                if (this.operands[i7] != null) {
                    this.argLevelConstraints.putAll(this.operands[i7].getArgLevelConstraints());
                }
                ++i7;
            }
            i7 = 0;
            while (i7 < this.ranges.length) {
                this.argLevelConstraints.putAll(this.ranges[i7].getArgLevelConstraints());
                ++i7;
            }
            i7 = 0;
            while (i7 < this.operands.length) {
                ExprOrOpArgNode opdi = this.operands[i7];
                if (opdi != null && opdi instanceof OpArgNode && ((OpArgNode)opdi).getOp().isParam()) {
                    SymbolNode opArg = ((OpArgNode)opdi).getOp();
                    int alen = opArg.getArity();
                    int j = 0;
                    while (j < alen) {
                        ParamAndPosition pap = new ParamAndPosition(opArg, j);
                        Integer mlevel = opDef.getMinMaxLevel(i7, j);
                        this.argLevelConstraints.put(pap, mlevel);
                        ++j;
                    }
                    j = 0;
                    while (j < this.operands.length) {
                        int k = 0;
                        while (k < alen) {
                            if (opDef.getOpLevelCond(i7, j, k)) {
                                ParamAndPosition pap = new ParamAndPosition(opArg, k);
                                Integer mlevel = this.operands[j].getLevel();
                                this.argLevelConstraints.put(pap, mlevel);
                            }
                            ++k;
                        }
                        ++j;
                    }
                }
                ++i7;
            }
            for (ArgLevelParam alp : alpSet) {
                ExprOrOpArgNode arg3 = this.getArg(alp.op);
                if (arg3 == null) continue;
                arg3.levelCheck(itr, errors);
                ParamAndPosition pap = new ParamAndPosition(alp.op, alp.i);
                this.argLevelConstraints.put(pap, arg3.getLevel());
            }
            this.argLevelParams = new HashSet();
            i = 0;
            while (i < this.operands.length) {
                if (this.operands[i] != null) {
                    if (allBoundSymbols.size() == 0) {
                        this.argLevelParams.addAll(this.operands[i].getArgLevelParams());
                    } else {
                        for (ArgLevelParam alp : this.operands[i].getArgLevelParams()) {
                            if (allBoundSymbols.contains(alp.param)) continue;
                            this.argLevelParams.add(alp);
                        }
                    }
                }
                ++i;
            }
            i = 0;
            while (i < this.ranges.length) {
                this.argLevelParams.addAll(this.ranges[i].getArgLevelParams());
                ++i;
            }
            for (ArgLevelParam alp : alpSet) {
                ExprOrOpArgNode arg4 = this.getArg(alp.op);
                if (arg4 == null) {
                    arg4 = this.getArg(alp.param);
                    if (arg4 == null) {
                        this.argLevelParams.add(alp);
                        continue;
                    }
                    arg4.levelCheck(itr, errors);
                    for (SymbolNode param : arg4.getLevelParams()) {
                        this.argLevelParams.add(new ArgLevelParam(alp.op, alp.i, param));
                    }
                    continue;
                }
                if (!(arg4 instanceof OpArgNode) || !((OpArgNode)arg4).getOp().isParam()) continue;
                SymbolNode argOp = ((OpArgNode)arg4).getOp();
                this.argLevelParams.add(new ArgLevelParam(argOp, alp.i, alp.param));
            }
            i = 0;
            while (i < this.operands.length) {
                ExprOrOpArgNode opdi = this.operands[i];
                if (opdi != null && opdi instanceof OpArgNode && ((OpArgNode)opdi).getOp().isParam()) {
                    SymbolNode opArg = ((OpArgNode)opdi).getOp();
                    int alen = opArg.getArity();
                    int j = 0;
                    while (j < this.operands.length) {
                        int k = 0;
                        while (k < alen) {
                            if (opDef.getOpLevelCond(i, j, k)) {
                                for (SymbolNode param : this.operands[j].getLevelParams()) {
                                    this.argLevelParams.add(new ArgLevelParam(opArg, k, param));
                                }
                            }
                            ++k;
                        }
                        ++j;
                    }
                }
                ++i;
            }
        } else {
            this.operator.levelCheck(itr, errors);
            this.level = this.operator.getLevel();
            i = 0;
            while (i < this.operands.length) {
                this.operands[i].levelCheck(itr, errors);
                this.level = Math.max(this.level, this.operands[i].getLevel());
                ++i;
            }
            this.levelParams = new HashSet();
            this.levelParams.add(this.operator);
            this.allParams.add(this.operator);
            i = 0;
            while (i < this.operands.length) {
                this.levelParams.addAll(this.operands[i].getLevelParams());
                this.allParams.addAll(this.operands[i].getAllParams());
                this.nonLeibnizParams.addAll(this.operands[i].getNonLeibnizParams());
                ++i;
            }
            this.levelConstraints = new SetOfLevelConstraints();
            i = 0;
            while (i < this.operands.length) {
                this.levelConstraints.putAll(this.operands[i].getLevelConstraints());
                ++i;
            }
            this.argLevelConstraints = new SetOfArgLevelConstraints();
            i = 0;
            while (i < this.operands.length) {
                this.argLevelConstraints.put(this.operator, i, this.operands[i].getLevel());
                this.argLevelConstraints.putAll(this.operands[i].getArgLevelConstraints());
                ++i;
            }
            this.argLevelParams = new HashSet();
            i = 0;
            while (i < this.operands.length) {
                HashSet<SymbolNode> lpSet = this.operands[i].getLevelParams();
                for (SymbolNode param : lpSet) {
                    this.argLevelParams.add(new ArgLevelParam(this.operator, i, param));
                }
                this.argLevelParams.addAll(this.operands[i].getArgLevelParams());
                ++i;
            }
        }
        String opName = this.operator.getName().toString();
        if (opName.equals("[]") && (arg = (ExprNode)this.getArgs()[0]).getLevel() == 2 && arg.getKind() == 9 && !((OpApplNode)arg).operator.getName().toString().equals("$SquareAct")) {
            errors.addError(ErrorCode.ALWAYS_PROPERTY_SENSITIVE_TO_STUTTERING, this.stn.getLocation(), "[] followed by action not of form [A]_v.");
            this.levelCorrect = false;
        }
        if (opName.equals("<>") && (arg = (ExprNode)this.getArgs()[0]).getLevel() == 2 && arg.getKind() == 9 && !((OpApplNode)arg).operator.getName().toString().equals("$AngleAct")) {
            errors.addError(ErrorCode.EVENTUALLY_PROPERTY_SENSITIVE_TO_STUTTERING, this.stn.getLocation(), "<> followed by action not of form <<A>>_v.");
            this.levelCorrect = false;
        }
        if ((opName.equals("~>") || opName.equals("-+->")) && (this.getArgs()[0].getLevel() == 2 || this.getArgs()[1].getLevel() == 2)) {
            errors.addError(ErrorCode.BINARY_TEMPORAL_OPERATOR_WITH_ACTION_LEVEL_PARAMETER, this.stn.getLocation(), "Action used where only temporal formula or state predicate allowed.");
            this.levelCorrect = false;
        }
        if (opName.equals("\\land") || opName.equals("\\lor") || opName.equals("=>") || opName.equals("\\equiv") || opName.equals("$ConjList") || opName.equals("$DisjList")) {
            boolean hasTemporal = false;
            boolean hasAction = false;
            int i8 = 0;
            while (i8 < this.getArgs().length) {
                hasTemporal = hasTemporal || this.getArgs()[i8].getLevel() == 3;
                hasAction = hasAction || this.getArgs()[i8].getLevel() == 2;
                ++i8;
            }
            if (hasTemporal && hasAction) {
                String pop = opName;
                if (pop.equals("$ConjList")) {
                    pop = "Conjunction list";
                }
                if (pop.equals("$DisjList")) {
                    pop = "Disjunction list";
                }
                errors.addError(ErrorCode.LOGICAL_OPERATOR_WITH_MIXED_ACTION_TEMPORAL_PARAMETERS, this.stn.getLocation(), pop + " has both temporal formula and action as arguments.");
                this.levelCorrect = false;
            }
        }
        if (this.level == 3 && (opName.equals("$BoundedExists") || opName.equals("$BoundedForall"))) {
            int i9 = 0;
            while (i9 < this.ranges.length) {
                if (this.ranges[i9].getLevel() == 2) {
                    errors.addError(ErrorCode.QUANTIFIED_TEMPORAL_FORMULA_WITH_ACTION_LEVEL_BOUND, this.ranges[i9].stn.getLocation(), "Action-level bound of quantified temporal formula.");
                    this.levelCorrect = false;
                }
                ++i9;
            }
        }
        return this.levelCorrect;
    }

    public boolean hasOpcode(int opCode) {
        return opCode == BuiltInOPs.getOpCode(this.getOperator().getName());
    }

    @Override
    public SemanticNode[] getChildren() {
        SemanticNode[] res = new SemanticNode[this.ranges.length + this.operands.length];
        int i = 0;
        while (i < this.ranges.length) {
            res[i] = this.ranges[i];
            ++i;
        }
        int j = 0;
        while (j < this.operands.length) {
            res[i + j] = this.operands[j];
            ++j;
        }
        return res;
    }

    @Override
    public void walkGraph(Hashtable<Integer, ExploreNode> semNodesTable, ExplorerVisitor visitor) {
        int i;
        Integer uid = this.myUID;
        if (semNodesTable.get(uid) != null) {
            return;
        }
        semNodesTable.put(uid, this);
        visitor.preVisit(this);
        if (this.operator != null) {
            this.operator.walkGraph(semNodesTable, visitor);
        }
        if (this.unboundedBoundSymbols != null && this.unboundedBoundSymbols.length > 0) {
            i = 0;
            while (i < this.unboundedBoundSymbols.length) {
                if (this.unboundedBoundSymbols[i] != null) {
                    this.unboundedBoundSymbols[i].walkGraph(semNodesTable, visitor);
                }
                ++i;
            }
        }
        if (this.operands != null && this.operands.length > 0) {
            i = 0;
            while (i < this.operands.length) {
                if (this.operands[i] != null) {
                    this.operands[i].walkGraph(semNodesTable, visitor);
                }
                ++i;
            }
        }
        if (this.ranges.length > 0) {
            i = 0;
            while (i < this.ranges.length) {
                if (this.ranges[i] != null) {
                    this.ranges[i].walkGraph(semNodesTable, visitor);
                }
                ++i;
            }
        }
        if (this.boundedBoundSymbols != null && this.boundedBoundSymbols.length > 0) {
            i = 0;
            while (i < this.boundedBoundSymbols.length) {
                if (this.boundedBoundSymbols[i] != null && this.boundedBoundSymbols[i].length > 0) {
                    int j = 0;
                    while (j < this.boundedBoundSymbols[i].length) {
                        if (this.boundedBoundSymbols[i][j] != null) {
                            this.boundedBoundSymbols[i][j].walkGraph(semNodesTable, visitor);
                        }
                        ++j;
                    }
                }
                ++i;
            }
        }
        visitor.postVisit(this);
    }

    private String toStringBody(int depth, Errors errors) {
        int i;
        if (depth <= 1) {
            return "";
        }
        Object ret = this.operator == null ? "\nOperator: null" : "\nOperator: " + this.operator.getName().toString() + "  " + this.operator.getUid() + "  ";
        if (this.unboundedBoundSymbols != null && this.unboundedBoundSymbols.length > 0) {
            ret = (String)ret + "\nUnbounded bound symbols:  ";
            i = 0;
            while (i < this.unboundedBoundSymbols.length) {
                ret = (String)ret + Strings.indent(2, this.unboundedBoundSymbols[i].toString(depth - 1, errors));
                ++i;
            }
        }
        if (this.boundedBoundSymbols != null && this.boundedBoundSymbols.length > 0) {
            ret = (String)ret + "\nBounded bound symbols: " + this.getNumberOfBoundedBoundSymbols();
            i = 0;
            while (i < this.boundedBoundSymbols.length) {
                if (this.boundedBoundSymbols[i] != null && this.boundedBoundSymbols[i].length > 0) {
                    int j = 0;
                    while (j < this.boundedBoundSymbols[i].length) {
                        ret = (String)ret + Strings.indent(2, "\n[" + i + "," + j + "]" + Strings.indent(2, this.boundedBoundSymbols[i][j].toString(depth - 1, errors)));
                        ++j;
                    }
                }
                ++i;
            }
        }
        if (this.ranges.length > 0) {
            ret = (String)ret + "\nRanges: ";
            i = 0;
            while (i < this.ranges.length) {
                ret = (String)ret + Strings.indent(2, this.ranges[i] != null ? this.ranges[i].toString(depth - 1, errors) : "null");
                ++i;
            }
        }
        if (this.tupleOrs != null && this.tupleOrs.length > 0) {
            ret = (String)ret + "\nTupleOrs:   ";
            i = 0;
            while (i < this.tupleOrs.length) {
                ret = (String)ret + Strings.indent(2, this.tupleOrs[i] ? "\ntrue" : "\nfalse");
                ++i;
            }
        }
        if (this.operands != null) {
            if (this.operands.length > 0) {
                ret = (String)ret + "\nOperands: " + this.operands.length;
                i = 0;
                while (i < this.operands.length) {
                    ret = (String)ret + Strings.indent(2, this.operands[i] == null ? "\nnull" : this.operands[i].toString(depth - 1, errors));
                    ++i;
                }
            }
        } else {
            ret = (String)ret + "\nOperands: null";
        }
        return Strings.indent(2, (String)ret);
    }

    @Override
    public String toString(int depth, Errors errors) {
        if (depth <= 0) {
            return "";
        }
        String sEO = "";
        if (this.subExpressionOf != null) {
            sEO = Strings.indent(2, "\nsubExpressionOf: " + Strings.indent(2, this.subExpressionOf.toString(1, errors)));
        }
        return "\n*OpApplNode: " + String.valueOf(this.operator.getName()) + "  " + super.toString(depth + 1, errors) + "  errors: " + (errors != null ? "non-null" : "null") + this.toStringBody(depth, errors) + sEO;
    }

    @Override
    public String toString(IValue aValue) {
        if (aValue instanceof ITupleValue && this.allParams.size() == ((ITupleValue)aValue).size()) {
            StringBuffer result = new StringBuffer();
            TreeSet<SymbolNode> s = new TreeSet<SymbolNode>(new Comparator<SymbolNode>(){

                @Override
                public int compare(SymbolNode o1, SymbolNode o2) {
                    return Integer.compare(o1.getName().getVarLoc(), o2.getName().getVarLoc());
                }
            });
            s.addAll(this.allParams);
            int idx = 0;
            for (SymbolNode sn : s) {
                result.append("/\\ ");
                result.append(sn.getName().toString());
                IValue value = ((ITupleValue)aValue).getElem(idx++);
                result.append(" = ");
                result.append(Values.ppr(value));
                result.append("\n");
            }
            return result.toString();
        }
        return super.toString(aValue);
    }

    @Override
    protected Element getLevelElement(Document doc, SymbolContext context, BiPredicate<SemanticNode, SemanticNode> filter) {
        OpApplNode other;
        ExprOrOpArgNode lastOperand;
        Element e = doc.createElement("OpApplNode");
        if (this.operator.getName().toString().equals("$Case") && this.operands.length > 1 && (lastOperand = this.operands[this.operands.length - 1]) instanceof OpApplNode && (other = (OpApplNode)lastOperand).getOperator().getName().toString().equals("$Pair") && other.getArgs()[0] == null) {
            context = new SymbolContext(context);
            context.setFlag(0);
        }
        Element op = doc.createElement("operator");
        op.appendChild(this.operator.export(doc, context, filter));
        e.appendChild(op);
        Element ope = doc.createElement("operands");
        int i = 0;
        while (i < this.operands.length) {
            if (i == 0 && this.operands[0] == null && context.hasFlag(0)) {
                Element otherValue = this.appendText(doc, "StringValue", "$Other");
                ope.appendChild(this.appendElement(doc, "StringNode", otherValue));
            } else {
                ope.appendChild(this.operands[i].export(doc, context, filter));
            }
            ++i;
        }
        e.appendChild(ope);
        if (this.unboundedBoundSymbols != null | this.boundedBoundSymbols != null) {
            Element bvar;
            Element bvars = doc.createElement("boundSymbols");
            if (this.unboundedBoundSymbols != null) {
                int i2 = 0;
                while (i2 < this.unboundedBoundSymbols.length) {
                    bvar = doc.createElement("unbound");
                    bvar.appendChild(this.unboundedBoundSymbols[i2].export(doc, context, filter));
                    if (this.tupleOrs != null && this.tupleOrs[i2]) {
                        bvar.appendChild(doc.createElement("tuple"));
                    }
                    bvars.appendChild(bvar);
                    ++i2;
                }
            }
            if (this.boundedBoundSymbols != null) {
                int i3 = 0;
                while (i3 < this.boundedBoundSymbols.length) {
                    bvar = doc.createElement("bound");
                    int j = 0;
                    while (j < this.boundedBoundSymbols[i3].length) {
                        bvar.appendChild(this.boundedBoundSymbols[i3][j].export(doc, context, filter));
                        ++j;
                    }
                    if (this.tupleOrs != null && this.tupleOrs[i3]) {
                        bvar.appendChild(doc.createElement("tuple"));
                    }
                    bvar.appendChild(this.ranges[i3].export(doc, context, filter));
                    bvars.appendChild(bvar);
                    ++i3;
                }
            }
            e.appendChild(bvars);
        }
        return e;
    }
}

