/*
 * Decompiled with CFR 0.152.
 */
package tla2sany.semantic;

import java.util.Hashtable;
import java.util.function.BiPredicate;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import tla2sany.explorer.ExploreNode;
import tla2sany.explorer.ExplorerVisitor;
import tla2sany.semantic.Context;
import tla2sany.semantic.Errors;
import tla2sany.semantic.InstanceNode;
import tla2sany.semantic.LevelNode;
import tla2sany.semantic.ProofNode;
import tla2sany.semantic.SemanticNode;
import tla2sany.st.TreeNode;
import tla2sany.utilities.Strings;
import tla2sany.utilities.Vector;
import tla2sany.xml.SymbolContext;

public class NonLeafProofNode
extends ProofNode {
    private LevelNode[] steps = null;
    private InstanceNode[] insts;
    private Context context;

    public NonLeafProofNode(TreeNode stn, LevelNode[] stps, InstanceNode[] inst, Context ctxt) {
        super(34, stn);
        this.steps = stps;
        this.insts = inst;
        this.context = ctxt;
    }

    public LevelNode[] getSteps() {
        return this.steps;
    }

    public Context getContext() {
        return this.context;
    }

    @Override
    public boolean levelCheck(int iter, Errors errors) {
        if (this.levelChecked >= iter) {
            return this.levelCorrect;
        }
        LevelNode[] ln = new LevelNode[this.steps.length + this.insts.length];
        System.arraycopy(this.steps, 0, ln, 0, this.steps.length);
        System.arraycopy(this.insts, 0, ln, this.steps.length, this.insts.length);
        return this.levelCheckSubnodes(iter, ln, errors);
    }

    @Override
    public SemanticNode[] getChildren() {
        if (this.steps == null || this.steps.length == 0) {
            return null;
        }
        SemanticNode[] res = new SemanticNode[this.steps.length];
        int i = 0;
        while (i < this.steps.length) {
            res[i] = this.steps[i];
            ++i;
        }
        return res;
    }

    @Override
    public void walkGraph(Hashtable<Integer, ExploreNode> semNodesTable, ExplorerVisitor visitor) {
        Integer uid = this.myUID;
        if (semNodesTable.get(uid) != null) {
            return;
        }
        semNodesTable.put(uid, this);
        visitor.preVisit(this);
        int i = 0;
        while (i < this.steps.length) {
            this.steps[i].walkGraph(semNodesTable, visitor);
            ++i;
        }
        this.context.walkGraph(semNodesTable, visitor);
        visitor.postVisit(this);
    }

    @Override
    public String toString(int depth, Errors errors) {
        if (depth <= 0) {
            return "";
        }
        String ret = "\n*ProofNode:\n" + super.toString(depth, errors) + Strings.indent(2, "\nsteps:");
        int i = 0;
        while (i < this.steps.length) {
            ret = ret + Strings.indent(4, this.steps[i].toString(depth - 1, errors));
            ++i;
        }
        Vector<String> contextEntries = this.context.getContextEntryStringVector(depth - 1, false, errors);
        if (contextEntries != null) {
            int i2 = 0;
            while (i2 < contextEntries.size()) {
                ret = contextEntries.elementAt(i2) != null ? ret + Strings.indent(2, contextEntries.elementAt(i2)) : ret + "*** null ***";
                ++i2;
            }
        }
        return ret;
    }

    @Override
    protected Element getLevelElement(Document doc, SymbolContext context, BiPredicate<SemanticNode, SemanticNode> filter) {
        Element e = doc.createElement("steps");
        int i = 0;
        while (i < this.steps.length) {
            e.appendChild(this.steps[i].export(doc, context, filter));
            ++i;
        }
        return e;
    }
}

