/*
 * Decompiled with CFR 0.152.
 */
package tlc2.value;

import java.util.Random;
import tlc2.TLCGlobals;
import tlc2.tool.ModelChecker;
import tlc2.tool.TLCState;
import tlc2.util.IdThread;

public abstract class RandomEnumerableValues {
    private static long randomSeed;
    private static final ThreadLocal<Random> RANDOMS;

    static {
        RANDOMS = new ThreadLocal<Random>(){

            @Override
            protected Random initialValue() {
                if (TLCGlobals.mainChecker != null && ModelChecker.class.equals(TLCGlobals.mainChecker.getClass())) {
                    return new TLCStateRandom(randomSeed);
                }
                return new DefaultRandom(randomSeed);
            }

            @Override
            public Random get() {
                return ((EnumerableValueRandom)super.get()).initialize();
            }
        };
    }

    public static long getSeed() {
        return randomSeed;
    }

    public static void setSeed(long seed) {
        randomSeed = seed;
        RandomEnumerableValues.reset();
    }

    public static Random reset() {
        Random random = RandomEnumerableValues.get();
        RANDOMS.remove();
        return random;
    }

    public static Random set(Random random) {
        Random old = RandomEnumerableValues.get();
        RANDOMS.set(random);
        return old;
    }

    public static Random get() {
        return RANDOMS.get();
    }

    private static final class DefaultRandom
    extends Random
    implements EnumerableValueRandom {
        public DefaultRandom(long randomSeed) {
            super(randomSeed);
        }

        @Override
        public final Random initialize() {
            return this;
        }
    }

    private static interface EnumerableValueRandom {
        public Random initialize();
    }

    private static final class TLCStateRandom
    extends Random
    implements EnumerableValueRandom {
        private TLCState state;

        public TLCStateRandom(long randomSeed) {
            super(randomSeed);
        }

        private void initializedFor(TLCState state) {
            long seed = state.fingerPrint() ^ randomSeed;
            this.setSeed(seed);
            this.state = state;
        }

        private boolean isInitializedFor(TLCState another) {
            return this.state == another;
        }

        @Override
        public Random initialize() {
            TLCState state = IdThread.getCurrentState();
            if (state != null && !this.isInitializedFor(state)) {
                this.initializedFor(state);
            }
            return this;
        }
    }
}

