/*
 * Decompiled with CFR 0.152.
 */
package tlc2.tool.impl;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import tla2sany.drivers.SemanticException;
import tla2sany.modanalyzer.ModulePointer;
import tla2sany.modanalyzer.ParseUnit;
import tla2sany.modanalyzer.SpecObj;
import tla2sany.output.SanyOutput;
import tla2sany.parser.ParseException;
import tla2sany.semantic.AbortException;
import tla2sany.semantic.Errors;
import tla2sany.semantic.ExprNode;
import tla2sany.semantic.ExternalModuleTable;
import tla2sany.semantic.ModuleNode;
import tla2sany.semantic.OpDeclNode;
import tla2sany.semantic.OpDefNode;
import tla2sany.semantic.SemanticNode;
import tlc2.debug.TLCDebuggerExpression;
import tlc2.tool.Action;
import tlc2.tool.Defns;
import tlc2.tool.impl.Spec;
import tlc2.tool.impl.SpecProcessor;
import tlc2.util.Context;
import tlc2.value.impl.StringValue;
import util.Assert;
import util.FilenameToStream;

public class ParameterizedSpecObj
extends SpecObj {
    public static final String ACTION_CONSTRAINTS = "ACTION_CONSTRAINT";
    public static final String CONSTRAINTS = "CONSTRAINT";
    public static final String POST_CONDITIONS = "POST_CONDITIONS";
    public static final String INVARIANT = "INVARIANT";
    private final Spec spec;
    private final Map<String, Object> params;

    public ParameterizedSpecObj(Spec spec, FilenameToStream resolver, Map<String, Object> params) {
        super(spec.rootFile, resolver);
        this.spec = spec;
        this.params = params;
    }

    @Override
    protected final ParseUnit findOrCreateParsedUnit(String name, Errors errors, boolean firstCall, SanyOutput out) throws AbortException {
        List constraints;
        ModulePointer rootModule;
        ParseUnit pu = super.findOrCreateParsedUnit(name, errors, firstCall, out);
        if (firstCall && this.params.containsKey(POST_CONDITIONS)) {
            rootModule = pu.getRootModule();
            List pcs = (List)this.params.get(POST_CONDITIONS);
            for (PostCondition pc : pcs) {
                rootModule.getRelatives().addExtendee(pc.module);
            }
        }
        if (firstCall && this.params.containsKey(INVARIANT)) {
            rootModule = pu.getRootModule();
            List invs = (List)this.params.get(INVARIANT);
            for (InvariantTemplate inv : invs) {
                inv.getModules().forEach(rootModule.getRelatives()::addExtendee);
            }
        }
        if (firstCall && this.params.containsKey(CONSTRAINTS)) {
            rootModule = pu.getRootModule();
            constraints = (List)this.params.get(CONSTRAINTS);
            for (Constraint c : constraints) {
                rootModule.getRelatives().addExtendee(c.module);
            }
        }
        if (firstCall && this.params.containsKey(ACTION_CONSTRAINTS)) {
            rootModule = pu.getRootModule();
            constraints = (List)this.params.get(ACTION_CONSTRAINTS);
            for (Constraint c : constraints) {
                rootModule.getRelatives().addExtendee(c.module);
            }
        }
        return pu;
    }

    @Override
    public void processConstantDefns(Defns defns) {
        ExternalModuleTable mt = this.getExternalModuleTable();
        List constraints = this.params.getOrDefault(CONSTRAINTS, new ArrayList());
        for (Constraint c : constraints) {
            this.processConstantsForModule(mt, c.module, c.constDefs, defns);
        }
        List actionConstraints = this.params.getOrDefault(ACTION_CONSTRAINTS, new ArrayList());
        for (Constraint c : actionConstraints) {
            this.processConstantsForModule(mt, c.module, c.constDefs, defns);
        }
        List postConditions = this.params.getOrDefault(POST_CONDITIONS, new ArrayList());
        for (PostCondition pc : postConditions) {
            this.processConstantsForModule(mt, pc.module, pc.constDecls, defns);
        }
        List invariants = this.params.getOrDefault(INVARIANT, new ArrayList());
        for (InvariantTemplate inv : invariants) {
            for (String module : inv.getModules()) {
                this.processConstantsForModule(mt, module, new HashMap<String, String>(), defns);
            }
        }
        super.processConstantDefns(defns);
    }

    private void processConstantsForModule(ExternalModuleTable mt, String moduleName, Map<String, String> constDefs, Defns defns) {
        ModuleNode moduleNode = mt.getModuleNode(moduleName);
        Assert.check(moduleNode != null, 1000, "Could not find module: " + moduleName);
        OpDeclNode[] constantDecls = moduleNode.getConstantDecls();
        int i = 0;
        while (i < constantDecls.length) {
            String constName = constantDecls[i].getName().toString();
            if (constDefs.containsKey(constName)) {
                StringValue val = new StringValue(constDefs.get(constName));
                constantDecls[i].setToolObject(this.spec.getId(), val);
                defns.put(constName, (Object)val);
            }
            ++i;
        }
    }

    @Override
    public List<ExprNode> getPostConditionSpecs() {
        ArrayList<ExprNode> res = new ArrayList<ExprNode>();
        List pcs = this.params.getOrDefault(POST_CONDITIONS, new ArrayList());
        for (PostCondition pc : pcs) {
            ExternalModuleTable mt = this.getExternalModuleTable();
            ModuleNode moduleNode = mt.getModuleNode(pc.module);
            Assert.check(moduleNode != null, 1000, "Could not find module: " + pc.module);
            OpDefNode opDef = moduleNode.getOpDef(pc.operator);
            Assert.check(opDef != null, 1000, "Could not find operator: " + pc.operator + " in module: " + pc.module);
            res.add(opDef.getBody());
        }
        return res;
    }

    @Override
    public List<Action> getInvariants(SpecProcessor specProcessor) throws ParseException, SemanticException, AbortException {
        ArrayList<Action> res = new ArrayList<Action>();
        List invs = this.params.getOrDefault(INVARIANT, new ArrayList());
        for (InvariantTemplate inv : invs) {
            res.add(inv.getAction(specProcessor));
        }
        return res;
    }

    @Override
    public List<OpDefNode> getConstraints() {
        List<OpDefNode> res = this.getConstraints0(this.params.getOrDefault(CONSTRAINTS, new ArrayList()));
        return res;
    }

    @Override
    public List<OpDefNode> getActionConstraints() {
        List<OpDefNode> res = this.getConstraints0(this.params.getOrDefault(ACTION_CONSTRAINTS, new ArrayList()));
        return res;
    }

    private List<OpDefNode> getConstraints0(List<Constraint> constraints) {
        ArrayList<OpDefNode> res = new ArrayList<OpDefNode>();
        ExternalModuleTable mt = this.getExternalModuleTable();
        for (Constraint c : constraints) {
            ModuleNode moduleNode = mt.getModuleNode(c.module);
            Assert.check(moduleNode != null, 1000, "Could not find module: " + c.module);
            OpDefNode opDef = moduleNode.getOpDef(c.operator);
            Assert.check(opDef != null, 1000, "Could not find operator: " + c.operator + " in module: " + c.module);
            res.add(opDef);
        }
        return res;
    }

    public static class Constraint {
        private final String module;
        private final String operator;
        private final Map<String, String> constDefs;

        public Constraint(String module, String operator, String def, String constDef) {
            this(module, operator, Map.of(def, constDef));
        }

        public Constraint(String module, String operator, Map<String, String> constDefs) {
            this.module = module;
            this.operator = operator;
            this.constDefs = constDefs;
        }
    }

    public static abstract class InvariantTemplate {
        protected final Set<String> modules;

        public InvariantTemplate(Set<String> modules) {
            this.modules = modules;
        }

        public abstract Action getAction(SpecProcessor var1) throws ParseException, SemanticException, AbortException;

        public Set<String> getModules() {
            return this.modules;
        }
    }

    public static class PostCondition {
        public final String module;
        public final String operator;
        public final Map<String, String> constDecls;

        public PostCondition(String module, String operator) {
            this(module, operator, new HashMap<String, String>());
        }

        public PostCondition(String module, String operator, String def, String constDef) {
            this(module, operator);
            this.constDecls.put(def, constDef);
        }

        public PostCondition(String module, String operator, Map<String, String> constDecls) {
            this.module = module;
            this.operator = operator;
            this.constDecls = constDecls;
        }
    }

    public static class RuntimeInvariantTemplate
    extends InvariantTemplate {
        private final String expr;

        public RuntimeInvariantTemplate(Set<String> modules, String expr) {
            super(modules);
            this.expr = expr;
        }

        @Override
        public Action getAction(SpecProcessor spec) throws ParseException, SemanticException, AbortException {
            OpDefNode opDef = TLCDebuggerExpression.process(spec, spec.getRootModule(), this.expr);
            return new Action((SemanticNode)opDef.getBody(), Context.Empty, opDef, false, true);
        }
    }
}

