/*
 * Decompiled with CFR 0.152.
 */
package tlc2.tool;

import tlc2.TLCGlobals;
import tlc2.output.MP;
import tlc2.output.StatePrinter;
import tlc2.tool.AbstractChecker;
import tlc2.tool.DFIDModelChecker;
import tlc2.tool.IWorker;
import tlc2.tool.StateVec;
import tlc2.tool.TLCState;
import tlc2.tool.TLCStateInfo;
import tlc2.tool.fp.dfid.FPIntSet;
import tlc2.util.IdThread;
import tlc2.util.LongVec;
import tlc2.util.RandomGenerator;

public class DFIDWorker
extends IdThread
implements IWorker {
    private DFIDModelChecker tlc;
    private RandomGenerator rng;
    private TLCState[] stateStack;
    private long[] fpStack;
    private StateVec[] succStateStack;
    private LongVec[] succFPStack;
    private FPIntSet theFPSet;
    private TLCState[] theInitStates;
    private long[] theInitFPs;
    private int initLen;
    private int toLevel;
    private int curLevel;
    private int stopCode;
    private boolean moreLevel;

    public DFIDWorker(int id, int toLevel, AbstractChecker tlc) {
        super(id);
        this.tlc = (DFIDModelChecker)tlc;
        this.rng = new RandomGenerator();
        this.rng.setSeed(this.rng.nextLong());
        this.stateStack = new TLCState[TLCGlobals.DFIDMax];
        this.fpStack = new long[TLCGlobals.DFIDMax];
        this.succStateStack = new StateVec[TLCGlobals.DFIDMax];
        this.succFPStack = new LongVec[TLCGlobals.DFIDMax];
        int i = 0;
        while (i < TLCGlobals.DFIDMax) {
            this.succStateStack[i] = new StateVec(1);
            this.succFPStack[i] = new LongVec(1);
            ++i;
        }
        this.theFPSet = this.tlc.theFPSet;
        this.initLen = this.tlc.theInitStates.length;
        this.theInitStates = new TLCState[this.initLen];
        this.theInitFPs = new long[this.initLen];
        System.arraycopy(this.tlc.theInitStates, 0, this.theInitStates, 0, this.initLen);
        System.arraycopy(this.tlc.theInitFPs, 0, this.theInitFPs, 0, this.initLen);
        this.toLevel = toLevel;
        this.curLevel = 0;
        this.stopCode = 0;
        this.moreLevel = false;
    }

    public final void setStop(int code) {
        this.stopCode = code;
    }

    public final boolean isTerminated() {
        return this.stopCode == 2;
    }

    public final boolean hasMoreLevel() {
        return this.moreLevel;
    }

    private final int getInit() {
        while (this.initLen > 0) {
            int index = (int)Math.floor(this.rng.nextDouble() * (double)this.initLen);
            long fp = this.theInitFPs[index];
            int status = this.theFPSet.getStatus(fp);
            if (!FPIntSet.isCompleted(status)) {
                return index;
            }
            --this.initLen;
            this.theInitStates[index] = this.theInitStates[this.initLen];
            this.theInitFPs[index] = this.theInitFPs[this.initLen];
        }
        return -1;
    }

    private final int getNext(TLCState curState, long cfp) {
        StateVec succStates = this.succStateStack[this.curLevel - 1];
        LongVec succFPs = this.succFPStack[this.curLevel - 1];
        int len = succFPs.size();
        while (len > 0) {
            int index = (int)Math.floor(this.rng.nextDouble() * (double)len);
            long fp = succFPs.elementAt(index);
            int status = this.theFPSet.getStatus(fp);
            if (!FPIntSet.isCompleted(status) && this.curLevel < FPIntSet.getLevel(status)) {
                return index;
            }
            succStates.removeElement(index);
            succFPs.removeElement(index);
            --len;
        }
        return -1;
    }

    public final void printErrorTrace(int errorCode, String[] parameters, TLCState s1, TLCState s2) {
        MP.printError(errorCode, parameters);
        MP.printError(2121);
        int idx = 0;
        while (idx < this.curLevel) {
            StatePrinter.printRuntimeErrorStateTraceState(this.stateStack[idx], ++idx);
        }
        assert (s1.equals(this.stateStack[idx]));
        StatePrinter.printRuntimeErrorStateTraceState(s1, ++idx);
        if (s2 != null) {
            StatePrinter.printRuntimeErrorStateTraceState(s2, idx + 1);
        }
    }

    public final void printInvariantTrace(int errorCode, String[] parameters, TLCState s1, TLCState s2) {
        TLCStateInfo currentState;
        int ordinal;
        MP.printError(errorCode, parameters);
        MP.printError(2121);
        int idx = 0;
        while (idx <= this.curLevel) {
            if (this.curLevel == idx) assert (s1.equals(this.stateStack[idx]));
            ordinal = idx + 1;
            currentState = new TLCStateInfo(this.stateStack[idx], ordinal);
            TLCState previousState = idx == 0 ? null : this.stateStack[idx - 1];
            StatePrinter.printInvariantViolationStateTraceState(currentState, previousState, ordinal);
            ++idx;
        }
        ordinal = idx + 1;
        currentState = new TLCStateInfo(s2, ordinal);
        StatePrinter.printInvariantViolationStateTraceState(currentState, s1, ordinal, true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final void run() {
        TLCState curState = null;
        try {
            block8: while (this.stopCode == 0) {
                int index = this.getInit();
                if (index == -1) {
                    this.tlc.setStop(1);
                    DFIDModelChecker dFIDModelChecker = this.tlc;
                    synchronized (dFIDModelChecker) {
                        this.tlc.setDone();
                        this.tlc.notifyAll();
                    }
                    return;
                }
                curState = this.theInitStates[index];
                long cfp = this.theInitFPs[index];
                this.stateStack[0] = curState;
                this.fpStack[0] = cfp;
                this.succStateStack[0].reset();
                this.succFPStack[0].reset();
                boolean isLeaf = this.toLevel < 2;
                boolean noLeaf = this.tlc.doNext(curState, cfp, isLeaf, this.succStateStack[0], this.succFPStack[0]);
                this.moreLevel = this.moreLevel || !noLeaf;
                this.curLevel = 1;
                while (!isLeaf) {
                    index = this.getNext(curState, cfp);
                    if (index == -1) {
                        this.theFPSet.setLeveled(cfp);
                        if (this.curLevel == 1) continue block8;
                        --this.curLevel;
                        curState = this.stateStack[this.curLevel - 1];
                        cfp = this.fpStack[this.curLevel - 1];
                        continue;
                    }
                    curState = this.succStateStack[this.curLevel - 1].elementAt(index);
                    cfp = this.succFPStack[this.curLevel - 1].elementAt(index);
                    this.stateStack[this.curLevel] = curState;
                    this.fpStack[this.curLevel] = cfp;
                    this.succStateStack[this.curLevel].reset();
                    this.succFPStack[this.curLevel].reset();
                    isLeaf = this.curLevel >= this.toLevel - 1;
                    noLeaf = this.tlc.doNext(curState, cfp, isLeaf, this.succStateStack[this.curLevel], this.succFPStack[this.curLevel]);
                    this.moreLevel = this.moreLevel || !noLeaf;
                    ++this.curLevel;
                }
            }
        }
        catch (Throwable e) {
            this.tlc.setStop(2);
            DFIDModelChecker dFIDModelChecker = this.tlc;
            synchronized (dFIDModelChecker) {
                if (this.tlc.setErrState(curState, null, true, 1000)) {
                    MP.printError(1000, e);
                }
                this.tlc.setDone();
                this.tlc.notifyAll();
            }
            return;
        }
    }
}

