---------------------------- MODULE _TLCTrace ----------------------------
LOCAL INSTANCE TLC
LOCAL INSTANCE TLCExt
LOCAL INSTANCE Sequences

\* This operator has a Java module override (tlc2.module._TLCTrace#ioDeserialize).
LOCAL _TLCTraceDeserialize(absoluteFilename) ==
    TRUE

\* This operator has a Java module override (tlc2.module._TLCTrace#ioSerialize).
LOCAL _TLCTraceSerialize(val, absoluteFilename) ==
    TRUE

----------------------------------------------------------------------------
\* Serialize a trace to a file.

CONSTANT _TLCTraceFile

LOCAL _TLCTrace0(verbose) ==
    IF CounterExample.state = {} \/ ("console" \in DOMAIN CounterExample /\ CounterExample["console"] = FALSE) THEN TRUE ELSE
        /\ _TLCTraceSerialize(ToTrace(CounterExample), _TLCTraceFile)
        /\ IF verbose THEN PrintT("CounterExample written: " \o _TLCTraceFile) ELSE TRUE

LOCAL _TLCTraceSilent ==
    _TLCTrace0(FALSE)

_TLCTrace ==
    _TLCTrace0(TRUE)

----------------------------------------------------------------------------
\* Deserialize a trace created by _TLCTrace above.

LOCAL _TLCTraceFileDeserialized ==
    _TLCTraceDeserialize(_TLCTraceFile)

\* This operator has a Java module override (tlc2.module._TLCTrace#tlcState).
LOCAL _TLCState(level) ==
	Trace[level]

LOCAL _TLCTraceConstraint ==
    LET level == TLCGet("level")
        dump  == _TLCTraceFileDeserialized
	\* For liveness properties, TLC trace dumps stop at the state *before* the
	\* lasso is closed. When replaying such a trace, TLC may request a state with
	\*   level = Len(dump) + 1,
	\* which does not exist in the dump. In that case, the constraint
	\* is intentionally vacuously satisfied.
	\* Since the names of the spec’s variables are not known, Trace[level] is
	\* used as a generic reference to the variables of the current state.
    IN level \in DOMAIN dump => _TLCState(level) = dump[level]

=============================================================================
