/*
 * Decompiled with CFR 0.152.
 */
package tlc2.value.impl;

import java.util.Enumeration;
import tlc2.util.Vect;
import tlc2.value.IMVPerm;
import tlc2.value.IModelValue;
import tlc2.value.impl.Enumerable;
import tlc2.value.impl.FcnRcdValue;
import tlc2.value.impl.MVPerm;
import tlc2.value.impl.ModelValue;
import tlc2.value.impl.Value;
import tlc2.value.impl.ValueEnumeration;
import util.Assert;
import util.Set;

public abstract class MVPerms {
    public static final IMVPerm[] permutationSubgroup(Enumerable enumerable) {
        Value elem;
        ValueEnumeration Enum2 = enumerable.elements();
        int sz = enumerable.size() - 1;
        Set perms = new Set(sz);
        Vect<IMVPerm> permVec = new Vect<IMVPerm>(sz);
        while ((elem = Enum2.nextElement()) != null) {
            FcnRcdValue fcn = (FcnRcdValue)elem.toFcnRcd();
            if (fcn == null) {
                Assert.fail("The symmetry operator must specify a set of functions.");
            }
            MVPerm perm = new MVPerm();
            int i = 0;
            while (i < fcn.domain.length) {
                Value dval = fcn.domain[i];
                Value rval = fcn.values[i];
                if (dval instanceof ModelValue && rval instanceof ModelValue) {
                    perm.put((ModelValue)dval, (IModelValue)((ModelValue)rval));
                } else {
                    Assert.fail("Symmetry function must have model values as domain and range.");
                }
                ++i;
            }
            if (perm.size() <= 0 || perms.put(perm) != null) continue;
            permVec.addElement(perm);
        }
        int gsz = permVec.size();
        int sz0 = 0;
        while (true) {
            int sz1 = permVec.size();
            int i = 0;
            while (i < gsz) {
                IMVPerm perm1 = (IMVPerm)permVec.elementAt(i);
                int j = sz0;
                while (j < sz1) {
                    IMVPerm perm = perm1.compose((IMVPerm)permVec.elementAt(j));
                    if (perm.size() > 0 && perms.put(perm) == null) {
                        permVec.addElement(perm);
                    }
                    ++j;
                }
                ++i;
            }
            if (sz1 == permVec.size()) break;
            sz0 = sz1;
        }
        IMVPerm[] res = new IMVPerm[permVec.size()];
        Enumeration permEnum = permVec.elements();
        int i = 0;
        while (i < res.length) {
            res[i] = (IMVPerm)permEnum.nextElement();
            ++i;
        }
        return res;
    }
}

