/*
 * Decompiled with CFR 0.152.
 */
package tla2sany.drivers;

import java.io.PrintStream;
import java.util.ArrayList;
import java.util.List;
import tla2sany.drivers.FrontEndException;
import tla2sany.drivers.SemanticException;
import tla2sany.explorer.Explorer;
import tla2sany.explorer.ExplorerQuitException;
import tla2sany.linter.Linter;
import tla2sany.modanalyzer.ParseUnit;
import tla2sany.modanalyzer.SpecObj;
import tla2sany.output.LogLevel;
import tla2sany.output.OutErrSanyOutput;
import tla2sany.output.SanyOutput;
import tla2sany.output.SimpleSanyOutput;
import tla2sany.parser.ParseException;
import tla2sany.semantic.AbortException;
import tla2sany.semantic.Context;
import tla2sany.semantic.Errors;
import tla2sany.semantic.ExternalModuleTable;
import tla2sany.semantic.Generator;
import tla2sany.semantic.ModuleNode;
import tla2sany.st.TreeNode;
import util.FileUtil;
import util.ToolIO;
import util.UniqueString;
import util.UsageGenerator;

public class SANY {
    private static String modDate = "08 July 2020";
    public static String version = "Version 2.2 created " + modDate;
    private static boolean doParsing = true;
    private static boolean doSemanticAnalysis = true;
    private static boolean doLevelChecking = true;
    private static boolean doLinting = true;
    private static boolean doDebugging = false;
    private static boolean doStrictErrorCodes = false;

    @Deprecated
    public static final int frontEndMain(SpecObj spec, String fileName, PrintStream syserr) throws FrontEndException {
        return SANY.frontEndMain(spec, fileName, new SimpleSanyOutput(syserr, LogLevel.INFO));
    }

    public static final int frontEndMain(SpecObj spec, String fileName, SanyOutput out) throws FrontEndException {
        try {
            SANY.frontEndInitialize();
            if (doParsing) {
                SANY.frontEndParse(spec, out);
            }
            if (doSemanticAnalysis) {
                SANY.frontEndSemanticAnalysis(spec, out, doLevelChecking);
            }
            if (doLinting) {
                SANY.frontEndLinting(spec, out);
            }
        }
        catch (ParseException pe) {
            return -1;
        }
        catch (SemanticException se) {
            return -1;
        }
        catch (Exception e) {
            out.log(LogLevel.ERROR, e.toString(), new Object[0]);
            throw new FrontEndException(e);
        }
        if (doStrictErrorCodes) {
            return spec.errorLevel;
        }
        return 0;
    }

    public static void frontEndInitialize() {
        Context.reInit();
    }

    @Deprecated
    public static void frontEndParse(SpecObj spec, PrintStream syserr) throws ParseException {
        SANY.frontEndParse(spec, new SimpleSanyOutput(syserr, LogLevel.INFO));
    }

    public static void frontEndParse(SpecObj spec, SanyOutput out) throws ParseException {
        SANY.frontEndParse(spec, out, true);
    }

    @Deprecated
    public static void frontEndParse(SpecObj spec, PrintStream sysErr, boolean validatePCalTranslation) throws ParseException {
        SANY.frontEndParse(spec, new SimpleSanyOutput(sysErr, LogLevel.INFO), validatePCalTranslation);
    }

    public static void frontEndParse(SpecObj spec, SanyOutput out, boolean validatePCalTranslation) throws ParseException {
        try {
            spec.loadSpec(spec.getFileName(), spec.parseErrors, validatePCalTranslation, out);
            List<Errors.ErrorDetails> warnings = spec.parseErrors.getWarningDetails();
            if (!warnings.isEmpty()) {
                out.log(LogLevel.WARNING, "Warnings (%d) during syntax parsing of %s:\n\n", warnings.size(), spec.getFileName());
                for (Errors.ErrorDetails warning : warnings) {
                    out.log(LogLevel.WARNING, "%s\n\n\n", warning);
                }
            }
            if (!spec.parseErrors.isSuccess()) {
                out.log(LogLevel.ERROR, spec.parseErrors.toString(), new Object[0]);
                spec.errorLevel = 2;
                throw new ParseException();
            }
        }
        catch (ParseException e) {
            throw new ParseException();
        }
        catch (Exception e) {
            out.log(LogLevel.ERROR, "\nFatal errors while parsing TLA+ spec in file %s\n", spec.getFileName());
            out.log(LogLevel.ERROR, e.toString(), new Object[0]);
            out.log(LogLevel.ERROR, spec.parseErrors.toString(), new Object[0]);
            throw new ParseException();
        }
    }

    @Deprecated
    public static void frontEndSemanticAnalysis(SpecObj spec, PrintStream syserr, boolean levelCheck) throws SemanticException {
        SANY.frontEndSemanticAnalysis(spec, new SimpleSanyOutput(syserr, LogLevel.INFO), levelCheck);
    }

    public static void frontEndSemanticAnalysis(SpecObj spec, SanyOutput out, boolean levelCheck) throws SemanticException {
        ExternalModuleTable externalModuleTable = spec.getExternalModuleTable();
        ModuleNode moduleNode = null;
        Errors semanticErrors = spec.semanticErrors;
        try {
            int i = 0;
            while (i < spec.semanticAnalysisVector.size()) {
                String moduleStringName = spec.semanticAnalysisVector.elementAt(i);
                if (externalModuleTable.getContext(UniqueString.uniqueStringOf(moduleStringName)) == null) {
                    ParseUnit parseUnit = spec.parseUnitContext.get(moduleStringName);
                    TreeNode syntaxTreeRoot = parseUnit.getParseTree();
                    out.log(LogLevel.INFO, "Semantic processing of module %s", moduleStringName);
                    Generator gen = new Generator(externalModuleTable, semanticErrors);
                    moduleNode = gen.generate(syntaxTreeRoot);
                    moduleNode.setStandard(spec.getResolver().isStandardModule(moduleStringName));
                    externalModuleTable.put(UniqueString.uniqueStringOf(moduleStringName), gen.getSymbolTable().getExternalContext(), moduleNode);
                    if (moduleNode != null && semanticErrors.isSuccess() && levelCheck) {
                        moduleNode.levelCheck(semanticErrors);
                    }
                    if (i == spec.semanticAnalysisVector.size() - 1) {
                        externalModuleTable.setRootModule(moduleNode);
                    }
                    if (semanticErrors.getNumMessages() > 0) {
                        out.log(LogLevel.ERROR, "Semantic errors:\n\n%s", semanticErrors);
                        if (semanticErrors.getNumErrors() > 0) {
                            spec.errorLevel = 4;
                        }
                    }
                }
                ++i;
            }
        }
        catch (AbortException e) {
            out.log(LogLevel.ERROR, "Fatal errors in semantic processing of TLA spec %s\n%s\nStack trace for exception:\n", spec.getFileName(), e.getMessage());
            e.printStackTrace(out.getStream(LogLevel.ERROR));
            if (semanticErrors.getNumMessages() > 0) {
                out.log(LogLevel.ERROR, "Semantic errors detected before the unexpected exception:\n\n%s", semanticErrors);
                if (semanticErrors.getNumErrors() > 0) {
                    spec.errorLevel = 4;
                }
            }
            throw new SemanticException(e);
        }
    }

    public static void frontEndLinting(SpecObj spec, SanyOutput out) {
        ExternalModuleTable externalModuleTable = spec.getExternalModuleTable();
        Errors semanticErrors = spec.semanticErrors;
        Linter linter = new Linter();
        ModuleNode[] moduleNodeArray = externalModuleTable.getModuleNodes();
        int n = moduleNodeArray.length;
        int n2 = 0;
        while (n2 < n) {
            ModuleNode module = moduleNodeArray[n2];
            if (!module.isStandardModule()) {
                out.log(LogLevel.INFO, "Linting of module %s", module.getName());
                linter.lint(module, externalModuleTable, semanticErrors);
            }
            ++n2;
        }
    }

    private static void printUsage() {
        ArrayList<List<UsageGenerator.Argument>> commandVariants = new ArrayList<List<UsageGenerator.Argument>>();
        ArrayList<UsageGenerator.Argument> variant = new ArrayList<UsageGenerator.Argument>();
        variant.add(new UsageGenerator.Argument("-s", "Turns off semantic analysis and level-checking.", true));
        variant.add(new UsageGenerator.Argument("-l", "Turns off level-checking.", true));
        variant.add(new UsageGenerator.Argument("-error-codes", "Return a descriptive exit code in case of error.\n\n'2' Error during parsing.\n'4' Error during semantic analysis or level-checking.", true));
        variant.add(new UsageGenerator.Argument("-d", "Opens the semantic graph explorer prompt. The prompt accepts the following commands:\n'cst' Prints out the concrete syntax tree.\n'dot' Emits the semantic graph to a ModuleName.dot file in the DOT graph description language.\n'mt'  Prints the module table, a list of all imported modules and their top-level definitions.\n'mt*' Prints the extended module table including built-in operator definitions.\n\nOptionally, skip the prompt and run a command directly by appending it like 'SANY -d ModuleName.tla cst'", true));
        variant.add(new UsageGenerator.Argument("FILE...", "1 or more files", false));
        commandVariants.add(variant);
        ArrayList<String> tips = new ArrayList<String>();
        UsageGenerator.displayUsage(ToolIO.out, "SANY", version, "provides parsing, semantic analysis, and level-checking for a TLA+ spec", "SANY is a parser and syntax checker for TLA+ specifications.\nIt catches parsing errors and some \"semantic\" errors such as\npriming an expression containing primed variables.", commandVariants, tips, ' ');
    }

    public static void SANYmain(String[] args) {
        if (args.length == 0) {
            SANY.printUsage();
            System.exit(-1);
        }
        int i = 0;
        while (i < args.length && args[i].charAt(0) == '-') {
            if (args[i].equals("-S") || args[i].equals("-s")) {
                doSemanticAnalysis = !doSemanticAnalysis;
            } else if (args[i].equals("-L") || args[i].equals("-l")) {
                doLevelChecking = !doLevelChecking;
            } else if (args[i].equals("-G") || args[i].equals("-g")) {
                doLinting = !doLinting;
            } else if (args[i].equals("-D") || args[i].equals("-d")) {
                doDebugging = !doDebugging;
            } else if (!args[i].equals("-STAT") && !args[i].equals("-stat")) {
                if (args[i].toLowerCase().equals("-error-codes")) {
                    doStrictErrorCodes = true;
                } else if (args[i].toLowerCase().equals("-help")) {
                    SANY.printUsage();
                    System.exit(0);
                } else {
                    ToolIO.out.println("Invalid option: " + args[i]);
                    ToolIO.out.println("Try 'SANY -help' for more information.");
                    System.exit(-1);
                }
            }
            ++i;
        }
        if (i == args.length) {
            ToolIO.out.println("At least 1 filename is required.");
            ToolIO.out.println("Try 'SANY -help' for more information.");
            System.exit(-1);
        }
        OutErrSanyOutput out = new OutErrSanyOutput(ToolIO.out, Boolean.getBoolean(SANY.class.getName() + ".errors2stderr") ? ToolIO.err : ToolIO.out, LogLevel.INFO, LogLevel.ERROR);
        while (i < args.length) {
            out.log(LogLevel.INFO, "\n****** SANY2 %s\n", version);
            SpecObj spec = new SpecObj(args[i], null);
            if (FileUtil.createNamedInputStream(args[i], spec.getResolver()) != null) {
                try {
                    int ret = SANY.frontEndMain(spec, args[i], out);
                    if (ret != 0) {
                        System.exit(ret);
                    }
                }
                catch (FrontEndException fe) {
                    fe.printStackTrace();
                    out.log(LogLevel.ERROR, fe.toString(), new Object[0]);
                    System.exit(-1);
                }
                if (doDebugging) {
                    Explorer explorer = new Explorer(spec.getExternalModuleTable(), spec.getSemanticErrors());
                    try {
                        explorer.main(args);
                    }
                    catch (ExplorerQuitException explorerQuitException) {}
                }
            } else {
                out.log(LogLevel.ERROR, "Cannot find the specified file %s.", args[i]);
                System.exit(-1);
            }
            ++i;
        }
    }
}

