/*
 * Decompiled with CFR 0.152.
 */
package tlc2.tool.coverage;

import java.util.ArrayDeque;
import java.util.Arrays;
import java.util.Comparator;
import java.util.Deque;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import tla2sany.explorer.ExploreNode;
import tla2sany.explorer.ExplorerVisitor;
import tla2sany.semantic.ASTConstants;
import tla2sany.semantic.ExprNode;
import tla2sany.semantic.ExprOrOpArgNode;
import tla2sany.semantic.LetInNode;
import tla2sany.semantic.OpApplNode;
import tla2sany.semantic.OpDeclNode;
import tla2sany.semantic.OpDefNode;
import tla2sany.semantic.SemanticNode;
import tla2sany.semantic.Subst;
import tla2sany.semantic.SubstInNode;
import tla2sany.semantic.SymbolNode;
import tla2sany.st.Location;
import tlc2.output.MP;
import tlc2.tool.Action;
import tlc2.tool.ITool;
import tlc2.tool.coverage.ActionWrapper;
import tlc2.tool.coverage.CostModel;
import tlc2.tool.coverage.CostModelNode;
import tlc2.tool.coverage.CoverageHashTable;
import tlc2.tool.coverage.OpApplNodeWrapper;
import tlc2.tool.coverage.RecursiveOpApplNodeWrapper;
import tlc2.tool.coverage.UnchangedOpApplNodeWrapper;
import tlc2.util.Context;
import tlc2.util.ObjLongTable;
import tlc2.util.Vect;
import tlc2.util.statistics.CountDistinct;
import util.UniqueString;

public class CostModelCreator
extends ExplorerVisitor {
    private final Deque<CostModelNode> stack = new ArrayDeque<CostModelNode>();
    private final Map<ExprOrOpArgNode, Subst> substs = new HashMap<ExprOrOpArgNode, Subst>();
    private final Map<OpApplNode, Set<OpApplNodeWrapper>> node2Wrapper = new HashMap<OpApplNode, Set<OpApplNodeWrapper>>();
    private final Set<OpDefNode> opDefNodes = new HashSet<OpDefNode>();
    private final Map<ExprNode, ExprNode> letIns = new HashMap<ExprNode, ExprNode>();
    private final Set<OpApplNodeWrapper> nodes = new HashSet<OpApplNodeWrapper>();
    private final ITool tool;
    private ActionWrapper root;
    private Context ctx = Context.Empty;

    private CostModelCreator(SemanticNode root, ActionWrapper aw, ITool tool) {
        this.tool = tool;
        this.root = aw;
        this.stack.push(new RecursiveOpApplNodeWrapper());
        root.walkGraph(new CoverageHashTable(this.opDefNodes), this);
    }

    private CostModelCreator(ITool tool) {
        SemanticNode sn;
        this.tool = tool;
        ObjLongTable.Enumerator<SemanticNode> keys = tool.getPrimedLocs().keys();
        while ((sn = keys.nextElement()) != null) {
            this.nodes.add(new OpApplNodeWrapper((OpApplNode)sn, null));
        }
    }

    private CostModel getCM(Action act, ActionWrapper.Relation relation) {
        this.substs.clear();
        this.node2Wrapper.clear();
        this.opDefNodes.clear();
        this.letIns.clear();
        this.stack.clear();
        this.ctx = Context.Empty;
        this.root = new ActionWrapper(act, relation);
        this.stack.push(this.root);
        act.pred.walkGraph(new CoverageHashTable(this.opDefNodes), this);
        assert (this.stack.peek().isRoot());
        return this.stack.peek().getRoot();
    }

    @Override
    public void preVisit(ExploreNode exploreNode) {
        if (exploreNode instanceof OpApplNode) {
            Object lookup;
            OpDefNode odn;
            ExprNode body;
            SymbolNode operator;
            Object val;
            OpApplNode opApplNode = (OpApplNode)exploreNode;
            if (opApplNode.isStandardModule()) {
                return;
            }
            OpApplNodeWrapper oan = opApplNode.hasOpcode(49) ? new UnchangedOpApplNodeWrapper(opApplNode, this.root) : new OpApplNodeWrapper(opApplNode, this.root);
            if (this.nodes.contains(oan)) {
                oan.setPrimed();
            }
            if (this.letIns.containsKey(opApplNode)) {
                ExprNode in = this.letIns.get(opApplNode);
                for (CostModelNode cmn2 : this.stack) {
                    SemanticNode node = cmn2.getNode();
                    if (node != in || !(cmn2 instanceof OpApplNodeWrapper)) continue;
                    ((OpApplNodeWrapper)cmn2).addLets(oan);
                }
            }
            if ((val = this.tool.lookup(operator = opApplNode.getOperator())) instanceof OpDefNode && operator != val && (body = (odn = (OpDefNode)val).getBody()) instanceof OpApplNode) {
                CostModelCreator substitution = new CostModelCreator(body, this.root, this.tool);
                oan.addChild((OpApplNodeWrapper)substitution.getModel());
            }
            if (operator instanceof OpDefNode && (odn = (OpDefNode)operator).getInRecursive()) {
                this.stack.stream().filter(w -> w.getNode() != null && w.getNode() instanceof OpApplNode && ((OpApplNode)w.getNode()).getOperator() == odn).findFirst().ifPresent(cmn -> {
                    OpApplNodeWrapper opApplNodeWrapper2 = oan.setRecursive((CostModelNode)cmn);
                });
            }
            if (this.tool != null && operator instanceof OpDefNode && opApplNode.hasOpcode(0) && opApplNode.argsContainOpArgNodes() && (odn = (OpDefNode)operator).hasOpcode(0) && !odn.isStandardModule()) {
                this.ctx = this.tool.getOpContext(odn, opApplNode.getArgs(), this.ctx, false);
            }
            if ((lookup = this.ctx.lookup(opApplNode.getOperator())) instanceof OpDefNode && (body = ((OpDefNode)lookup).getBody()) instanceof OpApplNode) {
                this.node2Wrapper.computeIfAbsent((OpApplNode)body, key -> new HashSet()).add(oan);
            }
            if (this.node2Wrapper.containsKey(opApplNode)) {
                this.node2Wrapper.get(opApplNode).forEach(w -> w.addChild(oan));
            }
            if (this.substs.containsKey(exploreNode)) {
                Subst subst = this.substs.get(exploreNode);
                assert (subst.getExpr() == oan.getNode());
                subst.setCM(oan);
            }
            CostModelNode parent = this.stack.peek();
            parent.addChild(oan.setLevel(parent.getLevel() + 1));
            this.stack.push(oan);
        } else if (exploreNode instanceof SubstInNode) {
            Subst[] substs;
            SubstInNode sin = (SubstInNode)exploreNode;
            Subst[] substArray = substs = sin.getSubsts();
            int n = substs.length;
            int n2 = 0;
            while (n2 < n) {
                Subst subst = substArray[n2];
                this.substs.put(subst.getExpr(), subst);
                ++n2;
            }
        } else if (exploreNode instanceof LetInNode) {
            LetInNode lin = (LetInNode)exploreNode;
            OpDefNode[] opDefNodeArray = lin.getLets();
            int n = opDefNodeArray.length;
            int n3 = 0;
            while (n3 < n) {
                OpDefNode opDefNode = opDefNodeArray[n3];
                this.letIns.put(opDefNode.getBody(), lin.getBody());
                ++n3;
            }
        } else if (exploreNode instanceof OpDefNode) {
            this.opDefNodes.add((OpDefNode)exploreNode);
        }
    }

    @Override
    public void postVisit(ExploreNode exploreNode) {
        if (exploreNode instanceof OpApplNode) {
            if (((OpApplNode)exploreNode).isStandardModule()) {
                return;
            }
            CostModelNode pop = this.stack.pop();
            assert (pop.getNode() == exploreNode);
        } else if (exploreNode instanceof OpDefNode) {
            boolean removed = this.opDefNodes.remove((OpDefNode)exploreNode);
            assert (removed);
        }
    }

    private CostModel getModel() {
        assert (this.stack.peek().isRoot());
        return this.stack.peek().getRoot();
    }

    public static final void create(ITool tool) {
        ExprNode[] actionConstraints;
        CostModelCreator collector = new CostModelCreator(tool);
        Vect<Action> init = tool.getInitStateSpec();
        int i = 0;
        while (i < init.size()) {
            Action initAction = init.elementAt(i);
            initAction.cm = collector.getCM(initAction, ActionWrapper.Relation.INIT);
            ++i;
        }
        HashMap<SemanticNode, CostModel> cms = new HashMap<SemanticNode, CostModel>();
        Action[] actionArray = tool.getActions();
        int n = actionArray.length;
        int n2 = 0;
        while (n2 < n) {
            Action nextAction = actionArray[n2];
            if (cms.containsKey(nextAction.pred)) {
                nextAction.cm = (CostModel)cms.get(nextAction.pred);
            } else {
                nextAction.cm = collector.getCM(nextAction, ActionWrapper.Relation.NEXT);
                cms.put(nextAction.pred, nextAction.cm);
            }
            ++n2;
        }
        actionArray = tool.getInvariants();
        n = actionArray.length;
        n2 = 0;
        while (n2 < n) {
            Action invariant = actionArray[n2];
            if (!invariant.isInternal()) {
                invariant.cm = collector.getCM(invariant, ActionWrapper.Relation.PROP);
            }
            ++n2;
        }
        ExprNode[] exprNodeArray = actionConstraints = tool.getActionConstraints();
        int n3 = actionConstraints.length;
        n = 0;
        while (n < n3) {
            ExprNode exprNode = exprNodeArray[n];
            OpDefNode odn = (OpDefNode)exprNode.getToolObject(tool.getId());
            Action act = new Action((SemanticNode)exprNode, Context.Empty, odn);
            act.cm = collector.getCM(act, ActionWrapper.Relation.CONSTRAINT);
            exprNode.setToolObject(tool.getId(), act);
            ++n;
        }
        ExprNode[] modelConstraints = tool.getModelConstraints();
        ASTConstants[] aSTConstantsArray = modelConstraints;
        int n4 = modelConstraints.length;
        n3 = 0;
        while (n3 < n4) {
            ExprNode exprNode = aSTConstantsArray[n3];
            OpDefNode odn = (OpDefNode)exprNode.getToolObject(tool.getId());
            Action act = new Action((SemanticNode)exprNode, Context.Empty, odn);
            act.cm = collector.getCM(act, ActionWrapper.Relation.CONSTRAINT);
            exprNode.setToolObject(tool.getId(), act);
            ++n3;
        }
        if (Boolean.getBoolean(CostModelCreator.class.getName() + ".implied")) {
            aSTConstantsArray = tool.getImpliedInits();
            n4 = aSTConstantsArray.length;
            n3 = 0;
            while (n3 < n4) {
                ASTConstants impliedInits = aSTConstantsArray[n3];
                ((Action)impliedInits).cm = collector.getCM((Action)impliedInits, ActionWrapper.Relation.PROP);
                ++n3;
            }
            aSTConstantsArray = tool.getImpliedActions();
            n4 = aSTConstantsArray.length;
            n3 = 0;
            while (n3 < n4) {
                ASTConstants impliedActions = aSTConstantsArray[n3];
                ((Action)impliedActions).cm = collector.getCM((Action)impliedActions, ActionWrapper.Relation.PROP);
                ++n3;
            }
        }
        aSTConstantsArray = tool.getSpecProcessor().getVariablesNodes();
        n4 = aSTConstantsArray.length;
        n3 = 0;
        while (n3 < n4) {
            ASTConstants odn = aSTConstantsArray[n3];
            ((OpDeclNode)odn).setCountDistinct(new CountDistinct.SyncedHyperLogLog(10));
            ++n3;
        }
    }

    public static void report(ITool tool, long startTime) {
        CostModelCreator.report(tool);
        long l = System.currentTimeMillis() - startTime;
        if (l > 300000L) {
            MP.printMessage(2777);
        } else {
            MP.printMessage(2202);
        }
    }

    private static void report(ITool tool) {
        ExprNode[] actionConstraints;
        MP.printMessage(2201);
        OpDeclNode[] opDeclNodeArray = tool.getSpecProcessor().getVariablesNodes();
        int n = opDeclNodeArray.length;
        int n2 = 0;
        while (n2 < n) {
            OpDeclNode odn = opDeclNodeArray[n2];
            long count = odn.getCountDistinct().count();
            if (count >= 0L) {
                UniqueString varName = odn.getName();
                Location location = odn.getLocation();
                MP.printMessage(2779, varName.toString(), location.toString(), String.valueOf(count));
            }
            ++n2;
        }
        Vect<Action> init = tool.getInitStateSpec();
        int i = 0;
        while (i < init.size()) {
            Action initAction = init.elementAt(i);
            initAction.cm.report();
            ++i;
        }
        Action[] actions = tool.getActions();
        HashSet<CostModel> reported = new HashSet<CostModel>();
        TreeSet<Action> sortedActions = new TreeSet<Action>(new Comparator<Action>(){

            @Override
            public int compare(Action o1, Action o2) {
                return o1.pred.getLocation().compareTo(o2.pred.getLocation());
            }
        });
        sortedActions.addAll(Arrays.asList(actions));
        for (Action action : sortedActions) {
            if (reported.contains(action.cm)) continue;
            action.cm.report();
            reported.add(action.cm);
        }
        Action[] actionArray = tool.getInvariants();
        int varName = actionArray.length;
        int n3 = 0;
        while (n3 < varName) {
            Action invariant = actionArray[n3];
            if (!invariant.isInternal()) {
                invariant.cm.report();
            }
            ++n3;
        }
        ExprNode[] exprNodeArray = actionConstraints = tool.getActionConstraints();
        int n4 = actionConstraints.length;
        varName = 0;
        while (varName < n4) {
            ExprNode exprNode = exprNodeArray[varName];
            Action act = (Action)exprNode.getToolObject(tool.getId());
            act.cm.report();
            ++varName;
        }
        ExprNode[] modelConstraints = tool.getModelConstraints();
        ASTConstants[] aSTConstantsArray = modelConstraints;
        int n5 = modelConstraints.length;
        n4 = 0;
        while (n4 < n5) {
            ExprNode exprNode = aSTConstantsArray[n4];
            Action act = (Action)exprNode.getToolObject(tool.getId());
            act.cm.report();
            ++n4;
        }
        if (Boolean.getBoolean(CostModelCreator.class.getName() + ".implied")) {
            aSTConstantsArray = tool.getImpliedInits();
            n5 = aSTConstantsArray.length;
            n4 = 0;
            while (n4 < n5) {
                ASTConstants impliedInits = aSTConstantsArray[n4];
                ((Action)impliedInits).cm.report();
                ++n4;
            }
            aSTConstantsArray = tool.getImpliedActions();
            n5 = aSTConstantsArray.length;
            n4 = 0;
            while (n4 < n5) {
                ASTConstants impliedActions = aSTConstantsArray[n4];
                ((Action)impliedActions).cm.report();
                ++n4;
            }
        }
    }
}

